"""
PyWX handler for Quixote applications.

Usage:

--
import handleQuixote
handler = handleQuixote.Handler(base_url, app)
--

then for each connection call 'handler.handle(conn)'.
"""

import sys

import quixote
quixote.enable_ptl()

import os
import ns_setup
import PyWX_buffer

#
# Handler
#

class Handler:
    """
    Base handler for Quixote applications inside of PyWX.
    """
    
    def __init__(self, base_url, app):
        if base_url[0] != '/':
            raise Exception("base_url must be an absolute local URL.")

        self._base_url = base_url
        sys.argv = (base_url,)

        assert isinstance(app, quixote.Publisher)
        self._app = app

    def handle(self, conn, add_environ = {}):
        # Set up a CGI-style environment:
        environ = {}
        environ.update(os.environ)
        ns_setup.create_cgi_environ(conn, environ)

        # Set a few parameters that Quixote expects to be munged in a
        # particular way:
        environ['SCRIPT_NAME'] = self._base_url
        environ['PATH_INFO'] = conn.request.url[len(self._base_url):]

        # Get an I/O handle for this connection:
        buff = PyWX_buffer.GetBuff()
        try:
            # publish!
            self._app.publish(buff, buff, buff, environ)
            buff.close()
        except IOError:                 # be forgiving of closed connections.
            pass
