#!/usr/bin/env python

import sys, os
import cmd
import httplib, socket
import updateformsub
import plantlistsub
import StringIO


def http_request(function, host, url, params, headers):
    status = None
    content = None
    try:
        conn = httplib.HTTPConnection(host)
        req = conn.request(function, url, params, headers)
    except socket.error:
        print "Can't connect to server: %s" % host
        return
    res = conn.getresponse()
    status = res.status
    if status == 200:
        content = res.read()
    conn.close()
    return (status, content)


def showlist(line):
    host = 'warbler:8081'
    url = '/UpdateRecord/recordlist/'
    headers = {'Accept': 'text/xml'}
    params = {}
    status, content = http_request('GET', host, url, params, headers)
    if status != 200:
        print "Can't get plant list.  status: %d" % status
        return
    root = plantlistsub.parseString(content)
    print 'Plant list:'
    for plant in root.getPlant():
        print '    Plant # %s:' % plant.getIndex()
        print '        Name:         %s' % plant.getName()
        print '        Description:  "%s"' % plant.getDescription()
        print '        Record link:  %s' % plant.getRecordlink()
        print '        Update link:  %s' % plant.getUpdatelink()


def showlistless(line):
    host = 'warbler:8081'
    url = '/UpdateRecord/recordlist/'
    headers = {'Accept': 'text/xml'}
    params = {}
    status, content = http_request('GET', host, url, params, headers)
    if status != 200:
        print "Can't get plant list.  status: %d" % status
        return
    root = plantlistsub.parseString(content)
    filename = os.tempnam('.')
    outfile = file(filename, 'w')
    outfile.write('Plant list:\n')
    for plant in root.getPlant():
        outfile.write('    Plant # %s:\n' % plant.getIndex())
        outfile.write('        Name:         %s\n' % plant.getName())
        outfile.write('        Description:  "%s"\n' % plant.getDescription())
        outfile.write('        Record link:  %s\n' % plant.getRecordlink())
        outfile.write('        Update link:  %s\n' % plant.getUpdatelink())
    outfile.close()
    os.system('less %s' % filename)
    os.remove(filename)


def show(line):
    name = None
    if line:
        args = line.split()
        if len(args) > 0:
            name = args[0]
    if not name:
        print '*** Missing plant name.'
        return
    host = 'warbler:8081'
    url = '/UpdateRecord/updateform/%s' % name
    headers = {'Accept': 'text/xml'}
    params = {}
    status, content = http_request('GET', host, url, params, headers)
    if status != 200:
        print "Can't get description for name: %s" % name
    root = updateformsub.parseString(content)
    descrip = root.getDescription()
    print 'Name:        %s' % name
    print 'Description: %s' % descrip


def update(line):
    name = None
    if line:
        args = line.split()
        if len(args) > 0:
            name = args[0]
    if not name:
        print '*** Missing plant name.'
        return
    host = 'warbler:8081'
    url = '/UpdateRecord/updateform/%s' % name
    headers = {'Accept': 'text/xml'}
    params = {}
    status, content = http_request('GET', host, url, params, headers)
    if status != 200:
        print "Can't get description for name: %s" % name
    root = updateformsub.parseString(content)
    olddescrip = root.getDescription()
    print 'Old description: %s' % olddescrip
    print 'Enter new description ("[quit]" to skip update).'
    newdescrip = raw_input('New description: ')
    if newdescrip != '[quit]':
        root.setDescription(newdescrip)
        contentstream = StringIO.StringIO()
        root.export(contentstream, 0)
        content = contentstream.getvalue()
        contentstream.close()
        url = root.getSubmitlink()
        status, content = http_request('GET', host, url, content, headers)
        print 'status: %s' % status


HELP_TEXT = """\
Commands:
    showlist      -- Show list of plant names.
    show <name>   -- Show plant <name>.
    update <name> -- Update description for plant <name>.
    quit          -- Exit.
    help          -- Show this help.
"""

class RestCmd(cmd.Cmd):
    prompt = '>>> '
    intro = "Type '?' for help."

    def __init__(self):
        cmd.Cmd.__init__(self)

    def do_help(self, line):
        print HELP_TEXT

    def do_quit(self, line):
        sys.exit(1)

    def do_showlist(self, line):
        showlist(line)

    def do_showlistless(self, line):
        showlistless(line)

    def do_show(self, line):
        show(line)

    def do_update(self, line):
        update(line)

    def emptyline(self):
        print "Enter a command or type '?' for help."


    
USAGE_TEXT = """
Usage: python client1.py
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    if len(args) != 0:
        usage()
    interp = RestCmd()
    interp.cmdloop()


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')



