#!/usr/bin/env python

import sys, getopt
import httplib


def request(host, url, typeXml):
    if typeXml:
        headers = {'Accept': 'text/xml'}
    else:
        headers = {'Accept': 'text/html'}
    params = {}
    conn = httplib.HTTPConnection(host)
    req = conn.request('GET', url, params, headers)
    res = conn.getresponse()
    status = res.status
    content = res.read()
    #print '=' * 50
    print 'Status: %s' % status
    print content
    #print '=' * 50


USAGE_TEXT = """
Usage: python get.py [ options ] <host> <url>
Options:
    -x  Request Content-type XML.
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    optlist, args = getopt.getopt(args, 'x')
    typeXml = 0
    for opt, val in optlist:
        if opt == '-x':
            typeXml = 1
    if len(args) != 2:
        usage()
    host = args[0]
    url = args[1]
    request(host, url, typeXml)

if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')


