#!/usr/bin/env python

import sys
import httplib, socket
import plantlistsub


def getplantlist():
    host = 'warbler:8081'
    url = 'UpdateRecord/recordlist/'
    headers = {'Accept': 'text/xml'}
    params = {}
    conn = httplib.HTTPConnection(host)
    try:
        req = conn.request('GET', url, params, headers)
    except socket.error:
        print "Can't connect to server: warbler:8081"
        return
    res = conn.getresponse()
    status = res.status
    content_type = res.getheader('Content-type')
    content = res.read()
    conn.close()
    if status != 200:
        print "Can't get plant list.  status: %d" % status
        return
    root = plantlistsub.parseString(content)
    print 'Plant list:'
    for plant in root.getPlant():
        print '    Plant # %s:' % plant.getIndex()
        print '        Name:         %s' % plant.getName()
        print '        Description:  "%s"' % plant.getDescription()
        print '        Record link:  %s' % plant.getRecordlink()
        print '        Update link:  %s' % plant.getUpdatelink()


USAGE_TEXT = """
Usage: python getplantlist.py
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    if len(args) != 0:
        usage()
    getplantlist()


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')


