#!/usr/bin/env python

import sys, getopt
import httplib
import updateformsub
import StringIO


def request(host, url, typeXml):
    if typeXml:
        headers = {'Accept': 'text/xml'}
    else:
        headers = {'Accept': 'text/html'}
    params = {}
    conn = httplib.HTTPConnection(host)
    req = conn.request('GET', url, params, headers)
    res = conn.getresponse()
    status = res.status
    content_type = res.getheader('Content-type')
    content = res.read()
    conn.close()
    #print '=' * 50
    print 'Status: %s' % status
    print 'Content-type: %s' % content_type
    print '-' * 50
    print content
    print '-' * 50
    root = updateformsub.parseString(content)
    root.export(sys.stdout, 0)
    olddescrip = root.getDescription()
    print 'Old description: %s' % olddescrip
    newdescrip = raw_input('New desription: ')
    if newdescrip:
        root.setDescription(newdescrip)
        root.export(sys.stdout, 0)
        contentstream = StringIO.StringIO()
        root.export(contentstream, 0)
        content = contentstream.getvalue()
        contentstream.close()
        url = root.getSubmitlink()
        length = len(content)
        print
        print 'New content:'
        print content
        print 'url: %s' % url
        print 'headers: %s ' % headers
        conn = httplib.HTTPConnection(host)
        req = conn.request('POST', url, content, headers)
        res = conn.getresponse()
        status = res.status
        content = res.read()
        conn.close()
        #print '=' * 50
        print 'Status: %s' % status
        print content



    #print '=' * 50


USAGE_TEXT = """
Usage: python get.py [ options ] <host> <url>
Options:
    -x  Request Content-type XML.
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def main():
    args = sys.argv[1:]
    optlist, args = getopt.getopt(args, 'x')
    typeXml = 0
    for opt, val in optlist:
        if opt == '-x':
            typeXml = 1
    if len(args) != 2:
        usage()
    host = args[0]
    url = args[1]
    request(host, url, typeXml)

if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')


