#!/usr/bin/env python

import sys
import getopt
from xml.dom import minidom
from xml.dom import Node
#import yaml

#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://www-hep.colorado.edu/~fperez/ipython.
#
#from IPython.Shell import IPythonShellEmbed
#IPShell = IPythonShellEmbed('-nosep',
#    banner = 'Entering interpreter.  Ctrl-D to exit.',
#    exit_msg = 'Leaving Interpreter.')

# Use the following line where and when you want to drop into the
# IPython shell:
#    IPShell(vars(), '<a msg>')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')


#
# Data representation classes.
#

class updateform:
    subclass = None
    def __init__(self, name='', description='', submitlink=''):
        self.name = name
        self.description = description
        self.submitlink = submitlink
    def factory(*args):
        if updateform.subclass:
            return apply(updateform.subclass, args)
        else:
            return apply(updateform, args)
    factory = staticmethod(factory)
    def getName(self): return self.name
    def setName(self, name): self.name = name
    def getDescription(self): return self.description
    def setDescription(self, description): self.description = description
    def getSubmitlink(self): return self.submitlink
    def setSubmitlink(self, submitlink): self.submitlink = submitlink
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<updateform>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<name>%s</name>\n' % self.getName())
        showIndent(outfile, level)
        outfile.write('<description>%s</description>\n' % self.getDescription())
        showIndent(outfile, level)
        outfile.write('<submitlink>%s</submitlink>\n' % self.getSubmitlink())
        level -= 1
        showIndent(outfile, level)
        outfile.write('</updateform>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'name':
                name = ''
                for text_ in child.childNodes:
                    name += text_.nodeValue
                self.name = name
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'description':
                description = ''
                for text_ in child.childNodes:
                    description += text_.nodeValue
                self.description = description
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'submitlink':
                submitlink = ''
                for text_ in child.childNodes:
                    submitlink += text_.nodeValue
                self.submitlink = submitlink
# end class updateform


USAGE_TEXT = """
Usage: python <Parser>.py <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.childNodes[0]
    rootObj = updateform.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('?xml version="1.0" ?>')
    rootObj.export(sys.stdout, 0)
    #yamlObj = rootObj.exportYaml()
    #yaml.dumpToFile(sys.stdout, yamlObj)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) != 1:
        usage()
    parse(args[0])


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')

