#!/usr/bin/env python

import sys
import getopt
from xml.dom import minidom
from xml.dom import Node
#import yaml

#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://www-hep.colorado.edu/~fperez/ipython.
#
#from IPython.Shell import IPythonShellEmbed
#IPShell = IPythonShellEmbed('-nosep',
#    banner = 'Entering interpreter.  Ctrl-D to exit.',
#    exit_msg = 'Leaving Interpreter.')

# Use the following line where and when you want to drop into the
# IPython shell:
#    IPShell(vars(), '<a msg>')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')


#
# Data representation classes.
#

class plants:
    subclass = None
    def __init__(self, plant=None):
        if plant is None:
            self.plant = []
        else:
            self.plant = plant
    def factory(*args):
        if plants.subclass:
            return apply(plants.subclass, args)
        else:
            return apply(plants, args)
    factory = staticmethod(factory)
    def getPlant(self): return self.plant
    def addPlant(self, plant): self.plant.append(plant)
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<plants>\n')
        level += 1
        for plant in self.plant:
            plant.export(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('</plants>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'plant':
                obj = plant.factory()
                obj.build(child)
                self.plant.append(obj)
# end class plants


class plant:
    subclass = None
    def __init__(self, index=-1, name='', description='', recordlink='', updatelink=''):
        self.index = index
        self.name = name
        self.description = description
        self.recordlink = recordlink
        self.updatelink = updatelink
    def factory(*args):
        if plant.subclass:
            return apply(plant.subclass, args)
        else:
            return apply(plant, args)
    factory = staticmethod(factory)
    def getIndex(self): return self.index
    def setIndex(self, index): self.index = index
    def getName(self): return self.name
    def setName(self, name): self.name = name
    def getDescription(self): return self.description
    def setDescription(self, description): self.description = description
    def getRecordlink(self): return self.recordlink
    def setRecordlink(self, recordlink): self.recordlink = recordlink
    def getUpdatelink(self): return self.updatelink
    def setUpdatelink(self, updatelink): self.updatelink = updatelink
    def export(self, outfile, level):
        showIndent(outfile, level)
        outfile.write('<plant>\n')
        level += 1
        showIndent(outfile, level)
        outfile.write('<index>%d</index>\n' % self.getIndex())
        showIndent(outfile, level)
        outfile.write('<name>%s</name>\n' % self.getName())
        showIndent(outfile, level)
        outfile.write('<description>%s</description>\n' % self.getDescription())
        showIndent(outfile, level)
        outfile.write('<recordlink>%s</recordlink>\n' % self.getRecordlink())
        showIndent(outfile, level)
        outfile.write('<updatelink>%s</updatelink>\n' % self.getUpdatelink())
        level -= 1
        showIndent(outfile, level)
        outfile.write('</plant>\n')
    def build(self, node_):
        attrs = node_.attributes
        for child in node_.childNodes:
            if child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'index':
                if child.firstChild:
                    sval = child.firstChild.nodeValue
                    try:
                        ival = int(sval)
                    except ValueError:
                        showError('*** requires integer -- %s' % child.toxml())
                    self.index = ival
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'name':
                name = ''
                for text_ in child.childNodes:
                    name += text_.nodeValue
                self.name = name
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'description':
                description = ''
                for text_ in child.childNodes:
                    description += text_.nodeValue
                self.description = description
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'recordlink':
                recordlink = ''
                for text_ in child.childNodes:
                    recordlink += text_.nodeValue
                self.recordlink = recordlink
            elif child.nodeType == Node.ELEMENT_NODE and \
                child.nodeName == 'updatelink':
                updatelink = ''
                for text_ in child.childNodes:
                    updatelink += text_.nodeValue
                self.updatelink = updatelink
# end class plant


USAGE_TEXT = """
Usage: python <Parser>.py <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(-1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.childNodes[0]
    rootObj = plants.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('?xml version="1.0" ?>')
    rootObj.export(sys.stdout, 0)
    #yamlObj = rootObj.exportYaml()
    #yaml.dumpToFile(sys.stdout, yamlObj)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) != 1:
        usage()
    parse(args[0])


if __name__ == '__main__':
    main()
    #import pdb
    #pdb.run('main()')

