﻿//
//  Example code - use without restriction.  
//
IMPORT Std;

//This code generates a nested child dataset containing 
// 1,000,000 Person (parent) records and all their associated Accounts (children)
// by starting with 1000 first names and 1000 last names

P_Mult1       := 1000;
P_Mult2       := 1000;
TotalParents  := P_Mult1 * P_Mult2;
TotalChildren := 5000000;

Layout_Person := RECORD
  UNSIGNED3 PersonID;
  STRING15 FirstName;
  STRING25 LastName;
  STRING1   MiddleInitial;
  STRING1   Gender;
  STRING42 Street;
  STRING20 City;
  STRING2   State;
  STRING5  Zip;
END;

Layout_Accounts := RECORD
  STRING20 Account;
  STRING8  OpenDate;
  STRING2   IndustryCode;
  STRING1   AcctType;
  STRING1   AcctRate;
  UNSIGNED1 Code1;
  UNSIGNED1 Code2;
  UNSIGNED4 HighCredit;
  UNSIGNED4 Balance;
END;
Layout_Accounts_Link := RECORD
  UNSIGNED3 PersonID;
  Layout_Accounts;
END;
Layout_Combined := RECORD
  Layout_Person;
	DATASET(Layout_Accounts) Accounts;
END;

//define data for record generation:

		//100 possible middle initials, 52 letters and 48 blanks
SetMiddleInitials := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ                          ABCDEFGHIJKLMNOPQRSTUVWXYZ                      ';
	
		//1000 First and last names
SET OF STRING14	SetFnames := [
							'TIMTOHY       ','ALCIAN        ','CHAMENE       ','CRISPEN       ','HATIM         ','ISILELI       ','ALLONN        ','MATHUR        ','REBECCA       ','ARUNOTHAI     ',
							'CHERIFA       ','CHUNMIN       ','DONGXIAO      ','ELIU          ','HOREA         ','KATSUYOSHI    ','LIWAYWAY      ','PERCHIYA      ','PERMELIA      ','REINALDO      ',
							'SANIYE        ','YAUCHEN       ','CHUANCHUAN    ','CULLEN        ','FARYAL        ','GARA          ','MELVY         ','MEMO          ','MERARI        ','MERCELO       ',
							'MERITA        ','MERLEENE      ','MERVINA       ','MGBITA        ','MICHAELA      ','MICHEALSA     ','MICHELELYN    ','MIDO          ','MIFFLIN       ','MILAN         ',
							'MINCHIN       ','MINGHORNG     ','MINGWAI       ','MINTE         ','MIRAFLOR      ','MIRCINE       ','MIRRIAM       ','MIRTA         ','MITOS         ','MITT          ',
							'MOH           ','MOISEY        ','MONTANO       ','MOONSAMMY     ','MORHAF        ','MOSUR         ','MOU           ','MUIBI         ','MUKHTAR       ','MURUGAN       ',
							'MUSA          ','MYLIEN        ','NAATALIE      ','NAHEED        ','NAIR          ','NAMSHIN       ','NANDALALL     ','NANH          ','NAPOLEON      ','NAR           ',
							'NARI          ','NASIMA        ','NATE          ','NATHANAIL     ','NATIERA       ','NATLEE        ','NATTAPOL      ','NAZANIN       ','NEDRET        ','NEDZAD        ',
							'NEVIL         ','NEWELL        ','NEWENKA       ','NGOCTHY       ','NHYDYA        ','NIKESHA       ','NILAM         ','NILSON        ','NIMROD        ','NNENNA        ',
							'NORBERT       ','NORUL         ','NOVICE        ','NUKHET        ','NURAL         ','NURTEN        ','NUSA          ','NYKE          ','OALYNN        ','ODIN          ',
							'ODUENYI       ','OGGIE         ','OJEDA         ','OKE           ','OKIE          ','OLGA          ','OLLI          ','ONELIA        ','OUARDA        ','OULADAY       ',
							'OVSANNA       ','OYONG         ','PAMI          ','PANCHOLI      ','PANGIOTIS     ','PANGTYNG      ','PANINE        ','PANKAJ        ','PANNIE        ','PARGEV        ',
							'PARNAZ        ','PAULENE       ','PAULY         ','PAVER         ','PEACE         ','PEN           ','PENNE         ','PENNOCK       ','PERCIVAL      ','PERHERMUND    ',
							'PERPETUA      ','PERRIANNE     ','PETRIT        ','PHALICIA      ','PHYLLISTINE   ','PIVRROT       ','POERAVA       ','POHN          ','POLA          ','PRANAV        ',
							'PRAVIL        ','PRECILA       ','PRINGLE       ','PUNAM         ','PURUSHOTTAM   ','PURVIN        ','PUSHPAK       ','PYEONG        ','QINYU         ','RACHID        ',
							'RACHMIM       ','RACQUEL       ','RAGUVEER      ','RAINFORD      ','RAJAA         ','RAJAGOPAL     ','RAJAH         ','RAJESHWAR     ','RAMESWARI     ','RAMIN         ',
							'RAMIZA        ','RANDESA       ','RAOUL         ','RAULITO       ','RAVJIT        ','REDOMIEL      ','REGINEL       ','REITHER       ','REMCO         ','RENANTE       ',
							'RENIE         ','RENNE         ','RENORDA       ','RHYNETA       ','RIA           ','RIESS         ','RITUA         ','ROBYN         ','RODERI        ','RODUARDO      ',
							'ROLANDAS      ','ROLISA        ','ROLLA         ','ROMANEY       ','ROMAS         ','RONALDO       ','RONIQUE       ','ROSANY        ','ROSHNI        ','ROYJOHN       ',
							'RUDI          ','RUDYANTO      ','RUOJIE        ','RYLE          ','RYVER         ','SABENA        ','SACHE         ','SADOK         ','SAHARA        ','SAKINA        ',
							'SALENDAR      ','SALIDA        ','SANCHOY       ','SANGCHEOL     ','SANGDUAN      ','SANTANYA      ','SATENDRA      ','SAYSAMONE     ','SCHARON       ','SEANYELLE     ',
							'SELIM         ','SELINDA       ','SENONA        ','SEUNGBUM      ','SEUNGHI       ','SEYI          ','SHAENITA      ','SHAGUFTA      ','SHAHAD        ','SHAHIN        ',
							'SHAHRNAZ      ','SHALEEN       ','SHAMOLI       ','SHANER        ','SHANNAN       ','SHANNY        ','SHANTHI       ','SHARENE       ','SHARESE       ','SHARMILEE     ',
							'SHARNA        ','SHARNEE       ','SHARRIE       ','SHAWZAAM      ','SHAYNA        ','SHEK          ','SHEKETHA      ','SHELLAY       ','SHENSHANE     ','SHEYRL        ',
							'SHING         ','SHINJI        ','SHIRLYNNE     ','SHOHEI        ','SHUAH         ','SHUCHUAN      ','HACI          ','HILLEARY      ','JENNINGS      ','KULWANT       ',
							'METILDE       ','OLYMPIO       ','PEDRO         ','SAYE          ','SHALA         ','SHAPOUR       ','ANYHONY       ','AZEEM         ','BENNIT        ','BRANTLEY      ',
							'DAYNER        ','DOLPH         ','DUNSTON       ','ESERAGHI      ','HARSHILA      ','HYOUNGJUN     ','JIMI          ','KOSHO         ','LAVONA        ','LONALD        ',
							'LOUVENE       ','MAHIAR        ','SHURL         ','SIB           ','SICESHI       ','SIDDHARGH     ','SIENNA        ','SIGITA        ','SIKUN         ','SIMLA         ',
							'SINDHU        ','SINKUO        ','SISOUVANH     ','SITTIPAN      ','SLAGE         ','SLK           ','SNYRRAH       ','SOFIANE       ','SOKCHEATA     ','SOM           ',
							'SORAYDA       ','SOUHAIL       ','SOVAN         ','SOYKAN        ','SRIKRISHNAN   ','STARLETT      ','STEFAAN       ','STEFIN        ','STELIAN       ','STEPANE       ',
							'SUEANNE       ','SUELGI        ','SUESAN        ','SUHIL         ','SUKARI        ','SULEMA        ','SULOLA        ','SUMAIRA       ','SUNEEL        ','SURRYA        ',
							'SUSHIL        ','SUSZANNE      ','SUVATTHI      ','SWAIN         ','TAFFEE        ','TAGGART       ','TAHANY        ','TAHNJA        ','TAIS          ','TALILA        ',
							'TAMAO         ','TAMERSAAD     ','TAMIEKA       ','TAMMARE       ','TANESHA       ','TANTA         ','TAPLEY        ','TARALINDE     ','TARAN         ','TARRYL        ',
							'TARVINDER     ','TARWYN        ','TECK          ','TEDDI         ','TEINA         ','TENG          ','TENNILLE      ','TERANI        ','TERRU         ','TERUHIKO      ',
							'TESESA        ','THANHGA       ','THARIN        ','THEAWONA      ','THEMISTOCOE   ','THERA         ','THERESSA      ','THERRION      ','THIAN         ','THODUR        ',
							'THONG         ','THOV          ','THREN         ','THUAN         ','THUSHARA      ','TIEISHA       ','TIFFIN        ','TIGER         ','TILFAS        ','TIMOTHEY      ',
							'TINACHERIE    ','TING          ','TINGSHENG     ','TINGSHIH      ','TOMEK         ','TOMEKIA       ','TOMOYUKI      ','TOMY          ','TONBUTDRIAN   ','TONGFU        ',
							'TORYA         ','TOUKTA        ','TOULA         ','TRELLA        ','TRIANE        ','TRILBY        ','TRISA         ','TRIVEN        ','TRUSHAR       ','TSESHIEN      ',
							'TUGSUU        ','TULSIEDAI     ','TUPPENCE      ','TUVINH        ','TUYNH         ','UISANG        ','UNAH          ','UNYONG        ','VACINIA       ','VAFA          ',
							'VALERI        ','VALLERY       ','VALOD         ','VALTAIRE      ','VAMSIDHAR     ','VANVY         ','VARERIE       ','VATHSALA      ','VELANIE       ','VELICIA       ',
							'VENIE         ','VENUGOPAL     ','VENUS         ','VERDIS        ','VERNARY       ','VICHHAY       ','VICKKI        ','VIIVIAN       ','VIJAYALAKS    ','VIJAYENDER    ',
							'VIKENTIA      ','VIOLETTE      ','VIRGILIO      ','VITALIANA     ','VIVEINNE      ','VRIGINIA      ','WAN           ','WANPEN        ','WANZA         ','WAZ           ',
							'WE            ','WEILAI        ','WEISHU        ','WENDELLYN     ','WENHUA        ','WENHWA        ','WENJIN        ','WENKUANG      ','WENLING       ','WENONA        ',
							'WERNER        ','WILLATON      ','WILLEY        ','WINCHAIN      ','WINDY         ','WOODS         ','XIANGEN       ','XIMG          ','YANCHING      ','YANETH        ',
							'YARDENA       ','YASAMAN       ','YASHIRA       ','YEHOUDA       ','YELISEY       ','YEONSIL       ','YHI           ','YIA-CHING     ','YINGQIU       ','YINGSHI       ',
							'YINGZHU       ','YIRLAN        ','YISELL        ','YNON          ','YOJIRO        ','YOLANDA       ','YOONKYEONG    ','YORCKA        ','YOSHIHARU     ','YOULI         ',
							'YOURI         ','YOUSEF        ','YOW           ','YOWMING       ','YUFEN         ','YUHO          ','YULIANNA      ','YUMKWON       ','YUNCHING      ','YUNGSUNG      ',
							'YUNPENG       ','YUNUS         ','YUPEI         ','YURIKA        ','YUSUF         ','ZAKHARY       ','ZAN           ','ZARGHOONA     ','ZCHON         ','ZENAIDA       ',
							'ZEYUN         ','ZHABINEZ      ','ZHAOMING      ','ZHEINA        ','ZHENGFANG     ','ZHIYANG       ','ZHUMANKHI     ','ZIHUA         ','ZINEB         ','ZOHRAB        ',
							'ZULEKHA       ','ZUOPING       ','MARCELLINUS   ','MARGRETTA     ','MARICELLA     ','MARIOLA       ','MARISKHA      ','MARJPLEIN     ','MARLAINA      ','MARLECIA      ',
							'MARMAR        ','MARQUELLE     ','MARRIANNE     ','MASAYUKI      ','MASSIMO       ','MATHILDE      ','MATYAS        ','MAVUNIWO      ','MAXIA         ','MAXX          ',
							'MAYDRA        ','MAYGENIA      ','MCNAMARA      ','MEHJABEEN     ','MEIHAO        ','MEIHUEY       ','MELISSA       ','MELVENEIDA    ','AALIYAH       ','ABHI          ',
							'ABHIJEET      ','ABIGAAIL      ','ABIR          ','ABRAM         ','ABREISHA      ','ABUR          ','ACHELLE       ','ACHILLE       ','ADAMA         ','ADDISWA       ',
							'ADHAM         ','ADLAI         ','ADLER         ','ADOLE         ','ADROLD        ','AEDAN         ','AHMED         ','AHMEREEN      ','AKEEMA        ','AKHMED        ',
							'AKIMA         ','AKWVN         ','ALADDIN       ','ALDRICK       ','ALEJANDRA     ','ALEMAYEHU     ','ALERUCHI      ','ALFONDO       ','ALGIDA        ','ALIKE         ',
							'ALINA         ','ALLESHA       ','ALOI          ','ALPHONSUS     ','ALPHUNO       ','ALSTON        ','ALVIN         ','AMANDAJO      ','AMATO         ','AMBRE         ',
							'AMDREA        ','AMEILIA       ','AMID          ','AMIRHASSAN    ','AMISHA        ','AMPHAI        ','AMYANN        ','ANAHI         ','ANAJULIETA    ','ANALIZA       ',
							'ANALUISA      ','ANAQVOC       ','ANASTASHA     ','ANASTASIYA    ','ANASTASSIA    ','ANASTASSIOS   ','ANATOLE       ','ANDEANA       ','ANETA         ','ANGELIKE      ',
							'ANGELS        ','ANGERLIA      ','ANKER         ','ANNAMARY      ','ANNCHRISTIN   ','ANNDRIA       ','ANNESSA       ','ANNLAUREL     ','ANNUE         ','ANOUMOU       ',
							'ANSHUL        ','ANSLEY        ','ANTAL         ','ANTHNOY       ','ANTHO         ','ANTOINE       ','ANTONI        ','ANTONIETA     ','ANTONIETTA    ','ANTWARNETTE   ',
							'ANURAK        ','AQUILINA      ','ARADA         ','ARAGON        ','ARBI          ','ARCHIE        ','ARDES         ','ARETHIA       ','ARGERO        ','ARGHA         ',
							'ARJANTA       ','ARKADY        ','ARKOCDY       ','ARLAN         ','ARLETA        ','ARMETTA       ','ARMINEA       ','ARSA          ','ARTA          ','ARTEM         ',
							'ARTEMISE      ','ARTIN         ','ARTOO         ','ASDAQ         ','ASHOOR        ','ASPANDYAR     ','ATERET        ','ATOSA         ','AUDREL        ','AUDRI         ',
							'AUDRIEL       ','AUGELITO      ','AUGGIE        ','AUGUSTE       ','AVI           ','AWADE         ','AY            ','AYELLEP       ','AYME          ','AYNET         ',
							'AYOOLA        ','AYOUB         ','AZLAN         ','AZZA          ','BAECKEL       ','BAEK          ','BAFODE        ','BAHI          ','BAIRD         ','BAKER         ',
							'BAOHONG       ','BAOTUAN       ','BAOYAU        ','BARBARAA      ','BARNETT       ','BARRY         ','BARY          ','BARZIN        ','BEHROUSH      ','BEHYAR        ',
							'BELARMINO     ','BENKT         ','BENZIE        ','BERGLIOTH     ','BERK          ','BERNADETT     ','BERNHARD      ','BERTHOLD      ','BHARATHI      ','BICHNGOC      ',
							'BICKLY        ','BIDJAN        ','BIJEN         ','BILKIS        ','BILLEY        ','BILYANA       ','BIN           ','BINGHANG      ','BINGSHIUN     ','BINIA         ',
							'BINTIA        ','BINTU         ','BIRDELL       ','BIRDLENE      ','BIZETTE       ','BLANDA        ','BOBBIJO       ','BOGIE         ','BOHDAN        ','BONAVENTURE   ',
							'BOOYUN        ','BORRE         ','BOTROS        ','BOZANA        ','BRANDEN       ','BRANT         ','BRAXTON       ','BRAYDON       ','BREGMA        ','BREJ          ',
							'BRETT         ','BRIANN        ','BRIANNA       ','BRIDGGETTE    ','BRUINSMA      ','BRYRON        ','BUDE          ','BYON          ','CABARITI      ','CAMARON       ',
							'CAMIE         ','CANDA         ','CAPRICIA      ','CARIANNE      ','CARIN         ','CARLYLSE      ','CARMINA       ','CARMINE       ','CAROTINE      ','CARRERA       ',
							'CARRI         ','CASANDRA      ','CASH          ','CASIDHE       ','CATHI         ','CATHRENE      ','CATHRYNE      ','CATRICE       ','CATRONA       ','CBA           ',
							'CCHAYA        ','CEANE         ','CELESTINO     ','CENOBIO       ','CERIC         ','CHAIM         ','CHAIRUL       ','LINFENG       ','LISAM         ','LISSETTE      ',
							'LIZZ          ','LORIKAY       ','LOURENCO      ','LUANNRENE     ','LUCRECIA      ','LUCRETIA      ','LULE          ','LUP           ','LUZETTA       ','LYLIA         ',
							'LYNN          ','LYNNAE        ','LYNNANN       ','LYS           ','MADLINE       ','MAHADEVAN     ','MAHOTA        ','MAHVEL        ','MALIC         ','MALLIKHARJUNA ',
							'MAMYE         ','MANDONA       ','MANPIU        ','CHAITANY      ','CHAJAVAL      ','CHAKRA        ','CHAKRIT       ','CHANARDAYE    ','CHANCEL       ','CHANDERPAUL   ',
							'CHANDI        ','CHANELLE      ','CHANGTU       ','CHANNEL       ','CHANNY        ','CHANUKA       ','CHAOCHUNG     ','CHARDONNAY    ','CHARLER       ','CHARLTON      ',
							'CHARMAE       ','CHARONNE      ','CHARRETTA     ','CHAUNTELLE    ','CHEAREEN      ','CHELEEM       ','CHENGNAN      ','CHENLUNG      ','CHERIANNE     ','CHERIJEAN     ',
							'CHERLIE       ','CHERY         ','CHEUKFAN      ','CHEVAL        ','CHIANTILU     ','CHIARONG      ','CHIAYANG      ','CHIH          ','CHIHKAO       ','CHIHLIANG     ',
							'CHIKEI        ','CHIMEN        ','CHINGYEH      ','CHIOWLAN      ','CHITRA        ','CHITRANG      ','CHIYAN        ','CHIZARI       ','CHRIOSTOPHER  ','CHRISTOFER    ',
							'CHRISTOHPHER  ','CHUANBIN      ','CHUANG        ','CHUCKY        ','CHUNGCHIEH    ','CHUNGMEI      ','CHUNHANG      ','CHUNYANG      ','CHYRELL       ','CIBA          ',
							'CICELI        ','CINE          ','CISSY         ','CLAES         ','CLAREESA      ','CLARIZEL      ','CLARY         ','CLEMATIS      ','CLIFFORD      ','CLITA         ',
							'CLYDE         ','CLYDEAN       ','COLETT        ','COLLON        ','COLLY         ','CORMAY        ','CORNELLIA     ','CORNER        ','CORSER        ','COULTER       ',
							'CREIGHTON     ','CRIFF         ','CRITTERKIN    ','CURLY         ','CURTISD       ','CYMANDA       ','CYRENA        ','CYRUSS        ','D             ','DACIA         ',
							'DACKIN        ','DAEN          ','DAIDRA        ','DAIHIEU       ','DAIQUIRI      ','DAJI          ','DAKISHA       ','DALLEN        ','DAMAN         ','DAMI          ',
							'DAMRON        ','DANAYA        ','DANCY         ','DANDI         ','DANDREA       ','DANIL         ','DANILYN       ','DANNON        ','DANROY        ','DANUELLE      ',
							'DANYEL        ','DAPORT        ','DAR           ','DARCIA        ','DARIS         ','DARISA        ','DARWINE       ','DATHON        ','DAVITT        ','DAWNN         ',
							'DAYARA        ','DE            ','DEBORAHLEE    ','DEELENA       ','DEIDRA        ','DEIDREANN     ','DELAILAH      ','DELSEDRICK    ','DELTRA        ','DEMAS         ',
							'DEMITRIO      ','DEMONE        ','DENETTE       ','DENIZE        ','DENNET        ','DERESSE       ','DERMOTT       ','DERRICH       ','DERROL        ','DERYL         ',
							'DESERIE       ','DESHAN        ','DESIREA       ','DESTINIE      ','DEVIDA        ','DEVINDER      ','DEVORAH       ','DIANITZA      ','DICKEN        ','DIFEI         ',
							'DILOJAN       ','DIMIRTIOS     ','DIODIO        ','DIONNE        ','DIVINAGRACE   ','DJIBRIL       ','DJUNA         ','DMITRI        ','DODD          ','DODGE         ',
							'DOMINGO       ','DONELL        ','DONGMIN       ','DONICA        ','DONNITA       ','DONYAL        ','DORLYNN       ','DORO          ','DOUANE        ','DOVIA         ',
							'DRINDA        ','DUANFU        ','DUKKU         ','DUOYOU        ','DURWARD       ','DUYNESS       ','EALEEN        ','EARTHALEEN    ','EBELYN        ','ECCHITA       ',
							'ED            ','EDWYNNA       ','EGIDIO        ','EHAB          ','EHTAN         ','EILEENH       ','ELADIA        ','ELANDA        ','ELEEN         ','ELEIZER       ',
							'ELEZ          ','ELFREDA       ','ELGA          ','ELIDA         ','ELIENE        ','ELISSAVET     ','ELIZANDRO     ','ELIZBETH      ','ELLERTON      ','ELLIMAN       ',
							'ELSSAMMA      ','ELTANALIA     ','ELUMALAI      ','ELWORTH       ','ELZIE         ','EMELY         ','EMFA          ','EMMART        ','EMME          ','EMMY          ',
							'ENDIA         ','ENIOLA        ','ENISA         ','ENOC          ','ENRICO        ','ENVALA        ','EPHRAIM       ','ERAINA        ','ERASTUS       ','ERICCA        ',
							'ERISSA        ','ERLENE        ','ERNEST        ','ERVA          ','ERZSEBET      ','ETORI         ','ETTAMAE       ','EUCLID        ','EUI           ','EULA          ',
							'EURQHARDT     ','EVGENI        ','EVLA          ','EWDWARD       ','EYERUSALEM    ','EZZAT         ','FABRICIO      ','FAISSAL       ','FAKHAR        ','FALGUNBHAI    '];

		//1000 Last names
SET OF STRING16	SetLnames := [
							'BIALES          ','COOLING         ','CROTHALL        ','COFRANCESCO     ','ADEKOYA         ','AKAPNITIS       ','ANHOUSE         ','FARIS           ','GELATO          ','MAMROSH         ',
							'PRUNER          ','STRACK          ','TRAYLOR         ','VANSPANJE       ','BARENT          ','BOISITS         ','GALANOPOULOS    ','GALLUB          ','GREENBUSH       ','HAM             ',
							'KALUSKY         ','ODOM            ','PLATE           ','TAUBENFELD      ','YOUCH           ','ALLAM           ','BELSER          ','BLONDEL         ','BOHORQUEZ       ','BONHARD         ',
							'BOWEN           ','CARNEGIE        ','CECCHETTI       ','CORLETO         ','DEMANN          ','GASSLER         ','GEORGEDAKIS     ','KREDA           ','KRUMRINE        ','LAROSEE         ',
							'LAUYER          ','PERFETTO        ','PRANSKY         ','PRITSKER        ','RAKVICA         ','TARGONSKI       ','VONDERLIETH     ','YOSHIKAWA       ','ZAMKOFF         ','AMIJI           ',
							'ANTONSSON       ','APRIGLIANO      ','BACHINSKY       ','BAIR            ','BALTUS          ','BEERMAN         ','BERGSKAUG       ','BOKAVICH        ','BOZORGZADEH     ','CALDERBANK      ',
							'CAPONIGRO       ','CARDENAS        ','CIABATTONI      ','COUSOUNIS       ','CUPPELS         ','DINDO           ','DORSCHEID       ','DRUM            ','DUGEY           ','ELIZONDO        ',
							'FERSKO          ','FLYNCH          ','GANTEAUME       ','GODLEWSKI       ','GUIDA           ','HEMMER          ','KAMIS           ','KOK             ','KURTISI         ','LABONTE         ',
							'LEINBACH        ','LOGUIRATO       ','LOUN            ','MUSANTE         ','NAGLER          ','NOPARSTAK       ','PALANZA         ','PANTALEONI      ','PIRAIN          ','RAVERA          ',
							'RIBBANS         ','SAEGER          ','SAMOLYK         ','SOUSOU          ','WAKSMAN         ','WHITING         ','WLODY           ','WUERTZ          ','AIRD            ','AMAN            ',
							'ANGER           ','ARENCIBIA       ','ARKEL           ','BACHLEDAWALA    ','BAEHNY          ','BARANDES        ','BASARAB         ','BECKSTEAD       ','BHERWANI        ','BLOSSFELD       ',
							'BLUSE           ','BORCHETTA       ','BOUTEILLER      ','BUGAY           ','BUMCROT         ','CANELA          ','CAPOGROSSI      ','CARREKER        ','CASALAINA       ','CATTO           ',
							'CAZIN           ','CHEHANSKE       ','CHYAN           ','CONAHAN         ','CRISALLI        ','DANIC           ','DELEIRE         ','DENISI          ','DENORMAND       ','DESOCIO         ',
							'DEUBER          ','DIEDRICHSEN     ','DINE            ','DIPPLE          ','DODGE           ','DUKESHIRE       ','DUNSIL          ','EASTERLING      ','EHRHARDT        ','EMANO           ',
							'EMMA            ','EMRICH          ','FANTASIA        ','FEIT            ','FINNERTY        ','FRIENDSHUH      ','FYLSTRA         ','GAVILANES       ','GLANCY          ','HAMEL           ',
							'HAROLD          ','HEARTH          ','HEERMANN        ','HELPRIN         ','JAMICKY         ','JODOIN          ','KACHINSKI       ','KALVA           ','KNOWLES         ','KRIAKOV         ',
							'LAFIURA         ','LAMBROS         ','LANAHAN         ','LATKIN          ','LESSEM          ','LINOWES         ','LOIZIDES        ','MACOLINI        ','MARINELLA       ','MASERANG        ',
							'MATTEUS         ','MERINEY         ','MIRAMBEAU       ','MONAHON         ','MORHAIM         ','NOCERITO        ','NYDAM           ','OCONNORAMBROSE  ','OSTROWSKI       ','OSTROWSKY       ',
							'PASIEKA         ','PASIERB         ','PEPPLE          ','PERRINE         ','PIANKO          ','PIKEN           ','RAMUNDO         ','REFINO          ','REHLING         ','RESENDE         ',
							'RESIL           ','RHINES          ','ROLLENCE        ','ROSENCRANS      ','SABB            ','SANTINO         ','SCANGAS         ','SCHEMBARI       ','SHPILSKY        ','SLITER          ',
							'SOTTOSANTI      ','SPARACIO        ','STURKEY         ','TANKSLEY        ','TERRISSE        ','ULRICHS         ','VENDER          ','VITELLO         ','WAGERS          ','WESLEY          ',
							'WESTERFIELD     ','WHITE           ','WIGNOT          ','YESKEVICZ       ','ZABBARA         ','ZAPIEC          ','ZAPPONE         ','ZAPUT           ','ZEKRYA          ','ZIEGLER         ',
							'ZIFFER          ','ZOGLIO          ','ABBENANTE       ','AGUS            ','AIME            ','ALCIDAS         ','ALTIZER         ','ALZATE          ','AMENTA          ','AMUNDARAIN      ',
							'ANDRIANI        ','ANGELL          ','ANGIER          ','ANTONIO         ','ANZA            ','ARIKAN          ','ARONOV          ','BABINEAU        ','BAGDONAVICIUS   ','BAGUIDY         ',
							'BAILER          ','BALCH           ','BALDIERI        ','BALDIZZONE      ','BAUMGARTEN      ','BELKIND-GERSON  ','BELLOG          ','BENJOSEPH       ','BENVIE          ','BERCHIN         ',
							'BERT            ','BIELER          ','BILLIE          ','BINZ            ','BOSSAERT        ','BRAKEL          ','BRIDI           ','BRONFELD        ','BZOZOWSKI       ','CAFONE          ',
							'CAMPOCHIARO     ','CASWELL         ','CATALANOTTI     ','CATARSI         ','CHANDRASEKARAN  ','CLAREY          ','COCHIN          ','COMAS           ','CONSAUL         ','COSFOL          ',
							'CRISCITIELLO    ','CUCURULLO       ','CURTI           ','DALBY           ','DANDROW         ','DARRISAW        ','DEHAY           ','DELANCER        ','DENTE           ','DIGONIS         ',
							'DLUGINSKI       ','DOERING         ','DONLEAVY        ','DUMOUCHEL       ','EITZMAN         ','ELBAZ           ','ELLINGSON       ','ESDELLE         ','FALIK           ','FALLAT          ',
							'FAVETTA         ','FENO            ','FITHIAN         ','FRIERY          ','FROVARP         ','GABREE          ','GAIRY           ','GATTINE         ','GAUME           ','GHEZ            ',
							'GILCHRIST       ','GIRARD          ','GLANFIELD       ','GONDOLFI        ','GOWDIE          ','GREENSHIELDS    ','GREGO           ','GRIESMAN        ','GU              ','GURD            ',
							'GUTHY           ','HARLESS         ','HARRY           ','HAYATH          ','HERKNER         ','HITSCHERICH     ','HOLLABAUGH      ','HOOTSMANS       ','IDROBO          ','INDIG           ',
							'JANOSKY         ','JELSTROM        ','KABADI          ','KAMMA           ','KATZOFF         ','KAU             ','KEAN            ','KILLEEN         ','KIRILL          ','KLAISS          ',
							'KNOBLOCK        ','KOBAN           ','KOSTRZEWSKI     ','KRAVARIK        ','LADDS           ','LEVENBERG       ','LEVERING        ','LIQUORI         ','LUCIN           ','LURITO          ',
							'MALACHOSKY      ','MARCHETERRE     ','MATARAS         ','MATHIESEN       ','MAUS            ','MCNELEY         ','MCNEMAR         ','MIKESCH         ','MILLIARD        ','MINSHALL        ',
							'MISERENDINO     ','MONAKOVA        ','MORISOLI        ','MUKHERJEE       ','NAYDEN          ','NEEDLE          ','NEMATI          ','NORDBY          ','NOURI           ','OLIVARES        ',
							'PALISOC         ','PAOLUCCI        ','PERKES          ','PIESANEN        ','PIZETTE         ','POLOMSKY        ','POMAKOY         ','PUCA            ','QUINTAL         ','RANDER          ',
							'RASCOE          ','ROCCI           ','ROLOFF          ','ROMNEY          ','SAGENDORF       ','SALLAM          ','SALLER          ','SAMBERG         ','SANKAR          ','SCHENCK         ',
							'SCHOEMAN        ','SCHOMER         ','SCHULTHEIS      ','SCHWARTZMAN     ','SCHWEND         ','SCHWIESOW       ','SCIECINSKI      ','SHABE           ','SHAKUN          ','SHANOCK         ',
							'SHEDIAC         ','SHINER          ','SICKLICK        ','SIECZKOWSKI     ','SITKO           ','SLIVINSKI       ','SMEHLIK         ','SONTUPE         ','SOUTHERN        ','SPAGNUOLA       ',
							'SPEZIALE        ','STAMOS          ','STATMAN         ','STOCH           ','STRICKLING      ','STUCKER         ','SUOMINEN        ','SUSSKIND        ','SUTER           ','SWORDS          ',
							'TANNEY          ','TANTON          ','TEMPORA         ','TIFTIKIDIS      ','TOBUREN         ','TRAFACONDA      ','VALLERA         ','VANTINE         ','VANTUNO         ','VENEGAS         ',
							'VILLALON        ','VONEUW          ','WHEEL           ','WIEBER          ','WISSINGER       ','WITKUS          ','WOJCIECHOWSKI   ','WYDA            ','ZEICHNER        ','ZEMANTIC        ',
							'ZITOFSKY        ','ZUZA            ','ABDALLAH        ','AGDERN          ','ALLI            ','ALSABEEH        ','ALSTON          ','ANTOSIEWICZ     ','ARCUNI          ','ARGANT          ',
							'ARIS            ','ARNAU           ','ATIENZA         ','AULISI          ','AYALA           ','BACHLER         ','BAILLIO         ','BAKRIE          ','BAKSH           ','BALLISTER       ',
							'BARNUM          ','BASHAM          ','BATEAU          ','BATTAGLINI      ','BELLITTIERI     ','BENTIVENGA      ','BENVENUTI       ','BERNZWEIG       ','BERSCAK         ','BIFANO          ',
							'BLACKMOND       ','BOBKER          ','BOENNING        ','BOHLINGER       ','BONACCIO        ','BONAVITA        ','BORDIERI        ','BOSSHART        ','BOSYK           ','BOYNTON         ',
							'BOZOF           ','BREULER         ','BRINCKA         ','BROHIM          ','BRUNETTE        ','BUCHAS          ','BUNAG           ','BUONAIUTO       ','BURGOYNE        ','CACCAMISE       ',
							'CANHOTO         ','CAROSELLA       ','CASSARINO       ','CAUDY           ','CHABAK          ','CHEVRIER        ','CHICHESTER      ','CIARCIA         ','CIZMICH         ','CLOUDEN         ',
							'COLARIK         ','CONOR           ','CORSAIR         ','CUTALO          ','CZMAR           ','DADFARIN        ','DANCIU          ','DARMAN          ','DEMILIA         ','DENNEHY         ',
							'DEPASCALE       ','DESIMONE        ','DEVINE          ','DHOLAKIA        ','DICKIE          ','DICOSTANZO      ','DOBROVOLSKY     ','DORTA           ','DOWNIE          ','DREIZEN         ',
							'DREYZIN         ','DUCA            ','DUDRICK         ','DUHAMEL         ','DUKKIPATI       ','DUNCKLEY        ','DUTHEL          ','EACRETT         ','EAKLEY          ','EILBERG         ',
							'EITEL           ','ELBAQALI        ','ELISEO          ','ELITZAK         ','ENIK            ','ESPINOSA        ','EZELL           ','FABRIZIO        ','FANTUZZI        ','FASMAN          ',
							'FEDERIGHI       ','FERSHTADT       ','FIERING         ','FILATOVA        ','FIRESTER        ','FLEAK           ','FLEIG           ','FLINTOFT        ','FOLCKEMER       ','FONTAINA        ',
							'FOROUGHI        ','FORRESTAL       ','FRANZOI         ','FRATTURA        ','FRAZIERPRITCHETL','FREUDENBERGER   ','FRISCO          ','GALIANI         ','GALLAGHER       ','GALUSHKO        ',
							'GAM             ','GAMET           ','GANO            ','GARLING         ','GASBARRO        ','GENCO           ','GENERLETTE      ','GERCHBERG       ','GERONEMO        ','GHANI           ',
							'GLATTS          ','GOBLIRSCH       ','GOPAUL          ','GOWARD          ','GRAMBOR         ','GREENWAY        ','GRIENBERG       ','GRITZ           ','GRUPPER         ','GURDJIAN        ',
							'GURTMAN         ','HAMILLA         ','HARBURY         ','HASIJA          ','HAZALL          ','HENKIN          ','HENNINGS        ','HENZER          ','HILD            ','HORNIK          ',
							'IANNACCONE      ','IBARRA          ','ISRI            ','ITURREGUI       ','IUZZOLINO       ','JACKMAN         ','JENERETTE       ','JOHNSON         ','JOW             ','KALAIE          ',
							'KANDZIOR        ','KARLINER        ','KASSNER         ','KENANA          ','KENES           ','KETTLES         ','KILLOUGH        ','KIRCHOFF        ','KIRKWOOD        ','KJARBO          ',
							'KLANN           ','KLYDE           ','KOLINSKI        ','KOLODIY         ','KONECKE         ','KOPLINER        ','KOREK           ','KORZONOWSKI     ','KOSYLO          ','KOVASALA        ',
							'KRAVEC          ','KRIPAROS        ','KROHG           ','KRUGMAN         ','KRUSKAL         ','KUCONIS         ','KUNZELMAN       ','KUNZMAN         ','LALONE          ','LAN             ',
							'LANDREE         ','LANGDELL        ','LANIER          ','LARACUENTE      ','LARESSO         ','LATANYSHYN      ','LATINO          ','LAUFFER         ','LEFF            ','LEHMKUHL        ',
							'LEVE            ','LINDOW          ','LIPSCHITZ       ','LOCKREM         ','LOEV            ','LOFARO          ','LONGUEIRA       ','LUCKENBACH      ','LUKIS           ','MACKNIS         ',
							'MAFFATTONE      ','MAGLICH         ','MAIKISH         ','MAIZER          ','MAKHIJANI       ','MANAHAN         ','MANJON          ','MARIANELLI      ','MARINAI         ','MARMER          ',
							'MAROLDI         ','MARSHAK         ','MARTURANA       ','MATERSKI        ','MATHISON        ','MATOUK          ','MCELHINNEY      ','MCKESEY         ','MCVAIGH         ','MELLON          ',
							'MELVIN          ','MENDAL          ','METKA           ','MICONE          ','MIERZEJEWSKI    ','MIKOLANDA       ','MILBY           ','MINGIONE        ','MINNELLA        ','MIRONOV         ',
							'MIYAGAWA        ','MOHLMAN         ','MOLYNEAUX       ','MONTREVIL       ','MORITZ          ','MYSLIWIEC       ','NAGURA          ','NAHAM           ','NAHUMI          ','NAJARIAN        ',
							'NERNEY          ','NESLER          ','NICKLAS         ','NOSOWSKY        ','OBALDE          ','ODRICH          ','OESTREICH       ','ORMISTON        ','OSTENBERG       ','OTTEY           ',
							'OURY            ','PACQUING        ','PALDIEL         ','PAPPANO         ','PARAGANO        ','PARLAPIANO      ','PASSON          ','PAVAN           ','PERELMAN        ','PEREZREED       ',
							'PERREIN         ','PERRICELLI      ','PERS            ','PESTER          ','PETACCIO        ','PEYMAN          ','PHIEBIG         ','PILTSER         ','PIUGGI          ','PLESH           ',
							'POMBO           ','PRIVE           ','PRUSZKOWSKI     ','PUNZI           ','QUAIN           ','QUALLEY         ','QUEVILLON       ','RAJKOTIA        ','RAMADA          ','RAPHAELY        ',
							'RATCLIFF        ','RAUSEN          ','RAVEY           ','REDWOOD         ','REMBIESA        ','REPETTI         ','RHAEL           ','RIAD            ','RIDOLPH         ','RISHTY          ',
							'ROKE            ','ROSINSKI        ','ROSKO           ','RYBNICK         ','SAIA            ','SAJER           ','SAJJA           ','SALEEMI         ','SALEMBIER       ','SALITURO        ',
							'SALOMONE        ','SANDYK          ','SARG            ','SARRAZOLA       ','SCELTA          ','SCEUSA          ','SCOZZARI        ','SCZANIECKI      ','SEIFF           ','SELIBER         ',
							'SENTIE          ','SHAMORY         ','SHAULSON        ','SHEBER          ','SHED            ','SHEINBERG       ','SHENDER         ','SHIMA           ','SHISKIN         ','SHOCAIR         ',
							'SILOCK          ','SILVAGGIO       ','SILVEY          ','SIMINKAS        ','SINGAPOREWALLA  ','SKELPS          ','SKLENKA         ','SNIEGOCKI       ','SOBER           ','SOBIERI         ',
							'SOLIMEO         ','SPACE           ','SPARROW         ','SSEMPA          ','STASINOS        ','STAVENIK        ','STECKLAIR       ','STEGNER         ','STEPNOWSKI      ','STERNAL         ',
							'STPETER         ','SUBTIL          ','SULC            ','SURKIN          ','SWEIGART        ','TAI             ','TANZOLA         ','TEARE           ','TEDALDI         ','TERICK          ',
							'TERTULIANO      ','THAM            ','TONI            ','TORREGIANI      ','TORREY          ','TOUTAIN         ','TREPKAU         ','TRICKETT        ','TRUSTY          ','TURNEA          ',
							'UMANSKY         ','VALDOVINOS      ','VALEROSO        ','VENKATARAMAN    ','VERHAGE         ','VIJ             ','VINTIMILLA      ','VITOVITCH       ','VYAS            ','WAIT            ',
							'WARESK          ','WARO            ','WARRICK         ','WASILOW         ','WEDE            ','WEGIELNIK       ','WEISHAAR        ','WENG            ','WESTENHISER     ','WILENS          ',
							'WINDLE          ','WIZOREK         ','WOMBOUGH        ','WOODTKE         ','WORRILOW        ','XIA             ','YASKOV          ','YAZMER          ','YEGOROV         ','YOFFEE          ',
							'YOUNG           ','YOUSUFUDDIN     ','ZANANIRI        ','ZIGLER          ','ZUBRYCKY        ','ZUHOSKI         ','ABOUDI          ','ACERRA          ','ACEVEDO         ','ADORNO          ',
							'AFFEL           ','AGOSTINELLO     ','ALAGO           ','ALDERDICE       ','ALEXIS          ','ALLEGAR         ','ALLEY           ','ALMONACID       ','ALTON           ','AMBLARD         ',
							'ANG             ','ANGAROLA        ','ANICITO         ','ANKIER          ','APAGHIAN        ','ARADO           ','ARANDO          ','ARBORIO         ','ARCA            ','ARCE            ',
							'ARD             ','ARMSADOWSKI     ','ARNAUD          ','ARRIZZA         ','ASADOORIAN      ','ASCHER          ','ASOULINE        ','BAFFONI         ','BAGGIO          ','BAGWELL         ',
							'BALASCO         ','BANSPACH        ','BARILA          ','BARNEA          ','BARNICKEL       ','BARNO           ','BATJIAKA        ','BAUNACH         ','BELLANGER       ','BELLOISE        ',
							'BENADRETE       ','BENDERS         ','BESSALELI       ','BETHEA          ','BIBBO           ','BIELAT          ','BIRCH           ','BIZOUSKY        ','BLACKLEY        ','BOGOLIOUBOV     ',
							'BONADIO         ','BONETTO         ','BONNY           ','BORDNE          ','BOSHA           ','BOURGET         ','BOUYET          ','BOWER           ','BOWHILL         ','BREEZE          ',
							'BRIDA           ','BRIGATI         ','BROADLEY        ','BROCK           ','BROCKDORFF      ','BRYANT          ','BUDICINI        ','BUKOWSKI        ','BUNBURY         ','BURKETT         ',
							'BURLETIC        ','BURRECE         ','BUSHUE          ','BUTTS           ','CALLARI         ','CALLENDER       ','CAMPIONE        ','CAPLAN          ','CAPOSSELA       ','CAPPONI         ',
							'CARLINI         ','CARNAZZA        ','CARNERO         ','CARPIO          ','CARRESI         ','CARVELLI        ','CASAMASSA       ','CASELLI         ','CASTILLERO      ','CATTIE          ',
							'CEBECI          ','CEMELLI         ','CERDEIRA        ','CERNAVA         ','CHAKIDES        ','CHALKIAS        ','CHAMPANERIA     ','CHANKO          ','CHARITONCHICK   ','CHATZOPOULOS    ',
							'CHICK           ','CHIODI          ','CHOPLIN         ','CHURCHWELL      ','CIGICH          ','CLAFFEY         ','CLEVERLY        ','COHOON          ','COLADANGELO     ','COMITAS         ',
							'CONVERY         ','CORBEIL         ','CORDING         ','CORFORTE        ','CORNICK         ','COSGRIFF        ','COVENTRY        ','COZZENS         ','CRAIGUE         ','CRATTY          ',
							'CRITES          ','CUPKOVIC        ','CUPRILL         ','CURBELO         ','CURTACHIO       ','CUTTS           ','DAHDOUH         ','DANISH          ','DAVIDIAN        ','DECOSTOLE       ',
							'DEHORATIUS      ','DEHUFF          ','DELAESPADA      ','DELISE          ','DELMONTE        ','DELURIO         ','DEMBO           ','DENTALE         ','DEPREY          ','DERITO          ',
							'DESANTI         ','DESIATO         ','DESIERO         ','DETULLIO        ','DEVEDJIEV       ','DEZEGO          ','DIASPARRA       ','DICAPUA         ','DIFORTE         ','DIIORIO         ',
							'DIMATTIA        ','DINGLE          ','DINICE          ','DINKELACKER     ','DISIMONE        ','DISPENSA        ','DIXE            ','DOLDERER        ','DONLEY          ','DOTTORI         '];

		//2400 street addresses to choose from
SET OF STRING31	SetStreets := [
								'1 SANDHURST DR                 ','1 SPENCER LN                   ','1 SYCAMORE LN                  ','1 TULIP RD                     ','1 W DEDHAM ST # B              ','1 WILSHIRE DR                  ','10 ABBETT AVE                  ','10 ARNOLD CIR                  ','10 BELCHERTOWN RD              ','10 BRIAN TER                   ',
								'10 CAPI LN                     ','10 CHURCH ST                   ','10 CORINNE LN                  ','10 DEER HOLLOW DR              ','10 E 29TH ST APT 17G           ','10 EMERALD LN                  ','10 FORD RD                     ','10 GREAT PLAIN TER             ','10 HELLBERG AVE                ','10 ICE HOUSE DR                ',
								'10 KEELERS RIDGE RD            ','10 LENOX PL                    ','10 MANHATTAN AVE APT 3A        ','10 MICHAEL DR                  ','10 NASON ST                    ','10 OSBORNE LN                  ','10 PENN DR                     ','10 RADNOR RD                   ','10 ROCK HILL LN                ','10 SAXON CT                    ',
								'10 SPINNING WHEEL RD           ','10 TAHOE CT                    ','10 TURNER CT                   ','10 W 15TH ST APT 927           ','10 WATERWHEEL CT               ','10 WINE SAP RUN                ','100 ASPEN DR                   ','100 CHAMBERS ST FL 2           ','100 E PALISADE AVE APT C11     ','100 HENRY ST # 307             ',
								'100 LAKESIDE DR                ','100 PARK AVE # 13FL            ','100 RUTGERS ST                 ','100 VAN CORTLANDT PARK         ','100 W 94TH ST APT 16F          ','1000 SHARPLESS RD              ','1002R WASHINGTON ST            ','1005 DEERFIELD CIR             ','1008 GATES PL                  ','101 BUTTERNUT DR               ',
								'101 DEVON DR                   ','101 HILLTOP DR                 ','101 MEDFORD BLVD               ','101 QUEEN ST                   ','101 W 12TH ST                  ','101 W 79TH ST # 2              ','101 WITMER RD # 700            ','10115 222ND ST                 ','10148 131ST ST                 ','10176 DEDAKER DR               ',
								'102 BRUNSWICK RD               ','102 GAINSBOROUGH ST APT 105E   ','102 MAIN ST APT 1              ','102 SCHOOL HOUSE RD            ','102 YEAKEL AVE # 2ND           ','1022 ROUTE 35                  ','1025 NEW BROOKLYN RD           ','103 12TH ST APT 5              ','103 CUTTERMILL RD              ','103 LARKSPUR LN                ',
								'103 RUSTIC ACRE DR             ','103 WOODLAND TRL               ','10326 68TH AVE APT 4G          ','1037 CLINTON ST # FL2          ','104 CARMEL CT                  ','104 GRACE LN                   ','104 MIZZEN AVE                 ','104 SALEM RD # K               ','104 WILLOW GLADE CT # 125      ','10428 191ST ST                 ',
								'1047 E 222ND ST                ','105 BERKSHIRE LN               ','105 DOUGLASS ST # 1            ','105 HARBOR DR APT 105          ','105 MONTAGUE ST APT 202        ','105 RIDGEWOOD TRL              ','105 W 28TH ST FL 3             ','1051 BEAUMONT RD               ','10555 62ND DR APT 2H           ','106 ALTIER AVE                 ',
								'106 E 17TH ST APT 3R           ','106 KENWOOD AVE                ','106 PINEWOOD TRL               ','106 W 76TH ST APT A            ','1062 BARBEY ST # 1             ','1069 HASTINGS ST # 1           ','107 DOROTHY LN                 ','107 LILAC DR                   ','107 SALLY DR                   ','107 W 82ND ST BSMT 103         ',
								'10715 103RD ST                 ','1078 E 38TH ST                 ','108 CENTRAL AVE                ','108 FORREST PL                 ','108 LINCOLN PARK E             ','108 POINT CIR S                ','108 W 95TH ST APT 3FW          ','10822 35TH AVE                 ','1087 VIKING DR                 ','109 COUNTRY FARMS RD           ',
								'109 KETCHAM RD                 ','109 READE ST APT 5             ','109 WALNUT VALLEY RD           ','10937 214TH ST                 ','11 ACORN HL                    ','11 AUSTIN CIR                  ','11 BIRD ST # 543               ','11 BURDICK AVE                 ','11 CHARLOTTE DR                ','11 COMMUNITY PL                ',
								'11 DANIELS DR                  ','11 DUCK POND CT                ','11 ELY CT                      ','11 FOREST VIEW DR              ','11 GRAND AVE                   ','11 HEMENWAY RD                 ','11 HUNTS LN # 1FL              ','11 KIMBERLY CT                 ','11 LIGHTHOUSE CT               ','11 MANOR TER                   ',
								'11 MISTY RIDGE CIR             ','11 NORCLIFF LN                 ','11 PAR LN                      ','11 PINE RIDGE RD               ','11 REGIONAL RD                 ','11 ROSE LN                     ','11 SCHOOLHOUSE WAY             ','11 SOUNDVIEW DR                ','11 SURREY RD                   ','11 TRINITY CT                  ',
								'11 WALDEN WOODS                ','11 WILLOW AVE                  ','11 ZINNIA DR                   ','110 CHRISTOPHER ST APT 41      ','110 FIFERS LN                  ','110 LONGWOOD CIR               ','110 RANDOM FARMS DR            ','110 W 26TH ST # 3RD            ','110 WOOSTER ST                 ','1102 AVALON GATES # 1L         ',
								'1105 57TH ST                   ','1108 BEVERLEY RD               ','111 ANNIE LN                   ','111 DEBORAH DR                 ','111 GAINSBOROUGH ST            ','111 JOJO RD                    ','111 PASSAIC AVE APT A40        ','111 VALENTINE ST               ','1110 CEDAR ST                  ','1112 COVERED BRIDGE XING       ',
								'11142 133RD ST                 ','1117 WASHINGTON AVE            ','112 CLARKE AVE                 ','112 HIDDEN CT                  ','112 OLD BAY ST                 ','112 W 73RD ST APT 4E           ','1122 BRIAN CT                  ','1125 AVALON COURT DR           ','1129 SOUTH AVE W               ','113 GATES AVE APT 4            ',
								'113 SMOKEY HOLLOW RD           ','1130 US HIGHWAY 46 # 46        ','1136 EDISON AVE                ','114 BRENTWOOD CIR              ','114 E CRESSE AVE               ','114 JUNIPER LN                 ','114 PINE ST                    ','114 WYNDMERE RD                ','1143 GOLDEN POND CT            ','1147 MOTOR ST                  ',
								'115 BUCKINGHAM RD              ','115 E 92ND ST # 3C             ','115 JEWETT ST                  ','115 PARK ST                    ','115 SWINNERTON ST              ','115 WILLOW ST APT 4F           ','11531 209TH ST                 ','1159 BRIGHTON BEACH AVE APT 6H ','116 CYDOT DR                   ','116 LAKE RD                    ',
								'116 RAINIER CT APT 12          ','116 W 73RD ST APT 2A           ','1161 YORK AVE APT 3N           ','1167 DICKINSON DR              ','117 COLD STREAM TRL            ','117 INVERNESS DR               ','117 RICHMOND ST # 0            ','117 W WOLFERT STATION RD # R   ','1175 BOYLSTON ST APT 1         ','118 BALTUSROL RD # O           ',
								'118 FAIRFIELD ST               ','118 N FAIRFIELD RD             ','118 W 109TH ST APT 2E          ','11818 UNION TPKE APT 10E       ','1186 E 46TH ST                 ','119 COMPO RD N                 ','119 LORI CIR                   ','119 SCHOOL DR                  ','1191 BRISTOL RD                ','1199 MARION RD                 ',
								'12 APPLETREE WAY               ','12 BENJAMIN KIDDER LN # 0      ','12 BUCKINGHAM RD               ','12 CHESSET LN                  ','12 CRANE CIR                   ','12 DUDLEY TOWNE RD             ','12 ELM TER                     ','12 FREDON RD                   ','12 GREGORY FARM RD             ','12 HILLSIDE CIR                ',
								'12 JENNIFER LN                 ','12 LAWRENCE DR                 ','12 MANOR RD                    ','12 MONROE DR                   ','12 OAKLAND DR                  ','12 PERSHING PL                 ','12 RACOON DR                   ','12 RUBENSTEIN ST               ','12 SHERWOOD DR                 ','12 STONYBROOK RD               ',
								'12 TOWER HILL DR               ','12 W 72ND ST APT 7A            ','12 WILLOW PKWY                 ','120 BEAUMONT DR                ','120 E 1ST ST APT 6             ','120 FARMINGTON AVE             ','120 LYNN AVE                   ','120 RASPBERRY PATCH DR         ','120 W 44TH ST # 305            ','1200 BYBERRY RD                ',
								'1202 HARRISON ST               ','1205 SYCAMORE LN               ','1209 PINE RIDGE DR             ','121 E 77TH ST APT 4N           ','121 LORRAINE AVE               ','121 READE ST # 8B6             ','121 W 78TH ST APT 4F           ','12112 BIG BUCK LN              ','1215 PARK AVE APT 4F           ','122 5TH AVE FL 3               ',
								'122 E 82ND ST APT 5A           ','122 MULBERRY DR                ','122 TRIANON LN                 ','12215 25TH RD APT 302          ','1226 2ND AVE                   ','123 BRISTOL DR                 ','123 HIGH ST APT 40             ','123 RIDGEWOOD WAY              ','123 W 78TH ST APT 1            ','1232 BLOOMFIELD ST             ',
								'1234 FERNRIDGE DR              ','124 BLACK ROCK TPKE            ','124 HARRISON AVE               ','124 RUSSET RD                  ','124 W 60TH ST APT 25F          ','1242 DEAN ST APT 2B            ','1248 BLOOMFIELD ST APT 1       ','125 CENTRAL AVE APT B4         ','125 FIFTH AVE APT 10C          ','125 MALCOLM RD                 ',
								'125 SAINT FELIX ST # 1         ','125 WASHINGTON ST APT 302      ','1256 N COUNTRY RD              ','126 E 12TH ST APT 4A           ','126 MANHATTAN AVE              ','126 TROY HILLS RD              ','12607 9TH AVE                  ','127 4TH AVE APT 2C             ','127 FARRELL ROAD EXT           ','127 REMSEN ST APT 3A           ',
								'127 WHIPSTICK RD               ','1275 E 51ST ST APT 7R          ','128 COUNTRY RIDGE DR           ','128 MEADOW LN                  ','128 W 70TH ST                  ','1287 HOPE ST APT B             ','129 CROSSTIE DR                ','129 MARKWOOD DR                ','129 W 22ND ST # 108            ','1296 OLD NORTH MAIN ST         ',
								'13 AVENUE A                    ','13 CAMBRIDGE CT                ','13 CRESCENT DR                 ','13 ELIZABETH DR                ','13 GODDARD DR                  ','13 IRISH SETTER LN             ','13 LINDEN LN                   ','13 MULBERRY RD                 ','13 PIEDMONT AVE                ','13 S CHANCELLOR ST             ',
								'13 SUNNYBROOK CIR              ','13 W 89TH ST APT 1             ','13 WOODLAND LN                 ','130 CENTRAL AVE                ','130 HARBOR RD                  ','130 PARADE HILL RD             ','130 W 16TH ST APT 54           ','1300 MAXIM SOUTHARD RD         ','13022 127TH ST                 ','1305 W MOUNTAIN AVE            ',
								'1309 LARBOARD CT               ','131 E 83RD ST APT 3G           ','131 PARSONS DR                 ','131 US HIGHWAY 46 W APT 36     ','13111 KEW GARDENS RD APT 6F    ','1315 90TH ST                   ','132 AMITY ST # 4               ','132 EVERGREEN TER              ','132 PIPING ROCK RD             ','132 W 95TH ST APT 3            ',
								'1320 YORK AVE APT 29M          ','13240 220TH ST                 ','1329 JEFFREY LN                ','133 GAFF RD                    ','133 PARK AVE APT 3             ','133 WELDON ST                  ','1333 HUDSON ST APT 215N        ','134 9TH AVE APT 4R             ','134 GERARD DR                  ','134 RIGBY RD                   ',
								'13400 PACIFIC AVE              ','1348 38TH ST                   ','135 COMSTOCK HILL RD           ','135 HOLLYWOOD XING             ','135 POST AVE APT 4G            ','135 W 79TH ST # 7              ','1352 BROOKEDGE DR              ','1359 DIAMOND HILL RD           ','136 E 55TH ST APT 3A           ','136 MOORE RD                   ',
								'136 SUNRISE DR                 ','13602 N ATLANTIC AVE           ','1365 YORK AVE APT 17M          ','137 BLUEBIRD DR                ','137 HIGH CLEAR DR              ','137 SAINT PAUL ST              ','1372 BROADWAY                  ','1376 MIDLAND AVE APT 807       ','138 E 37TH ST                  ','138 PERRY DR                   ',
								'1380 CHELSEA RD                ','1386 E 48TH ST                 ','139 E 30TH ST APT 3D           ','139 MILL POND HEIGHTS RD       ','139 WEBB CIR                   ','1394 YORK AVE APT 6D           ','14 AMESBURY PL                 ','14 BARK AVE                    ','14 BRIMBAL HILLS DR            ','14 CHANDLER CT                 ',
								'14 CORTLAND DR                 ','14 DICKENSON CT                ','14 EL TORO DR                  ','14 FOREST GLEN DR              ','14 GREEN HERON DR              ','14 HEWLETT RD                  ','14 ISABELLA ST                 ','14 KINGS HWY                   ','14 LOCUST AVE                  ','14 MEGAN DR                    ',
								'14 NATANIS RIDGE CIR           ','14 OXFORD DR                   ','14 POMEROY LN                  ','14 ROGERS RD                   ','14 SEYMOUR DR                  ','14 STREAM VIEW LN              ','14 TULIP TREE LN               ','14 WASHINGTON PL APT 9J        ','14 WOOD DR                     ','140 CALLE CARITE               ',
								'140 E 7TH ST APT 1G            ','140 MAIN ST APT 22             ','140 SAWMILL RD                 ','140 W END AVE APT 16H          ','1402 E 70TH ST                 ','1405 LOCUST CT                 ','1409 72ND ST                   ','141 E 55TH ST APT 11D          ','141 MAIN ST                    ','141 W 13TH ST APT 101          ',
								'1411 WALNUT ST APT 605         ','1416 BARTON DR                 ','142 BOWERY APT 3               ','142 INWOOD RD                  ','142 W 44TH ST APT 73           ','14205 ROOSEVELT AVE APT 334    ','1426 E 85TH ST                 ','143 COLUMBUS PL APT 3          ','143 NOTCH RD                   ','143 WEBSTER AVE                ',
								'1434 W 9TH ST                  ','1438 ORANGE TPKE               ','144 FAIRBROOK DR               ','144 SALINA RD                  ','1440 FREEPORT LOOP APT 2C      ','14444 28TH AVE                 ','145 4TH AVE APT 11M            ','145 E 15TH ST APT 15U          ','145 FAIRVIEW AVE               ','145 PINCKNEY ST APT 323        ',
								'145 W 67TH ST APT 29B          ','1450 HERZEL BLVD               ','1455 STERLING PL               ','146 CHELMSFORD RD              ','146 PAYNE WHITNEY LN           ','1460 60TH ST                   ','1465 E PUTNAM AVE APT 112      ','147 BRANDON CT                 ','147 MATTHEWS FARM RD           ','1470 1ST AVE APT 4D            ',
								'1474 60TH ST                   ','148 CARLI BLVD                 ','148 NATHAN LN                  ','148 WAINWRIGHT DR S            ','14847 EDGEWOOD ST              ','149 DRAKE AVE APT 11           ','149 SHORTWOODS RD              ','1492 PUSHAW RD                 ','1498 GREENLEAF DR N            ','15 APPLESEED DR # 0            ',
								'15 BEECHWOOD LN                ','15 BRINCKERHOFF AVE            ','15 CASTOR PL                   ','15 COGSWELL AVE                ','15 DANIELLE DR                 ','15 E ATLANTIC AVE              ','15 EXETER CT                   ','15 GAINES ST                   ','15 GROSSMAN ST                 ','15 HIGHVIEW CIR                ',
								'15 JAMOR CT                    ','15 KRUEGER CT                  ','15 LITTLE FOX LN               ','15 MARY ELLEN DR               ','15 MULBERRY AVE                ','15 ORCHARD PL                  ','15 PINEVIEW RD                 ','15 RIVERSIDE DR                ','15 SAINT SAVEUR CT             ','15 SNYDER RD                   ',
								'15 SURREY LN APT F             ','15 VANDAM ST                   ','15 W MINERVA RD                ','15 WHITNEY LN                  ','15 YORKTOWN DR                 ','150 E 39TH ST APT 1407         ','150 HALFWAY POND RD            ','150 PEPPERIDGE RD              ','150 W 21ST ST APT 2G           ','1500 HUDSON ST APT 5B          ',
								'15018 58TH AVE                 ','15046 72ND DR APT 1C           ','1509 UTOPIA PKWY               ','151 E 31ST ST APT 27D          ','151 LITTLEWORTH LN             ','151 UNION ST # 1               ','15120 33RD RD # 33             ','1516 W PARK AVE                ','152 E 22ND ST APT 1F           ','152 PINETREE CT # 19           ',
								'1520 WOODCREST CIR # M         ','1525 THOMAS JEFFERSON CT # T   ','153 E 43RD ST APT 3C           ','153 MOUNTAIN AVE               ','153 WOODBINE DR                ','1537 WINDWARD AVE              ','154 GREELEY AVE                ','154 THURBER AVE                ','1541 RANDOW RD                 ','155 ATHERTON DR                ',
								'155 E 31ST ST APT 17H          ','155 FAIRVIEW AVE               ','155 RIVERSIDE DR               ','155 W 68TH ST APT 1216         ','1551 E COBBLESTONE CIR         ','156 2ND AVE APT 5B             ','156 GILLIES LN                 ','156 W 74TH ST APT 1C           ','15647 78TH ST                  ','157 CRAB APPLE LN              ',
								'157 MANOR DR                   ','1570 GREGORY DR                ','1577 E 48TH ST # 2             ','158 GRAND ST RM 207            ','158 W 81ST ST APT 53           ','1585 MARIE CIR                 ','159 GLEN ST                    ','159 SMITH RD                   ','15934 RIVERSIDE DR W APT 2B    ','16 ANPELL DR                   ',
								'16 BELL LN                     ','16 BRUNSWICK AVE               ','16 CHESTER AVE                 ','16 CUTTING ST                  ','16 DURHAM ST # 2               ','16 FARROW ST                   ','16 GERVAISE DR                 ','16 HASSAKE RD                  ','16 ILEX CT                     ','16 KNOLL LN                    ',
								'16 LUNDVALL RD                 ','16 MILL ROAD EXT               ','16 NUTMEG LN                   ','16 PAVILION RD                 ','16 RED CLOVER CIR              ','16 SADDLER DR                  ','16 STARWOOD LN                 ','16 TICKNOR ST                  ','16 W 16TH ST APT 14NS          ','16 WEYBOSSET ST                ',
								'160 ALEXANDER DR               ','160 E 39TH ST # 1              ','160 HOWARD AVE                 ','160 STEEP HILL RD              ','160 W 71ST ST APT 15T          ','1600 BOSTON NECK RD            ','16015 108TH AVE FL 1           ','1606 BOULEVARD                 ','161 CLIVEDEN DR                ','161 MOUNTAIN RD                ',
								'161 W 15TH ST APT 6B           ','1611 WASHINGTON BLVD APT 26    ','1617 DOGWOOD RD                ','162 CLAFLIN BLVD               ','162 PEPPER ST                  ','1621 EDGEWOOD AVE              ','1627 LIBERTY DR                ','163 E 92ND ST APT 3            ','1630 2ND AVE APT 3FN           ','1636 3RD AVE APT 4B            ',
								'164 ERASMUS ST                 ','164 W 25TH ST FL 12            ','16424 96TH ST                  ','165 CHRISTOPHER ST APT 2C      ','165 LONGWOOD DR                ','165 W 66TH ST APT 2U           ','1652 WANTAGH AVE               ','166 DUANE ST # 7C              ','166 OLD BROOKFIELD RD # 30     ','166 WIMAN AVE                  ',
								'1666 NEWVILLE RD               ','167 FREMONT ST                 ','167 SOUTH ST                   ','1675 YORK AVE # 122            ','168 E 80TH ST APT 2C           ','168 SMULL AVE                  ','1689 3RD AVE APT 2             ','169 LOCUST AVE                 ','1691 2ND AVE APT 2S            ','17 ANEMONE LN                  ',
								'17 BERKELEY PL APT 2R          ','17 BYRAM BROOK PL              ','17 CHRISTINE CIR               ','17 DAVIS AVE                   ','17 EDGEWOOD PL                 ','17 FOREST PARK RD              ','17 HADLEY DR                   ','17 HOLLY LN                    ','17 KAREN TER W                 ','17 LINCOLN RD                  ',
								'17 MATTERHORN DR               ','17 N MEADOW RD                 ','17 PARLIN ST # A               ','17 QUINN RD                    ','17 SANDY LN                    ','17 STONEYBROOK RD              ','17 TREAT AVE                   ','17 WANDER CT                   ','17 WOOD VIEW DR                ','170 E 2ND ST # 1               ',
								'170 HIGHLAND ST APT 121        ','170 TREMONT ST APT 805         ','17005 LITHONIA AVE # 1         ','1706 OLD MILL RD               ','171 E 83RD ST APT 5D           ','171 MAIN AVE                   ','171 W 85TH ST                  ','1714 SHORE BLVD                ','172 DEERFIELD DR               ','172 RUMFORD RD                 ',
								'1722 RALPH AVE                 ','1729 WEIDNER CT                ','173 RIVER RD                   ','1734 NOSTRAND AVE # 3          ','174 E 90TH ST APT 2A           ','174 THOMPSON ST APT 5RS        ','1748 ROSEDALE AVE              ','175 E 91ST ST APT 4B           ','175 MILLTOWN RD                ','175 W 76TH ST                  ',
								'175 WILLIAMS ST E              ','1755 YORK AVE APT 34B          ','176 EDGEMERE DR                ','176 W 87TH ST # 7D             ','1769 PAPER MILL RD             ','177 MYANO LN APT 401           ','1774 UPPER BRIGGS HOLLOW RD    ','178 CEDAR HEIGHTS RD           ','178 OLD MILL DR                ','1786 AMSTERDAM AVE APT 5A      ',
								'179 LAKEWOOD DR                ','17B BIGELOW ST                 ','18 BALLINGER WAY               ','18 BRIGHTMAN RD                ','18 CHESTNUT AVE                ','18 CRESCENT BEACH RD # 604     ','18 E 33RD ST                   ','18 FIDELITY PL                 ','18 GREAT OAKS DR               ','18 HIGHVIEW LN                 ',
								'18 KENDALL RD                  ','18 LINSAL ST                   ','18 MELISSA LN                  ','18 OAK GROVE RD                ','18 PETERSON RD                 ','18 RHODE AVE                   ','18 SCHULTZ ST                  ','18 SUBURBAN AVE                ','18 VALLEY RD                   ','18 WHITMAN ST                  ',
								'180 BLACK WALNUT DR            ','180 ISLAND POND RD             ','180 SEEKONK ST # 0             ','1801 HOOD LN                   ','1806 S CRESCENT BLVD           ','181 ERIE ST APT 204            ','181 THOMPSON ST APT 17         ','1815 MEADOWS RD                ','182 E 95TH ST APT 14A          ','182 PARTRIDGE COVE RD          ',
								'1822 SWEETS CORNERS RD         ','183 CENTRAL PKWY               ','183 UNCAS AVE                  ','1839 VIRGINIA AVE              ','184 LYNDALE AVE                ','1841 MEADOWBROOK RD            ','185 DORIAN LN                  ','185 PARK ROW APT 15A           ','1852 TROY AVE                  ','186 FOREST ST                  ',
								'186 WAYNE ST APT 116D          ','187 E 4TH ST APT 2L            ','187 WASHINGTON AVE             ','188 CRANBERRY CT               ','188 WASHINGTON VALLEY RD       ','189 FARM HILL RD               ','189 W QUACKENBUSH AVE          ','19 AMBERFIELD DR               ','19 BEVERLY PL                  ','19 CARLTON RD                  ',
								'19 CLOVERHILL DR               ','19 DECATUR ST                  ','19 ENT RD                      ','19 FROG HOLLOW RD              ','19 HARBOUR TER                 ','19 HOMEWOOD DR                 ','19 KNOLLWOOD DR                ','19 MACDONNELL HTS              ','19 MOORE ST                    ','19 OVERLOOK DR                 ',
								'19 PURCHASE ST                 ','19 SAINT MORITZ LN             ','19 STEELE HILL RD              ','19 TODD DR                     ','19 W GATE RD                   ','19 WOODS RD                    ','190 E 72ND ST # 10C            ','190 SHARP HILL RD              ','1904 ASTER RD                  ','191 DUNDEE DR                  ',
								'191 UPLAND RD                  ','1915 MAPLEWOOD LN              ','192 OAKFIELD AVE               ','1927 80TH ST                   ','193 SAINT BOTOLPH ST # 5       ','194 BELMAR AVE                 ','194 WASHINGTON PARK APT 2      ','195 BINNEY ST APT 2317         ','195 RUTLAND ST                 ','196 12TH ST                    ',
								'196 OLD JAFFREY RD             ','1967 BYRON AVE                 ','197 PARK ST                    ','198 BOOT RD                    ','198 YALE CT                    ','199 MARLBOROUGH ST             ','2 2ND AVE # A                  ','2 AYRES WAY                    ','2 BLACKBERRY LN                ','2 BUCKTHORN LN                 ',
								'2 CHARLTON ST APT 12H          ','2 COLUMBUS AVE APT 18C         ','2 DANSPENCE RD                 ','2 DUNKIN DR                    ','2 EVERETT DR                   ','2 FULLER PL                    ','2 HARING LN                    ','2 HOLLY DR                     ','2 JEAN DR                      ','2 LACEBARK LN                  ',
								'2 LINDEN LN # 0                ','2 MARSHALL AVE                 ','2 MOUNTAIN TOP CT              ','2 OLD FARM CT                  ','2 PEMBROOK AVE                 ','2 QUAIL HILL RD                ','2 ROSECLIFF DR                 ','2 SHADY LN                     ','2 SQUIRREL HILL RD             ','2 TALCOTT FOREST RD APT D      ',
								'2 TUDOR CITY PL APT 4LN        ','2 WALNUT GROVE DR STE 230      ','2 WINTERBERRY LN               ','20 ALBRIGHT RD                 ','20 BARTLETT PL APT 1           ','20 BROAD ST E                  ','20 CHAPEL ST                   ','20 COUNTRY GREENS DR # A       ','20 DRIFTWAY POINT RD           ','20 ELIZABETH ST # 1            ',
								'20 GLEN RD                     ','20 HEREFORD DR                 ','20 JEREMIAH RD                 ','20 LEXINGTON HILLS RD # 5      ','20 MCKESSON HILL RD            ','20 NICKERSON FARM WAY          ','20 PATANIA CT                  ','20 QUAIL HOLLOW DR             ','20 RIVER RD APT 6J             ','20 SCOUT TRL                   ',
								'20 STRAWSTONE LN               ','20 UNDERHILL ST                ','20 W 76TH ST                   ','20 WHITE OAK CT                ','200 AVONDALE DR                ','200 DOMAIN DR                  ','200 E 32ND ST # 14A            ','200 E 61ST ST APT 12E          ','200 E 81ST ST APT 3A           ','200 E 90TH ST APT 25A          ',
								'200 LEXINGTON AVE APT 5C       ','200 RECTOR PL APT 10K          ','200 W 102ND ST APT 4E          ','200 W 60TH ST APT 6G           ','200 W 98TH ST APT 5W           ','2000 BROADWAY APT 6K           ','2005 N 2ND ST APT 2            ','201 CLINTON AVE                ','201 E 25TH ST APT 5L           ','201 E 80TH ST APT 8B           ',
								'201 ERIN CT                    ','201 SOMERSET CT                ','201 W 70TH ST APT 36B          ','201 WATCHUNG AVE APT 16        ','2019 AVENUE T                  ','202 HIGHLAND ST # 1            ','202 THOMPSON ST APT 1          ','2022 SCHENECTADY AVE           ','203 APRIL DR                   ','203 JAMES AVE                  ',
								'203 VILLAGE DR                 ','2031 RARITAN RD                ','204 BLOSSOM CIR                ','204 MANHATTAN AVE APT 3A       ','204 W 80TH ST APT 1E           ','2047 CHARLES CT                ','205 BERKSHIRE WAY              ','205 E 69TH ST # 3G             ','205 KIRK RD                    ','205 W 102ND ST APT 3B          ',
								'2051 STATE ROUTE 32            ','206 DIANA DR                   ','206 LUNNS WAY                  ','206 WHEATSHEAF LN              ','207 BEGONIA CT                 ','207 EAGLE BAY DR               ','207 W 106TH ST APT 3C          ','208 5TH AVE APT 7E             ','208 E 87TH ST APT 3R           ','208 ROYAL DR                   ',
								'2080 TURNBULL AVE              ','209 CLINTON ST APT 2L          ','209 MARTIN LUTHER KING DR # B  ','209 RAMAPO RD APT P            ','20910 86TH DR APT 3B           ','21 APPLE TREE RD               ','21 BERMUDA RD                  ','21 CARDINAL RD                 ','21 CONCORD DR                  ','21 DOGWOOD WAY                 ',
								'21 ENDOR AVE                   ','21 GLANCE RD                   ','21 HEDGES RD                   ','21 JESTER CT                   ','21 LINCOLN PL APT 4            ','21 MIDVALE MOUNTAIN RD         ','21 OGDEN LN # 908              ','21 PLANTATION RD               ','21 ROXBURY LN                  ','21 SHAW ST                     ',
								'21 SUNSET TER                  ','21 W 11TH RD                   ','21 WILBUR AVE                  ','210 BLOOMFIELD ST # 2          ','210 E 6TH ST # 1B              ','210 MILLS RD                   ','210 W 101ST ST                 ','210 W 90TH ST                  ','2104 E 72ND ST                 ','211 BEACH 145TH ST             ',
								'211 E 88TH ST APT 1D           ','211 QUARTER CIR # 161          ','211 WOODSIDE AVE               ','2117 HENRY CT                  ','212 E 47TH ST APT 21F          ','212 ORCHARD LN                 ','212 WELSFORD RD                ','2125 TURNPIKE ST               ','213 E 73RD ST APT 1C           ','213 SUNNYBROOK RD              ',
								'2137 LONGVIEW RD               ','214 FAWN RDG N                 ','214 SHEFFIELD CT               ','2142 WASHINGTON VALLEY RD      ','215 CORWIN RD                  ','215 E 95TH ST # 314            ','215 LINCOLN PL                 ','215 W 101ST ST APT 10C         ','215 W 91ST ST APT 5            ','2151 73RD ST # 31008           ',
								'216 BUTTRICK AVE PH            ','216 LINCOLN ST # 0             ','216 W 89TH ST APT 10D          ','217 BEECH GROVE RD             ','217 E WOODLAND DR              ','217 W 16TH ST APT B            ','218 BECKWITH HILL DR           ','218 MATTHEWS ST                ','21801 130TH AVE                ','219 E 28TH ST                  ',
								'219 OVERVIEW CIR W             ','21916 139TH AVE                ','22 ARROWHEAD WAY               ','22 BROOKLINE DR                ','22 CLINTON AVE                 ','22 DELWOOD RD                  ','22 ESSEX PL                    ','22 GLENWOOD DR                 ','22 HILLWOOD LN                 ','22 KELLY LN                    ',
								'22 LONGBRIDGE DR               ','22 MONTFORT RD                 ','22 PAPER CHASE                 ','22 QUEEN ANNE CT               ','22 SAINT LUKES PL APT 41       ','22 STONEHEDGE DR               ','22 VALLEY VIEW DR              ','22 WASHINGTON AVE              ','220 BEACON ST # 202            ','220 E 52ND ST APT 3F           ',
								'220 HARPER ST                  ','220 ROBIN HOOD LN              ','220 W 98TH ST APT 9B           ','2205 STECH DR                  ','221 E 28TH ST APT 15           ','221 RECREATION DR              ','2210 JANE ST                   ','2217 RAMSEY RD                 ','222 E 56TH ST APT 2C           ','222 LONGWOOD DR                ',
								'222 STONEWALL JACKSON DR APT D ','2223 WYNDHURST DR              ','223 E 14TH ST APT 20           ','223 RIVEREDGE DR               ','2235 LONG HILL RD              ','224 E 85TH ST APT 3B           ','224 TOWN COLONY DR             ','2248 E 29TH ST # A             ','225 E 10TH ST APT 4H           ','225 E 85TH ST APT 10B          ',
								'225 LINCOLN PL APT 5F          ','225 TYLER AVE                  ','225 W 86TH ST                  ','2257 23RD ST # 1               ','226 E 6TH ST APT 4C            ','226 VINE LN                    ','227 BERKELEY PL APT 3R         ','227 HOLDEN RD                  ','2271 SUNRISE WAY # 11          ','228 E 26TH ST APT 4C           ',
								'228 PINE BRIDGE LN             ','22823 EDGEWOOD AVE             ','229 E 79TH ST                  ','229 VINE ST                    ','23 ACADEMY ST                  ','23 BEECHWOOD RD                ','23 CEDAR POINT RD              ','23 CROWN HILL RD               ','23 EDGEWOOD RD                 ','23 GATES ST                    ',
								'23 HENRY CT                    ','23 JILL DR                     ','23 LINCOLN AVE                 ','23 MEL LN                      ','23 OVERLOOK DR                 ','23 QUEENSWAY                   ','23 SCHENCK AVE APT 2CE         ','23 STONEHURST DR               ','23 W 10TH ST APT 110           ','23 WEDGEWOOD DR                ',
								'230 BLOOMFIELD ST APT 402      ','230 E 44TH ST APT 7G           ','230 JAY ST APT 11H             ','230 SPRINGBROOK TRL            ','230 WINDING WAY                ','2306 SANDRA RD                 ','231 E 76TH ST APT 6E           ','231 S FULTON AVE APT 5E        ','2314 CROTONA AVE APT 4I        ','232 E 75TH ST APT 2A           ',
								'232 W 11TH ST                  ','233 COLT ST                    ','233 LONGWOOD DR                ','233 W 77TH ST APT 7B           ','234 9TH ST APT 8               ','234 LAWRENCE ST                ','234 W 75TH ST APT 2            ','235 DEVOE ST APT 2R            ','235 E 4TH ST APT 4B            ','235 EAST ST                    ',
								'235 SHERMAN AVE                ','235 W 48TH ST APT 11C          ','235 W 75TH ST APT 8X           ','2357 CHANNING AVE              ','236 E 88TH ST                  ','236 W 15TH ST APT 34           ','237 CREAM ST                   ','237 PARK AVE RM 900            ','2373 BROADWAY APT 1128         ','238 CHESTNUT ST                ',
								'238 VILLAGE WALK DR            ','239 CONCORD RD                 ','239 RACE ST # C                ','24 5TH AVE                     ','24 BALFOUR LN                  ','24 CAMELOT TER                 ','24 CONCORD AVE # 303           ','24 DONNA DR # 70               ','24 FOREST LN                   ','24 HAMPTON LN                  ',
								'24 JEAN PL                     ','24 LINCOLN AVE                 ','24 MICHAELSON DR               ','24 OLD STILL RD                ','24 PINEWOOD RD                 ','24 S BANK ST # 214             ','24 SPRINGWELL RD               ','24 VALLEY POND RD              ','24 WHITE BIRCH LN              ','240 CENTRE ST # 4-M            ',
								'240 E 39TH ST APT 20J          ','240 E 90TH ST APT 5D           ','240 MERCER ST # 1809           ','240 W 15TH ST APT 17           ','2400 WITCHAZEL DR              ','2408 BENNETT AVE               ','241 E 86TH ST APT 5A           ','241 TAXTER RD                  ','2413 CLARENDON RD # 3          ','242 E 3RD ST APT 13            ',
								'242 W 104TH ST APT 2FW         ','2429 BRISTOL RD                ','243 SEQUAMS LANE CTR           ','2435 BEDFORD ST APT 12A        ','244 E 28TH ST APT 1            ','244 W 102ND ST APT 3A          ','2446 96TH ST                   ','245 E 19TH ST APT 16C          ','245 E 54TH ST APT 15B          ','245 E 93RD ST APT 19C          ',
								'245 W 104TH ST # 16            ','24543 149TH AVE                ','246 MAYBURY AVE                ','247 ABINGDON AVE               ','247 W 102ND ST APT 3           ','248 AMHERST ST                 ','248 SAINT LEONARDS LN # T      ','249 COMMONWEALTH AVE APT 9     ','249 W 14TH ST                  ','25 AMAGANSETT DR               ',
								'25 BIRCH PL                    ','25 CARLIN ST                   ','25 COMMONS BLVD                ','25 DEER RUN                    ','25 EMILY LN                    ','25 GLEN CARL RD                ','25 HEATHER DR                  ','25 JACKSON DR                  ','25 LEEDS DR                    ','25 MCENTEE RD                  ',
								'25 OAK BLUFF AVE               ','25 PLAZA ST W APT 1J           ','25 ROSECLIFF LN # 1            ','25 SOUTH RD                    ','25 TIPPING ROCK DR             ','25 W 68TH ST # 3D              ','25 WILLOW DR                   ','250 E 33RD ST # A              ','250 HUDSON ST FRNT 3           ','250 TIFFANY DR                 ',
								'250 W 22ND ST # 43             ','250 W 89TH ST APT 12J          ','2503 SELWYN DR                 ','251 E 51ST ST                  ','251 W 92ND ST APT 4D           ','252 74TH ST APT 1I             ','252 OXHEAD RD                  ','2526 OLCOTT AVE                ','253 PARK AVE E                 ','2531 81ST ST                   ',
								'254 HENRY ST                   ','2540 SHORE BLVD PH 18E         ','255 E 49TH ST APT 12D          ','255 W 108TH ST APT 8B          ','255 WILDWOOD DR                ','256 GENEVA AVE                 ','2567 FOREST BROOK DR           ','257 SPRING RUN LN              ','258 COMMONWEALTH AVE # A       ','2588 FIRMA LN                  ',
								'259 W 15TH ST APT 3E           ','26 AMITY RD                    ','26 BRANDY LN                   ','26 CLARK DR                    ','26 DEVON ST                    ','26 FIELDSTONE DR               ','26 GUILDS HOLLOW RD            ','26 IRIS CIR                    ','26 LEHIGH RD                   ','26 MEYER PL                    ',
								'26 OMNI PARC DR                ','26 PRESIDENT ST                ','26 S OXFORD ST APT 3A          ','26 STONE HOLLOW DR             ','26 UNION ST                    ','26 WESTWAY                     ','260 CAMBRIDGE RD               ','260 SAYRE DR                   ','2603 VIRGINIA LN # 76          ','261 JUNIPER DR                 ',
								'2612 DOOLITTLE DR              ','262 MOTT ST APT 506            ','2627 SPRINGFIELD PIKE          ','263 ROCK RUN RD # 27           ','264 CRESTWAY DR                ','2647 93RD ST                   ','265 REDDING RD                 ','266 HUDSON AVE APT 1           ','267 CARYL DR                   ','268 BLEECKER ST # 2            ',
								'2681 FAWN LN                   ','269 W 72ND ST # PH1            ','27 BAYBERRY LN                 ','27 BURNETT AVE                 ','27 COTTAGE ST                  ','27 EDGEWATER DR                ','27 GOLDSMITH DR                ','27 HIGHGATE RD                 ','27 LANE DR                     ','27 MAUD GRAHAM CIR # 0         ',
								'27 OAK ST                      ','27 PROSPECT ST APT 6           ','27 SANDY BEACH RD              ','27 TALLOWOOD DR                ','27 W 72ND ST                   ','27 WILLIAMS ST                 ','270 HILLSPOINT RD              ','270 W 17TH ST APT 11A          ','2705 COMMONS AT KINGSWOOD DR   ','271 MEADOWLAKE DR              ',
								'2715 CREEK RD                  ','2720 MOUNTAIN RD               ','273 PARK PL                    ','274 ALEXANDRIA WAY             ','2747 HOOPER AVE                ','275 PEAK PL                    ','276 BIRCH HOLLOW DR            ','2769 BRIGGS AVE                ','277 W 11TH ST APT 2A           ','278 STUMPSTOWN RD              ',
								'279 REDDING RD                 ','28 ARNOLD LN                   ','28 CADMAN PLZ W                ','28 COMSTOCK RD                 ','28 E 10TH ST APT 10J           ','28 FLORIE FARM RD              ','28 HATIKVA WAY                 ','28 KAREN WAY                   ','28 MAPLEWOOD PL                ','28 NOREAST DR                  ',
								'28 PITTSBURGH AVE              ','28 RUSTIC RD                   ','28 STEEPLECHASE CIR            ','28 VESEY ST # 2293             ','28 WILLOUGHBY RD               ','280 HIBERNIA RD                ','280 ROUND SWAMP RD             ','281 BROWERTOWN RD # B          ','2816 OCEAN AVE                 ','2822 BEACON HILL DR            ',
								'2831 WOODMONT DR               ','284 PARK AVE                   ','285 CARYL DR                   ','285 SILVERMINE AVE             ','286 WARREN ST APT 5            ','287 PROSPECT AVE APT 7G        ','288 OAK NECK LN                ','289 LIGHTNER AVE               ','29 AVERELL DR # 74             ','29 CANNOCK DR                  ',
								'29 CRAIGMOOR RD                ','29 ENGLISH DR                  ','29 GRIEB TRL                   ','29 IRON ST                     ','29 LONG SWAMP RD               ','29 NASSAU PL                   ','29 PLEASANT AVE                ','29 S OAKS BLVD                 ','29 STERNER AVE                 ','29 VICTOR AVE # 1              ',
								'29 WINTHROP RD                 ','290 LINCOLN RD APT 3A          ','2905 LONG RIDGE RD             ','2914 YATES AVE                 ','2921 BELGRADE ST               ','293 W CEDAR ST                 ','2940 MORRIS RD                 ','295 HUNTINGTON AVE APT 404     ','2957 QUINCY TURN               ','297 BOULEVARD                  ',
								'298 PIERMONT AVE APT 1C        ','299 W MOUNT AIRY RD            ','3 ANTRIM RD                    ','3 BEAVER CREEK DR              ','3 BRENTWOOD CT                 ','3 CARDINAL RD                  ','3 CLAIRE TER                   ','3 COVEY DR                     ','3 DIAMOND LN                   ','3 ELEANOR DR                   ',
								'3 FISHER DR                    ','3 GLEN RD                      ','3 HAVEN PLZ APT 11H            ','3 HOLDEN CT                    ','3 JENKINS ST                   ','3 LAFAYETTE RD # 0             ','3 LOCKWOOD PL                  ','3 MEADOW WAY                   ','3 MYRTLE BLVD                  ','3 OKEEFE ST # O                ',
								'3 PENN CT                      ','3 QUAILTREE LN                 ','3 ROSE RITA TER # D            ','3 SEIR HILL RD # 5             ','3 STANLEY ST                   ','3 TARA LN                      ','3 VANDERBILT DR                ','3 WESTBRIDGE CT                ','3 WOODLAND AVE                 ','30 ARROW WAY                   ',
								'30 BROADVIEW AVE               ','30 CLAFLIN RD                  ','30 DORCHESTER RD               ','30 ELLERY LN                   ','30 GLEN BURNIE DR              ','30 HILLCREST RD                ','30 LAKE DR                     ','30 MARKWOOD RD                 ','30 OAKLAWN RD                  ','30 PINEBROOK CIR               ',
								'30 ROSEHOLM PL                 ','30 SOUTHWIND DR                ','30 VAN ORDEN PL                ','30 W 63RD ST APT 4J            ','30 WILDCAT AVE                 ','300 BROADWAY                   ','300 E 40TH ST APT 32W          ','300 E 71ST ST # 50             ','300 EXECUTIVE BLVD             ','300 MOORE RD                   ',
								'300 VOLLMER PKWY               ','300 W STATE ST STE 107         ','301 CLERMONT AVE               ','301 E 62ND ST APT 10E          ','301 E 88TH ST APT 10           ','301 PARK AVE                   ','301 W GENESEE ST # 441         ','302 CANTERBURY WAY             ','302 SEQUOIA DR                 ','303 5TH ST                     ',
								'303 E 83RD ST APT 25C          ','303 MIDDLE RD                  ','3033 HEWLETT AVE               ','304 E 65TH ST                  ','304 NEWBURY ST # 415           ','304 W 92ND ST APT 6A           ','305 BROADWAY STE 200           ','305 E 78TH ST # 2              ','305 N DOUGLAS AVE              ','305 W 19TH ST APT 32           ',
								'3056 30TH ST APT 4G            ','306 E 96TH ST APT 6B           ','306 W 80TH ST APT 5D           ','307 E 44TH ST APT 217          ','307 SPRING ST                  ','308 CONSTITUTION CIR           ','308 QUARRY ST APT 502          ','309 BISHOP MORGAN CT           ','309 N GREELEY AVE              ','309 W 99TH ST                  ',
								'31 BARNSTABLE RD               ','31 CAMBRIDGE DR                ','31 COUNTRY PL                  ','31 E ELM ST                    ','31 GLEN WAY                    ','31 HORSESHOE LN                ','31 LATHERS PARK                ','31 MERION DR                   ','31 PADDOCK WAY # 301           ','31 RAINBOW DR                  ',
								'31 SECOR RD                    ','31 TROY DR # B                 ','31 WILLOW LN                   ','310 E 44TH ST APT 717          ','310 IVY MILLS RD               ','310 TREETOPS CT                ','310 W END AVE                  ','311 BRAM HALL                  ','311 HICKS ST                   ','311 W 97TH ST APT 3E           ',
								'312 E 23RD ST APT 10C          ','312 PINE VALLEY DR             ','3120 WESTBOURNE AVE            ','313 E 93RD ST APT 5B           ','3130 IRWIN AVE APT 7J          ','314 E PLEASANT GROVE RD        ','314 W 89TH ST APT 8            ','315 DAVID HUMPHREY RD          ','315 E 90TH ST APT 3E           ','315 RIVEREDGE DR               ',
								'315 WOODLAND AVE               ','316 EATON AVE                  ','316 W 39TH ST APT 5W           ','317 E 75TH ST APT 9            ','317 W 82ND ST APT 2A           ','318 E 70TH ST APT 3RW          ','318 WASHINGTON ST APT 5L       ','319 JEFFERSON CT               ','319 YORK ST # 1                ','32 BENTON CIR                  ',
								'32 CHERYL DR                   ','32 DORA CIR                    ','32 FIELDSTONE DR               ','32 HARVEST RUN                 ','32 JOTHAM RD                   ','32 MAPLE HILL DR               ','32 NORBROOK RD                 ','32 PROSPECT AVE APT 6J         ','32 SELE DR                     ','32 TURNER CT                   ',
								'32 WEXFORD DR                  ','320 COACHMAN LN                ','320 E 52ND ST APT 5C           ','320 MAIN ST                    ','320 W 77TH ST                  ','321 149TH PL                   ','321 E 71ST ST APT 1G           ','321 W 108TH ST APT 5E          ','3216 82ND ST                   ','322 HUDSON ST APT 1            ',
								'3222 BLOOMINGDALE DR           ','323 HICKSVILLE RD APT 12       ','3237 77TH ST # 1A              ','324 GUINEVERE RDG              ','3241 DAY SPRING RDG            ','325 E 79TH ST APT 8A           ','325 W 11TH ST APT 4E           ','3253 MILLERS RUN RD            ','326 LINCOLN PL APT 5C          ','327 BERNICK DR                 ',
								'327 ROSELAND AVE               ','328 BULLMOOSE RIDGE RD         ','328 QUAIL DR                   ','329 E 50TH ST APT 3B           ','329 WOODSIDE RD                ','33 BARLEY SHEAF RD             ','33 CASTLE CT                   ','33 CYPRESS ST                  ','33 ELMWOOD CT                  ','33 GREEN LN                    ',
								'33 JAY ST                      ','33 LUNDBERG ST                 ','33 NEW ST                      ','33 QUAKER RIDGE RD             ','33 SHEPHERD WAY                ','33 TWISS LN                    ','33 WELLINGTON DR               ','330 89TH ST APT 2F             ','330 E 39TH ST APT 11L          ','330 E 75TH ST APT 7D           ',
								'330 S 1ST ST                   ','330 WIMBELDON CT               ','331 E 29TH ST # 60             ','331 W 57TH ST # 443            ','332 COUNTRY CLUB LN            ','332 WAGNER AVE                 ','333 E 14TH ST APT 12K          ','333 E 53RD ST APT 4E           ','333 E 93RD ST # 170G           ','333 UNION AVE                  ',
								'334 BOWDEN RD                  ','334 RIVERSIDE DR               ','335 COPLEY DR                  ','335 SALISBURY ST               ','336 E 19TH ST # 2              ','336 W END AVE APT 12F          ','337 ISINGLASS RD               ','338 E 30TH ST APT 4R           ','339 ARLINGTON ST               ','3390 HEATHERBROOK LN           ',
								'34 BELLA RD                    ','34 CENTRAL AVE                 ','34 DIBUONO DR                  ','34 FORT AVE                    ','34 HIGHLAND CROSS # 2          ','34 LAUREL RD                   ','34 MIANUS DR                   ','34 PARK TER                    ','34 RUNNING BROOK DR            ','34 SUMMIT DR                   ',
								'34 WARNER LN                   ','340 ASHFORD AVE                ','340 E 83RD ST APT 2B           ','340 S BEDFORD RD               ','3405 30TH AVE                  ','341 HIGHLAND AVE               ','3411 WINDER DR                 ','342 E 9TH ST APT 4C            ','3425 69TH ST                   ','343 S PLEASANT AVE             ',
								'344 COMMERCE ST                ','344 VANDERBILT AVE             ','345 BUCKLAND HILLS DR APT 1    ','345 E 80TH ST APT 11J          ','345 GREENWICH AVE              ','345 W 85TH ST APT 38           ','346 E 65TH ST APT 1A           ','347 CEDAR AVE                  ','348 COACHMAN LN                ','3488 WILSON AVE APT 4C         ',
								'35 14TH ST                     ','35 BENTLY DR                   ','35 CHAPEL ST                   ','35 CURRIE AVE                  ','35 EDDY ST                     ','35 GREENRIDGE WAY              ','35 JACKSON DR                  ','35 MAPLE AVE N                 ','35 NORTHAMPTON ST              ','35 POCONO RD                   ',
								'35 S KEREMA AVE                ','35 STONYBROOK DR               ','35 W 82ND ST APT 4B            ','35 WOOD RD                     ','350 E 52ND ST APT 10A          ','350 MIDDLESEX RD               ','3503 TUCKERS LN                ','351 MARSHALL ST                ','3515 BEECH RUN LN              ','352 W 15TH ST APT 301          ',
								'353 E 17TH ST APT 25A          ','3533 105TH ST                  ','354 SCONTICUT NECK RD          ','355 E 4TH ST APT 5C            ','355 STUMPSTOWN RD              ','356 MIDDLEWOOD RD              ','357 COMMERCIAL ST APT 815      ','358 LAKEVIEW DR                ','359 HOLBROOK RD                ','36 ARLINGTON RD                ',
								'36 CASSILIS AVE                ','36 DANDY DR                    ','36 FLEET ST APT A              ','36 HEMLOCK CT                  ','36 LAUREL TRL                  ','36 MORDAUNT RD                 ','36 PERRY LN                    ','36 SACHEM ST                   ','36 STURBRIDGE RD               ','36 WAITE ST                    ',
								'360 7TH ST                     ','360 MAIN RD                    ','360 W 34TH ST APT 7G           ','361 3RD AVE APT 7              ','3612 NANCY WARD CIR            ','362 W 20TH ST APT 1            ','363 LANES POND RD              ','364 MULBERRY ST                ','365 JAMES WAY                  ','3659 BOLLER AVE                ',
								'3669 CONCORD RD                ','368 HAVILAND RD                ','369 SILVA ST                   ','37 BEDFORD ST # 2-B            ','37 CHARLES ST                  ','37 DUBOIS ST                   ','37 GREEN ACRE LN               ','37 KIRK RD                     ','37 MILL ST                     ','37 PAYSON AVE APT 4I           ',
								'37 SADDLEBROOK DR              ','37 SYLVAN DR                   ','37 W 76TH ST                   ','370 CNTRAL PARK AVE APT        ','370 W BROADWAY APT 5L          ','3710 HANCOCK LN # 44           ','372 MOUNT SINAI CORAM RD       ','373 PLAINFIELD AVE             ','374 POND RD                    ','375 S END AVE APT 17T          ',
								'376 BERGEN ST APT 4F           ','3767 HUDSON AVE                ','3777 INDEPENDENCE AVE APT 16   ','379 MARKET ST                  ','38 BELLEFAIR RD                ','38 CLEARWAY ST APT 6           ','38 EDDON DR                    ','38 HANCOCK ST APT 2            ','38 KNOLLWOOD RD                ','38 MOCCASIN TRL                ',
								'38 PIERSON DR                  ','38 SCRANTON AVE                ','38 VALADE RD                   ','38 WOOD VIEW DR                ','380 RECTOR PL APT 23G          ','381 EDGECOMBE AVE APT 2D       ','382 3RD AVE APT 7C             ','383 CHARLES AVE                ','384 MAIN AVE                   ','385 STETSON RD                 ',
								'3864 E BRANDON WAY             ','388 PEARL ST APT 6B            ','39 5TH ST                      ','39 CAITLIN CT                  ','39 CUMMINGS RD                 ','39 ELM ST                      ','39 HARDSCRABBLE HL             ','39 KLINGERMAN RD               ','39 MIDDLE ST # R               ','39 PEARL ST APT 5R             ',
								'39 SCHERMERHORN ST APT 3       ','39 W 38TH ST FL 9              ','390 BROOME ST APT 13           ','3904 MELVILLE CT               ','3912 HERBERTSVILLE RD          ','392 STATE ST APT 20H           ','393 W END AVE APT 5C           ','394B DELANCEY PL               ','395 SYCAMORE MILLS RD          ','396 WELSH RD                   ',
								'398 COLUMBUS AVE               ','399 NORTH AVE                  ','4 ANNA DR                      ','4 BASSETT CT                   ','4 BOYD RD                      ','4 CAPALBO AVE                  ','4 CHEROKEE TRL                 ','4 COPPLES LN                   ','4 DEBBIE CT                    ','4 E 89TH ST APT 4E             ',
								'4 FAIRMONT AVE                 ','4 GALLOPING HILL RD            ','4 HAMILTON ST                  ','4 HIGHVIEW DR                  ','4 JACKSON CT W                 ','4 KNOB HILL RD                 ','4 LEXINGTON AVE APT 6J         ','4 MADISON PL # 3G              ','4 MERRILL INDUSTRIAL DR        ','4 NEWLIN WAY                   ',
								'4 OTSEGO AVE                   ','4 PETER RD # 0                 ','4 QUAIL DR                     ','4 RIVER RD APT 9L              ','4 SARAH BISHOP RD              ','4 SOUTH ST                     ','4 SUMMIT TER                   ','4 TODD CT                      ','4 VICTOR LN                    ','4 WELLS ST                     ',
								'4 WOODRIDGE AVE                ','40 ARCHER ST                   ','40 CALIFORNIA ST UNIT B6       ','40 CRAB APPLE PL               ','40 E 9TH ST APT 5E             ','40 GREYSTONE LN                ','40 HUNT AVE                    ','40 MADISON ST APT 10J          ','40 NASSAU PL                   ','40 PRIMROSE ST                 ',
								'40 SALISBURY WAY               ','40 TRAPPE LN # R1              ','40 W ELM ST APT 4A             ','40 WINFIELD CT                 ','400 COMMONS WAY STE 224        ','400 E 71ST ST                  ','400 MAIN ST                    ','400 W 46TH ST APT 3A           ','4008 10TH ST APT 1A            ','401 E 34TH ST # 4-G            ',
								'401 E 74TH ST APT 19F          ','401 E 89TH ST APT 7L           ','401 W 34TH ST # 21G            ','4018 77TH ST # 2J              ','402 KING ST                    ','4025 TURNWOOD LN               ','403 PEMBROKE RD                ','404 CHESWOLD CT                ','404 SARAH WELLS TRL            ','405 COLUMBUS AVE               ',
								'405 LONGVIEW CT                ','4056 SWEET GUM LN              ','406 W 39TH ST APT 3F           ','407 LINKS DR                   ','408 CRUMP RD                   ','408 W 57TH ST APT 3K           ','409 PERRY ST                   ','41 ATLANTIC HOUSE RD           ','41 CEDAR AVE                   ','41 E 7TH ST APT 14             ',
								'41 HARTLEY ST                  ','41 LAKEVIEW DR                 ','41 MORRIS LN                   ','41 PONDEROSA DR                ','41 SHORE RD                    ','41 VILLAGE DR                  ','41 WOODBROOK CIR               ','410 E 78TH ST PH B             ','410 W 24TH ST APT 12E          ','4108 12TH ST APT 3A            ',
								'411 HOLLY LN                   ','4110 10TH ST APT 5E            ','412 E 83RD ST APT 2A           ','4121 KINGS HWY                 ','413 PACIFIC ST # 2A            ','414 BENEDICT AVE APT 2A        ','414 WINCHESTER AVE             ','415 E 52ND ST                  ','415 SUGAR HILL RD              ','416 CUMBERLAND ST # 3          ',
								'4160 HILLSIDE CIR              ','417 E 90TH ST APT 4B           ','418 ACORN AVE                  ','418 SCANEATELES AVE            ','419 E 72ND ST APT 18           ','419 W 17TH ST APT 7H           ','42 BEECHWOOD DR                ','42 CINDY CIR                   ','42 ELMWOOD AVE                 ','42 HEMLOCK DR                  ',
								'42 MACAFEE RD                  ','42 PALMER LN                   ','42 SAINT JOHN ST               ','42 VERES ST                    ','42 WINDING WAY                 ','420 E 64TH ST # 8B             ','420 E 70TH ST # 13J            ','420 LEXINGTON AVE RM 420       ','420 WASHINGTON DR              ','421 BREWER ST                  ',
								'421 MIDLAND AVE                ','4214 SNYDER AVE                ','422 RIVER RENAISSANCE          ','423 ATLANTIC AVE APT 4B        ','423 VAN HOLTEN RD              ','424 E 84TH ST                  ','424 W OAKLAND AVE              ','425 E 25TH ST # 317            ','425 E 86TH ST APT 1E           ','425 W 25TH ST APT 15B          ',
								'426 CYPRESS RD                 ','427 59TH ST # 1                ','427 W 26TH ST                  ','428 W 47TH ST APT 5R           ','429 MCGRATH BLVD               ','43 BEECHWOOD ST                ','43 COLONY LN                   ','43 ELM ST                      ','43 HERITAGE DR                 ','43 LEMPA RD                    ',
								'43 NOROTON AVE                 ','43 RICHMOND HILL DR            ','43 SUTTON DR                   ','43 WATSON AVE APT 1B           ','430 E 65TH ST # 1              ','430 W 34TH ST APT 5G           ','431 MARYLAND AVE               ','432 E 14TH ST # 176            ','433 16TH ST APT 4L             ','433 W 54TH ST APT 8            ',
								'434 W 19TH ST APT 4D           ','435 E 30TH ST # 608            ','435 E 70TH ST APT 5K           ','435 W 45TH ST                  ','436 W 22ND ST APT 1B           ','437 W 48TH ST APT 1B           ','438 SMITHBRIDGE RD             ','439 USS IOWA CIR APT 3         ','44 BRADBURY AVE                ','44 CHESTER ST # 1              ',
								'44 E 12TH ST APT 9C            ','44 HAMILTON DR                 ','44 LAUREL DR                   ','44 MORRIS LN                   ','44 PICKWICK DR                 ','44 SILVER HILL RD # 0          ','44 W 10TH ST APT 6E            ','44 WYCKLOW CT                  ','440 N BROADWAY APT 31          ','441 15TH ST                    ',
								'4416 EDSON AVE                 ','4423 PIEDMONT CT               ','4432 SILKWEED CIR              ','444 E 84TH ST APT 1F           ','444 W 48TH ST APT 1D           ','445 E 69TH ST # 724            ','445 W 19TH ST APT 4F           ','446 W 19TH ST APT 4B           ','447 W 36TH ST # 5FL            ','4483 SUMMERMEADOW DR           ',
								'45 ADAMS DR                    ','45 CARLSON CIR                 ','45 DYKERS FARM RD # 0          ','45 FRISBIE ST                  ','45 HUNT RD                     ','45 MAPLE ST APT 3K             ','45 OLE MUSKET LN               ','45 RIVER DR S APT 2406         ','45 STONYBROOK DR               ','45 W 132ND ST APT 4G           ',
								'45 WHISCONIER RD               ','450 ISLAND RD APT 46           ','4506 WINDING WOODS LN          ','4512 PEPPERIDGE CT             ','4527 RED SPRUCE LN             ','454 CREEKSIDE DR               ','455 E 86TH ST APT 30B          ','4555 48TH ST APT 2F            ','457 3RD ST # 3                 ','458 MILLER AVE                 ',
								'4594 BROOKHILL DR S            ','46 BRUNDIGE DR                 ','46 DONNA DR                    ','46 HAMPSHIRE RD                ','46 LAWRENCE RD                 ','46 N MAIN ST                   ','46 REINMAN RD                  ','46 STRATFORD CT                ','46 WARREN ST                   ','460 OLD POST RD                ',
								'461 MARION CT                  ','4620 BROOKHILL DR S            ','463 W 24TH ST APT 3R           ','465 BRIGGS RD                  ','466 CENTER ST                  ','467 W 141ST ST                 ','469 S DELAWARE AVE             ','47 BLUEBERRY LN                ','47 DIETZ AVE                   ','47 GREENFIELD RD               ',
								'47 LAKE SHORE DR S             ','47 MURRAY AVE                  ','47 QUINN RD                    ','47 STONEHENGE RD               ','47 WILSON AVE                  ','470 VANDERBILT AVE             ','4715 39TH PL # 2R              ','473 4TH ST APT 2L              ','474 OAKSHADE RD                ','475 W 142ND ST                 ',
								'4767 STONEHURST RD             ','479 BLACKS RD                  ','48 BELL DR                     ','48 CRESTVIEW DR                ','48 GASTON ST                   ','48 LANDAU RD                   ','48 NEWBRIDGE RD # 0            ','48 RIDGE RUN RD                ','48 VALLEY CREST RD             ','48 WOODALE RD                  ',
								'480 SHAWMUT AVE                ','481 MCCOMBS RD                 ','4827 HARWICK TER               ','484 E 74TH ST APT 15           ','485 DURFEE HILL RD             ','4868 BRECKENRIDGE RUN          ','4887 EXCALIBUR DR              ','49 BENSON ST                   ','49 COSEY BEACH RD              ','49 FREEDOM RD                  ',
								'49 LE GRANDE AVE               ','49 OVERLOOK RD                 ','49 SCENIC RD                   ','49 W 68TH ST APT 1A            ','490 2ND AVE APT 2F             ','491 HAMMERTOWN RD              ','4920 TALL CEDAR CT             ','494 STATE RD                   ','496 PRESIDENT ST # 1           ','498 PATRIOT RD                 ',
								'5 2ND RD                       ','5 APPLEWOOD CT                 ','5 BAYWOOD BLVD                 ','5 BOULDER DR                   ','5 CALIFORNIA AVE               ','5 CHAUNCEY PL                  ','5 CONCORD CIR                  ','5 DEER CREEK RD                ','5 E 22ND ST APT 19J            ','5 ERINN CT                     ',
								'5 GAINSBOROUGH ST              ','5 GROVE ST                     ','5 HIGHWOOD DR                  ','5 IROQUOIS DR                  ','5 KERWIN CT                    ','5 LEWIS DR                     ','5 MANORVIEW WAY                ','5 METACOMET RD                 ','5 NELSON LN                    ','5 OSPREY DR                    ',
								'5 PHEASANT RUN                 ','5 RAINEY LN                    ','5 ROOSEVELT PL APT 5B          ','5 SENECA PL                    ','5 STANWOOD CT                  ','5 TARRAGON TER                 ','5 TUDOR CITY PL APT 160        ','5 VINELAND AVE                 ','5 WESTVIEW RD                  ','5 WOODBURY ST                  ',
								'50 AVENUE D APT 4D             ','50 CARDINAL DR                 ','50 DAWES AVE                   ','50 FELDLAND ST                 ','50 HILLSIDE RD                 ','50 LEXINGTON AVE APT 3C        ','50 NEWGATE RD                  ','50 PRESIDENT AVE               ','50 SEQUOIA DR                  ','50 VERNA RD                    ',
								'50 W 77TH ST APT 3L            ','50 WINDING WAY # 8             ','500 E 63RD ST APT 7B           ','500 PARKER ST # 414            ','500 WASHINGTON AVE APT 41      ','501 CONTENTION LN              ','501 W 110TH ST APT 3A          ','502 LARKINS BRIDGE DR          ','503 E 78TH ST APT 3G           ','504 E 63RD ST APT 15O          ',
								'5045 FOUNTAINWOOD DR           ','505 MASSACHUSETTS AVE APT 5    ','506 EAGLES RIDGE RD            ','507 DUNN CIR                   ','508 FINLAY PL                  ','509 E 73RD ST APT 28           ','51 ANNANDALE RD                ','51 CLIFT ST                    ','51 FLORENCE WAY                ','51 HOBSON ST                   ',
								'51 MASSACHUSETTS AVE APT 1     ','51 PARK DR APT 12              ','51 SHAFFER RD                  ','51 W 11TH ST APT 9B            ','510 2ND AVE APT 7D             ','510 OLD SHORT HILLS RD         ','511 BITTERSWEET DR             ','511 W 235TH ST APT 6F          ','512 LANZARO DR                 ','513 E 87TH ST # 2FW            ',
								'514 MONROE RD                  ','515 E 72ND ST APT 39E          ','515 W 110TH ST APT 5F          ','516 MARTIN LN                  ','5176 WOOD LN                   ','519 COUNTRY CLUB RD            ','52 BAYBERRY LN                 ','52 COLFAX AVE                  ','52 FENWAY APT 5                ','52 INDEPENDENCE DR             ',
								'52 MAYFAIR RD                  ','52 PICKMAN RD                  ','52 SOUNDVIEW DR                ','52 WALNUT ST                   ','520 E 72ND ST APT 15B          ','520 W 43RD ST APT 22E          ','521 DEAN ST APT 7              ','5218 CHERYL DR                 ','523 CENTRE ISLAND RD           ','524 BEATTIE RD                 ',
								'5247 POINT PLEASANT PIKE       ','525 HUDSON ST APT 4FN          ','526 EMERALD                    ','527 FRIENDSHIP RD              ','528 RIDGE RD                   ','529 W 42ND ST APT 3F           ','53 BROADACRE DR                ','53 DIRKSEN DR                  ','53 HENRY AVE                   ','53 MAGNOLIA DR                 ',
								'53 POST RD                     ','53 SULLIVAN CHASE DR           ','53 WHITETAIL RD                ','530 E FULTON ST                ','5309 MURIEL LN                 ','532 ALICIA DR                  ','533 E 5TH ST APT 24            ','534 E LINCOLN AVE              ','535 MADISON AVE FL 35          ','536 GRAND ST APT 602           ',
								'537 WOODSIDE AVE               ','539 SUMMERCROFT DR             ','54 BRIGHTON WAY                ','54 DANBURY RD # 222            ','54 GORDONS CORNER RD           ','54 LEDGE BROOK RD              ','54 NICHOLS RD                  ','54 SAINT STEPHEN ST # 2        ','54 W 21ST ST RM 903            ','540 E 14TH ST APT 7            ',
								'540 WHETSTONE RD               ','5412 HILLTOP CT                ','542 W 149TH ST APT 2B          ','544 LAWRENCE AVE               ','545 EXETER CT # 528            ','546 RUGBY RD                   ','548 WINANT AVE                 ','55 APAWAMIS AVE                ','55 CENTRAL PARK W # 10C        ','55 E 10TH ST # 1408            ',
								'55 GREAVES LN                  ','55 KING HILL RD                ','55 MOUNTAIN HILL RD # 0        ','55 PILGRIM RD # 202            ','55 SEMINARY CT                 ','55 W 11TH ST PH E              ','55 WETMORE AVE # 1L            ','550 W 153RD ST APT 23          ','551 OBSERVER HWY APT 6F        ','553 3RD AVE APT 44             ',
								'5545 MECHANICSVILLE RD         ','5557 PIN OAK DR                ','557 W UWCHLAN AVE              ','56 ASPEN DR                    ','56 CROWN AVE # 1               ','56 GREENACRES AVE              ','56 LINCOLN ST                  ','56 OLD VILLAGE RD              ','56 SHELDON AVE                 ','56 W EMERSON ST # 1L           ',
								'560 MAIN ST APT 486            ','5605 BROADWAY ST               ','562 PINE ST                    ','564 1ST AVE APT 20E            ','565 WINDING RIVER RD           ','568 BALTIC ST APT 3L           ','57 BAUER AVE                   ','57 COOLRIDGE RD                ','57 FRONT ST                    ','57 LAIGHT ST APT 1             ',
								'57 OENOKE LN                   ','57 STEDWICK VLG # K            ','57 W VIEW RD                   ','570 WOODHAVEN DR               ','5719 162ND ST                  ','5733 POINT PLEASANT PIKE       ','575 MAIN ST APT 1507           ','5761 PRESCOTT CT               ','579 BROADWAY APT 5A            ','58 BUCHANAN ST                 ',
								'58 EASTWOOD HALL RD            ','58 JUNIPER RD                  ','58 NEWELL HILL RD              ','58 SILVER RIDGE RD             ','58 WHITEHALL RD                ','580 WOODROW RD                 ','582 MAIN ST                    ','584 BROADWAY RM 606            ','587 ACLAND BLVD                ','589 VAUGHN AVE                 ',
								'59 CHELSEA DR                  ','59 FISHER ST                   ','59 LIVINGSTON ST               ','59 OVERLOOK RD                 ','59 STEPSTONE HILL RD           ','59 WILLOW ST                   ','591 COUNTY ROUTE 50            ','593 OLD COUNTRY RD             ','5951 JERUSALEM DR              ','598 QUAKER RD                  ',
								'6 ALEXANDRIA DR                ','6 BALD ROCK RD                 ','6 BIRCH LN # 109               ','6 BROOKE CLUB DR APT 5         ','6 CARMELLA DR                  ','6 CHURCHILL ST                 ','6 CRESENT PL                   ','6 DINGLEBROOK LN               ','6 EDWARD AVE                   ','6 FIELDCREST CT                ',
								'6 GENERAL KARGE CT             ','6 HAMILTON PL                  ','6 HOBBLEBUSH RD                ','6 JEFFERSON CT # 2             ','6 LAFAYETTE CT                 ','6 LOCUST DR                    ','6 MARWOOD RD N                 ','6 MODEAN DR                    ','6 NORRIS DR                    ','6 PARK LN                      ',
								'6 PRINCE PHILLIP CT            ','6 RIDGE RD                     ','6 SAINT JOHNS LN               ','6 SHORT LN                     ','6 SUCCESS RD                   ','6 TONI LN                      ','6 VIRGINIA RD                  ','6 WHETMORE DR                  ','6 WOODS DR                     ','60 BICENTENIAL WAY             ',
								'60 CRITTENDEN BLVD APT 50      ','60 E 9TH ST APT 332            ','60 GRAMERCY PARK N FRNT 1      ','60 JUNIPER RD                  ','60 MOUNTAIN HILL RD            ','60 PULASKI HWY                 ','60 SUNSET PL UNIT 10C          ','60 W 75TH ST APT 3C            ','600 COLUMBUS AVE APT 5G        ','600 W 113TH ST # 12C2          ',
								'601 E 11TH ST                  ','6014 STATE ROUTE 21            ','6023 LISI GARDENS DR           ','604 CHESWOLD CT                ','605 CONCORD RD                 ','605 ZION RD # B                ','6064 69TH AVE # 1ST            ','608 CAROL AVE                  ','609 JEFFERSON AVE              ','61 BAYARD ST APT 13            ',
								'61 DAVIS RD                    ','61 HARRIS RD                   ','61 LINCOLN RD # 0              ','61 PEAR TREE LN                ','61 SKYLINE LN                  ','61 W 88TH ST APT 2             ','610 SLOAT PL                   ','611 BROADWAY RM 808            ','612 BAYBERRY LN                ','6125 WALLINGFORD WAY           ',
								'6138 WEDGE DR                  ','615 BEERS ST                   ','616 AVENUE D                   ','617 E 79TH ST                  ','618 TERRACE BLVD               ','6195 HAYMARKET WAY             ','62 CARLETON RD                 ','62 FIELD ST                    ','62 LIMEKILN RD                 ','62 PELHAM LN # A               ',
								'62 SUNSET LAKE RD              ','62 WINDSOR WAY                 ','6201 ALLETTA CIR               ','6219 53RD AVE                  ','623 MADISON ST                 ','6247 WELLAND LN                ','6258 WELLAND LN                ','6272 NESHAMINY VALLEY DR       ','629 TAYLOR AVE                 ','63 CASSVILLE RD                ',
								'63 EDITH ST                    ','63 JOYCE LN                    ','63 MYANO LN APT 3              ','63 RUSTIC WAY                  ','63 W 22ND ST                   ','630 1ST AVE APT 7M             ','6308 AUBURN DR                 ','632 RIDGE RD                   ','634 E 91ST ST                  ','635 STARK TER                  ',
								'637 E 6TH ST APT 5             ','6399 TRANSIT RD                ','64 CRANBROOK RD                ','64 HUTCHINGS RD                ','64 PARK AVE                    ','64 SPRING HILL AVE             ','64 WINTHROP SHORE DR           ','641 E 13TH ST                  ','6420 65TH PL                   ','6440 CONWAY RD                 ',
								'646 GARDEN ST                  ','6489 83RD PL                   ','65 BARROWS RD                  ','65 CONCORD ST                  ','65 FARMSTEAD LN                ','65 HUNTERS LN                  ','65 MOUNTAIN AVE                ','65 ROLLING HILL RD             ','65 VT RTE 12A # 9              ','650 1ST ST APT 2               ',
								'651 E 32ND ST # 3              ','6534 77TH ST                   ','6550 ADMIRAL AVE               ','6588 UPPER YORK RD             ','66 CAMPBELL AVE                ','66 FLANDERS RD                 ','66 KATHLEEN DR                 ','66 NICHOLS RD                  ','66 SUMMIT DR                   ','66 WITHERSPOON ST # 152        ',
								'6610 SCHOOL RD                 ','664 HUCKLEBERRY LN             ','666 GREENWICH ST APT 1006      ','667 E 77TH ST                  ','67 ADAMS RD                    ','67 CURTIS DR                   ','67 GROVE ST                    ','67 MCKEE ST                    ','67 RIVERVIEW RD                ','67 W 92ND ST APT 3B            ',
								'6707 ALFRED DR                 ','673 FRANKLIN ST APT 207C       ','675 WINTER ST                  ','679 GRACE LN                   ','68 CIRCLE RD                   ','68 HANNAHS RD                  ','68 MANET RD # B                ','68 RAVENSDALE RD               ','68 W CEDAR ST                  ','6802 DURHAM AVE                ',
								'683 OLD STAMFORD RD            ','686 WILLOW BROOK RD            ','69 APPLETON ST # 2F            ','69 CROSS GATES RD              ','69 HILLTOP VIEW RD # 0         ','69 OSGOOD HILL RD              ','69 TOWN HOUSE DR               ','690 SACKETT ST # 1A            ','692 WASHINGTON ST              ','6960 108TH ST APT 701          ',
								'7 4TH ST APT 3F                ','7 AUDREY ST                    ','7 BIRCH DR                     ','7 BROAD ST W # 109             ','7 CATHY CT                     ','7 CLEARBROOK CT                ','7 CRAWFORD LN                  ','7 DOGWOOD CT                   ','7 E 35TH ST APT 1E             ','7 FAIRFIELD MANOR DR           ',
								'7 GALLOWS HILL ROAD EXT        ','7 GREENSHIRE WAY               ','7 HEMLOCK LN                   ','7 HUCKLEBERRY LN               ','7 JOTHAM RD                    ','7 LARCH LN                     ','7 LONGVIEW LN                  ','7 MEAD ST APT D                ','7 MYRTLE AVE                   ','7 ODESSA DR                    ',
								'7 PARSONS ST                   ','7 POWELSON DR                  ','7 RICHARD LN                   ','7 SAINT GEORGE RD              ','7 SHARON DR                    ','7 STERLING ST                  ','7 TEMPLE TER                   ','7 VAN TUYL ST                  ','7 WEINGART RD                  ','7 WOODBINE ST                  ',
								'70 BATTERY PL APT 522          ','70 E 10TH ST APT 18S           ','70 HENSHAW AVE                 ','70 MARLTON PIKE E              ','70 REMSEN ST # 8-I             ','70 VALEWOOD RUN                ','700 ACKERMAN AVE               ','7001 65TH PL APT 3R            ','701 WATERCOURSE ROW            ','703 DARLEY CIR                 ',
								'704 TURNBRIDGE LN # 71         ','706 FORDHAM RD # A             ','708 BROADWAY                   ','709 S BRANCH DR                ','71 BRAEMAR DR                  ','71 EAGLE RIDGE WAY             ','71 LONE STAR LN                ','71 POSSUM DR                   ','71 VOLPI RD                    ','710 NW MAIN ST                 ',
								'711 PINE ST APT 2F             ','713 4TH AVE                    ','715 E 38TH ST # 1              ','717 E 5TH ST                   ','719 SHIPPEE CT APT C           ','72 COMMERCIAL ST               ','72 HAWLEY AVE                  ','72 MILK ST                     ','72 SAM BONNELL DR              ','72 W HOLLIS RD                 ',
								'720 TROY AVE                   ','7217 34TH AVE                  ','724 E 6TH ST                   ','725 SOCIETY HL                 ','727 WASHINGTON ST # 0          ','73 ABBETT AVE # B              ','73 ELIZABETH DR                ','73 JILL CT # 264               ','73 PLUM LN                     ','73 W 83RD ST APT 2W            ',
								'730 E 49TH ST                  ','732 COLONIAL RD                ','7337 TOMWOOD DR                ','736 BLOOMING GROVE RD          ','739 BEST RD                    ','74 COUNTRY CLUB DR             ','74 HORIZON VIEW DR             ','74 ONDAORA PKWY                ','74 TUCKAHOE DR                 ','740 TUTOR LN                   ',
								'743 EASTERN PKWY               ','746 GARFIELD AVE # 2FL         ','749 SELFRIDGE ST # C           ','75 BERKELEY ST # 3             ','75 DEER TRAIL RD               ','75 HERITAGE LN                 ','75 MAPLE ST                    ','75 POPLAR SPRINGS BLVD         ','75 SUTTON ST                   ','75 W END AVE APT P15C          ',
								'750 COLUMBUS AVE APT 10T       ','751 RARITAN AVE                ','7532 PARSONS BLVD APT G1       ','756 FOREST AVE                 ','76 ALMA ST                     ','76 E HOLLY AVE                 ','76 KETTLEBROOK DR              ','76 POTTER ST                   ','76 VICTORIA ST # 0             ','760 W END AVE APT 16A          ',
								'763 FRANKLIN AVE APT 4R        ','765 KENDUSKEAG AVE             ','769 JACKSON RD                 ','77 BLEECKER ST APT 320N        ','77 ELLIOTT DR # 0              ','77 LEXINGTON AVE               ','77 PLYMOUTH ST                 ','77 W 24TH ST APT 22A           ','7707 BLACK WILLOW              ','7728 79TH ST                   ',
								'777 MAIN ST                    ','78 BOOTHBY DR                  ','78 FRONT ST APT 3D             ','78 MAPLE VALLEY RD             ','78 SPAULSBURY RD               ','780 EAST ST                    ','7815 RUNNING BROOK LN          ','784 REMSEN AVE                 ','787 PRINCETON RD               ','79 CANTIAGUE LN                ',
								'79 HIAWATHA BLVD               ','79 PERRY ST APT 2R             ','79 W 108TH ST                  ','7903 EISENHOWER BLVD           ','793 LOVVLE RD                  ','799 BISHOPS LN                 ','8 ASHLOR DR                    ','8 BENTLEY CT                   ','8 BRITTANY CT                  ','8 CASALE DR                    ',
								'8 CLOVER HILL DR               ','8 CRESTMONT CT                 ','8 DOOLITTLE RD                 ','8 ENT RD                       ','8 FOX HUNT LN                  ','8 GRAND AVE # 8                ','8 HEATON LN                    ','8 HUNTER LN                    ','8 KENT PL                      ','8 LEXINGTON HILLS RD # 3       ',
								'8 MAPLE AVE                    ','8 MILL ST                      ','8 NORMANDY RD                  ','8 PARKSIDE DR                  ','8 POND ST                      ','8 RIDGELAND DR                 ','8 SALEM LN                     ','8 SNOWCREST RD                 ','8 SUGAR MAPLE LN               ','8 THRUSH CT                    ',
								'8 VIRGINIA DR                  ','8 WESTERLY CT                  ','8 WOODLAND TRL                 ','80 BRUNDAGE RIDGE RD           ','80 E END AVE APT 10H           ','80 HUNTINGTON RD               ','80 MANSION AVE                 ','80 PARK AVE APT 2G             ','80 TALLY HO RD                 ','800 CHEWS LANDING RD APT 2G    ',
								'8004 THOMPSON RD               ','802 CENTRE AVE                 ','804 HAWTHORNE ST               ','806 HEMLOCK CT                 ','808 JOSHUA CT                  ','81 ASPINWALL ST                ','81 EDGEMONT RD                 ','81 LENAPE RD                   ','81 PYE BROOK LN                ','81 WASHINGTON ST # 4J          ',
								'8105 ROCKAWAY BEACH BLVD APT 7D','812 E GLEN AVE                 ','814 ACRI RD                    ','8153 RIZZO DR                  ','818 BEECHWOOD AVE              ','82 ALDER AVE                   ','82 DEVONSHIRE ST # R24A        ','82 LELAND HILL RD              ','82 S STATE RD                  ','820 GUNGYWAMP RD # A           ',
								'821 TREMONT DR                 ','823 E 35TH ST                  ','825 HOPE ST APT 1              ','8267 OAKWAY LN                 ','829 W TILGHMAN ST              ','83 CROMWELL AVE                ','83 LOPEZ RD                    ','83 RIDGEVIEW DR                ','830 AMSTERDAM AVE # 1          ','8309 TALBOT ST APT 3F          ',
								'8329 SEXTANT DR                ','835 SCHUYLER DR                ','839 HAMLIN CENTER RD           ','84 DALE DR                     ','84 JOYCE RD                    ','84 PROSPECT AVE                ','84 ZEVAN RD                    ','841 HOLLY BERRY LN             ','8428 LAKEWOOD CT               ','845 SPRINGBANK LN              ',
								'8483 BUTTON RD                 ','85 ARLYN DR E                  ','85 DAHLGREN PL                 ','85 KELLY DR                    ','85 OLD EAGLEVILLE RD           ','85 SUNSET HILL RD              ','850 W END AVE # 509            ','8520 GATES AVE                 ','855 GATES ST                   ','859 MONTGOMERY AVE # 2         ',
								'86 DEMAREST AVE                ','86 KIRKWOOD DR                 ','86 RANDOM FARMS CIR            ','86 WORCESTER ST # 1            ','8610 TRANSIT RD                ','8644 DISRAELI PATH             ','867 STATE ROUTE 79 # 79        ','87 BROWN ST                    ','87 HALF HOLLOW RD              ','87 OXFORD PL                   ',
								'87 WESTFIELD DR                ','8710 LYKENS LN                 ','8742 COLUMBINE CIR             ','8766 FOXFIRE LN                ','88 BEECH TREE RDG              ','88 FLORENCE ST # 22            ','88 MADISON AVE                 ','88 SMOKEBOX CIR                ','8800 BOULEVARD E APT 2G        ','883 DEAN ST                    ',
								'887 CRANFORD AVE               ','89 BERKSHIRE DR                ','89 GREW AVE APT B              ','89 OAK ST                      ','89 W HILLSIDE AVE              ','8915 GETTYSBURG ST             ','896 EASTERN PKWY               ','9 ALEXANDER DR                 ','9 BAKER DR                     ','9 BLUE JAY ST                  ',
								'9 BYRON LN                     ','9 CHESTERFIELD DR              ','9 COUNTRYSIDE RD               ','9 DODD ST                      ','9 EDGEHILL DR                  ','9 FELA DR                      ','9 GLENVIEW LN                  ','9 HARTZEL CT                   ','9 HOGATE CT                    ','9 JODI LN                      ',
								'9 LANSING PL # 1               ','9 LYMAN RD                     ','9 MERCER ST APT 5B             ','9 NETHERWOOD CIR               ','9 PALMER HILL AVE # 0          ','9 PIONEER CIR                  ','9 RICHARDSON CT                ','9 SAINT PAULS RD N APT 3D      ','9 SNAPDRAGON DR                ','9 SUNDALE PL                   ',
								'9 TREASURE LN                  ','9 WARD ST                      ','9 WINTHROP RD                  ','90 BOULDER TRL                 ','90 GAYNOR AVE                  ','90 LEXINGTON AVE APT 3D        ','90 PURITAN LN                  ','90 WASHINGTON RD               ','900 W END AVE # 4E             ','9016 155TH ST                  ',
								'903 N YORK DR # 40             ','905 REED CT                    ','908 BIG OAK RD                 ','91 BELLWOOD AVE                ','91 GARDNER AVE                 ','91 PLEASANT ST # 1             ','91 WINDSOR MEWS                ','911 MIDLAND AVE APT 2          ','914 HEAVER CLOSE               ','916 MERRITT DR APT E           ',
								'92 2ND AVE APT 11              ','92 FRANKLIN AVE                ','92 MOUNTAIN AVE                ','92 TRENTON ST # 0              ','921 E 103RD ST                 ','923 WELSH AYRES WAY # 43       ','9269 SHORE RD APT D7           ','93 ALPINE TRL                  ','93 DUNDERBERG RD               ','93 MAIN ST                     ',
								'93 SILOAM RD                   ','9304 102ND ST                  ','933 HAMILTON ST                ','937 BANCROFT PL                ','94 CHARLES ST                  ','94 JONQUIL DR                  ','94 STATION RD                  ','9411 109TH ST                  ','945 KINGS WAY E                ','949 ROCKPORT RD                ',
								'95 CHURCH RD                   ','95 HORATIO ST APT 212          ','95 LOUVAIN ST                  ','95 SMOKEBOX CIR                ','95 WINTHROP AVE                ','9516 239TH ST                  ','955 E 87TH ST                  ','96 5TH AVE APT 8P              ','96 FLAG HILL RD                ','96 MADISON CT                  ',
								'96 SCHERMERHORN ST APT 6G      ','9602 57TH AVE APT 7D           ','966 CENTRE ST                  ','97 BRADFORD ST                 ','97 HORATIO ST # 628            ','97 RED OAK RD                  ','970 INDIAN CREEK RD            ','9728 3RD AVE # 615             ','978 SMITHRIDGE RD              ','98 EDITH ST                    ',
								'98 NURSERY RD                  ','98 UNION ST                    ','982 WILSON CT                  ','988 COLUMBUS AVE APT 3G        ','99 CENTER BRIDGE RD # A        ','99 HUSTED LN                   ','99 MEESHAWAY TRL               ','99 RUTHVEN ST                  ','991 HIGH ST                    ','998 AMSTERDAM AVE APT 3A       '];


	//9540 valid city,state,zip combinations

		//Matched sets of 9540 City,State, Zips
SET OF STRING15 SetCity := [
			'ABBEVILLE      ','ABBOTTSTOWN    ','ABELL          ','ABERDEEN       ','ABERDEEN PROVIN','ABERNATHY      ','ABILENE        ','ABINGDON       ','ABINGTON       ','ABITA SPRINGS  ',
			'ABRAMS         ','ABSECON        ','ACAMPO         ','ACCIDENT       ','ACCOKEEK       ','ACCOMAC        ','ACCORD         ','ACME           ','ACTON          ','ACUSHNET       ',
			'ACWORTH        ','ADA            ','ADAIRSVILLE    ','ADAK           ','ADAMS          ','ADAMS CENTER   ','ADAMSTOWN      ','ADAMSVILLE     ','ADDISON        ','ADDY           ',
			'ADEL           ','ADELANTO       ','ADELL          ','ADKINS         ','ADRIAN         ','ADVANCE        ','AFTON          ','AGANA HEIGHTS  ','AGAWAM         ','AGENDA         ',
			'AGOURA HILLS   ','AGUADILLA      ','AGUANGA        ','AHOSKIE        ','AIEA           ','AIKEN          ','AILEY          ','AINSWORTH      ','AJO            ','AKRON          ',
			'ALABASTER      ','ALACHUA        ','ALAMEDA        ','ALAMO          ','ALAMOGORDO     ','ALAMOSA        ','ALANSON        ','ALBANY         ','ALBEMARLE      ','ALBERT LEA     ',
			'ALBERTSON      ','ALBERTVILLE    ','ALBION         ','ALBRIGHTSVILLE ','ALBUQUERQUE    ','ALBURG         ','ALBURTIS       ','ALCALDE        ','ALCESTER       ','ALCOA          ',
			'ALDEN          ','ALDERSON       ','ALDIE          ','ALEDO          ','ALEXANDER      ','ALEXANDER CITY ','ALEXANDRIA     ','ALEXANDRIA BAY ','ALFORD         ','ALFRED         ',
			'ALFRED STATION ','ALGER          ','ALGONQUIN      ','ALHAMBRA       ','ALICE          ','ALIEF          ','ALIQUIPPA      ','ALISO VIEJO    ','ALLAMUCHY      ','ALLEGAN        ',
			'ALLEGANY       ','ALLEN          ','ALLEN PARK     ','ALLENDALE      ','ALLENHURST     ','ALLENSPARK     ','ALLENTOWN      ','ALLENWOOD      ','ALLIANCE       ','ALLISON        ',
			'ALLISON PARK   ','ALLOUEZ        ','ALLSTON        ','ALLYN          ','ALMA           ','ALMIRA         ','ALMONT         ','ALNA           ','ALPENA         ','ALPHARETTA     ',
			'ALPINE         ','ALSIP          ','ALSTEAD        ','ALTA LOMA      ','ALTA VISTA     ','ALTADENA       ','ALTAMONT       ','ALTAMONTE SPRIN','ALTAVILLE      ','ALTAVISTA      ',
			'ALTMAR         ','ALTO           ','ALTON          ','ALTON BAY      ','ALTOONA        ','ALTURAS        ','ALTUS          ','ALUM CREEK     ','ALVA           ','ALVARADO       ',
			'ALVATON        ','ALVERTON       ','ALVIN          ','ALVISO         ','ALVO           ','AMAGANSETT     ','AMANA          ','AMANDA PARK    ','AMARGOSA VALLEY','AMARILLO       ',
			'AMAWALK        ','AMBLER         ','AMBOY          ','AMELIA         ','AMENIA         ','AMERICAN CANYON','AMERICAN FALLS ','AMERICAN FORK  ','AMERICUS       ','AMERY          ',
			'AMES           ','AMESBURY       ','AMF OHARE      ','AMHERST        ','AMISSVILLE     ','AMITY          ','AMITYVILLE     ','AMLIN          ','AMSTERDAM      ','AMSTON         ',
			'ANABEL         ','ANACOCO        ','ANACONDA       ','ANACORTES      ','ANADARKO       ','ANAHEIM        ','ANAHOLA        ','ANAHUAC        ','ANALOMINK      ','ANAMOSA        ',
			'ANCHOR POINT   ','ANCHORAGE      ','ANDALE         ','ANDALUSIA      ','ANDERSON       ','ANDERSON ISLAND','ANDERSONVILLE  ','ANDOVER        ','ANDREWS        ','ANDREWS AIR FOR',
			'ANGELICA       ','ANGELS CAMP    ','ANGIER         ','ANGLETON       ','ANGOLA         ','ANGUS          ','ANGWIN         ','ANKENY         ','ANN ARBOR      ','ANNA           ',
			'ANNABELLA      ','ANNANDALE      ','ANNAPOLIS      ','ANNAPOLIS JUNCT','ANNISTON       ','ANNVILLE       ','ANOKA          ','ANSON          ','ANSONIA        ','ANTELOPE       ',
			'ANTHEM         ','ANTHONY        ','ANTIGO         ','ANTIOCH        ','ANTONITO       ','ANZA           ','APACHE JUNCTION','APALACHICOLA   ','APALACHIN      ','APEX           ',
			'APOLLO         ','APOLLO BEACH   ','APOPKA         ','APPLE VALLEY   ','APPLETON       ','APPLETON CITY  ','APPLING        ','APTOS          ','AQUASCO        ','AQUEBOGUE      ',
			'ARAB           ','ARABI          ','ARAGON         ','ARANSAS PASS   ','ARAPAHOE       ','ARARAT         ','ARBELA         ','ARBUCKLE       ','ARCADE         ','ARCADIA        ',
			'ARCANUM        ','ARCATA         ','ARCHBOLD       ','ARCHDALE       ','ARCHER         ','ARCOLA         ','ARDARA         ','ARDEN          ','ARDMORE        ','ARDSLEY        ',
			'ARDSLEY ON HUDS','ARENA          ','ARENDTSVILLE   ','ARENZVILLE     ','ARGONIA        ','ARGOS          ','ARGUSVILLE     ','ARGYLE         ','ARIEL          ','ARIVACA        ',
			'ARIZONA CITY   ','ARKADELPHIA    ','ARKANSAS CITY  ','ARKOMA         ','ARLINGTON      ','ARLINGTON HEIGH','ARMA           ','ARMADA         ','ARMONK         ','ARNAUDVILLE    ',
			'ARNOLD         ','ARNOLDSVILLE   ','AROMAS         ','ARP            ','ARPIN          ','ARROYO GRANDE  ','ARTESIA        ','ARTHUR CITY    ','ARVADA         ','ARVERNE        ',
			'ARVIN          ','ASBURY         ','ASBURY PARK    ','ASH FLAT       ','ASHAWAY        ','ASHBURN        ','ASHBURNHAM     ','ASHBY          ','ASHDOWN        ','ASHEBORO       ',
			'ASHEVILLE      ','ASHFIELD       ','ASHFORD        ','ASHKUM         ','ASHLAND        ','ASHLAND CITY   ','ASHLEY         ','ASHLEY FALLS   ','ASHTABULA      ','ASHTON         ',
			'ASHVILLE       ','ASPEN          ','ASSONET        ','ASTON          ','ASTORIA        ','ATASCADERO     ','ATASCOSA       ','ATCHISON       ','ATCO           ','ATGLEN         ',
			'ATHENS         ','ATHERTON       ','ATHOL          ','ATKINS         ','ATKINSON       ','ATLANTA        ','ATLANTIC       ','ATLANTIC BEACH ','ATLANTIC CITY  ','ATLANTIC HIGHLA',
			'ATLAS          ','ATMORE         ','ATOKA          ','ATTALLA        ','ATTICA         ','ATTLEBORO      ','ATTLEBORO FALLS','ATWATER        ','ATWOOD         ','AU GRES        ',
			'AU SABLE FORKS ','AUBURN         ','AUBURN HILLS   ','AUBURNDALE     ','AUDUBON        ','AUGUSTA        ','AULT           ','AULTMAN        ','AURELIA        ','AURORA         ',
			'AUSTELL        ','AUSTIN         ','AUSTINBURG     ','AUTAUGAVILLE   ','AVA            ','AVALON         ','AVELLA         ','AVENEL         ','AVENUE         ','AVERILL PARK   ',
			'AVERY          ','AVILA BEACH    ','AVILLA         ','AVINGER        ','AVON           ','AVON BY THE SEA','AVON LAKE      ','AVON PARK      ','AVONDALE       ','AVONDALE ESTATE',
			'AVONMORE       ','AWENDAW        ','AXIS           ','AXTELL         ','AXTON          ','AYDEN          ','AYER           ','AYLETT         ','AYR            ','AZLE           ',
			'AZTEC          ','AZUSA          ','BABSON PARK    ','BABYLON        ','BACKUS         ','BAD AXE        ','BADEN          ','BAGDAD         ','BAGLEY         ','BAHAMA         ',
			'BAILEY         ','BAILEYS HARBOR ','BAILEYTON      ','BAILEYVILLE    ','BAINBRIDGE     ','BAINBRIDGE ISLA','BAKER          ','BAKER CITY     ','BAKERSFIELD    ','BALA CYNWYD    ',
			'BALD KNOB      ','BALDWIN        ','BALDWIN CITY   ','BALDWIN PARK   ','BALDWIN PLACE  ','BALDWINSVILLE  ','BALDWYN        ','BALL GROUND    ','BALLENTINE     ','BALLINGER      ',
			'BALLSTON LAKE  ','BALLSTON SPA   ','BALLWIN        ','BALTIC         ','BALTIMORE      ','BAMBERG        ','BANCROFT       ','BANDERA        ','BANGALL        ','BANGOR         ',
			'BANKS          ','BANKSTON       ','BANNER ELK     ','BANNING        ','BANNISTER      ','BANTAM         ','BAPCHULE       ','BAPTISTOWN     ','BAR HARBOR     ','BAR MILLS      ',
			'BARABOO        ','BARAGA         ','BARBEAU        ','BARBERS POINT N','BARBERTON      ','BARBOURSVILLE  ','BARBOURVILLE   ','BARD           ','BARDSTOWN      ','BARGERSVILLE   ',
			'BARKER         ','BARKSDALE AFB  ','BARLING        ','BARNEGAT       ','BARNEGAT LIGHT ','BARNESTON      ','BARNESVILLE    ','BARNET         ','BARNEVELD      ','BARNHART       ',
			'BARNSTABLE     ','BARNWELL       ','BARODA         ','BARRE          ','BARRIGADA      ','BARRINGTON     ','BARROW         ','BARSTOW        ','BARTLESVILLE   ','BARTLETT       ',
			'BARTO          ','BARTON         ','BARTON CITY    ','BARTONSVILLE   ','BARTOW         ','BASALT         ','BASCOM         ','BASEHOR        ','BASKING RIDGE  ','BASOM          ',
			'BASS HARBOR    ','BASTROP        ','BATAVIA        ','BATES CITY     ','BATESVILLE     ','BATH           ','BATON ROUGE    ','BATTLE CREEK   ','BATTLE GROUND  ','BATTLE LAKE    ',
			'BATTLE MOUNTAIN','BATTLEBORO     ','BAUDETTE       ','BAUXITE        ','BAXLEY         ','BAXTER         ','BAY CITY       ','BAY MINETTE    ','BAY PINES      ','BAY SAINT LOUIS',
			'BAY SHORE      ','BAY SPRINGS    ','BAY VILLAGE    ','BAYAMON        ','BAYARD         ','BAYFIELD       ','BAYONNE        ','BAYPORT        ','BAYSIDE        ','BAYTOWN        ',
			'BAYVILLE       ','BEACH HAVEN    ','BEACHWOOD      ','BEACON         ','BEACON FALLS   ','BEALE AFB      ','BEALETON       ','BEALS          ','BEAN STATION   ','BEAR           ',
			'BEAR CREEK     ','BEAR LAKE      ','BEARDSLEY      ','BEARDSTOWN     ','BEATRICE       ','BEATTYVILLE    ','BEAUFORT       ','BEAUMONT       ','BEAUTY         ','BEAVER         ',
			'BEAVER DAM     ','BEAVER DAMS    ','BEAVER FALLS   ','BEAVER ISLAND  ','BEAVERCREEK    ','BEAVERDAM      ','BEAVERTON      ','BEAVERVILLE    ','BECHTELSVILLE  ','BECKER         ',
			'BECKET         ','BECKLEY        ','BEDFORD        ','BEDFORD HILLS  ','BEDFORD PARK   ','BEDIAS         ','BEDMINSTER     ','BEE            ','BEEBE          ','BEECH CREEK    ',
			'BEECH GROVE    ','BEECH ISLAND   ','BEECHER        ','BEECHER CITY   ','BEECHGROVE     ','BEECHMONT      ','BEEVILLE       ','BEGGS          ','BEL AIR        ','BEL ALTON      ',
			'BELCAMP        ','BELCHERTOWN    ','BELCOURT       ','BELDEN         ','BELDENVILLE    ','BELDING        ','BELEWS CREEK   ','BELFAIR        ','BELFAST        ','BELFIELD       ',
			'BELFORD        ','BELFRY         ','BELGIUM        ','BELGRADE       ','BELL BUCKLE    ','BELL CANYON    ','BELL GARDENS   ','BELLA VISTA    ','BELLAIRE       ','BELLBROOK      ',
			'BELLE          ','BELLE CENTER   ','BELLE CHASSE   ','BELLE FOURCHE  ','BELLE GLADE    ','BELLE MEAD     ','BELLE PLAINE   ','BELLE RIVE     ','BELLE VALLEY   ','BELLE VERNON   ',
			'BELLEAIR       ','BELLEAIR BEACH ','BELLEFONTAINE  ','BELLEFONTE     ','BELLEROSE      ','BELLEVIEW      ','BELLEVILLE     ','BELLEVUE       ','BELLFLOWER     ','BELLINGHAM     ',
			'BELLMAWR       ','BELLMORE       ','BELLOWS FALLS  ','BELLPORT       ','BELLVILLE      ','BELLVUE        ','BELLWOOD       ','BELMAR         ','BELMONT        ','BELOIT         ',
			'BELPRE         ','BELSANO        ','BELTON         ','BELTSVILLE     ','BELVEDERE TIBUR','BELVIDERE      ','BELZONI        ','BEMIDJI        ','BEMUS POINT    ','BEN LOMOND     ',
			'BENA           ','BEND           ','BENEDICT       ','BENEDICTA      ','BENET LAKE     ','BENICIA        ','BENNETT        ','BENNETTSVILLE  ','BENNINGTON     ','BENSALEM       ',
			'BENSENVILLE    ','BENSON         ','BENTLEYVILLE   ','BENTON         ','BENTON CITY    ','BENTON HARBOR  ','BENTON RIDGE   ','BENTONVILLE    ','BENZONIA       ','BEREA          ',
			'BERESFORD      ','BERGENFIELD    ','BERGHEIM       ','BERKELEY       ','BERKELEY HEIGHT','BERKLEY        ','BERKSHIRE      ','BERLIN         ','BERLIN HEIGHTS ','BERN           ',
			'BERNARD        ','BERNARDSTON    ','BERNARDSVILLE  ','BERNE          ','BERNHARDS BAY  ','BERNIE         ','BERNVILLE      ','BERRIEN SPRINGS','BERRY          ','BERRYTON       ',
			'BERRYVILLE     ','BERTHOUD       ','BERTRAM        ','BERWICK        ','BERWYN         ','BESSEMER       ','BESSEMER CITY  ','BETHALTO       ','BETHANY        ','BETHANY BEACH  ',
			'BETHEL         ','BETHEL ISLAND  ','BETHEL PARK    ','BETHESDA       ','BETHLEHEM      ','BETHPAGE       ','BETHUNE        ','BETTENDORF     ','BETTERTON      ','BETTSVILLE     ',
			'BEULAH         ','BEVERLY        ','BEVERLY HILLS  ','BEVIER         ','BICKNELL       ','BIDDEFORD      ','BIG BEAR CITY  ','BIG BEAR LAKE  ','BIG BEND       ','BIG CREEK      ',
			'BIG LAKE       ','BIG OAK FLAT   ','BIG PINE KEY   ','BIG POOL       ','BIG PRAIRIE    ','BIG RAPIDS     ','BIG ROCK       ','BIG SANDY      ','BIG SKY        ','BIG SPRING     ',
			'BIG STONE CITY ','BIG SUR        ','BIG TIMBER     ','BILLERICA      ','BILLINGS       ','BILLINGSLEY    ','BILOXI         ','BINGHAM        ','BINGHAMTON     ','BIRCH RUN      ',
			'BIRCH TREE     ','BIRCHRUNVILLE  ','BIRD ISLAND    ','BIRDS          ','BIRDSBORO      ','BIRMINGHAM     ','BISBEE         ','BISHOP         ','BISHOPVILLE    ','BISMARCK       ',
			'BITELY         ','BIXBY          ','BLACK          ','BLACK CREEK    ','BLACK DIAMOND  ','BLACK EAGLE    ','BLACK EARTH    ','BLACK HAWK     ','BLACK MOUNTAIN ','BLACK RIVER    ',
			'BLACK RIVER FAL','BLACKBURN      ','BLACKDUCK      ','BLACKFOOT      ','BLACKLICK      ','BLACKSBURG     ','BLACKSHEAR     ','BLACKSTONE     ','BLACKWATER     ','BLACKWELL      ',
			'BLACKWOOD      ','BLADEN         ','BLADENBORO     ','BLADENSBURG    ','BLAINE         ','BLAIR          ','BLAIRS         ','BLAIRSDEN-GRAEA','BLAIRSTOWN     ','BLAIRSVILLE    ',
			'BLAKELY        ','BLAKELY ISLAND ','BLAKESLEE      ','BLANCHARD      ','BLANCHARDVILLE ','BLANCHESTER    ','BLANCO         ','BLAND          ','BLANDFORD      ','BLANDING       ',
			'BLANDON        ','BLANKS         ','BLAUVELT       ','BLAWENBURG     ','BLENCOE        ','BLISSFIELD     ','BLOCK ISLAND   ','BLOOMDALE      ','BLOOMER        ','BLOOMFIELD     ',
			'BLOOMFIELD HILL','BLOOMING GROVE ','BLOOMINGBURG   ','BLOOMINGDALE   ','BLOOMINGTON    ','BLOOMSBURG     ','BLOOMSBURY     ','BLOOMSDALE     ','BLOOMVILLE     ','BLOSSVALE      ',
			'BLOUNTSVILLE   ','BLOUNTVILLE    ','BLOWING ROCK   ','BLOXOM         ','BLUE BELL      ','BLUE DIAMOND   ','BLUE GRASS     ','BLUE HILL      ','BLUE ISLAND    ','BLUE JAY       ',
			'BLUE MOUNDS    ','BLUE MOUNTAIN  ','BLUE POINT     ','BLUE RIDGE     ','BLUE RIDGE SUMM','BLUE SPRINGS   ','BLUEFIELD      ','BLUEGROVE      ','BLUEJACKET     ','BLUEMONT       ',
			'BLUFFTON       ','BLYTHE         ','BLYTHEVILLE    ','BLYTHEWOOD     ','BOALSBURG      ','BOAZ           ','BOCA GRANDE    ','BOCA RATON     ','BODEGA         ','BODEGA BAY     ',
			'BOERNE         ','BOGALUSA       ','BOGART         ','BOGATA         ','BOGOTA         ','BOGUE CHITTO   ','BOHEMIA        ','BOILING SPRINGS','BOISE          ','BOLINGBROOK    ',
			'BOLIVAR        ','BOLIVIA        ','BOLTON         ','BOLTON LANDING ','BOMOSEEN       ','BON AQUA       ','BON SECOUR     ','BONAIRE        ','BONDSVILLE     ','BONDUEL        ',
			'BONDURANT      ','BONDVILLE      ','BONFIELD       ','BONHAM         ','BONIFAY        ','BONITA         ','BONITA SPRINGS ','BONNE TERRE    ','BONNER         ','BONNER SPRINGS ',
			'BONNERS FERRY  ','BONO           ','BONSALL        ','BOONE          ','BOONES MILL    ','BOONEVILLE     ','BOONSBORO      ','BOONTON        ','BOONVILLE      ','BOOTHBAY HARBOR',
			'BORDEN         ','BORDENTOWN     ','BORGER         ','BORING         ','BORREGO SPRINGS','BOSCAWEN       ','BOSQUE FARMS   ','BOSSIER CITY   ','BOSTON         ','BOSWELL        ',
			'BOTHELL        ','BOTSFORD       ','BOTTINEAU      ','BOUCKVILLE     ','BOULDER        ','BOULDER CITY   ','BOULDER CREEK  ','BOULDER JUNCTIO','BOULEVARD      ','BOUND BROOK    ',
			'BOUNTIFUL      ','BOURBON        ','BOURBONNAIS    ','BOURG          ','BOUTTE         ','BOW            ','BOWDOIN        ','BOWDOINHAM     ','BOWDON         ','BOWEN          ',
			'BOWERS         ','BOWIE          ','BOWLING GREEN  ','BOWMANSVILLE   ','BOX ELDER      ','BOXBOROUGH     ','BOXFORD        ','BOYCE          ','BOYCEVILLE     ','BOYD           ',
			'BOYDS          ','BOYDTON        ','BOYERTOWN      ','BOYES HOT SPRIN','BOYKINS        ','BOYLSTON       ','BOYNE CITY     ','BOYNE FALLS    ','BOYNTON BEACH  ','BOYS TOWN      ',
			'BOZEMAN        ','BOZMAN         ','BOZRAH         ','BRACKNEY       ','BRADBURY       ','BRADENTON      ','BRADENTON BEACH','BRADFORD       ','BRADFORDSVILLE ','BRADFORDWOODS  ',
			'BRADLEY        ','BRADLEY BEACH  ','BRADLEYVILLE   ','BRADY          ','BRAGG CITY     ','BRAIDWOOD      ','BRAINERD       ','BRAINTREE      ','BRANCHVILLE    ','BRANDAMORE     ',
			'BRANDENBURG    ','BRANDON        ','BRANDY STATION ','BRANDYWINE     ','BRANFORD       ','BRANSON        ','BRANT          ','BRANT ROCK     ','BRANTLEY       ','BRASELTON      ',
			'BRATTLEBORO    ','BRAWLEY        ','BRAYMER        ','BRAZIL         ','BRAZORIA       ','BREA           ','BREAUX BRIDGE  ','BRECKENRIDGE   ','BRECKSVILLE    ','BREESE         ',
			'BREEZEWOOD     ','BREEZY POINT   ','BREINIGSVILLE  ','BREMEN         ','BREMERTON      ','BREMO BLUFF    ','BREMOND        ','BRENHAM        ','BRENT          ','BRENTON        ',
			'BRENTWOOD      ','BREVARD        ','BREVIG MISSION ','BREWER         ','BREWERTON      ','BREWSTER       ','BREWTON        ','BRIAN HEAD     ','BRIARCLIFF MANO','BRICK          ',
			'BRIDGE CITY    ','BRIDGEHAMPTON  ','BRIDGEPORT     ','BRIDGETON      ','BRIDGEVIEW     ','BRIDGEVILLE    ','BRIDGEWATER    ','BRIDGMAN       ','BRIDGTON       ','BRIELLE        ',
			'BRIERFIELD     ','BRIGANTINE     ','BRIGHAM CITY   ','BRIGHTON       ','BRIGHTWATERS   ','BRILLION       ','BRIMFIELD      ','BRINKLEY       ','BRINKLOW       ','BRISBANE       ',
			'BRISTOL        ','BRISTOW        ','BRITTON        ','BROAD BROOK    ','BROAD CHANNEL  ','BROAD RUN      ','BROADALBIN     ','BROADDUS       ','BROADUS        ','BROADVIEW      ',
			'BROADVIEW HEIGH','BROADWAY       ','BROCKPORT      ','BROCKTON       ','BROCKWAY       ','BRODHEAD       ','BRODHEADSVILLE ','BROKEN ARROW   ','BRONSON        ','BRONX          ',
			'BRONXVILLE     ','BROOK PARK     ','BROOKDALE      ','BROOKE         ','BROOKEVILLE    ','BROOKFIELD     ','BROOKHAVEN     ','BROOKINGS      ','BROOKLAND      ','BROOKLANDVILLE ',
			'BROOKLIN       ','BROOKLINE      ','BROOKLINE STATI','BROOKLYN       ','BROOKPARK      ','BROOKPORT      ','BROOKS         ','BROOKSHIRE     ','BROOKSIDE      ','BROOKSTON      ',
			'BROOKSVILLE    ','BROOKTONDALE   ','BROOKVILLE     ','BROOMALL       ','BROOMFIELD     ','BROUGHTON      ','BROUSSARD      ','BROWN CITY     ','BROWNFIELD     ','BROWNING       ',
			'BROWNS MILLS   ','BROWNS SUMMIT  ','BROWNSBORO     ','BROWNSBURG     ','BROWNSTOWN     ','BROWNSVILLE    ','BROWNWOOD      ','BROXTON        ','BRUCETON MILLS ','BRUNDIDGE      ',
			'BRUNEAU        ','BRUNSWICK      ','BRUSH          ','BRUSH CREEK    ','BRUSH PRAIRIE  ','BRUSHTON       ','BRUSSELS       ','BRYAN          ','BRYANS ROAD    ','BRYANT         ',
			'BRYANT POND    ','BRYANTOWN      ','BRYN ATHYN     ','BRYN MAWR      ','BRYSON CITY    ','BUCHANAN       ','BUCKATUNNA     ','BUCKEYE        ','BUCKEYSTOWN    ','BUCKFIELD      ',
			'BUCKHANNON     ','BUCKHEAD       ','BUCKINGHAM     ','BUCKLEY        ','BUCKLIN        ','BUCKNER        ','BUCKSPORT      ','BUCYRUS        ','BUDA           ','BUDD LAKE      ',
			'BUELLTON       ','BUENA          ','BUENA PARK     ','BUENA VISTA    ','BUFFALO        ','BUFFALO CREEK  ','BUFFALO GROVE  ','BUFFALO JUNCTIO','BUFORD         ','BUIES CREEK    ',
			'BULLARD        ','BULLHEAD CITY  ','BULVERDE       ','BUMPASS        ','BUNCOMBE       ','BUNKER         ','BUNKER HILL    ','BUNKERVILLE    ','BUNNELL        ','BURAS          ',
			'BURBANK        ','BURDETT        ','BURGAW         ','BURGETTSTOWN   ','BURGOON        ','BURIEN         ','BURKBURNETT    ','BURKE          ','BURKESVILLE    ','BURKEVILLE     ',
			'BURLESON       ','BURLEY         ','BURLINGAME     ','BURLINGTON     ','BURNET         ','BURNETT        ','BURNHAM        ','BURNS          ','BURNSVILLE     ','BURNT HILLS    ',
			'BURR RIDGE     ','BURSON         ','BURT           ','BURTCHVILLE    ','BURTON         ','BURTONSVILLE   ','BUSH           ','BUSHKILL       ','BUSHLAND       ','BUSHNELL       ',
			'BUSHWOOD       ','BUSKIRK        ','BUTLER         ','BUTLERVILLE    ','BUTNER         ','BUTTE          ','BUTTE DES MORTS','BUTTE FALLS    ','BUTTERNUT      ','BUXTON         ',
			'BUZZARDS BAY   ','BYERS          ','BYFIELD        ','BYRON          ','BYRON CENTER   ','CABAZON        ','CABIN JOHN     ','CABOT          ','CACHE          ','CADDO MILLS    ',
			'CADILLAC       ','CADIZ          ','CAGUAS         ','CAIRO          ','CALABASAS      ','CALABASH       ','CALAIS         ','CALCIUM        ','CALDWELL       ','CALEDONIA      ',
			'CALERA         ','CALEXICO       ','CALHAN         ','CALHOUN        ','CALIENTE       ','CALIFON        ','CALIFORNIA     ','CALIFORNIA CITY','CALIMESA       ','CALIPATRIA     ',
			'CALISTOGA      ','CALLAHAN       ','CALLAO         ','CALLAWAY       ','CALPELLA       ','CALUMET CITY   ','CALVERT CITY   ','CALVERTON      ','CALVIN         ','CAMAK          ',
			'CAMANCHE       ','CAMANO ISLAND  ','CAMARILLO      ','CAMAS          ','CAMBRIA        ','CAMBRIA HEIGHTS','CAMBRIDGE      ','CAMBRIDGE CITY ','CAMBRIDGE SPRIN','CAMBY          ',
			'CAMDEN         ','CAMDEN WYOMING ','CAMDENTON      ','CAMERON        ','CAMILLA        ','CAMILLUS       ','CAMINO         ','CAMP CREEK     ','CAMP H M SMITH ','CAMP HILL      ',
			'CAMP LEJEUNE   ','CAMP MEEKER    ','CAMP VERDE     ','CAMPAIGN       ','CAMPBELL       ','CAMPBELL HALL  ','CAMPBELLSBURG  ','CAMPBELLSPORT  ','CAMPBELLSVILLE ','CAMPBELLTON    ',
			'CAMPO          ','CAMPO SECO     ','CAMPOBELLO     ','CAMPTON        ','CANAAN         ','CANADA         ','CANAL FULTON   ','CANAL WINCHESTE','CANANDAIGUA    ','CANASERAGA     ',
			'CANASTOTA      ','CANBY          ','CANDIA         ','CANDLER        ','CANDOR         ','CANEADEA       ','CANEY          ','CANFIELD       ','CANNON FALLS   ','CANOGA PARK    ',
			'CANON CITY     ','CANONSBURG     ','CANOVANAS      ','CANTERBURY     ','CANTON         ','CANTON CENTER  ','CANTONMENT     ','CANTRALL       ','CANYON         ','CANYON COUNTRY ',
			'CANYON LAKE    ','CANYONVILLE    ','CAPE CANAVERAL ','CAPE CHARLES   ','CAPE CORAL     ','CAPE ELIZABETH ','CAPE GIRARDEAU ','CAPE MAY       ','CAPE MAY COURT ','CAPE NEDDICK   ',
			'CAPISTRANO BEAC','CAPITOL HEIGHTS','CAPITOLA       ','CAPON BRIDGE   ','CAPRON         ','CAPSHAW        ','CAPTAIN COOK   ','CAPTIVA        ','CARBON         ','CARBON HILL    ',
			'CARBONDALE     ','CARDIFF BY THE ','CARDINGTON     ','CAREFREE       ','CARENCRO       ','CARIBOU        ','CARL JUNCTION  ','CARLE PLACE    ','CARLETON       ','CARLIN         ',
			'CARLINVILLE    ','CARLISLE       ','CARLOCK        ','CARLSBAD       ','CARLSTADT      ','CARLTON        ','CARLYLE        ','CARMEL         ','CARMEL VALLEY  ','CARMI          ',
			'CARMICHAEL     ','CARNATION      ','CARNEGIE       ','CARNELIAN BAY  ','CARNESVILLE    ','CARO           ','CAROL STREAM   ','CAROLEEN       ','CAROLINA       ','CAROLINA BEACH ',
			'CARPENTER      ','CARPENTERSVILLE','CARPINTERIA    ','CARR           ','CARRBORO       ','CARRIER        ','CARRIERE       ','CARRINGTON     ','CARRIZO SPRINGS','CARROLL        ',
			'CARROLLTON     ','CARROLLTOWN    ','CARRSVILLE     ','CARSON         ','CARSON CITY    ','CARSONVILLE    ','CARTER LAKE    ','CARTERET       ','CARTERSVILLE   ','CARTERVILLE    ',
			'CARTHAGE       ','CARUTHERS      ','CARUTHERSVILLE ','CARVER         ','CARVERSVILLE   ','CARY           ','CASA GRANDE    ','CASCADE        ','CASCADE LOCKS  ','CASCO          ',
			'CASEVILLE      ','CASEY          ','CASH           ','CASHION        ','CASHMERE       ','CASNOVIA       ','CASPER         ','CASSELBERRY    ','CASSVILLE      ','CASTAIC        ',
			'CASTALIA       ','CASTINE        ','CASTLE CREEK   ','CASTLE HAYNE   ','CASTLE ROCK    ','CASTLETON      ','CASTLETON ON HU','CASTLEWOOD     ','CASTRO VALLEY  ','CASTROVILLE    ',
			'CATALINA       ','CATANO         ','CATASAUQUA     ','CATAULA        ','CATAWBA        ','CATAWISSA      ','CATHARPIN      ','CATHEDRAL CITY ','CATHLAMET      ','CATLETT        ',
			'CATLETTSBURG   ','CATLIN         ','CATO           ','CATONSVILLE    ','CATOOSA        ','CATSKILL       ','CATTARAUGUS    ','CAVALIER       ','CAVE CITY      ','CAVE CREEK     ',
			'CAVE SPRINGS   ','CAVENDISH      ','CAYCE          ','CAYUCOS        ','CAYUGA         ','CAYUTA         ','CAZENOVIA      ','CECIL          ','CEDAR          ','CEDAR BLUFF    ',
			'CEDAR CITY     ','CEDAR CREEK    ','CEDAR CREST    ','CEDAR FALLS    ','CEDAR GLEN     ','CEDAR GROVE    ','CEDAR HILL     ','CEDAR KNOLLS   ','CEDAR LAKE     ','CEDAR PARK     ',
			'CEDAR RAPIDS   ','CEDAR SPRINGS  ','CEDAR VALLEY   ','CEDARBURG      ','CEDARHURST     ','CEDARS         ','CEDARTOWN      ','CEDARVILLE     ','CEIBA          ','CELINA         ',
			'CEMENT CITY    ','CENTER         ','CENTER CITY    ','CENTER CONWAY  ','CENTER CROSS   ','CENTER HARBOR  ','CENTER HILL    ','CENTER LINE    ','CENTER MORICHES','CENTER OSSIPEE ',
			'CENTER POINT   ','CENTER RIDGE   ','CENTER SANDWICH','CENTER STRAFFOR','CENTER VALLEY  ','CENTERBROOK    ','CENTERBURG     ','CENTEREACH     ','CENTERPOINT    ','CENTERPORT     ',
			'CENTERTON      ','CENTERTOWN     ','CENTERVILLE    ','CENTRAL        ','CENTRAL BRIDGE ','CENTRAL CITY   ','CENTRAL FALLS  ','CENTRAL ISLIP  ','CENTRAL LAKE   ','CENTRAL POINT  ',
			'CENTRAL SQUARE ','CENTRAL VALLEY ','CENTRALIA      ','CENTRE         ','CENTRE HALL    ','CENTREVILLE    ','CENTURIA       ','CERES          ','CERESCO        ','CERRITOS       ',
			'CERRO GORDO    ','CERULEAN       ','CHADDS FORD    ','CHADWICKS      ','CHAFFEE        ','CHAGRIN FALLS  ','CHALFONT       ','CHALMETTE      ','CHAMBERSBURG   ','CHAMPAIGN      ',
			'CHAMPION       ','CHAMPLAIN      ','CHAMPLIN       ','CHANA          ','CHANDLER       ','CHANDLERSVILLE ','CHANHASSEN     ','CHANNAHON      ','CHANNELVIEW    ','CHANTILLY      ',
			'CHANUTE        ','CHAPEL HILL    ','CHAPIN         ','CHAPLIN        ','CHAPMANVILLE   ','CHAPPAQUA      ','CHAPPELL HILL  ','CHAPTICO       ','CHARDON        ','CHARLEMONT     ',
			'CHARLEROI      ','CHARLES CITY   ','CHARLES TOWN   ','CHARLESTON     ','CHARLESTON AFB ','CHARLESTOWN    ','CHARLEVOIX     ','CHARLOTTE      ','CHARLOTTE HALL ','CHARLOTTESVILLE',
			'CHARLTON       ','CHARLTON CITY  ','CHARTLEY       ','CHASE          ','CHASEBURG      ','CHASKA         ','CHATEAUGAY     ','CHATFIELD      ','CHATHAM        ','CHATOM         ',
			'CHATSWORTH     ','CHATTAHOOCHEE  ','CHATTANOOGA    ','CHATTAROY      ','CHAUTAUQUA     ','CHAZY          ','CHEBANSE       ','CHEBOYGAN      ','CHECOTAH       ','CHEHALIS       ',
			'CHELAN         ','CHELMSFORD     ','CHELSEA        ','CHELTENHAM     ','CHENANGO FORKS ','CHENEY         ','CHEPACHET      ','CHERAW         ','CHEROKEE       ','CHEROKEE VILLAG',
			'CHERRY FORK    ','CHERRY HILL    ','CHERRY VALLEY  ','CHERRYVILLE    ','CHESANING      ','CHESAPEAKE     ','CHESAPEAKE BEAC','CHESAPEAKE CITY','CHESHIRE       ','CHESNEE        ',
			'CHESTER        ','CHESTER HEIGHTS','CHESTER SPRINGS','CHESTERFIELD   ','CHESTERHILL    ','CHESTERLAND    ','CHESTERTON     ','CHESTERTOWN    ','CHESTERVILLE   ','CHESTNUT HILL  ',
			'CHESWICK       ','CHEVY CHASE    ','CHEYENNE       ','CHEYNEY        ','CHICAGO        ','CHICAGO HEIGHTS','CHICAGO PARK   ','CHICAGO RIDGE  ','CHICKAMAUGA    ','CHICKASHA      ',
			'CHICO          ','CHICOPEE       ','CHILDERSBURG   ','CHILDRESS      ','CHILDS         ','CHILHOWIE      ','CHILI          ','CHILLICOTHE    ','CHILMARK       ','CHILOQUIN      ',
			'CHILTON        ','CHIMACUM       ','CHIMNEY ROCK   ','CHINA          ','CHINA GROVE    ','CHINA SPRING   ','CHINCOTEAGUE IS','CHINO          ','CHINO HILLS    ','CHINO VALLEY   ',
			'CHIPLEY        ','CHIPPEWA FALLS ','CHISAGO CITY   ','CHISHOLM       ','CHITTENANGO    ','CHITTENDEN     ','CHLOE          ','CHOCOWINITY    ','CHOCTAW        ','CHOTEAU        ',
			'CHOUDRANT      ','CHOUTEAU       ','CHRISMAN       ','CHRISTIANA     ','CHRISTIANSBURG ','CHRISTIANSTED  ','CHRISTOPHER    ','CHUGIAK        ','CHULA VISTA    ','CHUNCHULA      ',
			'CHURCH HILL    ','CHURCH POINT   ','CHURCH ROAD    ','CHURCHTON      ','CHURCHVILLE    ','CHURUBUSCO     ','CIBOLO         ','CICERO         ','CIMARRON       ','CINCINNATI     ',
			'CIRCLE         ','CIRCLE PINES   ','CIRCLEVILLE    ','CITRA          ','CITRUS HEIGHTS ','CITY OF INDUSTR','CLACKAMAS      ','CLAFLIN        ','CLAIRTON       ','CLANCY         ',
			'CLANTON        ','CLARCONA       ','CLARE          ','CLAREMONT      ','CLAREMORE      ','CLARENCE       ','CLARENCE CENTER','CLARENDON HILLS','CLARIDGE       ','CLARINDA       ',
			'CLARION        ','CLARK          ','CLARKDALE      ','CLARKESVILLE   ','CLARKIA        ','CLARKS HILL    ','CLARKS SUMMIT  ','CLARKSBORO     ','CLARKSBURG     ','CLARKSDALE     ',
			'CLARKSTON      ','CLARKSVILLE    ','CLARKTON       ','CLATSKANIE     ','CLAUDVILLE     ','CLAVERACK      ','CLAWSON        ','CLAY           ','CLAY CENTER    ','CLAY CITY      ',
			'CLAYMONT       ','CLAYSVILLE     ','CLAYTON        ','CLAYVILLE      ','CLE ELUM       ','CLEAR          ','CLEAR CREEK    ','CLEAR LAKE     ','CLEAR SPRING   ','CLEARFIELD     ',
			'CLEARLAKE      ','CLEARVILLE     ','CLEARWATER     ','CLEARWATER BEAC','CLEBURNE       ','CLEMENTS       ','CLEMMONS       ','CLEMONS        ','CLEMSON        ','CLERMONT       ',
			'CLEVELAND      ','CLEVER         ','CLEVES         ','CLEWISTON      ','CLIFFORD       ','CLIFFSIDE PARK ','CLIFFWOOD      ','CLIFTON        ','CLIFTON HEIGHTS','CLIFTON PARK   ',
			'CLIMAX         ','CLINCHCO       ','CLINT          ','CLINTON        ','CLINTON CORNERS','CLINTON TOWNSHI','CLINTONDALE    ','CLINTONVILLE   ','CLIO           ','CLIVE          ',
			'CLOQUET        ','CLOSTER        ','CLOVER         ','CLOVERDALE     ','CLOVIS         ','CLYDE          ','CLYMER         ','CLYO           ','COACHELLA      ','COAL CENTER    ',
			'COAL CITY      ','COAL TOWNSHIP  ','COALING        ','COALINGA       ','COALPORT       ','COALVILLE      ','COARSEGOLD     ','COATESVILLE    ','COATS          ','COBALT         ',
			'COBB           ','COBLESKILL     ','COCHRAN        ','COCHRANE       ','COCHRANVILLE   ','COCKEYSVILLE   ','COCOA          ','COCOA BEACH    ','COCONUT CREEK  ','CODEN          ',
			'CODY           ','COEBURN        ','COEUR D ALENE  ','COEYMANS       ','COFFEYVILLE    ','COGAN STATION  ','COHASSET       ','COHOES         ','COKATO         ','COKER          ',
			'COLBERT        ','COLBY          ','COLCHESTER     ','COLD BROOK     ','COLD SPRING    ','COLD SPRING HAR','COLDEN         ','COLDSPRING     ','COLDWATER      ','COLEBROOK      ',
			'COLEMAN        ','COLESBURG      ','COLFAX         ','COLGATE        ','COLLEGE PARK   ','COLLEGE PLACE  ','COLLEGE POINT  ','COLLEGE STATION','COLLEGEVILLE   ','COLLEYVILLE    ',
			'COLLIERVILLE   ','COLLINGSWOOD   ','COLLINS        ','COLLINSVILLE   ','COLLINWOOD     ','COLMA          ','COLMAR         ','COLO           ','COLOGNE        ','COLOMA         ',
			'COLONA         ','COLONIA        ','COLONIAL BEACH ','COLONIAL HEIGHT','COLORA         ','COLORADO CITY  ','COLORADO SPRING','COLQUITT       ','COLTON         ','COLTS NECK     ',
			'COLUMBIA       ','COLUMBIA CITY  ','COLUMBIA FALLS ','COLUMBIA STATIO','COLUMBIANA     ','COLUMBIAVILLE  ','COLUMBUS       ','COLUMBUS GROVE ','COLUSA         ','COLVILLE       ',
			'COLWICH        ','COMANCHE       ','COMBINED LOCKS ','COMER          ','COMMACK        ','COMMERCE       ','COMMERCE CITY  ','COMMERCE TOWNSH','COMMERCIAL POIN','COMO           ',
			'COMPTON        ','COMSTOCK PARK  ','CONCORD        ','CONCORDIA      ','CONCORDVILLE   ','CONCRETE       ','CONDON         ','CONESUS        ','CONGERS        ','CONGERVILLE    ',
			'CONIFER        ','CONKLIN        ','CONLEY         ','CONNEAUT       ','CONNEAUT LAKE  ','CONNEAUTVILLE  ','CONNELLSVILLE  ','CONNERSVILLE   ','CONOVER        ','CONOWINGO      ',
			'CONROE         ','CONSHOHOCKEN   ','CONSTABLEVILLE ','CONSTANTIA     ','CONSTANTINE    ','CONTOOCOOK     ','CONVENT STATION','CONVERSE       ','CONVOY         ','CONWAY         ',
			'CONYERS        ','CONYNGHAM      ','COOK           ','COOKEVILLE     ','COOKSTOWN      ','COOKSVILLE     ','COOKVILLE      ','COOL           ','COOLIDGE       ','COOPERSBURG    ',
			'COOPERSTOWN    ','COOSADA        ','COPAKE FALLS   ','COPAN          ','COPE           ','COPELAND       ','COPENHAGEN     ','COPIAGUE       ','COPLAY         ','COPLEY         ',
			'COPPELL        ','COPPERAS COVE  ','COPPEROPOLIS   ','COQUILLE       ','CORA           ','CORAL GABLES   ','CORAL SPRINGS  ','CORALVILLE     ','CORAM          ','CORAOPOLIS     ',
			'CORAPEAKE      ','CORBETT        ','CORBIN         ','CORDELE        ','CORDELL        ','CORDOVA        ','CORE           ','CORFU          ','CORINTH        ','CORNELIA       ',
			'CORNELIUS      ','CORNELL        ','CORNERSVILLE   ','CORNETTSVILLE  ','CORNING        ','CORNVILLE      ','CORNWALL       ','CORNWALL BRIDGE','CORNWALL ON HUD','COROLLA        ',
			'CORONA         ','CORONA DEL MAR ','CORONADO       ','CORPUS CHRISTI ','CORRALES       ','CORRIGAN       ','CORRY          ','CORRYTON       ','CORSICA        ','CORSICANA      ',
			'CORTARO        ','CORTE MADERA   ','CORTEZ         ','CORTLAND       ','CORTLANDT MANOR','CORUNNA        ','CORVALLIS      ','CORYDON        ','COS COB        ','COSBY          ',
			'COSHOCTON      ','COST           ','COSTA MESA     ','COTATI         ','COTOPAXI       ','COTTAGE GROVE  ','COTTEKILL      ','COTTLEVILLE    ','COTTONDALE     ','COTTONPORT     ',
			'COTTONTOWN     ','COTTONWOOD     ','COTTRELLVILLE  ','COTUIT         ','COTULLA        ','COUDERAY       ','COUDERSPORT    ','COULTERVILLE   ','COUNCE         ','COUNCIL BLUFFS ',
			'COUNTRY CLUB HI','COUPEVILLE     ','COURTLAND      ','COVENTRY       ','COVINA         ','COVINGTON      ','COWARTS        ','COWETA         ','COWICHE        ','COWPENS        ',
			'COXS CREEK     ','COXSACKIE      ','COYOTE         ','CRAIG          ','CRAMERTON      ','CRANBERRY      ','CRANBERRY TWP  ','CRANBURY       ','CRANDALL       ','CRANDON        ',
			'CRANE          ','CRANE HILL     ','CRANESVILLE    ','CRANFORD       ','CRANSTON       ','CRARY          ','CRARYVILLE     ','CRAWFORD       ','CRAWFORDSVILLE ','CRAWFORDVILLE  ',
			'CRAWLEY        ','CREAL SPRINGS  ','CREAM RIDGE    ','CREAMERY       ','CREEDMOOR      ','CREEKSIDE      ','CREIGHTON      ','CRESBARD       ','CRESCENT       ','CRESCENT CITY  ',
			'CRESCO         ','CRESSKILL      ','CRESSON        ','CRESTED BUTTE  ','CRESTLINE      ','CRESTON        ','CRESTVIEW      ','CRESTWOOD      ','CRESWELL       ','CRETE          ',
			'CREWE          ','CRIMORA        ','CRITTENDEN     ','CROCKETT       ','CROFTON        ','CROGHAN        ','CROMPOND       ','CROMWELL       ','CROOKS         ','CROOKSTON      ',
			'CROPSEYVILLE   ','CROPWELL       ','CROSBY         ','CROSBYTON      ','CROSS HILL     ','CROSS JUNCTION ','CROSS PLAINS   ','CROSS RIVER    ','CROSSETT       ','CROSSVILLE     ',
			'CROSSWICKS     ','CROSWELL       ','CROTON FALLS   ','CROTON ON HUDSO','CROUSE         ','CROUSEVILLE    ','CROWLEY        ','CROWN POINT    ','CROWNSVILLE    ','CROYDON        ',
			'CROZET         ','CROZIER        ','CRYSTAL BAY    ','CRYSTAL BEACH  ','CRYSTAL CITY   ','CRYSTAL FALLS  ','CRYSTAL LAKE   ','CRYSTAL RIVER  ','CUBA           ','CUDAHY         ',
			'CUDDEBACKVILLE ','CUERO          ','CULLEOKA       ','CULLMAN        ','CULLODEN       ','CULLOWHEE      ','CULPEPER       ','CULVER         ','CULVER CITY    ','CUMBERLAND     ',
			'CUMBERLAND CENT','CUMBERLAND CITY','CUMBERLAND FORE','CUMBERLAND GAP ','CUMMAQUID      ','CUMMING        ','CUMMINGTON     ','CUNNINGHAM     ','CUPERTINO      ','CURLEW         ',
			'CURRITUCK      ','CURTICE        ','CURTIS         ','CURTIS BAY     ','CUSHING        ','CUSTAR         ','CUSTER         ','CUTCHOGUE      ','CUTLER         ','CUTTINGSVILLE  ',
			'CUYAHOGA FALLS ','CYNTHIANA      ','CYPRESS        ','DACONO         ','DACULA         ','DADE CITY      ','DADEVILLE      ','DAFTER         ','DAGSBORO       ','DAHINDA        ',
			'DAHLGREN       ','DAHLONEGA      ','DAINGERFIELD   ','DAKOTA         ','DAKOTA CITY    ','DALE CITY      ','DALEVILLE      ','DALHART        ','DALLAS         ','DALLASTOWN     ',
			'DALTON         ','DALTON CITY    ','DALY CITY      ','DALZELL        ','DAMARISCOTTA   ','DAMASCUS       ','DAMERON        ','DAMMERON VALLEY','DAMON          ','DANA           ',
			'DANA POINT     ','DANBORO        ','DANBURY        ','DANDRIDGE      ','DANIA          ','DANIELS        ','DANIELSON      ','DANIELSVILLE   ','DANNEMORA      ','DANSVILLE      ',
			'DANVERS        ','DANVILLE       ','DAPHNE         ','DARBY          ','DARDANELLE     ','DARIEN         ','DARIEN CENTER  ','DARLINGTON     ','DARRINGTON     ','DARWIN         ',
			'DASSEL         ','DAUPHIN        ','DAVENPORT      ','DAVIDSON       ','DAVIDSONVILLE  ','DAVIE          ','DAVIS          ','DAVIS JUNCTION ','DAVISBURG      ','DAVISON        ',
			'DAVISVILLE     ','DAWSON         ','DAWSONVILLE    ','DAYTON         ','DAYTONA BEACH  ','DAYVILLE       ','DE FOREST      ','DE GRAFF       ','DE PERE        ','DE QUEEN       ',
			'DE SOTO        ','DE TOUR VILLAGE','DE WITT        ','DEAL           ','DEALE          ','DEANE          ','DEARBORN       ','DEARBORN HEIGHT','DEATSVILLE     ','DEBARY         ',
			'DECATUR        ','DECHERD        ','DECLO          ','DECORAH        ','DEDEDO         ','DEDHAM         ','DEEP RIVER     ','DEEP RUN       ','DEEPWATER      ','DEER CREEK     ',
			'DEER ISLE      ','DEER PARK      ','DEER TRAIL     ','DEERBROOK      ','DEERFIELD      ','DEERFIELD BEACH','DEERING        ','DEERWOOD       ','DEFIANCE       ','DEFUNIAK SPRING',
			'DEKALB         ','DEL MAR        ','DEL NORTE      ','DEL RIO        ','DEL VALLE      ','DELAFIELD      ','DELAND         ','DELANO         ','DELANSON       ','DELAPLANE      ',
			'DELAVAN        ','DELAWARE       ','DELAWARE CITY  ','DELAWARE WATER ','DELCAMBRE      ','DELEVAN        ','DELHI          ','DELIA          ','DELL RAPIDS    ','DELLROY        ',
			'DELLSLOW       ','DELMAR         ','DELMONT        ','DELONG         ','DELPHI         ','DELPHOS        ','DELRAY BEACH   ','DELTA          ','DELTA JUNCTION ','DELTON         ',
			'DELTONA        ','DEMAREST       ','DEMING         ','DEMOPOLIS      ','DEMOREST       ','DEMOTTE        ','DENHAM SPRINGS ','DENISON        ','DENMARK        ','DENNIS         ',
			'DENNIS PORT    ','DENNISTOWN     ','DENTON         ','DENVER         ','DENVER CITY    ','DENVILLE       ','DEPEW          ','DEPOSIT        ','DEQUINCY       ','DERBY          ',
			'DERBY LINE     ','DERIDDER       ','DERRICK CITY   ','DERRY          ','DERWOOD        ','DES ALLEMANDS  ','DES ARC        ','DES LACS       ','DES MOINES     ','DES PLAINES    ',
			'DESCANSO       ','DESERT HOT SPRI','DESHLER        ','DESOTO         ','DESTIN         ','DESTREHAN      ','DETROIT        ','DETROIT LAKES  ','DEVAULT        ','DEVILLE        ',
			'DEVILS LAKE    ','DEVINE         ','DEVON          ','DEWAR          ','DEWEY          ','DEWITT         ','DEXTER         ','DIABLO         ','DIAMOND        ','DIAMOND BAR    ',
			'DIAMOND POINT  ','DIAMOND SPRINGS','DIAMONDHEAD    ','DIANA          ','DICKERSON      ','DICKEYVILLE    ','DICKINSON      ','DICKSON        ','DICKSON CITY   ','DIGHTON        ',
			'DIKE           ','DILLINGHAM     ','DILLON         ','DILLON BEACH   ','DILLSBORO      ','DILLSBURG      ','DILWORTH       ','DIMMITT        ','DIMONDALE      ','DINGMANS FERRY ',
			'DINUBA         ','DISPUTANTA     ','DISTRICT HEIGHT','DIVERNON       ','DIVIDE         ','DIX            ','DIXFIELD       ','DIXON          ','DIXON SPRINGS  ','DOBBS FERRY    ',
			'DODGE          ','DODGE CENTER   ','DODGE CITY     ','DODGEVILLE     ','DOLOMITE       ','DOLORES        ','DOLPHIN        ','DOLTON         ','DONALDSON      ','DONALSONVILLE  ',
			'DONEGAL        ','DONIPHAN       ','DONORA         ','DOON           ','DORA           ','DORCHESTER     ','DORCHESTER CENT','DOROTHY        ','DORR           ','DORSET         ',
			'DORSEY         ','DOS PALOS      ','DOTHAN         ','DOUGHERTY      ','DOUGLAS        ','DOUGLASS       ','DOUGLASSVILLE  ','DOUGLASVILLE   ','DOUSMAN        ','DOVER          ',
			'DOVER AFB      ','DOVER FOXCROFT ','DOVER PLAINS   ','DOWAGIAC       ','DOWELLTOWN     ','DOWNERS GROVE  ','DOWNEY         ','DOWNING        ','DOWNINGTOWN    ','DOWNS          ',
			'DOWNSVILLE     ','DOYLE          ','DOYLESTOWN     ','DRACUT         ','DRAKE          ','DRAPER         ','DRAYDEN        ','DRESDEN        ','DRESHER        ','DRESSER        ',
			'DREXEL         ','DRIFTWOOD      ','DRIPPING SPRING','DRUMORE        ','DRUMRIGHT      ','DRUMS          ','DRY FORK       ','DRY RIDGE      ','DRY RUN        ','DRYDEN         ',
			'DU BOIS        ','DU QUOIN       ','DUANESBURG     ','DUARTE         ','DUBACH         ','DUBLIN         ','DUBOIS         ','DUBUQUE        ','DUDLEY         ','DUFUR          ',
			'DUGGER         ','DUGSPUR        ','DUGWAY         ','DULUTH         ','DULZURA        ','DUMAS          ','DUMFRIES       ','DUMONT         ','DUNBAR         ','DUNBARTON      ',
			'DUNCAN         ','DUNCANNON      ','DUNCANS MILLS  ','DUNCANSVILLE   ','DUNCANVILLE    ','DUNDALK        ','DUNDEE         ','DUNEDIN        ','DUNKIRK        ','DUNLAP         ',
			'DUNMORE        ','DUNN           ','DUNN LORING    ','DUNNELLON      ','DUNNIGAN       ','DUNNVILLE      ','DUNSEITH       ','DUNSTABLE      ','DUPLESSIS      ','DUPO           ',
			'DUPONT         ','DUQUESNE       ','DURAND         ','DURANGO        ','DURANT         ','DURHAM         ','DURHAMVILLE    ','DURYEA         ','DUSON          ','DUTCH HARBOR   ',
			'DUTCHTOWN      ','DUTTON         ','DUVALL         ','DUXBURY        ','DYER           ','DYERSBURG      ','DYERSVILLE     ','DYESS AFB      ','DYSART         ','EADS           ',
			'EAGAR          ','EAGLE          ','EAGLE BRIDGE   ','EAGLE CREEK    ','EAGLE GROVE    ','EAGLE LAKE     ','EAGLE PASS     ','EAGLE POINT    ','EAGLE RIVER    ','EAGLEVILLE     ',
			'EARLEVILLE     ','EARLTON        ','EARLVILLE      ','EARLYSVILLE    ','EARTH CITY     ','EASLEY         ','EAST ALTON     ','EAST AMHERST   ','EAST AURORA    ','EAST BARRE     ',
			'EAST BEND      ','EAST BERLIN    ','EAST BERNARD   ','EAST BERNE     ','EAST BOOTHBAY  ','EAST BRIDGEWATE','EAST BROOKFIELD','EAST BRUNSWICK ','EAST BURKE     ','EAST BUTLER    ',
			'EAST CALAIS    ','EAST CARONDELET','EAST CHATHAM   ','EAST CLARIDON  ','EAST CORINTH   ','EAST DENNIS    ','EAST DORSET    ','EAST DUBUQUE   ','EAST ELMHURST  ','EAST FAIRFIELD ',
			'EAST FLAT ROCK ','EAST FREETOWN  ','EAST GRANBY    ','EAST GRAND FORK','EAST GREENBUSH ','EAST GREENVILLE','EAST GREENWICH ','EAST HADDAM    ','EAST HAMPSTEAD ','EAST HAMPTON   ',
			'EAST HANOVER   ','EAST HARTFORD  ','EAST HARTLAND  ','EAST HAVEN     ','EAST HELENA    ','EAST IRVINE    ','EAST ISLIP     ','EAST JORDAN    ','EAST KILLINGLY ','EAST KINGSTON  ',
			'EAST LANSING   ','EAST LEROY     ','EAST LIBERTY   ','EAST LIVERMORE ','EAST LIVERPOOL ','EAST LONGMEADOW','EAST LYME      ','EAST MACHIAS   ','EAST MEADOW    ','EAST MIDDLEBURY',
			'EAST MILLINOCKE','EAST MOLINE    ','EAST MONTPELIER','EAST MORICHES  ','EAST NASSAU    ','EAST NEW MARKET','EAST NORTHPORT ','EAST NORWICH   ','EAST ORANGE    ','EAST ORLEANS   ',
			'EAST OTIS      ','EAST PALATKA   ','EAST PALESTINE ','EAST PEMBROKE  ','EAST PEORIA    ','EAST PETERSBURG','EAST POLAND    ','EAST PRAIRIE   ','EAST PROSPECT  ','EAST PROVIDENCE',
			'EAST QUOGUE    ','EAST RANDOLPH  ','EAST ROCHESTER ','EAST ROCKAWAY  ','EAST RUTHERFORD','EAST SAINT LOUI','EAST SANDWICH  ','EAST SETAUKET  ','EAST SMITHFIELD','EAST STROUDSBUR',
			'EAST SYRACUSE  ','EAST TAUNTON   ','EAST TAWAS     ','EAST TEMPLETON ','EAST TEXAS     ','EAST THETFORD  ','EAST TROY      ','EAST WAKEFIELD ','EAST WALPOLE   ','EAST WAREHAM   ',
			'EAST WATERBORO ','EAST WENATCHEE ','EAST WILTON    ','EAST WINDSOR   ','EAST WINDSOR HI','EASTABOGA      ','EASTCHESTER    ','EASTFORD       ','EASTHAM        ','EASTHAMPTON    ',
			'EASTLAKE       ','EASTMAN        ','EASTON         ','EASTPOINTE     ','EASTPORT       ','EASTSIDE CPO CO','EASTSOUND      ','EATON          ','EATON PARK     ','EATON RAPIDS   ',
			'EATONTON       ','EATONTOWN      ','EATONVILLE     ','EAU CLAIRE     ','EBENSBURG      ','ECKERT         ','ECLECTIC       ','ECONOMY        ','EDDINGTON      ','EDDYVILLE      ',
			'EDEN           ','EDEN MILLS     ','EDEN PRAIRIE   ','EDENTON        ','EDGAR SPRINGS  ','EDGARTOWN      ','EDGECOMB       ','EDGEFIELD      ','EDGEMONT       ','EDGEMOOR       ',
			'EDGERTON       ','EDGEWATER      ','EDGEWOOD       ','EDINBORO       ','EDINBURG       ','EDINBURGH      ','EDISON         ','EDISTO ISLAND  ','EDMESTON       ','EDMOND         ',
			'EDMONDS        ','EDMORE         ','EDNA           ','EDON           ','EDWARDS        ','EDWARDSBURG    ','EDWARDSVILLE   ','EFFIE          ','EFFINGHAM      ','EFFORT         ',
			'EFLAND         ','EGG HARBOR CITY','EGG HARBOR TOWN','EGLIN AFB      ','EIELSON AFB    ','EIGHT MILE     ','EIGHTY FOUR    ','EITZEN         ','EKRON          ','EL CAJON       ',
			'EL CAMPO       ','EL CENTRO      ','EL CERRITO     ','EL DORADO      ','EL DORADO HILLS','EL GRANADA     ','EL JEBEL       ','EL MACERO      ','EL MIRAGE      ','EL MONTE       ',
			'EL PASO        ','EL PORTAL      ','EL PRADO       ','EL RENO        ','EL SEGUNDO     ','EL SOBRANTE    ','EL VERANO      ','ELAINE         ','ELAND          ','ELBA           ',
			'ELBERT         ','ELBERTA        ','ELBERTON       ','ELBOW LAKE     ','ELBRIDGE       ','ELBURN         ','ELCHO          ','ELDENA         ','ELDON          ','ELDORADO       ',
			'ELDORADO SPRING','ELDRIDGE       ','ELGIN          ','ELIASVILLE     ','ELIOT          ','ELIZABETH      ','ELIZABETH CITY ','ELIZABETHTON   ','ELIZABETHTOWN  ','ELIZABETHVILLE ',
			'ELIZAVILLE     ','ELK CITY       ','ELK GROVE      ','ELK GROVE VILLA','ELK MILLS      ','ELK MOUND      ','ELK POINT      ','ELK RAPIDS     ','ELK RIVER      ','ELKHART        ',
			'ELKHART LAKE   ','ELKHORN        ','ELKIN          ','ELKINS         ','ELKINS PARK    ','ELKLAND        ','ELKMONT        ','ELKO           ','ELKRIDGE       ','ELKTON         ',
			'ELKVIEW        ','ELKVILLE       ','ELLABELL       ','ELLENBORO      ','ELLENDALE      ','ELLENSBURG     ','ELLENTON       ','ELLENVILLE     ','ELLENWOOD      ','ELLETTSVILLE   ',
			'ELLICOTT CITY  ','ELLIJAY        ','ELLINGTON      ','ELLIOTT        ','ELLISTON       ','ELLISVILLE     ','ELLSWORTH      ','ELLSWORTH AFB  ','ELLWOOD CITY   ','ELM CITY       ',
			'ELM GROVE      ','ELM SPRINGS    ','ELMA           ','ELMENDORF      ','ELMENDORF AFB  ','ELMER          ','ELMHURST       ','ELMIRA         ','ELMONT         ','ELMORE         ',
			'ELMSFORD       ','ELMWOOD PARK   ','ELON COLLEGE   ','ELROD          ','ELROY          ','ELSA           ','ELSAH          ','ELSBERRY       ','ELTON          ','ELVERSON       ',
			'ELVERTA        ','ELWELL         ','ELWOOD         ','ELY            ','ELYRIA         ','ELYSIAN        ','EMERADO        ','EMERALD ISLE   ','EMERSON        ','EMERYVILLE     ',
			'EMINENCE       ','EMMAUS         ','EMMETSBURG     ','EMMETT         ','EMMITSBURG     ','EMORY          ','EMPIRE         ','EMPORIA        ','EMPORIUM       ','ENCINITAS      ',
			'ENCINO         ','ENDICOTT       ','ENERGY         ','ENFIELD        ','ENGLAND        ','ENGLEWOOD      ','ENGLEWOOD CLIFF','ENGLISH        ','ENGLISHTOWN    ','ENID           ',
			'ENIGMA         ','ENNIS          ','ENOLA          ','ENON           ','ENOSBURG FALLS ','ENTERPRISE     ','ENUMCLAW       ','EPHRAIM        ','EPHRATA        ','EPPING         ',
			'EPSOM          ','EPWORTH        ','EQUINUNK       ','ERIE           ','ERLANGER       ','ERWIN          ','ERWINNA        ','ESCALANTE      ','ESCALON        ','ESCANABA       ',
			'ESCONDIDO      ','ESKO           ','ESKRIDGE       ','ESMOND         ','ESPANOLA       ','ESPARTO        ','ESPERANCE      ','ESSEX          ','ESSEX FELLS    ','ESSEX JUNCTION ',
			'ESSEXVILLE     ','ESSINGTON      ','ESTACADA       ','ESTANCIA       ','ESTELL MANOR   ','ESTER          ','ESTERO         ','ESTES PARK     ','ESTILL         ','ESTILL SPRINGS ',
			'ETHEL          ','ETNA           ','ETNA GREEN     ','ETON           ','ETOWAH         ','ETTERS         ','ETTRICK        ','EUCLID         ','EUDORA         ','EUFAULA        ',
			'EUGENE         ','EULESS         ','EUNICE         ','EUREKA         ','EUREKA SPRINGS ','EUSTACE        ','EUSTIS         ','EUTAWVILLE     ','EVANS          ','EVANS CITY     ',
			'EVANS MILLS    ','EVANSDALE      ','EVANSTON       ','EVANSVILLE     ','EVART          ','EVERETT        ','EVERGREEN      ','EVERGREEN PARK ','EVERSON        ','EVINGTON       ',
			'EWA BEACH      ','EWAN           ','EXCELSIOR      ','EXCELSIOR SPRIN','EXETER         ','EXMORE         ','EXPERIMENT     ','EXPORT         ','EXTON          ','EYOTA          ',
			'FACKLER        ','FACTORYVILLE   ','FAIR GROVE     ','FAIR HAVEN     ','FAIR LAWN      ','FAIR OAKS      ','FAIRBANKS      ','FAIRBORN       ','FAIRBURN       ','FAIRBURY       ',
			'FAIRCHILD AIR F','FAIRDALE       ','FAIRFAX        ','FAIRFAX STATION','FAIRFIELD      ','FAIRHAVEN      ','FAIRHOPE       ','FAIRLESS HILLS ','FAIRMONT       ','FAIRMOUNT      ',
			'FAIRMOUNT CITY ','FAIRPLAY       ','FAIRPORT       ','FAIRVIEW       ','FAIRVIEW HEIGHT','FAIRWATER      ','FAISON         ','FALL CITY      ','FALL CREEK     ','FALL RIVER     ',
			'FALL RIVER MILL','FALLBROOK      ','FALLING WATERS ','FALLON         ','FALLS          ','FALLS CHURCH   ','FALLS CITY     ','FALLS OF ROUGH ','FALLS VILLAGE  ','FALLSTON       ',
			'FALMOUTH       ','FANCY GAP      ','FANNIN         ','FANSHAWE       ','FANWOOD        ','FAR HILLS      ','FAR ROCKAWAY   ','FARGO          ','FARIBAULT      ','FARINA         ',
			'FARLEY         ','FARMERSBURG    ','FARMERSVILLE   ','FARMERVILLE    ','FARMINGDALE    ','FARMINGTON     ','FARMINGTON HILL','FARMINGVILLE   ','FARMLAND       ','FARMVILLE      ',
			'FARRELL        ','FARWELL        ','FAULKNER       ','FAULKTON       ','FAWN GROVE     ','FAYETTE        ','FAYETTEVILLE   ','FAYVILLE       ','FE WARREN AFB  ','FEASTERVILLE TR',
			'FEDERAL WAY    ','FEEDING HILLS  ','FELDA          ','FELT           ','FELTON         ','FELTS MILLS    ','FENNVILLE      ','FENTON         ','FENWICK ISLAND ','FERDINAND      ',
			'FERGUS FALLS   ','FERNANDINA BEAC','FERNDALE       ','FERNLEY        ','FERNWOOD       ','FERRIS         ','FERRISBURG     ','FERRON         ','FERRUM         ','FERRYSBURG     ',
			'FERTILE        ','FESTUS         ','FEURA BUSH     ','FIDDLETOWN     ','FIFE LAKE      ','FIFIELD        ','FILLMORE       ','FINCASTLE      ','FINCHVILLE     ','FINDLAY        ',
			'FINKSBURG      ','FINLEYVILLE    ','FIREBAUGH      ','FIRESTONE      ','FIRTH          ','FISCHER        ','FISH CREEK     ','FISHER         ','FISHERS        ','FISHERS ISLAND ',
			'FISHERSVILLE   ','FISHERVILLE    ','FISHKILL       ','FISKDALE       ','FISKEVILLE     ','FITCHBURG      ','FITZGERALD     ','FITZWILLIAM    ','FLAGLER        ','FLAGLER BEACH  ',
			'FLAGSTAFF      ','FLAGTOWN       ','FLANDERS       ','FLANDREAU      ','FLAT ROCK      ','FLATGAP        ','FLATONIA       ','FLATWOODS      ','FLEETWOOD      ','FLEMING        ',
			'FLEMINGSBURG   ','FLEMINGTON     ','FLETCHER       ','FLINT          ','FLINT HILL     ','FLINTHILL      ','FLINTON        ','FLINTSTONE     ','FLIPPIN        ','FLOMATON       ',
			'FLORA          ','FLORAHOME      ','FLORAL CITY    ','FLORAL PARK    ','FLORENCE       ','FLORESVILLE    ','FLORHAM PARK   ','FLORIDA        ','FLORIDA CITY   ','FLORISSANT     ',
			'FLOSSMOOR      ','FLOURTOWN      ','FLOWER MOUND   ','FLOWERY BRANCH ','FLOYD          ','FLOYDADA       ','FLOYDS KNOBS   ','FLUSHING       ','FLY CREEK      ','FOGELSVILLE    ',
			'FOLCROFT       ','FOLEY          ','FOLSOM         ','FOND DU LAC    ','FONTANA        ','FOOTHILL RANCH ','FOOTVILLE      ','FORD           ','FORDLAND       ','FORDS          ',
			'FORDYCE        ','FOREST         ','FOREST CITY    ','FOREST FALLS   ','FOREST GROVE   ','FOREST HILL    ','FOREST HILLS   ','FOREST KNOLLS  ','FOREST LAKE    ','FOREST PARK    ',
			'FOREST RANCH   ','FORESTBURGH    ','FORESTDALE     ','FORESTHILL     ','FORESTVILLE    ','FORISTELL      ','FORK UNION     ','FORKED RIVER   ','FORNEY         ','FORREST CITY   ',
			'FORRESTON      ','FORSYTH        ','FORT ANN       ','FORT ATKINSON  ','FORT BELVOIR   ','FORT BENNING   ','FORT BRAGG     ','FORT BRANCH    ','FORT BUCHANAN  ','FORT CALHOUN   ',
			'FORT CAMPBELL  ','FORT COLLINS   ','FORT DEFIANCE  ','FORT DODGE     ','FORT EDWARD    ','FORT EUSTIS    ','FORT GEORGE G M','FORT HARRISON  ','FORT HUACHUCA  ','FORT IRWIN     ',
			'FORT JONES     ','FORT KNOX      ','FORT LARAMIE   ','FORT LAUDERDALE','FORT LEAVENWORT','FORT LEE       ','FORT LEONARD WO','FORT LORAMIE   ','FORT LOUDON    ','FORT LUPTON    ',
			'FORT MEADE     ','FORT MILL      ','FORT MITCHELL  ','FORT MOHAVE    ','FORT MONMOUTH  ','FORT MONROE    ','FORT MONTGOMERY','FORT MORGAN    ','FORT MYERS     ','FORT MYERS BEAC',
			'FORT NECESSITY ','FORT OGLETHORPE','FORT PAYNE     ','FORT PIERCE    ','FORT PIERRE    ','FORT PLAIN     ','FORT RICHARDSON','FORT RILEY     ','FORT RIPLEY    ','FORT RUCKER    ',
			'FORT SCOTT     ','FORT SHERIDAN  ','FORT SILL      ','FORT SMITH     ','FORT STEWART   ','FORT STOCKTON  ','FORT SUMNER    ','FORT THOMAS    ','FORT TOTTEN    ','FORT VALLEY    ',
			'FORT WAINWRIGHT','FORT WALTON BEA','FORT WASHINGTON','FORT WAYNE     ','FORT WHITE     ','FORT WORTH     ','FORTSON        ','FORTUNA        ','FORTVILLE      ','FOSS           ',
			'FOSTER         ','FOSTER CITY    ','FOSTORIA       ','FOUNTAIN       ','FOUNTAIN CITY  ','FOUNTAIN GREEN ','FOUNTAIN HILLS ','FOUNTAIN INN   ','FOUNTAIN VALLEY','FOUNTAINTOWN   ',
			'FOUNTAINVILLE  ','FOUR OAKS      ','FOWLER         ','FOWLERVILLE    ','FOX ISLAND     ','FOX LAKE       ','FOX RIVER GROVE','FOXBORO        ','FOXWORTH       ','FRAMINGHAM     ',
			'FRANCESTOWN    ','FRANCESVILLE   ','FRANCISCO      ','FRANCONIA      ','FRANKENMUTH    ','FRANKFORD      ','FRANKFORT      ','FRANKLIN       ','FRANKLIN FURNAC','FRANKLIN LAKES ',
			'FRANKLIN PARK  ','FRANKLIN SQUARE','FRANKLINTON    ','FRANKLINVILLE  ','FRANKSTON      ','FRANKSVILLE    ','FRANKTOWN      ','FRASER         ','FRAZEE         ','FRAZEYSBURG    ',
			'FRAZIER PARK   ','FRAZIERS BOTTOM','FREDERIC       ','FREDERICA      ','FREDERICK      ','FREDERICKSBRG  ','FREDERICKSBURG ','FREDERICKTOWN  ','FREDONIA       ','FREE UNION     ',
			'FREEBURG       ','FREEBURN       ','FREEDOM        ','FREEHOLD       ','FREELAND       ','FREEMAN        ','FREEPORT       ','FREER          ','FREEVILLE      ','FREMONT        ',
			'FRENCH CAMP    ','FRENCH LICK    ','FRENCH VILLAGE ','FRENCHGLEN     ','FRENCHTOWN     ','FRENCHVILLE    ','FRESH MEADOWS  ','FRESNO         ','FRIANT         ','FRIDAY HARBOR  ',
			'FRIEND         ','FRIENDSHIP     ','FRIENDSVILLE   ','FRIENDSWOOD    ','FRISCO         ','FROHNA         ','FRONT ROYAL    ','FRONTENAC      ','FROST          ','FROSTBURG      ',
			'FRUITA         ','FRUITLAND      ','FRUITLAND PARK ','FT MYER        ','FULLERTON      ','FULSHEAR       ','FULTON         ','FULTONDALE     ','FULTONVILLE    ','FULTS          ',
			'FUQUAY VARINA  ','FURLONG        ','FURMAN         ','GADSDEN        ','GAFFNEY        ','GAINES         ','GAINESVILLE    ','GAITHERSBURG   ','GALAX          ','GALENA         ',
			'GALES FERRY    ','GALESBURG      ','GALESVILLE     ','GALETON        ','GALION         ','GALLATIN       ','GALLIANO       ','GALLINA        ','GALLIPOLIS     ','GALLITZIN      ',
			'GALLOWAY       ','GALLUP         ','GALT           ','GALVA          ','GALVESTON      ','GALWAY         ','GAMBRILLS      ','GANADO         ','GANDEEVILLE    ','GANSEVOORT     ',
			'GARARDS FORT   ','GARDEN CITY    ','GARDEN GROVE   ','GARDEN PLAIN   ','GARDEN PRAIRIE ','GARDEN VALLEY  ','GARDENA        ','GARDENDALE     ','GARDINER       ','GARDNER        ',
			'GARDNERVILLE   ','GARFIELD       ','GARLAND        ','GARNER         ','GARNERVILLE    ','GARNETT        ','GARRETT        ','GARRETT PARK   ','GARRETTSVILLE  ','GARRISON       ',
			'GARRISONVILLE  ','GARVIN         ','GARWOOD        ','GARY           ','GARYSBURG      ','GASPORT        ','GASSAWAY       ','GASTON         ','GASTONIA       ','GATES          ',
			'GATES MILLS    ','GATESVILLE     ','GATLINBURG     ','GAUTIER        ','GAY            ','GAYLORD        ','GAYLORDSVILLE  ','GAYS           ','GEISMAR        ','GENESEE        ',
			'GENESEE DEPOT  ','GENESEO        ','GENEVA         ','GENOA          ','GENOA CITY     ','GEORGE WEST    ','GEORGES MILLS  ','GEORGETOWN     ','GERING         ','GERMAN VALLEY  ',
			'GERMANSVILLE   ','GERMANTON      ','GERMANTOWN     ','GERRARDSTOWN   ','GETTYSBURG     ','GETZVILLE      ','GEYSERVILLE    ','GHENT          ','GIBBON         ','GIBBSBORO      ',
			'GIBBSTOWN      ','GIBSON         ','GIBSON ISLAND  ','GIBSONBURG     ','GIBSONIA       ','GIBSONTON      ','GIBSONVILLE    ','GIDDINGS       ','GIFFORD        ','GIG HARBOR     ',
			'GILBERT        ','GILBERTS       ','GILBERTSVILLE  ','GILBOA         ','GILCREST       ','GILFORD        ','GILL           ','GILLETTE       ','GILLSVILLE     ','GILMAN         ',
			'GILMANTON      ','GILMANTON IRON ','GILMER         ','GILROY         ','GILSON         ','GIRARD         ','GIRDWOOD       ','GLADE PARK     ','GLADE SPRING   ','GLADE VALLEY   ',
			'GLADEWATER     ','GLADSTONE      ','GLADWIN        ','GLADWYNE       ','GLADY          ','GLASFORD       ','GLASGOW        ','GLASSBORO      ','GLASSTON       ','GLASTONBURY    ',
			'GLEN           ','GLEN ALLEN     ','GLEN ARM       ','GLEN AUBREY    ','GLEN BURNIE    ','GLEN CARBON    ','GLEN COVE      ','GLEN ECHO      ','GLEN ELLEN     ','GLEN ELLYN     ',
			'GLEN GARDNER   ','GLEN HEAD      ','GLEN MILLS     ','GLEN OAKS      ','GLEN RIDDLE LIM','GLEN RIDGE     ','GLEN ROCK      ','GLEN ROSE      ','GLEN SPEY      ','GLENARM        ',
			'GLENBURN       ','GLENCOE        ','GLENDALE       ','GLENDALE HEIGHT','GLENDIVE       ','GLENDORA       ','GLENELG        ','GLENFIELD      ','GLENFORD       ','GLENHAM        ',
			'GLENMONT       ','GLENMOORE      ','GLENN          ','GLENN DALE     ','GLENNVILLE     ','GLENOLDEN      ','GLENPOOL       ','GLENS FALLS    ','GLENSHAW       ','GLENSIDE       ',
			'GLENVIEW       ','GLENVILLE      ','GLENWOOD       ','GLENWOOD CITY  ','GLENWOOD LANDIN','GLENWOOD SPRING','GLOBE          ','GLOSTER        ','GLOUCESTER     ','GLOUCESTER CITY',
			'GLOUCESTER POIN','GLOUSTER       ','GLOVER         ','GLOVERSVILLE   ','GLYNDON        ','GOBLES         ','GODDARD        ','GODFREY        ','GODLEY         ','GOESSEL        ',
			'GOFFSTOWN      ','GOLD BAR       ','GOLD HILL      ','GOLD RUN       ','GOLDEN         ','GOLDEN VALLEY  ','GOLDENS BRG    ','GOLDSBORO      ','GOLDVEIN       ','GOLETA         ',
			'GOLF           ','GOLIAD         ','GOLTRY         ','GONZALES       ','GOOCHLAND      ','GOOD HOPE      ','GOODE          ','GOODFELLOW AFB ','GOODFIELD      ','GOODHUE        ',
			'GOODLAND       ','GOODLETTSVILLE ','GOODRICH       ','GOODVIEW       ','GOODYEAR       ','GOOSE CREEK    ','GORDO          ','GORDONSVILLE   ','GOREE          ','GOREVILLE      ',
			'GORHAM         ','GORMANIA       ','GOSHEN         ','GOSPORT        ','GOTHA          ','GOULD          ','GOWEN          ','GOWER          ','GRABILL        ','GRACE          ',
			'GRACE CITY     ','GRACEVILLE     ','GRAFTON        ','GRAHAM         ','GRAIN VALLEY   ','GRAINFIELD     ','GRAMBLING      ','GRAMERCY       ','GRANADA HILLS  ','GRANBURY       ',
			'GRANBY         ','GRAND BAY      ','GRAND BLANC    ','GRAND CANYON   ','GRAND CHENIER  ','GRAND FORKS    ','GRAND FORKS AFB','GRAND HAVEN    ','GRAND ISLAND   ','GRAND ISLE     ',
			'GRAND JUNCTION ','GRAND LAKE     ','GRAND LEDGE    ','GRAND MARAIS   ','GRAND PRAIRIE  ','GRAND RAPIDS   ','GRAND RIVER    ','GRAND RONDE    ','GRAND SALINE   ','GRAND TERRACE  ',
			'GRAND VALLEY   ','GRANDIN        ','GRANDVIEW      ','GRANDVILLE     ','GRANDY         ','GRANGER        ','GRANGEVILLE    ','GRANITE BAY    ','GRANITE CITY   ','GRANITE FALLS  ',
			'GRANITE SPRINGS','GRANITEVILLE   ','GRANT          ','GRANT PARK     ','GRANT TOWNSHIP ','GRANTHAM       ','GRANTS         ','GRANTS PASS    ','GRANTSBURG     ','GRANTSVILLE    ',
			'GRANTVILLE     ','GRANVILLE      ','GRAPELAND      ','GRAPEVIEW      ','GRAPEVINE      ','GRASONVILLE    ','GRASS LAKE     ','GRASS VALLEY   ','GRATIS         ','GRATON         ',
			'GRATZ          ','GRAVETTE       ','GRAVOIS MILLS  ','GRAWN          ','GRAY           ','GRAY COURT     ','GRAYLING       ','GRAYSLAKE      ','GRAYSON        ','GRAYSVILLE     ',
			'GREAT BARRINGTO','GREAT BEND     ','GREAT FALLS    ','GREAT LAKES    ','GREAT MEADOWS  ','GREAT MILLS    ','GREAT NECK     ','GREAT RIVER    ','GREAT VALLEY   ','GREELEY        ',
			'GREELEYVILLE   ','GREEN BAY      ','GREEN BROOK    ','GREEN COVE SPRI','GREEN CREEK    ','GREEN FOREST   ','GREEN HARBOR   ','GREEN ISLE     ','GREEN LAKE     ','GREEN LANE     ',
			'GREEN MOUNTAIN ','GREEN POND     ','GREEN RIDGE    ','GREEN RIVER    ','GREEN VALLEY   ','GREEN VALLEY LA','GREEN VILLAGE  ','GREENACRES     ','GREENBACKVILLE ','GREENBANK      ',
			'GREENBELT      ','GREENBRIER     ','GREENBUSH      ','GREENCASTLE    ','GREENDALE      ','GREENE         ','GREENEVILLE    ','GREENFIELD     ','GREENFIELD CENT','GREENFIELD PARK',
			'GREENLAND      ','GREENLAWN      ','GREENLEAF      ','GREENPORT      ','GREENS FARMS   ','GREENS FORK    ','GREENSBORO     ','GREENSBORO BEND','GREENSBURG     ','GREENTOWN      ',
			'GREENUP        ','GREENVALE      ','GREENVILLE     ','GREENVILLE JUNC','GREENWELL SPRIN','GREENWICH      ','GREENWOOD      ','GREENWOOD LAKE ','GREER          ','GREGORY        ',
			'GRELTON        ','GRENADA        ','GRESHAM        ','GRETNA         ','GRIDLEY        ','GRIFFIN        ','GRIFFITH       ','GRIFTON        ','GRIMES         ','GRIMESLAND     ',
			'GRIMSLEY       ','GRINNELL       ','GROOM          ','GROSSE ILE     ','GROSSE POINTE  ','GROSSE POINTE P','GROSSE TETE    ','GROTON         ','GROTTOES       ','GROVE          ',
			'GROVE CITY     ','GROVE HILL     ','GROVELAND      ','GROVEPORT      ','GROVER         ','GROVER BEACH   ','GROVES         ','GROVETON       ','GROVETOWN      ','GUADALUPE      ',
			'GUALALA        ','GUASTI         ','GUAYNABO       ','GUERNEVILLE    ','GUEYDAN        ','GUILDERLAND    ','GUILDERLAND CEN','GUILFORD       ','GUIN           ','GULF BREEZE    ',
			'GULF SHORES    ','GULFPORT       ','GULNARE        ','GUM SPRING     ','GUNNISON       ','GUNPOWDER      ','GUNTER         ','GUNTERSVILLE   ','GUNTOWN        ','GURLEY         ',
			'GURNEE         ','GUSTINE        ','GUSTON         ','GUTHRIE        ','GUTHRIE CENTER ','GUY            ','GUYMON         ','GUYS MILLS     ','GUYTON         ','GWINN          ',
			'GWYNEDD        ','GWYNEDD VALLEY ','GWYNN OAK      ','GYPSUM         ','HACIENDA HEIGHT','HACKBERRY      ','HACKENSACK     ','HACKETTSTOWN   ','HADDAM         ','HADDON HEIGHTS ',
			'HADDONFIELD    ','HADLEY         ','HADLYME        ','HAGATNA        ','HAGER CITY     ','HAGERHILL      ','HAGERSTOWN     ','HAGUE          ','HAHIRA         ','HAIKU          ',
			'HAILEY         ','HAINES CITY    ','HAINESPORT     ','HALEDON        ','HALEIWA        ','HALES CORNERS  ','HALETHORPE     ','HALF MOON BAY  ','HALIFAX        ','HALLANDALE     ',
			'HALLETTSVILLE  ','HALLOWELL      ','HALLS          ','HALLSVILLE     ','HALSTEAD       ','HALTOM CITY    ','HAMBLETON      ','HAMBURG        ','HAMDEN         ','HAMEL          ',
			'HAMER          ','HAMILTON       ','HAMLIN         ','HAMMOND        ','HAMMONTON      ','HAMPDEN        ','HAMPSHIRE      ','HAMPSTEAD      ','HAMPTON        ','HAMPTON BAYS   ',
			'HAMPTON FALLS  ','HAMSHIRE       ','HANAHAN        ','HANALEI        ','HANAMAULU      ','HANAPEPE       ','HANCEVILLE     ','HANCOCK        ','HANFORD        ','HANKINS        ',
			'HANNA          ','HANNACROIX     ','HANNIBAL       ','HANOVER        ','HANSCOM AFB    ','HANSEN         ','HANSON         ','HANSVILLE      ','HARBESON       ','HARBINGER      ',
			'HARBOR CITY    ','HARBOR SPRINGS ','HARBORCREEK    ','HARDIN         ','HARDINSBURG    ','HARDWICK       ','HARDY          ','HARKER HEIGHTS ','HARLAN         ','HARLEYSVILLE   ',
			'HARLEYVILLE    ','HARLINGEN      ','HARMONY        ','HARPER         ','HARPER WOODS   ','HARPERS FERRY  ','HARPERSVILLE   ','HARPSWELL      ','HARPURSVILLE   ','HARRAH         ',
			'HARRIMAN       ','HARRINGTON     ','HARRINGTON PARK','HARRIS         ','HARRISBURG     ','HARRISON       ','HARRISON CITY  ','HARRISON VALLEY','HARRISONBURG   ','HARRISONVILLE  ',
			'HARRISVILLE    ','HARRODS CREEK  ','HARRODSBURG    ','HARROGATE      ','HARSENS ISLAND ','HART           ','HARTFORD       ','HARTFORD CITY  ','HARTLAND       ','HARTLY         ',
			'HARTSBURG      ','HARTSDALE      ','HARTSELLE      ','HARTSVILLE     ','HARTVILLE      ','HARTWELL       ','HARVARD        ','HARVEST        ','HARVEY         ','HARWICH        ',
			'HARWICH PORT   ','HARWINTON      ','HARWOOD        ','HASBROUCK HEIGH','HASKELL        ','HASKINS        ','HASLET         ','HASLETT        ','HASTINGS       ','HASTINGS ON HUD',
			'HASTY          ','HATBORO        ','HATFIELD       ','HATHAWAY PINES ','HATHORNE       ','HATLEY         ','HATTIESBURG    ','HAUBSTADT      ','HAUGHTON       ','HAUPPAUGE      ',
			'HAUULA         ','HAVANA         ','HAVELOCK       ','HAVERFORD      ','HAVERHILL      ','HAVERSTRAW     ','HAVERTOWN      ','HAVRE          ','HAVRE DE GRACE ','HAW RIVER      ',
			'HAWAIIAN GARDEN','HAWARDEN       ','HAWESVILLE     ','HAWI           ','HAWKINS        ','HAWKINSVILLE   ','HAWLEY         ','HAWLEYVILLE    ','HAWORTH        ','HAWTHORNE      ',
			'HAYDEN         ','HAYDENVILLE    ','HAYES          ','HAYESVILLE     ','HAYFIELD       ','HAYMARKET      ','HAYNEVILLE     ','HAYS           ','HAYSVILLE      ','HAYTI          ',
			'HAYWARD        ','HAZARD         ','HAZEL          ','HAZEL CREST    ','HAZEL GREEN    ','HAZEL PARK     ','HAZELHURST     ','HAZELWOOD      ','HAZLEHURST     ','HAZLET         ',
			'HAZLETON       ','HEADLAND       ','HEAFFORD JUNCTI','HEALDSBURG     ','HEALY          ','HEARNE         ','HEATH          ','HEBER          ','HEBER CITY     ','HEBRON         ',
			'HECTOR         ','HEDGESVILLE    ','HEFLIN         ','HEIDELBERG     ','HEIDRICK       ','HEIMDAL        ','HELEN          ','HELENA         ','HELENDALE      ','HELENVILLE     ',
			'HELIX          ','HELLAM         ','HELLERTOWN     ','HELMETTA       ','HELOTES        ','HELPER         ','HELTONVILLE    ','HEMET          ','HEMLOCK        ','HEMPSTEAD      ',
			'HENAGAR        ','HENDERSON      ','HENDERSONVILLE ','HENNESSEY      ','HENNIKER       ','HENNING        ','HENRICO        ','HENRIETTA      ','HENRY          ','HENRYVILLE     ',
			'HENSLEY        ','HEPHZIBAH      ','HERALD         ','HERCULANEUM    ','HERCULES       ','HEREFORD       ','HERKIMER       ','HERMAN         ','HERMANN        ','HERMANTOWN     ',
			'HERMISTON      ','HERMITAGE      ','HERMON         ','HERMOSA        ','HERMOSA BEACH  ','HERNANDEZ      ','HERNANDO       ','HERNDON        ','HERRICK CENTER ','HERRIN         ',
			'HERRON         ','HERSCHER       ','HERSHEY        ','HERTFORD       ','HESPERIA       ','HESSTON        ','HETTINGER      ','HEUVELTON      ','HEWITT         ','HEWLETT        ',
			'HEYBURN        ','HEYWORTH       ','HIALEAH        ','HIAWASSEE      ','HIAWATHA       ','HIBBING        ','HIBERNIA       ','HICKAM AFB     ','HICKMAN        ','HICKORY        ',
			'HICKORY CORNERS','HICKORY HILLS  ','HICKSVILLE     ','HIGGANUM       ','HIGGINSVILLE   ','HIGH BRIDGE    ','HIGH FALLS     ','HIGH POINT     ','HIGH RIDGE     ','HIGH SPRINGS   ',
			'HIGHGATE CENTER','HIGHLAND       ','HIGHLAND FALLS ','HIGHLAND HEIGHT','HIGHLAND HOME  ','HIGHLAND LAKES ','HIGHLAND MILLS ','HIGHLAND PARK  ','HIGHLANDS      ','HIGHLANDVILLE  ',
			'HIGHMOUNT      ','HIGHTSTOWN     ','HIGHWOOD       ','HIGLEY         ','HILBERT        ','HILL AFB       ','HILL CITY      ','HILLBURN       ','HILLIARD       ','HILLIARDS      ',
			'HILLMAN        ','HILLROSE       ','HILLSBORO      ','HILLSBOROUGH   ','HILLSDALE      ','HILLSIDE       ','HILLSVILLE     ','HILLTOWN       ','HILMAR         ','HILO           ',
			'HILTON         ','HILTON HEAD ISL','HINCKLEY       ','HINDSVILLE     ','HINES          ','HINESBURG      ','HINESVILLE     ','HINGHAM        ','HINSDALE       ','HINTON         ',
			'HIRAM          ','HITCHCOCK      ','HIWASSEE       ','HIXSON         ','HIXTON         ','HO HO KUS      ','HOBART         ','HOBBS          ','HOBE SOUND     ','HOBOKEN        ',
			'HOBSON         ','HOBUCKEN       ','HOCKESSIN      ','HOCKLEY        ','HODGENVILLE    ','HODGES         ','HOFFMAN        ','HOFFMAN ESTATES','HOGANSVILLE    ','HOHENWALD      ',
			'HOLBROOK       ','HOLCOMB        ','HOLCOMBE       ','HOLDEN         ','HOLDENVILLE    ','HOLDERNESS     ','HOLDREGE       ','HOLGATE        ','HOLICONG       ','HOLIDAY        ',
			'HOLLAND        ','HOLLAND PATENT ','HOLLEY         ','HOLLIDAYSBURG  ','HOLLIS         ','HOLLIS CENTER  ','HOLLISTER      ','HOLLISTON      ','HOLLOMAN AIR FO','HOLLY          ',
			'HOLLY RIDGE    ','HOLLY SPRINGS  ','HOLLYWOOD      ','HOLMDEL        ','HOLMEN         ','HOLMES         ','HOLMES BEACH   ','HOLMES CITY    ','HOLMESVILLE    ','HOLT           ',
			'HOLTON         ','HOLTS SUMMIT   ','HOLTSVILLE     ','HOLTVILLE      ','HOLTWOOD       ','HOLUALOA       ','HOLYOKE        ','HOMELAND       ','HOMER          ','HOMERVILLE     ',
			'HOMESTEAD      ','HOMETOWN       ','HOMEWOOD       ','HOMINY         ','HOMOSASSA      ','HONAUNAU       ','HONDO          ','HONEA PATH     ','HONEOYE        ','HONEOYE FALLS  ',
			'HONESDALE      ','HONEY BROOK    ','HONEY CREEK    ','HONEY GROVE    ','HONEYVILLE     ','HONOLULU       ','HONOMU         ','HONOR          ','HOOD RIVER     ','HOODSPORT      ',
			'HOOKERTON      ','HOOKS          ','HOOKSETT       ','HOOKSTOWN      ','HOOLEHUA       ','HOOPER         ','HOOPESTON      ','HOOSICK FALLS  ','HOPATCONG      ','HOPE           ',
			'HOPE HULL      ','HOPE MILLS     ','HOPE VALLEY    ','HOPEDALE       ','HOPEWELL       ','HOPEWELL JUNCTI','HOPKINS        ','HOPKINSVILLE   ','HOPKINTON      ','HOPLAND        ',
			'HOPWOOD        ','HOQUIAM        ','HORACE         ','HORICON        ','HORN LAKE      ','HORNELL        ','HORSE CAVE     ','HORSE SHOE     ','HORSEHEADS     ','HORSESHOE BEND ',
			'HORSHAM        ','HORTON         ','HORTONVILLE    ','HOSCHTON       ','HOT SPRINGS    ','HOT SPRINGS NAT','HOT SPRINGS VIL','HOUGHTON       ','HOUGHTON LAKE  ','HOULKA         ',
			'HOULTON        ','HOUMA          ','HOUSATONIC     ','HOUSE SPRINGS  ','HOUSTON        ','HOUSTONIA      ','HOWARD         ','HOWARD BEACH   ','HOWARD CITY    ','HOWARD LAKE    ',
			'HOWELL         ','HOWES          ','HOWEY IN THE HI','HUBBARD        ','HUBBARDSTON    ','HUBERT         ','HUBERTUS       ','HUDDLESTON     ','HUDSON         ','HUDSON FALLS   ',
			'HUDSONVILLE    ','HUFFMAN        ','HUGER          ','HUGHES         ','HUGHESVILLE    ','HUGHSON        ','HUGHSONVILLE   ','HUGO           ','HULBERT        ','HULL           ',
			'HULLS COVE     ','HUMAROCK       ','HUMBLE         ','HUMBOLDT       ','HUME           ','HUMESTON       ','HUMMELSTOWN    ','HUNKER         ','HUNT VALLEY    ','HUNTER         ',
			'HUNTERSVILLE   ','HUNTERTOWN     ','HUNTINGBURG    ','HUNTINGDON     ','HUNTINGDON VALL','HUNTINGTON     ','HUNTINGTON BEAC','HUNTINGTON MILL','HUNTINGTON PARK','HUNTINGTON STAT',
			'HUNTINGTON WOOD','HUNTINGTOWN    ','HUNTLEY        ','HUNTLY         ','HUNTSVILLE     ','HURDLE MILLS   ','HURLBURT FIELD ','HURLEY         ','HURLEYVILLE    ','HURLOCK        ',
			'HURON          ','HURRICANE      ','HURST          ','HUSTISFORD     ','HUTCHINSON     ','HUTTO          ','HUTTONSVILLE   ','HYANNIS        ','HYANNIS PORT   ','HYATTSVILLE    ',
			'HYDE PARK      ','HYDES          ','HYDEVILLE      ','HYRUM          ','IDA            ','IDABEL         ','IDAHO CITY     ','IDAHO FALLS    ','IDAHO SPRINGS  ','IDALOU         ',
			'IDAVILLE       ','IDER           ','IDYLLWILD      ','IGNACIO        ','IJAMSVILLE     ','ILION          ','ILLIOPOLIS     ','ILWACO         ','IMLAY CITY     ','IMLAYSTOWN     ',
			'IMLER          ','IMMOKALEE      ','IMPERIAL       ','IMPERIAL BEACH ','INARAJAN       ','INCLINE VILLAGE','INDEPENDENCE   ','INDIAHOMA      ','INDIALANTIC    ','INDIAN HEAD    ',
			'INDIAN HILLS   ','INDIAN ORCHARD ','INDIAN RIVER   ','INDIAN ROCKS BE','INDIAN SPRINGS ','INDIAN TRAIL   ','INDIAN VALLEY  ','INDIAN WELLS   ','INDIANA        ','INDIANAPOLIS   ',
			'INDIANOLA      ','INDIO          ','INDUSTRY       ','INEZ           ','INGALLS        ','INGLEFIELD     ','INGLESIDE      ','INGLEWOOD      ','INGRAM         ','INKSTER        ',
			'INMAN          ','INOLA          ','INTERLACHEN    ','INTERLOCHEN    ','INTERNATIONAL F','INTERVALE      ','INVER GROVE HEI','INVERNESS      ','INWOOD         ','INYOKERN       ',
			'IOLA           ','IONE           ','IONIA          ','IOWA           ','IOWA CITY      ','IOWA FALLS     ','IOWA PARK      ','IPSWICH        ','IRA            ','IRASBURG       ',
			'IRMA           ','IRMO           ','IRON MOUNTAIN  ','IRON RIDGE     ','IRONDALE       ','IRONIA         ','IRONS          ','IRONTON        ','IRONWOOD       ','IRVINE         ',
			'IRVING         ','IRVINGTON      ','IRVONA         ','IRWIN          ','ISANTI         ','ISELIN         ','ISHPEMING      ','ISLAMORADA     ','ISLAND HEIGHTS ','ISLAND LAKE    ',
			'ISLAND PARK    ','ISLAND POND    ','ISLANDIA       ','ISLE LA MOTTE  ','ISLE OF PALMS  ','ISLETON        ','ISLIP          ','ISLIP TERRACE  ','ISOLA          ','ISSAQUAH       ',
			'ISSUE          ','ITASCA         ','ITHACA         ','IUKA           ','IVINS          ','IVOR           ','IVORYTON       ','IVY            ','JACKSBORO      ','JACKSON        ',
			'JACKSON CENTER ','JACKSON HEIGHTS','JACKSONVILLE   ','JACKSONVILLE BE','JACOB          ','JACOBSON       ','JAFFREY        ','JAMAICA        ','JAMAICA PLAIN  ','JAMESON        ',
			'JAMESPORT      ','JAMESTOWN      ','JAMESVILLE     ','JAMISON        ','JAMUL          ','JANE LEW       ','JANESVILLE     ','JARREAU        ','JARRETTSVILLE  ','JASONVILLE     ',
			'JASPER         ','JAY            ','JEAN           ','JEANERETTE     ','JEANNETTE      ','JEFFERSON      ','JEFFERSON CITY ','JEFFERSON VALLE','JEFFERSONTON   ','JEFFERSONVILLE ',
			'JEKYLL ISLAND  ','JEMEZ SPRINGS  ','JEMISON        ','JENERA         ','JENISON        ','JENKINS        ','JENKINTOWN     ','JENKS          ','JENNER         ','JENSEN         ',
			'JENSEN BEACH   ','JERICHO        ','JEROME         ','JERSEY CITY    ','JERSEY SHORE   ','JERSEYVILLE    ','JESSUP         ','JESUP          ','JETMORE        ','JEWETT         ',
			'JEWETT CITY    ','JIM FALLS      ','JIM THORPE     ','JOBSTOWN       ','JOELTON        ','JOHANNESBURG   ','JOHNS ISLAND   ','JOHNSON        ','JOHNSON CITY   ','JOHNSON CREEK  ',
			'JOHNSONVILLE   ','JOHNSTON       ','JOHNSTON CITY  ','JOHNSTOWN      ','JOINER         ','JOLIET         ','JOLON          ','JONES          ','JONESBORO      ','JONESBOROUGH   ',
			'JONESPORT      ','JONESTOWN      ','JONESVILLE     ','JOPLIN         ','JOPPA          ','JORDAN         ','JORDANVILLE    ','JOSHUA         ','JOSHUA TREE    ','JOURDANTON     ',
			'JUDSON         ','JULIAN         ','JULIETTE       ','JUNCTION       ','JUNCTION CITY  ','JUNE LAKE      ','JUNEAU         ','JUNEDALE       ','JUNIATA        ','JUNTURA        ',
			'JUPITER        ','JUSTICE        ','JUSTIN         ','KAAAWA         ','KAHUKU         ','KAHULUI        ','KAILUA         ','KAILUA KONA    ','KALAHEO        ','KALAMAZOO      ',
			'KALISPELL      ','KALKASKA       ','KAMAS          ','KAMIAH         ','KAMUELA        ','KANE           ','KANEOHE        ','KANKAKEE       ','KANNAPOLIS     ','KANOPOLIS      ',
			'KANSAS         ','KANSAS CITY    ','KANSASVILLE    ','KAPAA          ','KAPAAU         ','KAPOLEI        ','KARBERS RIDGE  ','KARNES CITY    ','KASILOF        ','KASOTA         ',
			'KASSON         ','KATHLEEN       ','KATONAH        ','KATY           ','KAUFMAN        ','KAUKAUNA       ','KAUNAKAKAI     ','KAYENTA        ','KAYSVILLE      ','KEAAU          ',
			'KEALAKEKUA     ','KEANSBURG      ','KEARNEY        ','KEARNY         ','KEASBEY        ','KEAUHOU        ','KECHI          ','KEEDYSVILLE    ','KEEGO HARBOR   ','KEELING        ',
			'KEENE          ','KEENE VALLEY   ','KEENESBURG     ','KEESEVILLE     ','KEITHVILLE     ','KEKAHA         ','KELL           ','KELLER         ','KELLOGG        ','KELLY          ',
			'KELSEYVILLE    ','KELSO          ','KEMAH          ','KEMBLESVILLE   ','KEMMERER       ','KEMP           ','KEMPNER        ','KEMPTON        ','KENAI          ','KENANSVILLE    ',
			'KENBRIDGE      ','KENDALL PARK   ','KENDALLVILLE   ','KENDRICK       ','KENEDY         ','KENILWORTH     ','KENMORE        ','KENNA          ','KENNARD        ','KENNEBUNK      ',
			'KENNEBUNKPORT  ','KENNEDALE      ','KENNER         ','KENNESAW       ','KENNETT        ','KENNETT SQUARE ','KENNEWICK      ','KENOCKEE       ','KENOSHA        ','KENSINGTON     ',
			'KENT           ','KENT CITY      ','KENTFIELD      ','KENTON         ','KENTS STORE    ','KENTWOOD       ','KENVIL         ','KENWOOD        ','KENYON         ','KEO            ',
			'KEOKUK         ','KERENS         ','KERHONKSON     ','KERMAN         ','KERNERSVILLE   ','KERRVILLE      ','KERSEY         ','KESHENA        ','KESWICK        ','KETCHIKAN      ',
			'KETCHUM        ','KETTLE FALLS   ','KEUKA PARK     ','KEVIL          ','KEW GARDENS    ','KEWADIN        ','KEWANEE        ','KEWANNA        ','KEWASKUM       ','KEWAUNEE       ',
			'KEY BISCAYNE   ','KEY COLONY BEAC','KEY LARGO      ','KEY WEST       ','KEYMAR         ','KEYPORT        ','KEYSTONE       ','KEYSTONE HEIGHT','KEYSVILLE      ','KIAMESHA LAKE  ',
			'KIEL           ','KIELER         ','KIHEI          ','KILAUEA        ','KILGORE        ','KILL DEVIL HILL','KILLBUCK       ','KILLEEN        ','KILLEN         ','KILLINGTON     ',
			'KILLINGWORTH   ','KILN           ','KIMBALL        ','KIMBERLING CITY','KIMBERLY       ','KIMBERTON      ','KIMMELL        ','KIMPER         ','KINCAID        ','KINCHELOE      ',
			'KINDERHOOK     ','KING           ','KING AND QUEEN ','KING CITY      ','KING COVE      ','KING GEORGE    ','KING OF PRUSSIA','KING SALMON    ','KING WILLIAM   ','KINGFISHER     ',
			'KINGMAN        ','KINGS BAY      ','KINGS CANYON NA','KINGS MILLS    ','KINGS MOUNTAIN ','KINGS PARK     ','KINGSBURG      ','KINGSBURY      ','KINGSFORD      ','KINGSLAND      ',
			'KINGSLEY       ','KINGSPORT      ','KINGSTON       ','KINGSTON SPRING','KINGSVILLE     ','KINROSS        ','KINSMAN        ','KINSTON        ','KINTNERSVILLE  ','KIOWA          ',
			'KIRBYVILLE     ','KIRKLAND       ','KIRKSEY        ','KIRKSVILLE     ','KIRKVILLE      ','KIRKWOOD       ','KIRTLAND AFB   ','KISSIMMEE      ','KITTERY        ','KITTREDGE      ',
			'KITTRELL       ','KITTS HILL     ','KITTY HAWK     ','KLAMATH FALLS  ','KLAWOCK        ','KNAPP          ','KNIGHTDALE     ','KNIGHTSEN      ','KNIGHTSTOWN    ','KNIPPA         ',
			'KNOB NOSTER    ','KNOTTS ISLAND  ','KNOX           ','KNOXVILLE      ','KODIAK         ','KOHLER         ','KOKOMO         ','KOLOA          ','KORBEL         ','KOSCIUSKO      ',
			'KOUNTZE        ','KOUTS          ','KRAKOW         ','KRANZBURG      ','KREBS          ','KREMMLING      ','KRUGERVILLE    ','KRUM           ','KULA           ','KULPMONT       ',
			'KULPSVILLE     ','KUNA           ','KUNKLETOWN     ','KURE BEACH     ','KURTISTOWN     ','KUTZTOWN       ','KYLE           ','KYLERTOWN      ','LA BELLE       ','LA CANADA FLINT',
			'LA CENTER      ','LA CONNER      ','LA CRESCENT    ','LA CRESCENTA   ','LA CROSSE      ','LA CYGNE       ','LA FAYETTE     ','LA FOLLETTE    ','LA FONTAINE    ','LA GRANDE      ',
			'LA GRANGE      ','LA GRANGE PARK ','LA HABRA       ','LA HONDA       ','LA JOLLA       ','LA JOSE        ','LA JUNTA       ','LA MARQUE      ','LA MESA        ','LA MIRADA      ',
			'LA MONTE       ','LA MOTTE       ','LA PALMA       ','LA PINE        ','LA PLACE       ','LA PLATA       ','LA PORTE       ','LA PUENTE      ','LA QUINTA      ','LA SALLE       ',
			'LA VERGNE      ','LA VERKIN      ','LA VERNE       ','LA VERNIA      ','LA VETA        ','LA VISTA       ','LABADIE        ','LABELLE        ','LACEY          ','LACEYVILLE     ',
			'LACOMBE        ','LACONIA        ','LADERA RANCH   ','LADOGA         ','LADSON         ','LADY LAKE      ','LADYSMITH      ','LAFAYETTE      ','LAFAYETTE HILL ','LAFOX          ',
			'LAGRANGE       ','LAGRANGEVILLE  ','LAGUNA BEACH   ','LAGUNA HILLS   ','LAGUNA NIGUEL  ','LAGUNITAS      ','LAHAINA        ','LAHASKA        ','LAHMANSVILLE   ','LAIE           ',
			'LAINGSBURG     ','LAIRD HILL     ','LAKE           ','LAKE ALFRED    ','LAKE ANN       ','LAKE ARIEL     ','LAKE ARROWHEAD ','LAKE BENTON    ','LAKE BLUFF     ','LAKE BUTLER    ',
			'LAKE CHARLES   ','LAKE CITY      ','LAKE CRYSTAL   ','LAKE DALLAS    ','LAKE ELMO      ','LAKE ELMORE    ','LAKE ELSINORE  ','LAKE FOREST    ','LAKE GENEVA    ','LAKE GEORGE    ',
			'LAKE GROVE     ','LAKE HAMILTON  ','LAKE HARMONY   ','LAKE HAVASU CIT','LAKE HELEN     ','LAKE HIAWATHA  ','LAKE HOPATCONG ','LAKE HUGHES    ','LAKE IN THE HIL','LAKE ISABELLA  ',
			'LAKE JACKSON   ','LAKE LURE      ','LAKE LUZERNE   ','LAKE MARY      ','LAKE MILLS     ','LAKE MILTON    ','LAKE ODESSA    ','LAKE ORION     ','LAKE OSWEGO    ','LAKE OZARK     ',
			'LAKE PANASOFFKE','LAKE PARK      ','LAKE PEEKSKILL ','LAKE PLACID    ','LAKE SAINT LOUI','LAKE SHERWOOD  ','LAKE STATION   ','LAKE STEVENS   ','LAKE TOMAHAWK  ','LAKE VIEW      ',
			'LAKE VILLA     ','LAKE VILLAGE   ','LAKE WALES     ','LAKE WORTH     ','LAKE ZURICH    ','LAKEBAY        ','LAKEHURST      ','LAKELAND       ','LAKEPORT       ','LAKESIDE       ',
			'LAKESIDE MARBLE','LAKEVIEW       ','LAKEVILLE      ','LAKEWOOD       ','LAMAR          ','LAMBERTVILLE   ','LAMESA         ','LAMOILLE       ','LAMONI         ','LAMONT         ',
			'LAMOURE        ','LAMPASAS       ','LAMPE          ','LAMPETER       ','LAMY           ','LANARK         ','LANCASTER      ','LAND O LAKES   ','LANDENBERG     ','LANDER         ',
			'LANDING        ','LANDISBURG     ','LANDISVILLE    ','LANDRUM        ','LANESBORO      ','LANEXA         ','LANGHORNE      ','LANGLEY        ','LANHAM         ','LANNON         ',
			'LANOKA HARBOR  ','LANSDALE       ','LANSDOWNE      ','LANSE          ','LANSFORD       ','LANSING        ','LAPAZ          ','LAPEER         ','LAPORTE        ','LAQUEY         ',
			'LARAMIE        ','LARCHMONT      ','LAREDO         ','LARES          ','LARGO          ','LARIMORE       ','LARKSPUR       ','LAROSE         ','LARSEN         ','LARUE          ',
			'LARWILL        ','LAS CRUCES     ','LAS VEGAS      ','LASARA         ','LATEXO         ','LATHAM         ','LATHROP        ','LATROBE        ','LATTA          ','LAUDERDALE     ',
			'LAUDERDALE LAKE','LAUDERHILL     ','LAUGHLIN       ','LAUGHLIN A F B ','LAUREL         ','LAUREL FORK    ','LAUREL HILL    ','LAURELVILLE    ','LAURENS        ','LAURINBURG     ',
			'LAURYS STATION ','LAVACA         ','LAVALETTE      ','LAVALLETTE     ','LAVEEN         ','LAVON          ','LAVONIA        ','LAWAI          ','LAWNDALE       ','LAWNSIDE       ',
			'LAWRENCE       ','LAWRENCEBURG   ','LAWRENCEVILLE  ','LAWSON         ','LAWTEY         ','LAWTON         ','LAYTON         ','LE CLAIRE      ','LE MARS        ','LE ROY         ',
			'LEADVILLE      ','LEAF RIVER     ','LEAGUE CITY    ','LEANDER        ','LEAVENWORTH    ','LEBANON        ','LEBO           ','LECANTO        ','LECOMPTE       ','LECOMPTON      ',
			'LEDBETTER      ','LEDERACH       ','LEDGER         ','LEDGEWOOD      ','LEDYARD        ','LEE            ','LEE CENTER     ','LEEDS          ','LEEDS POINT    ','LEES SUMMIT    ',
			'LEESBURG       ','LEESPORT       ','LEESVILLE      ','LEETON         ','LEETONIA       ','LEHI           ','LEHIGH ACRES   ','LEHIGH VALLEY  ','LEHIGHTON      ','LEICESTER      ',
			'LEIGHTON       ','LEIPSIC        ','LELAND         ','LEMON GROVE    ','LEMONT         ','LEMOORE        ','LEMOYNE        ','LENA           ','LENHARTSVILLE  ','LENNI          ',
			'LENNOX         ','LENOIR         ','LENOIR CITY    ','LENOX          ','LENOX DALE     ','LENZBURG       ','LEO            ','LEOLA          ','LEOMINSTER     ','LEON           ',
			'LEONARD        ','LEONARDO       ','LEONARDTOWN    ','LEONIA         ','LEPANTO        ','LEROY          ','LESLIE         ','LEVAN          ','LEVANT         ','LEVELLAND      ',
			'LEVELOCK       ','LEVERETT       ','LEVITTOWN      ','LEWES          ','LEWIS          ','LEWIS CENTER   ','LEWISBERRY     ','LEWISBURG      ','LEWISTON       ','LEWISTOWN      ',
			'LEWISVILLE     ','LEXINGTON      ','LEXINGTON PARK ','LIBBY          ','LIBERAL        ','LIBERTY        ','LIBERTY CENTER ','LIBERTY CORNER ','LIBERTY HILL   ','LIBERTY LAKE   ',
			'LIBERTYTOWN    ','LIBERTYVILLE   ','LIBUSE         ','LICKING        ','LIGHTFOOT      ','LIGHTHOUSE POIN','LIGNUM         ','LIGONIER       ','LIHUE          ','LILBURN        ',
			'LILLINGTON     ','LILLY          ','LIMA           ','LIMERICK       ','LIMESTONE      ','LIMINGTON      ','LINCOLN        ','LINCOLN PARK   ','LINCOLN UNIVERS','LINCOLNDALE    ',
			'LINCOLNSHIRE   ','LINCOLNTON     ','LINCOLNVILLE   ','LINCOLNWOOD    ','LINCROFT       ','LINDALE        ','LINDEN         ','LINDENHURST    ','LINDENWOLD     ','LINDLEY        ',
			'LINDON         ','LINDRITH       ','LINDSAY        ','LINDSBORG      ','LINDSEY        ','LINDSTROM      ','LINE LEXINGTON ','LINEVILLE      ','LINN           ','LINN CREEK     ',
			'LINTHICUM HEIGH','LINTON         ','LINVILLE       ','LINWOOD        ','LIPAN          ','LISBON         ','LISBON FALLS   ','LISLE          ','LITCHFIELD     ','LITCHFIELD PARK',
			'LITHIA         ','LITHIA SPRINGS ','LITHONIA       ','LITHOPOLIS     ','LITITZ         ','LITTLE CHUTE   ','LITTLE COMPTON ','LITTLE CREEK   ','LITTLE ELM     ','LITTLE FALLS   ',
			'LITTLE FERRY   ','LITTLE HOCKING ','LITTLE MOUNTAIN','LITTLE NECK    ','LITTLE RIVER   ','LITTLE ROCK    ','LITTLE SILVER  ','LITTLE VALLEY  ','LITTLE YORK    ','LITTLEFIELD    ',
			'LITTLEROCK     ','LITTLESTOWN    ','LITTLETON      ','LIVE OAK       ','LIVERMORE      ','LIVERMORE FALLS','LIVERPOOL      ','LIVINGSTON     ','LIVINGSTON MANO','LIVONIA        ',
			'LIZELLA        ','LOAMI          ','LOCH SHELDRAKE ','LOCK HAVEN     ','LOCKE          ','LOCKEFORD      ','LOCKHART       ','LOCKPORT       ','LOCKRIDGE      ','LOCKWOOD       ',
			'LOCUST         ','LOCUST GAP     ','LOCUST GROVE   ','LOCUST HILL    ','LOCUST VALLEY  ','LODI           ','LOGAN          ','LOGANDALE      ','LOGANSPORT     ','LOGANTON       ',
			'LOGANVILLE     ','LOMA LINDA     ','LOMA MAR       ','LOMBARD        ','LOMIRA         ','LOMITA         ','LOMPOC         ','LONDON         ','LONDONDERRY    ','LONE JACK      ',
			'LONE OAK       ','LONE PINE      ','LONE TREE      ','LONEDELL       ','LONG BEACH     ','LONG BRANCH    ','LONG GREEN     ','LONG GROVE     ','LONG ISLAND    ','LONG ISLAND CIT',
			'LONG LAKE      ','LONG LANE      ','LONG POINT     ','LONG POND      ','LONG PRAIRIE   ','LONG VALLEY    ','LONGBOAT KEY   ','LONGMEADOW     ','LONGMONT       ','LONGPORT       ',
			'LONGTON        ','LONGVIEW       ','LONGVILLE      ','LONGWOOD       ','LONOKE         ','LONSDALE       ','LOOGOOTEE      ','LOOKOUT MOUNTAI','LOOMIS         ','LOON LAKE      ',
			'LOOP           ','LOOSE CREEK    ','LORAIN         ','LORENA         ','LORENZO        ','LORETTO        ','LORMAN         ','LORTON         ','LOS ALAMITOS   ','LOS ALAMOS     ',
			'LOS ALTOS      ','LOS ANGELES    ','LOS BANOS      ','LOS FRESNOS    ','LOS GATOS      ','LOS LUNAS      ','LOS OLIVOS     ','LOS OSOS       ','LOST NATION    ','LOSTANT        ',
			'LOTHIAN        ','LOTTSBURG      ','LOTUS          ','LOUDON         ','LOUDONVILLE    ','LOUISA         ','LOUISBURG      ','LOUISVILLE     ','LOVEJOY        ','LOVELAND       ',
			'LOVELL         ','LOVES PARK     ','LOVETTSVILLE   ','LOVINGSTON     ','LOVINGTON      ','LOWELL         ','LOWER BRULE    ','LOWER PEACH TRE','LOWMAN         ','LOWRY          ',
			'LOWRY CITY     ','LOXAHATCHEE    ','LOXLEY         ','LOYAL          ','LOYSBURG       ','LUANA          ','LUBBOCK        ','LUCASVILLE     ','LUCEDALE       ','LUCERNE VALLEY ',
			'LUCERNEMINES   ','LUCILE         ','LUDINGTON      ','LUDLOW         ','LUDOWICI       ','LUFKIN         ','LUGOFF         ','LUKE AFB       ','LULING         ','LUMBERTON      ',
			'LUMBERVILLE    ','LUNA PIER      ','LUNENBURG      ','LUPTON         ','LURAY          ','LUSBY          ','LUSK           ','LUTCHER        ','LUTHER         ','LUTHERVILLE TIM',
			'LUTTRELL       ','LUTZ           ','LUVERNE        ','LUXEMBURG      ','LUZERNE        ','LYLES          ','LYMAN          ','LYME           ','LYNBROOK       ','LYNCH          ',
			'LYNCHBURG      ','LYNDEBOROUGH   ','LYNDELL        ','LYNDEN         ','LYNDHURST      ','LYNDON         ','LYNDON STATION ','LYNDONVILLE    ','LYNN           ','LYNN HAVEN     ',
			'LYNNFIELD      ','LYNNWOOD       ','LYNWOOD        ','LYON           ','LYONS          ','LYTLE          ','M C B H KANEOHE','MABANK         ','MABELVALE      ','MABLETON       ',
			'MABTON         ','MACCLENNY      ','MACEDON        ','MACEDONIA      ','MACHESNEY PARK ','MACHIAS        ','MACHIASPORT    ','MACKEYVILLE    ','MACKINAC ISLAND','MACKINAW       ',
			'MACKINAW CITY  ','MACKSBURG      ','MACOMB         ','MACON          ','MACUNGIE       ','MADERA         ','MADILL         ','MADISON        ','MADISON HEIGHTS','MADISON LAKE   ',
			'MADISONVILLE   ','MADRAS         ','MADRID         ','MAGALIA        ','MAGEE          ','MAGNA          ','MAGNOLIA       ','MAGNOLIA SPRING','MAHOMET        ','MAHOPAC        ',
			'MAHOPAC FALLS  ','MAHWAH         ','MAIDEN         ','MAIDENS        ','MAINEVILLE     ','MAINLAND       ','MAITLAND       ','MAIZE          ','MAKANDA        ','MAKAWAO        ',
			'MALABAR        ','MALAD CITY     ','MALAGA         ','MALAKOFF       ','MALCOLM        ','MALDEN         ','MALIBU         ','MALINTA        ','MALMSTROM A F B','MALONE         ',
			'MALTA          ','MALVERN        ','MALVERNE       ','MAMARONECK     ','MAMMOTH LAKES  ','MAMOU          ','MAN            ','MANAHAWKIN     ','MANAKIN SABOT  ','MANASQUAN      ',
			'MANASSAS       ','MANAWA         ','MANCELONA      ','MANCHACA       ','MANCHESTER     ','MANCHESTER CENT','MANDAN         ','MANDAREE       ','MANDEVILLE     ','MANHASSET      ',
			'MANHATTAN      ','MANHATTAN BEACH','MANHEIM        ','MANILA         ','MANILLA        ','MANISTEE       ','MANISTIQUE     ','MANITO         ','MANITOU BEACH  ','MANITOU SPRINGS',
			'MANITOWOC      ','MANKATO        ','MANLIUS        ','MANNFORD       ','MANNING        ','MANNS CHOICE   ','MANOMET        ','MANOR          ','MANORVILLE     ','MANSFIELD      ',
			'MANSFIELD CENTE','MANSON         ','MANTACHIE      ','MANTECA        ','MANTENO        ','MANTOLOKING    ','MANTON         ','MANTORVILLE    ','MANTUA         ','MANVEL         ',
			'MANVILLE       ','MANY           ','MAPLE          ','MAPLE CITY     ','MAPLE HEIGHTS  ','MAPLE HILL     ','MAPLE LAKE     ','MAPLE PARK     ','MAPLE PLAIN    ','MAPLE SHADE    ',
			'MAPLE VALLEY   ','MAPLETON       ','MAPLEVILLE     ','MAPLEWOOD      ','MAR LIN        ','MARAMEC        ','MARANA         ','MARATHON       ','MARBLE FALLS   ','MARBLE HILL    ',
			'MARBLEHEAD     ','MARBURY        ','MARCELLUS      ','MARCH AIR FORCE','MARCO ISLAND   ','MARCOLA        ','MARCUS HOOK    ','MARCY          ','MARENGO        ','MARGARETVILLE  ',
			'MARGATE        ','MARGATE CITY   ','MARIANNA       ','MARIBEL        ','MARICOPA       ','MARIETTA       ','MARILLA        ','MARINA         ','MARINA DEL REY ','MARINE         ',
			'MARINE ON SAINT','MARINETTE      ','MARION         ','MARION CENTER  ','MARIPOSA       ','MARISSA        ','MARKLE         ','MARKLEEVILLE   ','MARKLEVILLE    ','MARKSVILLE     ',
			'MARLAND        ','MARLBORO       ','MARLBOROUGH    ','MARLOW         ','MARLTON        ','MARMORA        ','MARNE          ','MARQUETTE      ','MARRERO        ','MARRIOTTSVILLE ',
			'MARS           ','MARS HILL      ','MARSEILLES     ','MARSHALL       ','MARSHALLTOWN   ','MARSHFIELD     ','MARSHVILLE     ','MARSTONS MILLS ','MARTELL        ','MARTENSDALE    ',
			'MARTHASVILLE   ','MARTIN         ','MARTIN CITY    ','MARTINDALE     ','MARTINEZ       ','MARTINSBURG    ','MARTINSVILLE   ','MARTINTON      ','MARVELL        ','MARY ESTHER    ',
			'MARYDEL        ','MARYLAND       ','MARYLAND HEIGHT','MARYLAND LINE  ','MARYLHURST     ','MARYSVILLE     ','MARYVILLE      ','MASCOTTE       ','MASCOUTAH      ','MASHPEE        ',
			'MASON          ','MASON CITY     ','MASONTOWN      ','MASONVILLE     ','MASPETH        ','MASSAPEQUA     ','MASSAPEQUA PARK','MASSENA        ','MASSEY         ','MASSILLON      ',
			'MASTIC         ','MASTIC BEACH   ','MATAMORAS      ','MATAWAN        ','MATHER         ','MATHESON       ','MATHEWS        ','MATLACHA       ','MATLOCK        ','MATTAPAN       ',
			'MATTAPOISETT   ','MATTAWA        ','MATTAWAMKEAG   ','MATTAWAN       ','MATTESON       ','MATTHEWS       ','MATTITUCK      ','MATTOON        ','MAUCKPORT      ','MAUGANSVILLE   ',
			'MAULDIN        ','MAUMEE         ','MAUMELLE       ','MAUNALOA       ','MAUPIN         ','MAURICE        ','MAUSTON        ','MAXWELL        ','MAYAGUEZ       ','MAYBROOK       ',
			'MAYER          ','MAYFIELD       ','MAYFLOWER      ','MAYLENE        ','MAYNARD        ','MAYNARDVILLE   ','MAYO           ','MAYPEARL       ','MAYS LANDING   ','MAYSVILLE      ',
			'MAYVILLE       ','MAYWOOD        ','MAZEPPA        ','MAZOMANIE      ','MAZON          ','MC AFEE        ','MC ALISTERVILLE','MC ALPIN       ','MC CALL        ','MC CALL CREEK  ',
			'MC CALLA       ','MC CAMEY       ','MC CARR        ','MC CLELLAND    ','MC CLELLANVILLE','MC COLL        ','MC CONNELLSBURG','MC CORDSVILLE  ','MC CORMICK     ','MC CRORY       ',
			'MC DERMOTT     ','MC DONALD      ','MC FARLAND     ','MC GAHEYSVILLE ','MC GEHEE       ','MC GRADY       ','MC GRAW        ','MC GREGOR      ','MC HENRY       ','MC INTYRE      ',
			'MC KEES ROCKS  ','MC KEESPORT    ','MC KENZIE      ','MC KINNEY      ','MC LEAN        ','MC LEANSBORO   ','MC LEANSVILLE  ','MC LOUTH       ','MC MINNVILLE   ','MC RAE         ',
			'MC SHERRYSTOWN ','MC VEYTOWN     ','MCALESTER      ','MCALLEN        ','MCARTHUR       ','MCCHORD AFB    ','MCCLOUD        ','MCCOMB         ','MCDANIEL       ','MCDONOUGH      ',
			'MCHENRY        ','MCKENNA        ','MCKINLEYVILLE  ','MCLOUD         ','MCMINNVILLE    ','MCPHERSON      ','MEAD           ','MEADOR         ','MEADOW VISTA   ','MEADVILLE      ',
			'MEANSVILLE     ','MEBANE         ','MECCA          ','MECHANIC FALLS ','MECHANICSBURG  ','MECHANICSVILLE ','MECHANICVILLE  ','MECOSTA        ','MEDARYVILLE    ','MEDFIELD       ',
			'MEDFORD        ','MEDIA          ','MEDICAL LAKE   ','MEDINA         ','MEDINAH        ','MEDORA         ','MEDWAY         ','MEEKER         ','MELBOURNE      ','MELBOURNE BEACH',
			'MELFA          ','MELISSA        ','MELROSE        ','MELROSE PARK   ','MELVIN         ','MELVINDALE     ','MEMPHIS        ','MENA           ','MENARD         ','MENASHA        ',
			'MENDENHALL     ','MENDHAM        ','MENDOCINO      ','MENDON         ','MENDOTA        ','MENIFEE        ','MENLO PARK     ','MENOKEN        ','MENOMINEE      ','MENOMONEE FALLS',
			'MENOMONIE      ','MENTONE        ','MENTOR         ','MEQUON         ','MERAUX         ','MERCED         ','MERCER         ','MERCER ISLAND  ','MERCERSBURG    ','MEREDITH       ',
			'MERIDALE       ','MERIDEN        ','MERIDIAN       ','MERIDIANVILLE  ','MERION STATION ','MERIZO         ','MERKEL         ','MERLIN         ','MEROM          ','MERRICK        ',
			'MERRIFIELD     ','MERRILL        ','MERRILLVILLE   ','MERRIMAC       ','MERRIMACK      ','MERRITT        ','MERRITT ISLAND ','MERRY HILL     ','MERTON         ','MERTZTOWN      ',
			'MESA           ','MESICK         ','MESQUITE       ','META           ','METAIRIE       ','METAMORA       ','METHUEN        ','METROPOLIS     ','METTER         ','METUCHEN       ',
			'MEXIA          ','MEXICO         ','MEYERSDALE     ','MI WUK VILLAGE ','MIAMI          ','MIAMI BEACH    ','MIAMI SHORES   ','MIAMISBURG     ','MICA           ','MICHIANA SHORES',
			'MICHIE         ','MICHIGAN CENTER','MICKLETON      ','MICO           ','MIDDLE GROVE   ','MIDDLE HADDAM  ','MIDDLE ISLAND  ','MIDDLE POINT   ','MIDDLE RIVER   ','MIDDLE VILLAGE ',
			'MIDDLEBORO     ','MIDDLEBOURNE   ','MIDDLEBRANCH   ','MIDDLEBURG     ','MIDDLEBURGH    ','MIDDLEBURY     ','MIDDLEFIELD    ','MIDDLEPORT     ','MIDDLESBORO    ','MIDDLESEX      ',
			'MIDDLETON      ','MIDDLETOWN     ','MIDDLETOWN SPRI','MIDDLEVILLE    ','MIDLAND        ','MIDLAND CITY   ','MIDLAND PARK   ','MIDLOTHIAN     ','MIDVALE        ','MIDWAY         ',
			'MIDWAY CITY    ','MIDWAY PARK    ','MIDWEST CITY   ','MIFFLIN        ','MIFFLINBURG    ','MIFFLINTOWN    ','MILACA         ','MILAN          ','MILBANK        ','MILBRIDGE      ',
			'MILES CITY     ','MILFORD        ','MILILANI       ','MILL CREEK     ','MILL HALL      ','MILL NECK      ','MILL VALLEY    ','MILLBRAE       ','MILLBROOK      ','MILLBURN       ',
			'MILLBURY       ','MILLEDGEVILLE  ','MILLEN         ','MILLER         ','MILLER CITY    ','MILLER PLACE   ','MILLERSBURG    ','MILLERSVILLE   ','MILLERTON      ','MILLIGAN COLLEG',
			'MILLIKEN       ','MILLINGTON     ','MILLINOCKET    ','MILLIS         ','MILLS          ','MILLSBORO      ','MILLSTADT      ','MILLTOWN       ','MILLVILLE      ','MILLWOOD       ',
			'MILMAY         ','MILNER         ','MILO           ','MILPITAS       ','MILTON         ','MILTON FREEWATE','MILTONA        ','MILWAUKEE      ','MIMS           ','MINDEN         ',
			'MINDORO        ','MINE HILL      ','MINEOLA        ','MINERAL        ','MINERAL POINT  ','MINERAL RIDGE  ','MINERAL SPRINGS','MINERAL WELLS  ','MINERSVILLE    ','MINERVA        ',
			'MINETTO        ','MINFORD        ','MINIER         ','MINNEAPOLIS    ','MINNEOLA       ','MINNETONKA     ','MINNETONKA BEAC','MINOA          ','MINOCQUA       ','MINONG         ',
			'MINOOKA        ','MINOT          ','MINOT AFB      ','MINOTOLA       ','MINSTER        ','MINTURN        ','MIRA LOMA      ','MIRROR LAKE    ','MISHAWAKA      ','MISHICOT       ',
			'MISSION        ','MISSION HILLS  ','MISSION VIEJO  ','MISSISSIPPI STA','MISSOULA       ','MISSOURI CITY  ','MISSOURI VALLEY','MITCHELL       ','MIZPAH         ','MOAB           ',
			'MOBERLY        ','MOBILE         ','MOCKSVILLE     ','MODALE         ','MODENA         ','MODESTO        ','MODOC          ','MOFFAT         ','MOFFETT FIELD  ','MOGADORE       ',
			'MOHAVE VALLEY  ','MOHAWK         ','MOHEGAN LAKE   ','MOHNTON        ','MOHRSVILLE     ','MOJAVE         ','MOKELUMNE HILL ','MOKENA         ','MOLALLA        ','MOLENA         ',
			'MOLINE         ','MOLINO         ','MONA           ','MONACA         ','MONAHANS       ','MONAVILLE      ','MONCKS CORNER  ','MONCLOVA       ','MONCURE        ','MONDOVI        ',
			'MONEE          ','MONETA         ','MONETT         ','MONGMONG       ','MONKTON        ','MONMOUTH       ','MONMOUTH BEACH ','MONMOUTH JUNCTI','MONONGAHELA    ','MONPONSETT     ',
			'MONROE         ','MONROE CITY    ','MONROE TWP     ','MONROEVILLE    ','MONROVIA       ','MONSEY         ','MONSON         ','MONT CLARE     ','MONT VERNON    ','MONTAGUE       ',
			'MONTALBA       ','MONTARA        ','MONTAUK        ','MONTCHANIN     ','MONTCLAIR      ','MONTE VISTA    ','MONTEAGLE      ','MONTEBELLO     ','MONTEREY       ','MONTEREY PARK  ',
			'MONTESANO      ','MONTEVALLO     ','MONTEZUMA      ','MONTGOMERY     ','MONTGOMERY VILL','MONTGOMERYVILLE','MONTICELLO     ','MONTOURSVILLE  ','MONTPELIER     ','MONTREAL       ',
			'MONTROSE       ','MONTROSS       ','MONTVALE       ','MONTVERDE      ','MONTVILLE      ','MONUMENT       ','MOODUS         ','MOODY          ','MOOERS         ','MOOERS FORKS   ',
			'MOONACHIE      ','MOORCROFT      ','MOORE          ','MOOREFIELD     ','MOORES HILL    ','MOORESBORO     ','MOORESTOWN     ','MOORESVILLE    ','MOORHEAD       ','MOORINGSPORT   ',
			'MOORPARK       ','MOOSIC         ','MOOSUP         ','MORA           ','MORAGA         ','MORANN         ','MORAVIA        ','MOREHEAD       ','MOREHEAD CITY  ','MORELAND       ',
			'MORENCI        ','MORENO VALLEY  ','MORETOWN       ','MORGAN         ','MORGAN CITY    ','MORGAN HILL    ','MORGANFIELD    ','MORGANTON      ','MORGANTOWN     ','MORGANVILLE    ',
			'MORIARTY       ','MORICHES       ','MORMON LAKE    ','MORNING VIEW   ','MORO           ','MORRICE        ','MORRILL        ','MORRILTON      ','MORRIS         ','MORRIS CHAPEL  ',
			'MORRIS PLAINS  ','MORRISON       ','MORRISONVILLE  ','MORRISTON      ','MORRISTOWN     ','MORRISVILLE    ','MORRO BAY      ','MORROW         ','MORSE          ','MORSE MILL     ',
			'MORTON         ','MORTON GROVE   ','MORVEN         ','MOSCA          ','MOSCOW         ','MOSCOW MILLS   ','MOSELEY        ','MOSES LAKE     ','MOSHANNON      ','MOSIER         ',
			'MOSINEE        ','MOSS BEACH     ','MOSS POINT     ','MOSSYROCK      ','MOULTON        ','MOULTONBOROUGH ','MOULTRIE       ','MOUND          ','MOUND CITY     ','MOUNDRIDGE     ',
			'MOUNDSVILLE    ','MOUNDVILLE     ','MOUNT AIRY     ','MOUNT ANGEL    ','MOUNT ARLINGTON','MOUNT AUKUM    ','MOUNT BETHEL   ','MOUNT CARMEL   ','MOUNT CLEMENS  ','MOUNT CORY     ',
			'MOUNT DESERT   ','MOUNT DORA     ','MOUNT EPHRAIM  ','MOUNT FREEDOM  ','MOUNT GILEAD   ','MOUNT HAMILTON ','MOUNT HOLLY    ','MOUNT HOLLY SPR','MOUNT HOPE     ','MOUNT HOREB    ',
			'MOUNT IDA      ','MOUNT JACKSON  ','MOUNT JOY      ','MOUNT JULIET   ','MOUNT KISCO    ','MOUNT LAUREL   ','MOUNT LEMMON   ','MOUNT LOOKOUT  ','MOUNT MORRIS   ','MOUNT MOURNE   ',
			'MOUNT NEBO     ','MOUNT OLIVE    ','MOUNT ORAB     ','MOUNT PERRY    ','MOUNT PLEASANT ','MOUNT POCONO   ','MOUNT PROSPECT ','MOUNT PULASKI  ','MOUNT RAINIER  ','MOUNT ROYAL    ',
			'MOUNT SAVAGE   ','MOUNT SHASTA   ','MOUNT SINAI    ','MOUNT STERLING ','MOUNT TABOR    ','MOUNT TREMPER  ','MOUNT VERNON   ','MOUNT VICTORY  ','MOUNT VISION   ','MOUNT WASHINGTO',
			'MOUNTAIN CENTER','MOUNTAIN CITY  ','MOUNTAIN DALE  ','MOUNTAIN GROVE ','MOUNTAIN HOME  ','MOUNTAIN HOME A','MOUNTAIN IRON  ','MOUNTAIN LAKES ','MOUNTAIN PINE  ','MOUNTAIN TOP   ',
			'MOUNTAIN VIEW  ','MOUNTAINSIDE   ','MOUNTAINVILLE  ','MOUNTLAKE TERRA','MOUNTVILLE     ','MOUTH OF WILSON','MOVILLE        ','MOWEAQUA       ','MOYOCK         ','MT BALDY       ',
			'MT ZION        ','MUENSTER       ','MUKILTEO       ','MUKWONAGO      ','MULBERRY       ','MULBERRY GROVE ','MULDRAUGH      ','MULGA          ','MULINO         ','MULLICA HILL   ',
			'MULLIKEN       ','MULLINS        ','MULVANE        ','MUNCIE         ','MUNCY          ','MUNDELEIN      ','MUNFORD        ','MUNFORDVILLE   ','MUNGER         ','MUNISING       ',
			'MUNITH         ','MUNROE FALLS   ','MUNSTER        ','MURCHISON      ','MURDO          ','MURDOCK        ','MURFREESBORO   ','MURPHY         ','MURPHYS        ','MURPHYSBORO    ',
			'MURRAY         ','MURRAYVILLE    ','MURRELLS INLET ','MURRIETA       ','MURRYSVILLE    ','MURTAUGH       ','MUSCATINE      ','MUSCLE SHOALS  ','MUSCODA        ','MUSELLA        ',
			'MUSKEGO        ','MUSKEGON       ','MUSKOGEE       ','MUSSEY         ','MUSTANG        ','MYAKKA CITY    ','MYERSTOWN      ','MYERSVILLE     ','MYRA           ','MYRTLE         ',
			'MYRTLE BEACH   ','MYRTLE CREEK   ','MYSTIC         ','NACHES         ','NACHUSA        ','NACOGDOCHES    ','NAGS HEAD      ','NAHANT         ','NAMPA          ','NANCY          ',
			'NANJEMOY       ','NANTICOKE      ','NANTUCKET      ','NANUET         ','NAPA           ','NAPAVINE       ','NAPERVILLE     ','NAPLES         ','NAPOLEON       ','NAPPANEE       ',
			'NARBERTH       ','NARRAGANSETT   ','NARROWS        ','NARROWSBURG    ','NARVON         ','NASELLE        ','NASHOTAH       ','NASHPORT       ','NASHUA         ','NASHVILLE      ',
			'NASHWAUK       ','NASSAU         ','NATALIA        ','NATCHEZ        ','NATCHITOCHES   ','NATHROP        ','NATICK         ','NATIONAL CITY  ','NATIONAL PARK  ','NATRONA HEIGHTS',
			'NATURAL BRIDGE ','NAUBINWAY      ','NAUGATUCK      ','NAVAL AIR STATI','NAVARRE        ','NAVASOTA       ','NAVESINK       ','NAZARETH       ','NEBO           ','NEBRASKA CITY  ',
			'NEDERLAND      ','NEDROW         ','NEEDHAM        ','NEEDHAM HEIGHTS','NEEDLES        ','NEEDVILLE      ','NEENAH         ','NEGAUNEE       ','NEGLEY         ','NEHALEM        ',
			'NEHAWKA        ','NEILLSVILLE    ','NEKOOSA        ','NELIGH         ','NELLIS AFB     ','NELLYSFORD     ','NELSONVILLE    ','NEMO           ','NENANA         ','NEODESHA       ',
			'NEOGA          ','NEOLA          ','NEOSHO         ','NEPHI          ','NEPTUNE        ','NEPTUNE BEACH  ','NERSTRAND      ','NESBIT         ','NESCONSET      ','NESHANIC STATIO',
			'NESQUEHONING   ','NESS CITY      ','NETCONG        ','NETT LAKE      ','NETTIE         ','NEVADA         ','NEVADA CITY    ','NEW ALBANY     ','NEW ALEXANDRIA ','NEW ALMADEN    ',
			'NEW AUBURN     ','NEW BADEN      ','NEW BALTIMORE  ','NEW BEDFORD    ','NEW BERLIN     ','NEW BERN       ','NEW BETHLEHEM  ','NEW BLOOMFIELD ','NEW BOSTON     ','NEW BRAINTREE  ',
			'NEW BRAUNFELS  ','NEW BRITAIN    ','NEW BROCKTON   ','NEW BRUNSWICK  ','NEW BUFFALO    ','NEW CAMBRIA    ','NEW CANAAN     ','NEW CANEY      ','NEW CARLISLE   ','NEW CASTLE     ',
			'NEW CHURCH     ','NEW CITY       ','NEW COLUMBIA   ','NEW CONCORD    ','NEW CUMBERLAND ','NEW DOUGLAS    ','NEW DURHAM     ','NEW EAGLE      ','NEW EGYPT      ','NEW ELLENTON   ',
			'NEW ENTERPRISE ','NEW ERA        ','NEW FAIRFIELD  ','NEW FLORENCE   ','NEW FRANKEN    ','NEW FREEDOM    ','NEW GALILEE    ','NEW GLARUS     ','NEW GLOUCESTER ','NEW GRETNA     ',
			'NEW HAMPTON    ','NEW HARTFORD   ','NEW HAVEN      ','NEW HILL       ','NEW HOLLAND    ','NEW HOLSTEIN   ','NEW HOPE       ','NEW HUDSON     ','NEW HYDE PARK  ','NEW IBERIA     ',
			'NEW IPSWICH    ','NEW KENSINGTON ','NEW KENT       ','NEW KNOXVILLE  ','NEW LENOX      ','NEW LEXINGTON  ','NEW LISBON     ','NEW LONDON     ','NEW LOTHROP    ','NEW MADRID     ',
			'NEW MARKET     ','NEW MARTINSVILL','NEW MIDWAY     ','NEW MILFORD    ','NEW MUNSTER    ','NEW ORLEANS    ','NEW OXFORD     ','NEW PALESTINE  ','NEW PALTZ      ','NEW PARK       ',
			'NEW PHILADELPHI','NEW PLYMOUTH   ','NEW PORT RICHEY','NEW PRAGUE     ','NEW PRESTON MAR','NEW PROVIDENCE ','NEW RICHLAND   ','NEW RICHMOND   ','NEW RINGGOLD   ','NEW RIVER      ',
			'NEW ROADS      ','NEW ROCHELLE   ','NEW ROCKFORD   ','NEW SALISBURY  ','NEW SMYRNA BEAC','NEW STANTON    ','NEW SWEDEN     ','NEW TOWN       ','NEW TRIPOLI    ','NEW ULM        ',
			'NEW VERNON     ','NEW VIRGINIA   ','NEW WAVERLY    ','NEW WILMINGTON ','NEW WINDSOR    ','NEW WOODSTOCK  ','NEW YORK       ','NEWALLA        ','NEWARK         ','NEWARK VALLEY  ',
			'NEWBERG        ','NEWBERN        ','NEWBERRY       ','NEWBURG        ','NEWBURGH       ','NEWBURY        ','NEWBURY PARK   ','NEWBURYPORT    ','NEWCASTLE      ','NEWCOMB        ',
			'NEWELL         ','NEWFANE        ','NEWFIELD       ','NEWFIELDS      ','NEWFOUNDLAND   ','NEWHALL        ','NEWINGTON      ','NEWKIRK        ','NEWLAND        ','NEWLLANO       ',
			'NEWMAN         ','NEWMAN LAKE    ','NEWMANSTOWN    ','NEWMARKET      ','NEWNAN         ','NEWPORT        ','NEWPORT BEACH  ','NEWPORT COAST  ','NEWPORT NEWS   ','NEWTON         ',
			'NEWTON CENTER  ','NEWTON HIGHLAND','NEWTON JUNCTION','NEWTON LOWER FA','NEWTON UPPER FA','NEWTONVILLE    ','NEWTOWN        ','NEWTOWN SQUARE ','NEWVILLE       ','NIAGARA        ',
			'NIAGARA FALLS  ','NIAGARA UNIVERS','NIANTIC        ','NICASIO        ','NICEVILLE      ','NICHOLASVILLE  ','NICHOLS        ','NICHOLSON      ','NICHOLVILLE    ','NICKERSON      ',
			'NICOLLET       ','NICOMA PARK    ','NILES          ','NIMITZ         ','NINE MILE FALLS','NINEVEH        ','NINILCHIK      ','NIOBRARA       ','NIPOMO         ','NISSWA         ',
			'NITRO          ','NIVERVILLE     ','NIWOT          ','NIXA           ','NOBLE          ','NOBLEBORO      ','NOBLESVILLE    ','NOGALES        ','NOKESVILLE     ','NOKOMIS        ',
			'NOLANVILLE     ','NOLENSVILLE    ','NOME           ','NONANTUM       ','NORBORNE       ','NORCO          ','NORCROSS       ','NORFOLK        ','NORFORK        ','NORMAL         ',
			'NORMAN         ','NORMAN PARK    ','NORMANDY BEACH ','NORRIDGE       ','NORRIDGEWOCK   ','NORRIS         ','NORRISTOWN     ','NORTH ADAMS    ','NORTH ANDOVER  ','NORTH ANSON    ',
			'NORTH ARLINGTON','NORTH ATTLEBORO','NORTH AUGUSTA  ','NORTH AURORA   ','NORTH BABYLON  ','NORTH BALTIMORE','NORTH BEACH    ','NORTH BEND     ','NORTH BENNINGTO','NORTH BERGEN   ',
			'NORTH BERWICK  ','NORTH BETHESDA ','NORTH BILLERICA','NORTH BLOOMFIEL','NORTH BRANCH   ','NORTH BRANFORD ','NORTH BROOKFIEL','NORTH BRUNSWICK','NORTH CANTON   ','NORTH CARVER   ',
			'NORTH CHARLESTO','NORTH CHATHAM  ','NORTH CHELMSFOR','NORTH CHICAGO  ','NORTH CHILI    ','NORTH CLARENDON','NORTH CONWAY   ','NORTH DARTMOUTH','NORTH DIGHTON  ','NORTH EAST     ',
			'NORTH EASTON   ','NORTH ENGLISH  ','NORTH FALMOUTH ','NORTH FERRISBUR','NORTH FORK     ','NORTH FORT MYER','NORTH FRANKLIN ','NORTH FREEDOM  ','NORTH GRAFTON  ','NORTH GRANBY   ',
			'NORTH GROSVENOR','NORTH HAMPTON  ','NORTH HARTLAND ','NORTH HATFIELD ','NORTH HAVEN    ','NORTH HERO     ','NORTH HIGHLANDS','NORTH HILLS    ','NORTH HOLLYWOOD','NORTH HYDE PARK',
			'NORTH JACKSON  ','NORTH JUDSON   ','NORTH KINGSTOWN','NORTH LAKEWOOD ','NORTH LAS VEGAS','NORTH LAUDERDAL','NORTH LEWISBURG','NORTH LIBERTY  ','NORTH LIMA     ','NORTH LITTLE RO',
			'NORTH MANCHESTE','NORTH MARSHFIEL','NORTH MATEWAN  ','NORTH MIAMI    ','NORTH MIAMI BEA','NORTH MONMOUTH ','NORTH MONTPELIE','NORTH MYRTLE BE','NORTH OLMSTED  ','NORTH OXFORD   ',
			'NORTH PALM BEAC','NORTH PLAINS   ','NORTH PLATTE   ','NORTH POLE     ','NORTH POMFRET  ','NORTH PORT     ','NORTH PRAIRIE  ','NORTH PROVIDENC','NORTH READING  ','NORTH REDINGTON',
			'NORTH RICHLAND ','NORTH RIDGEVILL','NORTH ROYALTON ','NORTH SALEM    ','NORTH SALT LAKE','NORTH SCITUATE ','NORTH SIOUX CIT','NORTH SMITHFIEL','NORTH STONINGTO','NORTH TONAWANDA',
			'NORTH TROY     ','NORTH TRURO    ','NORTH UXBRIDGE ','NORTH VERNON   ','NORTH WALES    ','NORTH WATERBORO','NORTH WATERFORD','NORTH WEBSTER  ','NORTH WILKESBOR','NORTH WINDHAM  ',
			'NORTH YARMOUTH ','NORTHAMPTON    ','NORTHBOROUGH   ','NORTHBRIDGE    ','NORTHBROOK     ','NORTHEAST HARBO','NORTHFIELD     ','NORTHFORD      ','NORTHLAKE      ','NORTHPORT      ',
			'NORTHRIDGE     ','NORTHVALE      ','NORTHVILLE     ','NORTHWOOD      ','NORTON         ','NORTONVILLE    ','NORWALK        ','NORWAY         ','NORWELL        ','NORWICH        ',
			'NORWOOD        ','NOTASULGA      ','NOTI           ','NOTRE DAME     ','NOTTINGHAM     ','NOVATO         ','NOVELTY        ','NOVI           ','NOWATA         ','NOXAPATER      ',
			'NOXEN          ','NUEVO          ','NUNICA         ','NUNN           ','NURSERY        ','NUTLEY         ','NYACK          ','O FALLON       ','OAK BLUFFS     ','OAK BROOK      ',
			'OAK CREEK      ','OAK FOREST     ','OAK GROVE      ','OAK HALL       ','OAK HARBOR     ','OAK HILL       ','OAK HILLS      ','OAK ISLAND     ','OAK LAWN       ','OAK PARK       ',
			'OAK RIDGE      ','OAK VIEW       ','OAKDALE        ','OAKFIELD       ','OAKHAM         ','OAKHURST       ','OAKLAND        ','OAKLAND CITY   ','OAKLAND GARDENS','OAKLAND PARK   ',
			'OAKLEY         ','OAKLYN         ','OAKMONT        ','OAKPARK        ','OAKS           ','OAKS CORNERS   ','OAKTON         ','OAKVILLE       ','OAKWOOD        ','OBERLIN        ',
			'OBION          ','OCALA          ','OCCIDENTAL     ','OCCOQUAN       ','OCEAN BEACH    ','OCEAN BLUFF    ','OCEAN CITY     ','OCEAN GATE     ','OCEAN GROVE    ','OCEAN ISLE BEAC',
			'OCEAN PARK     ','OCEAN SHORES   ','OCEAN SPRINGS  ','OCEAN VIEW     ','OCEANA         ','OCEANO         ','OCEANPORT      ','OCEANSIDE      ','OCEANVILLE     ','OCHLOCKNEE     ',
			'OCKLAWAHA      ','OCOEE          ','OCONOMOWOC     ','OCONTO         ','OCRACOKE       ','ODEBOLT        ','ODELL          ','ODEM           ','ODENTON        ','ODENVILLE      ',
			'ODESSA         ','ODIN           ','ODON           ','OFFUTT A F B   ','OGALLALA       ','OGDEN          ','OGDENSBURG     ','OGEMA          ','OGILVIE        ','OGLESBY        ',
			'OGLETHORPE     ','OGUNQUIT       ','OHATCHEE       ','OIL CITY       ','OILVILLE       ','OJAI           ','OKANOGAN       ','OKARCHE        ','OKAUCHEE       ','OKAY           ',
			'OKEANA         ','OKEECHOBEE     ','OKEENE         ','OKEMAH         ','OKEMOS         ','OKLAHOMA CITY  ','OKMULGEE       ','OKOBOJI        ','OLALLA         ','OLAMON         ',
			'OLATHE         ','OLD BETHPAGE   ','OLD BRIDGE     ','OLD CHATHAM    ','OLD FIELDS     ','OLD FORGE      ','OLD GREENWICH  ','OLD HICKORY    ','OLD LYME       ','OLD MISSION    ',
			'OLD MYSTIC     ','OLD ORCHARD BEA','OLD SAYBROOK   ','OLD TOWN       ','OLD WESTBURY   ','OLD ZIONSVILLE ','OLDSMAR        ','OLDWICK        ','OLEAN          ','OLEY           ',
			'OLGA           ','OLIVE BRANCH   ','OLIVEHILL      ','OLIVET         ','OLIVIA         ','OLMSTED FALLS  ','OLNEY          ','OLNEY SPRINGS  ','OLYMPIA        ','OLYMPIA FIELDS ',
			'OLYPHANT       ','OMAHA          ','OMEGA          ','OMRO           ','ONA            ','ONALASKA       ','ONANCOCK       ','ONARGA         ','ONAWAY         ','ONEIDA         ',
			'ONEONTA        ','ONIDA          ','ONONDAGA       ','ONSTED         ','ONTARIO        ','OOLTEWAH       ','OOSTBURG       ','OPA LOCKA      ','OPDYKE         ','OPELIKA        ',
			'OPELOUSAS      ','OPHIR          ','OPP            ','ORADELL        ','ORANGE         ','ORANGE BEACH   ','ORANGE CITY    ','ORANGE COVE    ','ORANGE GROVE   ','ORANGE PARK    ',
			'ORANGEBURG     ','ORANGEVALE     ','ORANGEVILLE    ','ORAVILLE       ','ORCAS          ','ORCHARD LAKE   ','ORCHARD PARK   ','ORDWAY         ','ORE CITY       ','OREFIELD       ',
			'OREGON         ','OREGON CITY    ','OREGONIA       ','ORELAND        ','OREM           ','ORGAS          ','ORIENT         ','ORINDA         ','ORISKANY       ','ORLAND         ',
			'ORLAND PARK    ','ORLANDO        ','ORLEAN         ','ORLEANS        ','ORMOND BEACH   ','ORONDO         ','ORONO          ','ORONOCO        ','OROVILLE       ','ORRINGTON      ',
			'ORRS ISLAND    ','ORRTANNA       ','ORRVILLE       ','ORTING         ','ORTONVILLE     ','ORWELL         ','ORWIGSBURG     ','OSAGE BEACH    ','OSAKIS         ','OSAWATOMIE     ',
			'OSCEOLA        ','OSCO           ','OSCODA         ','OSGOOD         ','OSHKOSH        ','OSHTEMO        ','OSPREY         ','OSSEO          ','OSSIAN         ','OSSINING       ',
			'OSSIPEE        ','OSTERBURG      ','OSTERVILLE     ','OSTRANDER      ','OSWEGO         ','OSYKA          ','OTEGO          ','OTHELLO        ','OTIS           ','OTIS ORCHARDS  ',
			'OTISCO         ','OTISVILLE      ','OTSEGO         ','OTTAWA         ','OTTAWA LAKE    ','OTTER LAKE     ','OTTERBEIN      ','OTTERTAIL      ','OTTERVILLE     ','OTTSVILLE      ',
			'OTTUMWA        ','OVERTON        ','OVID           ','OVIEDO         ','OWASSO         ','OWATONNA       ','OWEGO          ','OWENS CROSS ROA','OWENSBORO      ','OWENSVILLE     ',
			'OWENTON        ','OWINGS         ','OWINGS MILLS   ','OWLS HEAD      ','OWOSSO         ','OWYHEE         ','OXFORD         ','OXNARD         ','OXON HILL      ','OYSTER BAY     ',
			'OZARK          ','OZONE PARK     ','PAAUILO        ','PACIFIC        ','PACIFIC GROVE  ','PACIFIC PALISAD','PACIFICA       ','PACKWAUKEE     ','PACOIMA        ','PACOLET        ',
			'PADUCAH        ','PAEONIAN SPRING','PAGO PAGO      ','PAGOSA SPRINGS ','PAHOA          ','PAHRUMP        ','PAIA           ','PAIGE          ','PAINESDALE     ','PAINESVILLE    ',
			'PAINTED POST   ','PAINTSVILLE    ','PALA           ','PALATINE       ','PALATKA        ','PALENVILLE     ','PALERMO        ','PALESTINE      ','PALISADE       ','PALISADES      ',
			'PALISADES PARK ','PALM           ','PALM BAY       ','PALM BEACH     ','PALM CITY      ','PALM COAST     ','PALM DESERT    ','PALM HARBOR    ','PALM SPRINGS   ','PALMDALE       ',
			'PALMER         ','PALMER LAKE    ','PALMERTON      ','PALMETTO       ','PALMYRA        ','PALO           ','PALO ALTO      ','PALO CEDRO     ','PALO PINTO     ','PALOMA         ',
			'PALOMAR MOUNTAI','PALOS HEIGHTS  ','PALOS HILLS    ','PALOS PARK     ','PAMPA          ','PAMPLICO       ','PANA           ','PANAMA         ','PANAMA CITY    ','PANAMA CITY BEA',
			'PANORAMA CITY  ','PAOLA          ','PAOLI          ','PAPILLION      ','PARACHUTE      ','PARADISE       ','PARADISE VALLEY','PARAGON        ','PARAGOULD      ','PARAMOUNT      ',
			'PARAMUS        ','PARDEEVILLE    ','PARIS          ','PARISH         ','PARK CITY      ','PARK FALLS     ','PARK FOREST    ','PARK HALL      ','PARK HILLS     ','PARK RAPIDS    ',
			'PARK RIDGE     ','PARKER         ','PARKER CITY    ','PARKER FORD    ','PARKERSBURG    ','PARKESBURG     ','PARKSLEY       ','PARKSTON       ','PARKTON        ','PARKVILLE      ',
			'PARLIN         ','PARMA          ','PARRISH        ','PARSIPPANY     ','PARSONS        ','PARSONSBURG    ','PARSONSFIELD   ','PASADENA       ','PASCAGOULA     ','PASCO          ',
			'PASCOAG        ','PASO ROBLES    ','PASS CHRISTIAN ','PASSAIC        ','PASSUMPSIC     ','PATASKALA      ','PATCHOGUE      ','PATERSON       ','PATRICK AFB    ','PATTEN         ',
			'PATTERSON      ','PATTERSONVILLE ','PATTON         ','PATUXENT RIVER ','PAULDEN        ','PAULDING       ','PAULINA        ','PAULLINA       ','PAULSBORO      ','PAUMA VALLEY   ',
			'PAVILION       ','PAW CREEK      ','PAW PAW        ','PAWCATUCK      ','PAWHUSKA       ','PAWLET         ','PAWLEYS ISLAND ','PAWLING        ','PAWNEE         ','PAWTUCKET      ',
			'PAXTON         ','PAYETTE        ','PAYNE          ','PAYNESVILLE    ','PAYSON         ','PEA RIDGE      ','PEABODY        ','PEACH BOTTOM   ','PEACHTREE CITY ','PEAKS ISLAND   ',
			'PEAPACK        ','PEARBLOSSOM    ','PEARCY         ','PEARISBURG     ','PEARL CITY     ','PEARL HARBOR   ','PEARL RIVER    ','PEARLAND       ','PEARSALL       ','PEASE          ',
			'PEBBLE BEACH   ','PECATONICA     ','PECK           ','PECKVILLE      ','PECONIC        ','PECULIAR       ','PEDRICKTOWN    ','PEEBLES        ','PEEKSKILL      ','PEGRAM         ',
			'PEKIN          ','PELAHATCHIE    ','PELHAM         ','PELION         ','PELL CITY      ','PELLA          ','PELLSTON       ','PELZER         ','PEMBERTON      ','PEMBINA        ',
			'PEMBROKE       ','PEMBROKE PINES ','PEN ARGYL      ','PENDERGRASS    ','PENDLETON      ','PENFIELD       ','PENHOOK        ','PENINSULA      ','PENN           ','PENN LAIRD     ',
			'PENN RUN       ','PENN VALLEY    ','PENN YAN       ','PENNELLVILLE   ','PENNEY FARMS   ','PENNGROVE      ','PENNINGTON     ','PENNOCK        ','PENNS GROVE    ','PENNS PARK     ',
			'PENNSAUKEN     ','PENNSBORO      ','PENNSBURG      ','PENNSVILLE     ','PENNSYLVANIA FU','PENNVILLE      ','PENROSE        ','PENRYN         ','PENSACOLA      ','PENTWATER      ',
			'PEORIA         ','PEOSTA         ','PEOTONE        ','PEP            ','PEPPERELL      ','PEQUANNOCK     ','PEQUEA         ','PEQUOT LAKES   ','PERALTA        ','PERCY          ',
			'PERHAM         ','PERIDOT        ','PERKASIE       ','PERKINS        ','PERKINSTON     ','PERKINSVILLE   ','PERKIOMENVILLE ','PERRIN         ','PERRINEVILLE   ','PERRIS         ',
			'PERRY          ','PERRY HALL     ','PERRYSBURG     ','PERRYTON       ','PERRYVILLE     ','PERTH AMBOY    ','PERU           ','PESCADERO      ','PETAL          ','PETALUMA       ',
			'PETERBOROUGH   ','PETERSBURG     ','PETOSKEY       ','PETROLIA       ','PEVELY         ','PEWAUKEE       ','PEWEE VALLEY   ','PEYTON         ','PFAFFTOWN      ','PFLUGERVILLE   ',
			'PHARR          ','PHELAN         ','PHELPS         ','PHENIX CITY    ','PHIL CAMPBELL  ','PHILADELPHIA   ','PHILIPPI       ','PHILIPSBURG    ','PHILLIPS       ','PHILLIPSBURG   ',
			'PHILO          ','PHILOMATH      ','PHILOMONT      ','PHILPOT        ','PHIPPSBURG     ','PHOENIX        ','PHOENIXVILLE   ','PICAYUNE       ','PICKENS        ','PICKERINGTON   ',
			'PICKETT        ','PICKFORD       ','PICKTON        ','PICO RIVERA    ','PICTURE ROCKS  ','PIEDMONT       ','PIERCETON      ','PIERMONT       ','PIERPONT       ','PIERRE         ',
			'PIERSON        ','PIFFARD        ','PIGEON FORGE   ','PIKE ROAD      ','PIKESVILLE     ','PIKEVILLE      ','PILGRIM        ','PILGRIM GARDENS','PILLAGER       ','PILOT HILL     ',
			'PILOT KNOB     ','PILOT MOUNTAIN ','PILOT POINT    ','PIMA           ','PINCKNEY       ','PINCKNEYVILLE  ','PINE           ','PINE APPLE     ','PINE BEACH     ','PINE BLUFF     ',
			'PINE BROOK     ','PINE BUSH      ','PINE CITY      ','PINE GROVE     ','PINE GROVE MILL','PINE HALL      ','PINE ISLAND    ','PINE KNOT      ','PINE MEADOW    ','PINE MOUNTAIN  ',
			'PINE PLAINS    ','PINE VALLEY    ','PINEHURST      ','PINELLAS PARK  ','PINETOP        ','PINEVILLE      ','PINEY FLATS    ','PINNACLE       ','PINOLA         ','PINOLE         ',
			'PINON          ','PINSON         ','PINSONFORK     ','PIOCHE         ','PIONEER        ','PIPE CREEK     ','PIPERSVILLE    ','PIPESTONE      ','PIQUA          ','PISCATAWAY     ',
			'PISECO         ','PISGAH         ','PISGAH FOREST  ','PISMO BEACH    ','PITCHER        ','PITMAN         ','PITTSBORO      ','PITTSBURG      ','PITTSBURGH     ','PITTSFIELD     ',
			'PITTSFORD      ','PITTSTON       ','PITTSTOWN      ','PITTSVILLE     ','PLACENTIA      ','PLACERVILLE    ','PLACITAS       ','PLAIN          ','PLAIN CITY     ','PLAINFIELD     ',
			'PLAINS         ','PLAINSBORO     ','PLAINVIEW      ','PLAINVILLE     ','PLAINWELL      ','PLAISTOW       ','PLANO          ','PLANT CITY     ','PLANTATION     ','PLANTERSVILLE  ',
			'PLANTSVILLE    ','PLAQUEMINE     ','PLATO          ','PLATTE CENTER  ','PLATTE CITY    ','PLATTEKILL     ','PLATTEVILLE    ','PLATTSBURG     ','PLATTSBURGH    ','PLATTSMOUTH    ',
			'PLAYA DEL REY  ','PLEASANT GARDEN','PLEASANT GROVE ','PLEASANT HALL  ','PLEASANT HILL  ','PLEASANT HOPE  ','PLEASANT LAKE  ','PLEASANT PLAIN ','PLEASANT PLAINS','PLEASANT PRAIRI',
			'PLEASANT RIDGE ','PLEASANT VALLEY','PLEASANT VIEW  ','PLEASANTON     ','PLEASANTVILLE  ','PLENTYWOOD     ','PLOVER         ','PLUCKEMIN      ','PLUM BRANCH    ','PLUMERVILLE    ',
			'PLYMOUTH       ','PLYMOUTH MEETIN','PLYMPTON       ','POCAHONTAS     ','POCATELLO      ','POCOLA         ','POCOMOKE CITY  ','POCONO PINES   ','POCONO SUMMIT  ','POCOPSON       ',
			'POESTENKILL    ','POINT HARBOR   ','POINT LOOKOUT  ','POINT MARION   ','POINT MUGU NAWC','POINT OF ROCKS ','POINT PLEASANT ','POINT REYES STA','POINT ROBERTS  ','POLAND         ',
			'POLK           ','POLK CITY      ','POLLOCK        ','POLLOCK PINES  ','POLSON         ','POMARIA        ','POMEROY        ','POMFRET        ','POMFRET CENTER ','POMONA         ',
			'POMPANO BEACH  ','POMPEY         ','POMPTON LAKES  ','POMPTON PLAINS ','PONCA CITY     ','PONCE          ','PONCHATOULA    ','POND EDDY      ','PONDER         ','PONDERAY       ',
			'PONSFORD       ','PONTE VEDRA    ','PONTE VEDRA BEA','PONTIAC        ','PONTOTOC       ','POOLER         ','POOLESVILLE    ','POOLVILLE      ','POPE A F B     ','POPE VALLEY    ',
			'POPLAR         ','POPLAR BLUFF   ','POPLAR GROVE   ','POPLARVILLE    ','POQUONOCK      ','POQUOSON       ','PORT ALLEGANY  ','PORT ALLEN     ','PORT ANGELES   ','PORT ARANSAS   ',
			'PORT ARTHUR    ','PORT BOLIVAR   ','PORT BYRON     ','PORT CHARLOTTE ','PORT CHESTER   ','PORT CLINTON   ','PORT CRANE     ','PORT DEPOSIT   ','PORT EDWARDS   ','PORT EWEN      ',
			'PORT GAMBLE    ','PORT HADLOCK   ','PORT HAYWOOD   ','PORT HUENEME   ','PORT HUENEME CB','PORT HURON     ','PORT ISABEL    ','PORT JEFFERSON ','PORT JERVIS    ','PORT LAVACA    ',
			'PORT LUDLOW    ','PORT MATILDA   ','PORT MONMOUTH  ','PORT MURRAY    ','PORT NECHES    ','PORT ORANGE    ','PORT ORCHARD   ','PORT READING   ','PORT REPUBLIC  ','PORT RICHEY    ',
			'PORT ROYAL     ','PORT SAINT LUCI','PORT SULPHUR   ','PORT TOBACCO   ','PORT TOWNSEND  ','PORT WASHINGTON','PORTAGE        ','PORTAGE DES SIO','PORTAGEVILLE   ','PORTAL         ',
			'PORTALES       ','PORTER         ','PORTER CORNERS ','PORTERFIELD    ','PORTERVILLE    ','PORTLAND       ','PORTOLA VALLEY ','PORTSMOUTH     ','POSEN          ','POST           ',
			'POST FALLS     ','POSTVILLE      ','POTEAU         ','POTOMAC        ','POTOSI         ','POTSDAM        ','POTTERVILLE    ','POTTSBORO      ','POTTSTOWN      ','POTTSVILLE     ',
			'POUGHKEEPSIE   ','POUGHQUAG      ','POULSBO        ','POULTNEY       ','POUND          ','POUND RIDGE    ','POUNDING MILL  ','POWAY          ','POWDER SPRINGS ','POWDERHORN     ',
			'POWDERLY       ','POWELL         ','POWELLS POINT  ','POWHATAN       ','POYNETTE       ','PRAGUE         ','PRAIRIE CITY   ','PRAIRIE CREEK  ','PRAIRIE DU CHIE','PRAIRIE DU SAC ',
			'PRAIRIE GROVE  ','PRAIRIEVILLE   ','PRATHER        ','PRATTVILLE     ','PRESCOTT       ','PRESCOTT VALLEY','PRESQUE ISLE   ','PRESTO         ','PRESTON        ','PRETTY PRAIRIE ',
			'PRICE          ','PRICHARD       ','PRIDE          ','PRIDES CROSSING','PRINCE FREDERIC','PRINCE GEORGE  ','PRINCESS ANNE  ','PRINCETON      ','PRINCETON JCT  ','PRINCEVILLE    ',
			'PRINEVILLE     ','PRINGLE        ','PRIOR LAKE     ','PROCIOUS       ','PROCTOR        ','PROCTORVILLE   ','PROLE          ','PROSPECT       ','PROSPECT HARBOR','PROSPECT HEIGHT',
			'PROSPECT HILL  ','PROSPECT PARK  ','PROSPER        ','PROSPERITY     ','PROSSER        ','PROVIDENCE     ','PROVINCETOWN   ','PROVO          ','PRYOR          ','PUEBLO         ',
			'PUKALANI       ','PULASKI        ','PULLMAN        ','PUNTA GORDA    ','PUNXSUTAWNEY   ','PURCELL        ','PURCELLVILLE   ','PURCHASE       ','PURDUM         ','PURDYS         ',
			'PURMELA        ','PURVIS         ','PUTNAM         ','PUTNAM HALL    ','PUTNAM VALLEY  ','PUTNEY         ','PUUNENE        ','PUXICO         ','PUYALLUP       ','PYLESVILLE     ',
			'QUAKER HILL    ','QUAKERTOWN     ','QUANTICO       ','QUAPAW         ','QUARRYVILLE    ','QUECHEE        ','QUEEN CREEK    ','QUEENS VILLAGE ','QUEENSBURY     ','QUEENSTOWN     ',
			'QUINCY         ','QUINEBAUG      ','QUINLAN        ','QUINNESEC      ','QUINTER        ','QUINTON        ','QUITMAN        ','QUOGUE         ','RABUN GAP      ','RACCOON        ',
			'RACELAND       ','RACINE         ','RADCLIFF       ','RADFORD        ','RADNOR         ','RAEFORD        ','RAGLAND        ','RAGLEY         ','RAGSDALE       ','RAHWAY         ',
			'RAINBOW        ','RAINBOW CITY   ','RAINBOW LAKE   ','RAINIER        ','RAINSVILLE     ','RALEIGH        ','RAMAH          ','RAMONA         ','RAMSEUR        ','RAMSEY         ',
			'RANCHITA       ','RANCHO CORDOVA ','RANCHO CUCAMONG','RANCHO MIRAGE  ','RANCHO PALOS VE','RANCHO SANTA FE','RANCHO SANTA MA','RANCHO VIEJO   ','RANCHOS DE TAOS','RANCOCAS       ',
			'RANDALL        ','RANDALLSTOWN   ','RANDLEMAN      ','RANDOLPH       ','RANDOLPH A F B ','RANDOM LAKE    ','RANGELY        ','RANSOM         ','RANSOM CANYON  ','RANSON         ',
			'RANTOUL        ','RAPID CITY     ','RAPIDS CITY    ','RARITAN        ','RATHDRUM       ','RATON          ','RAVENA         ','RAVENNA        ','RAVENSDALE     ','RAVENSWOOD     ',
			'RAWLINGS       ','RAWLINS        ','RAY            ','RAYLAND        ','RAYMOND        ','RAYMONDVILLE   ','RAYMORE        ','RAYNE          ','RAYNHAM        ','RAYNHAM CENTER ',
			'READFIELD      ','READING        ','READSTOWN      ','READVILLE      ','READYVILLE     ','RECTOR         ','RED BANK       ','RED BAY        ','RED BLUFF      ','RED BOILING SPR',
			'RED BUD        ','RED FEATHER LAK','RED HILL       ','RED HOOK       ','RED LION       ','RED OAK        ','RED RIVER      ','RED ROCK       ','RED SPRINGS    ','RED WING       ',
			'REDAN          ','REDDICK        ','REDDING        ','REDDING CENTER ','REDDING RIDGE  ','REDFIELD       ','REDFORD        ','REDLANDS       ','REDMON         ','REDMOND        ',
			'REDONDO        ','REDONDO BEACH  ','REDWOOD CITY   ','REDWOOD ESTATES','REDWOOD VALLEY ','REEDERS        ','REEDLEY        ','REEDS SPRING   ','REEDSBURG      ','REEDSVILLE     ',
			'REEDVILLE      ','REEDY          ','REELSVILLE     ','REESE          ','REESEVILLE     ','REFUGIO        ','REGISTER       ','REGO PARK      ','REHOBOTH       ','REHOBOTH BEACH ',
			'REIDSVILLE     ','REINBECK       ','REINHOLDS      ','REISTERSTOWN   ','REKLAW         ','REMBERT        ','REMINGTON      ','REMSEN         ','REMSENBURG     ','RENFREW        ',
			'RENO           ','RENSSELAER     ','RENSSELAER FALL','RENTON         ','RENVILLE       ','REPUBLIC       ','RESACA         ','RESCUE         ','RESEDA         ','RESERVE        ',
			'RESTON         ','REVERE         ','REX            ','REXBURG        ','REXFORD        ','REYNOLDS       ','REYNOLDSBURG   ','RHINEBECK      ','RHINELANDER    ','RHOADESVILLE   ',
			'RHODODENDRON   ','RHOME          ','RIALTO         ','RIB LAKE       ','RICE           ','RICE LAKE      ','RICEVILLE      ','RICHARDS       ','RICHARDSON     ','RICHARDTON     ',
			'RICHBORO       ','RICHBURG       ','RICHEY         ','RICHFIELD      ','RICHFIELD SPRIN','RICHFORD       ','RICHLAND       ','RICHLAND CENTER','RICHLAND HILLS ','RICHLANDS      ',
			'RICHLANDTOWN   ','RICHMOND       ','RICHMOND HILL  ','RICHTON        ','RICHTON PARK   ','RICHWOOD       ','RICKREALL      ','RIDDLETON      ','RIDERWOOD      ','RIDGE          ',
			'RIDGE SPRING   ','RIDGECREST     ','RIDGEFIELD     ','RIDGEFIELD PARK','RIDGELAND      ','RIDGELEY       ','RIDGELY        ','RIDGETOP       ','RIDGEVILLE     ','RIDGEWAY       ',
			'RIDGEWOOD      ','RIDGWAY        ','RIDLEY PARK    ','RIEGELSVILLE   ','RIEGELWOOD     ','RIFLE          ','RIFTON         ','RIGA           ','RIGBY          ','RILEY          ',
			'RILEYVILLE     ','RIMERSBURG     ','RIMFOREST      ','RINCON         ','RINDGE         ','RINER          ','RINEYVILLE     ','RINGGOLD       ','RINGLE         ','RINGOES        ',
			'RINGTOWN       ','RINGWOOD       ','RIO            ','RIO GRANDE     ','RIO GRANDE CITY','RIO LINDA      ','RIO MEDINA     ','RIO NIDO       ','RIO RANCHO     ','RIO RICO       ',
			'RIO VERDE      ','RIO VISTA      ','RIPLEY         ','RIPON          ','RIPPLEMEAD     ','RIRIE          ','RISING FAWN    ','RISING STAR    ','RISING SUN     ','RISON          ',
			'RIVA           ','RIVER EDGE     ','RIVER FALLS    ','RIVER FOREST   ','RIVER GROVE    ','RIVER OAKS     ','RIVER ROUGE    ','RIVERBANK      ','RIVERDALE      ','RIVERHEAD      ',
			'RIVERSIDE      ','RIVERTON       ','RIVERVIEW      ','RIVES JUNCTION ','RIVIERA        ','RIXEYVILLE     ','ROANOKE        ','ROANOKE RAPIDS ','ROARK          ','ROBELINE       ',
			'ROBERT         ','ROBERTA        ','ROBERTS        ','ROBERTSDALE    ','ROBERTSVILLE   ','ROBESONIA      ','ROBINS         ','ROBINSON       ','ROBINSONVILLE  ','ROBSON         ',
			'ROBSTOWN       ','ROCA           ','ROCHDALE       ','ROCHELLE       ','ROCHELLE PARK  ','ROCHEPORT      ','ROCHERT        ','ROCHESTER      ','ROCHESTER HILLS','ROCK CITY      ',
			'ROCK CREEK     ','ROCK FALLS     ','ROCK HILL      ','ROCK ISLAND    ','ROCK PORT      ','ROCK RIVER     ','ROCK SPRINGS   ','ROCK TAVERN    ','ROCKAWAY       ','ROCKAWAY BEACH ',
			'ROCKAWAY PARK  ','ROCKBRIDGE     ','ROCKDALE       ','ROCKFIELD      ','ROCKFORD       ','ROCKINGHAM     ','ROCKLAND       ','ROCKLEDGE      ','ROCKLIN        ','ROCKMART       ',
			'ROCKPORT       ','ROCKTON        ','ROCKVALE       ','ROCKVILLE      ','ROCKVILLE CENTR','ROCKWALL       ','ROCKWELL       ','ROCKWOOD       ','ROCKY COMFORT  ','ROCKY FACE     ',
			'ROCKY FORD     ','ROCKY HILL     ','ROCKY MOUNT    ','ROCKY POINT    ','ROCKY RIDGE    ','ROCKY RIVER    ','RODEO          ','RODMAN         ','ROEBLING       ','ROEBUCK        ',
			'ROGERS         ','ROGERS CITY    ','ROGERSVILLE    ','ROGUE RIVER    ','ROHNERT PARK   ','ROHRERSVILLE   ','ROLAND         ','ROLESVILLE     ','ROLLA          ','ROLLING FORK   ',
			'ROLLING HILLS  ','ROLLING MEADOWS','ROLLING PRAIRIE','ROLLINGSTONE   ','ROLLINSFORD    ','ROLLINSVILLE   ','ROMA           ','ROMANCE        ','ROME           ','ROMEO          ',
			'ROMEOVILLE     ','ROMNEY         ','ROMULUS        ','RONALD         ','RONKONKOMA     ','RONKS          ','ROODHOUSE      ','ROOSEVELT      ','ROOSEVELT ROADS','ROPESVILLE     ',
			'ROSALIA        ','ROSAMOND       ','ROSANKY        ','ROSCOE         ','ROSCOMMON      ','ROSE CITY      ','ROSE HILL      ','ROSEBORO       ','ROSEBUD        ','ROSEBURG       ',
			'ROSEDALE       ','ROSELAND       ','ROSELLE        ','ROSELLE PARK   ','ROSEMEAD       ','ROSEMONT       ','ROSEMOUNT      ','ROSENBERG      ','ROSENDALE      ','ROSEVILLE      ',
			'ROSHARON       ','ROSIE          ','ROSLINDALE     ','ROSLYN         ','ROSLYN HEIGHTS ','ROSS           ','ROSSFORD       ','ROSSITER       ','ROSSVILLE      ','ROSWELL        ',
			'ROTHSAY        ','ROTHSCHILD     ','ROTONDA WEST   ','ROTTERDAM JUNCT','ROUGEMONT      ','ROUGH AND READY','ROUND HILL     ','ROUND LAKE     ','ROUND O        ','ROUND ROCK     ',
			'ROUND TOP      ','ROUSES POINT   ','ROWE           ','ROWLAND HEIGHTS','ROWLETT        ','ROWLEY         ','ROXBORO        ','ROXBURY        ','ROXBURY CROSSIN','ROY            ',
			'ROYAL          ','ROYAL OAK      ','ROYAL PALM BEAC','ROYERSFORD     ','ROYSE CITY     ','ROYSTON        ','RUBICON        ','RUCKERSVILLE   ','RUDOLPH        ','RUDYARD        ',
			'RUFFS DALE     ','RUGBY          ','RUIDOSO        ','RUIDOSO DOWNS  ','RUMFORD        ','RUMSEY         ','RUMSON         ','RUNNELLS       ','RUNNEMEDE      ','RUNNING SPRINGS',
			'RUPERT         ','RURAL HALL     ','RURAL RETREAT  ','RURAL VALLEY   ','RUSH           ','RUSH CITY      ','RUSH VALLEY    ','RUSHFORD       ','RUSHLAND       ','RUSHVILLE      ',
			'RUSK           ','RUSSELL        ','RUSSELLS POINT ','RUSSELLVILLE   ','RUSSIAVILLE    ','RUSTBURG       ','RUSTON         ','RUTHER GLEN    ','RUTHERFORD     ','RUTHERFORDTON  ',
			'RUTHVILLE      ','RUTLAND        ','RYDAL          ','RYE            ','RYE BEACH      ','S COFFEYVILLE  ','SABATTUS       ','SABILLASVILLE  ','SABIN          ','SABINE PASS    ',
			'SACATON        ','SACO           ','SACRAMENTO     ','SADDLE BROOK   ','SADDLE RIVER   ','SADIEVILLE     ','SAEGERTOWN     ','SAFETY HARBOR  ','SAFFORD        ','SAG HARBOR     ',
			'SAGAMORE BEACH ','SAGAPONACK     ','SAGINAW        ','SAGLE          ','SAGOLA         ','SAHUARITA      ','SAINT ALBANS   ','SAINT AMANT    ','SAINT ANN      ','SAINT ANNE     ',
			'SAINT ANTHONY  ','SAINT AUGUSTINE','SAINT BERNARD  ','SAINT BONIFACIU','SAINT CHARLES  ','SAINT CLAIR    ','SAINT CLAIR SHO','SAINT CLAIRSVIL','SAINT CLOUD    ','SAINT CROIX FAL',
			'SAINT FRANCIS  ','SAINT FRANCISVI','SAINT GABRIEL  ','SAINT GEORGE   ','SAINT GEORGES  ','SAINT GERMAIN  ','SAINT HEDWIG   ','SAINT HELEN    ','SAINT HELENA   ','SAINT HELENA IS',
			'SAINT HELENS   ','SAINT HENRY    ','SAINT IGNACE   ','SAINT INIGOES  ','SAINT JACOB    ','SAINT JAMES    ','SAINT JOE      ','SAINT JOHN     ','SAINT JOHNS    ','SAINT JOHNSBURY',
			'SAINT JOHNSVILL','SAINT JOSEPH   ','SAINT LEONARD  ','SAINT LOUIS    ','SAINT MARIES   ','SAINT MARTINVIL','SAINT MARYS    ','SAINT MARYS CIT','SAINT MATTHEWS ','SAINT MICHAEL  ',
			'SAINT MICHAELS ','SAINT PARIS    ','SAINT PAUL     ','SAINT PAUL PARK','SAINT PAULS    ','SAINT PETER    ','SAINT PETERS   ','SAINT PETERSBUR','SAINT REGIS    ','SAINT ROSE     ',
			'SAINT SIMONS IS','SAINT THOMAS   ','SAINTE GENEVIEV','SAIPAN         ','SALADO         ','SALAMANCA      ','SALCHA         ','SALE CITY      ','SALE CREEK     ','SALEM          ',
			'SALIDA         ','SALINA         ','SALINAS        ','SALINE         ','SALISBURY      ','SALISBURY MILLS','SALLISAW       ','SALT LAKE CITY ','SALT POINT     ','SALTILLO       ',
			'SALVISA        ','SAMMAMISH      ','SAMSON         ','SAN ACACIA     ','SAN ANDREAS    ','SAN ANGELO     ','SAN ANSELMO    ','SAN ANTONIO    ','SAN AUGUSTINE  ','SAN BENITO     ',
			'SAN BERNARDINO ','SAN BRUNO      ','SAN CARLOS     ','SAN CLEMENTE   ','SAN DIEGO      ','SAN DIMAS      ','SAN FERNANDO   ','SAN FRANCISCO  ','SAN GABRIEL    ','SAN GERMAN     ',
			'SAN GERONIMO   ','SAN GREGORIO   ','SAN JACINTO    ','SAN JOSE       ','SAN JUAN       ','SAN JUAN BAUTIS','SAN JUAN CAPIST','SAN LEANDRO    ','SAN LORENZO    ','SAN LUIS       ',
			'SAN LUIS OBISPO','SAN MARCOS     ','SAN MARINO     ','SAN MARTIN     ','SAN MATEO      ','SAN PABLO      ','SAN PEDRO      ','SAN QUENTIN    ','SAN RAFAEL     ','SAN RAMON      ',
			'SAN SIMEON     ','SAN YGNACIO    ','SAN YSIDRO     ','SANBORN        ','SANBORNTON     ','SANBORNVILLE   ','SAND FORK      ','SAND LAKE      ','SAND SPRINGS   ','SANDERSON      ',
			'SANDERSVILLE   ','SANDIA         ','SANDIA PARK    ','SANDOVAL       ','SANDOWN        ','SANDPOINT      ','SANDSTON       ','SANDSTONE      ','SANDUSKY       ','SANDWICH       ',
			'SANDY          ','SANDY CREEK    ','SANDY HOOK     ','SANDY LAKE     ','SANDY RIDGE    ','SANDY SPRING   ','SANDYVILLE     ','SANFORD        ','SANGER         ','SANIBEL        ',
			'SANTA ANA      ','SANTA BARBARA  ','SANTA CLARA    ','SANTA CLARITA  ','SANTA CLAUS    ','SANTA CRUZ     ','SANTA FE       ','SANTA FE SPRING','SANTA MARGARITA','SANTA MARIA    ',
			'SANTA MONICA   ','SANTA PAULA    ','SANTA RITA     ','SANTA ROSA     ','SANTA ROSA BEAC','SANTA TERESA   ','SANTA YNEZ     ','SANTA YSABEL   ','SANTAQUIN      ','SANTEE         ',
			'SAPULPA        ','SARALAND       ','SARANAC        ','SARASOTA       ','SARATOGA       ','SARATOGA SPRING','SARDINIA       ','SARDIS         ','SARONA         ','SARTELL        ',
			'SARVER         ','SATELLITE BEACH','SATSUMA        ','SAUCIER        ','SAUGATUCK      ','SAUGERTIES     ','SAUGUS         ','SAUK RAPIDS    ','SAUKVILLE      ','SAULT SAINTE MA',
			'SAUNDERSTOWN   ','SAUQUOIT       ','SAUSALITO      ','SAUTEE NACOOCHE','SAVAGE         ','SAVANNAH       ','SAVOY          ','SAXTONS RIVER  ','SAYLORSBURG    ','SAYRE          ',
			'SAYREVILLE     ','SAYVILLE       ','SCALES MOUND   ','SCANDIA        ','SCANDINAVIA    ','SCAPPOOSE      ','SCARBOROUGH    ','SCARSDALE      ','SCHAEFFERSTOWN ','SCHAGHTICOKE   ',
			'SCHAUMBURG     ','SCHENECTADY    ','SCHENEVUS      ','SCHERERVILLE   ','SCHERTZ        ','SCHILLER PARK  ','SCHNECKSVILLE  ','SCHODACK LANDIN','SCHOFIELD      ','SCHOFIELD BARRA',
			'SCHOHARIE      ','SCHOOLCRAFT    ','SCHRIEVER      ','SCHROON LAKE   ','SCHULENBURG    ','SCHUYLER       ','SCHUYLER FALLS ','SCHUYLERVILLE  ','SCHUYLKILL HAVE','SCHWENKSVILLE  ',
			'SCIO           ','SCIOTA         ','SCIPIO         ','SCITUATE       ','SCOTCH PLAINS  ','SCOTIA         ','SCOTLAND       ','SCOTLAND NECK  ','SCOTRUN        ','SCOTT          ',
			'SCOTT AIR FORCE','SCOTT CITY     ','SCOTT DEPOT    ','SCOTTS         ','SCOTTS VALLEY  ','SCOTTSBLUFF    ','SCOTTSBORO     ','SCOTTSBURG     ','SCOTTSDALE     ','SCOTTSVILLE    ',
			'SCOTTVILLE     ','SCRANTON       ','SCURRY         ','SEA CLIFF      ','SEA GIRT       ','SEA ISLAND     ','SEA ISLE CITY  ','SEABECK        ','SEABROOK       ','SEAFORD        ',
			'SEAGOVILLE     ','SEAL BEACH     ','SEAL COVE      ','SEAL HARBOR    ','SEALY          ','SEAMAN         ','SEARCHLIGHT    ','SEARCY         ','SEARSMONT      ','SEARSPORT      ',
			'SEASIDE        ','SEASIDE HEIGHTS','SEASIDE PARK   ','SEATTLE        ','SEAVIEW        ','SEBAGO LAKE    ','SEBASTIAN      ','SEBASTOPOL     ','SEBREE         ','SEBRING        ',
			'SECAUCUS       ','SECTION        ','SEDALIA        ','SEDAN          ','SEDGWICK       ','SEDONA         ','SEDRO WOOLLEY  ','SEEKONK        ','SEELEY         ','SEFFNER        ',
			'SEGUIN         ','SELAH          ','SELBYVILLE     ','SELDEN         ','SELFRIDGE ANGB ','SELINSGROVE    ','SELKIRK        ','SELLERSBURG    ','SELLERSVILLE   ','SELMA          ',
			'SELMER         ','SEMINARY       ','SEMINOLE       ','SEMMES         ','SENATH         ','SENATOBIA      ','SENECA         ','SENECA FALLS   ','SENOIA         ','SEQUIM         ',
			'SERGEANT BLUFF ','SERGEANTSVILLE ','SESSER         ','SEVEN MILE     ','SEVEN SPRINGS  ','SEVEN VALLEYS  ','SEVERANCE      ','SEVERN         ','SEVERNA PARK   ','SEVERY         ',
			'SEVIERVILLE    ','SEVILLE        ','SEWANEE        ','SEWARD         ','SEWAREN        ','SEWELL         ','SEWICKLEY      ','SEXTONVILLE    ','SEYMOUR        ','SHABBONA       ',
			'SHADE GAP      ','SHADY COVE     ','SHADY SIDE     ','SHADY SPRING   ','SHADYSIDE      ','SHAFER         ','SHAFTER        ','SHAKOPEE       ','SHALIMAR       ','SHALLOTTE      ',
			'SHAMOKIN       ','SHAMOKIN DAM   ','SHANDAKEN      ','SHANKSVILLE    ','SHANNON        ','SHAPLEIGH      ','SHARON         ','SHARON CENTER  ','SHARON HILL    ','SHARON SPRINGS ',
			'SHARPES        ','SHARPSBURG     ','SHARPSVILLE    ','SHARPTOWN      ','SHARTLESVILLE  ','SHASTA LAKE    ','SHAUCK         ','SHAVER LAKE    ','SHAVERTOWN     ','SHAW A F B     ',
			'SHAWANO        ','SHAWMUT        ','SHAWNEE        ','SHAWNEE MISSION','SHAWNEE ON DELA','SHEBOYGAN      ','SHEBOYGAN FALLS','SHEFFIELD      ','SHEFFIELD LAKE ','SHELBINA       ',
			'SHELBURNE      ','SHELBY         ','SHELBY TOWNSHIP','SHELBYVILLE    ','SHELDAHL       ','SHELDON        ','SHELDON SPRINGS','SHELDONVILLE   ','SHELL LAKE     ','SHELLEY        ',
			'SHELLSBURG     ','SHELOCTA       ','SHELTER ISLAND ','SHELTON        ','SHENANDOAH     ','SHENANDOAH JUNC','SHENOROCK      ','SHEPHERD       ','SHEPHERDSTOWN  ','SHEPHERDSVILLE ',
			'SHEPPARD AFB   ','SHERBORN       ','SHERBURNE      ','SHERIDAN       ','SHERMAN        ','SHERMAN OAKS   ','SHERMANS DALE  ','SHERRARD       ','SHERRILL       ','SHERWOOD       ',
			'SHEVLIN        ','SHICKSHINNY    ','SHILOH         ','SHINGLE SPRINGS','SHINGLEHOUSE   ','SHINGLETOWN    ','SHINNSTON      ','SHIOCTON       ','SHIPMAN        ','SHIPPENSBURG   ',
			'SHIPSHEWANA    ','SHIRLEY        ','SHIRLEYSBURG   ','SHOALS         ','SHOHOLA        ','SHOKAN         ','SHOREHAM       ','SHORELINE      ','SHORT HILLS    ','SHORTSVILLE    ',
			'SHOSHONE       ','SHOSHONI       ','SHOW LOW       ','SHREVE         ','SHREVEPORT     ','SHREWSBURY     ','SHRUB OAK      ','SHUSHAN        ','SHUTESBURY     ','SIASCONSET     ',
			'SIBLEY         ','SICKLERVILLE   ','SIDNEY         ','SIERRA CITY    ','SIERRA MADRE   ','SIERRA VISTA   ','SIGEL          ','SIGNAL MOUNTAIN','SIKESTON       ','SILAS          ',
			'SILER CITY     ','SILOAM SPRINGS ','SILSBEE        ','SILT           ','SILVANA        ','SILVER CITY    ','SILVER CREEK   ','SILVER LAKE    ','SILVER SPRING  ','SILVER SPRINGS ',
			'SILVERADO      ','SILVERDALE     ','SILVERSTREET   ','SILVERTHORNE   ','SILVERTON      ','SILVIS         ','SIMI VALLEY    ','SIMPSON        ','SIMPSONVILLE   ','SIMSBURY       ',
			'SINKS GROVE    ','SIOUX CENTER   ','SIOUX CITY     ','SIOUX FALLS    ','SIPESVILLE     ','SISSETON       ','SISTERS        ','SITKA          ','SKANDIA        ','SKANEATELES    ',
			'SKILLMAN       ','SKIPPACK       ','SKIPWITH       ','SKOKIE         ','SKOWHEGAN      ','SKYLAND        ','SKYTOP         ','SLAGLE         ','SLATE HILL     ','SLATINGTON     ',
			'SLATON         ','SLAUGHTER      ','SLAYTON        ','SLICKVILLE     ','SLIDELL        ','SLINGER        ','SLINGERLANDS   ','SLOANSVILLE    ','SLOATSBURG     ','SLOUGHHOUSE    ',
			'SMACKOVER      ','SMARTVILLE     ','SMILEY         ','SMITHFIELD     ','SMITHS         ','SMITHS GROVE   ','SMITHSBURG     ','SMITHTON       ','SMITHTOWN      ','SMITHVILLE     ',
			'SMOKETOWN      ','SMYRNA         ','SNEADS FERRY   ','SNELLVILLE     ','SNOHOMISH      ','SNOQUALMIE     ','SNOW HILL      ','SNOW SHOE      ','SNOWMASS       ','SNOWMASS VILLAG',
			'SNYDER         ','SOBIESKI       ','SOCIAL CIRCLE  ','SOCORRO        ','SODA SPRINGS   ','SODDY DAISY    ','SODUS          ','SODUS POINT    ','SOLANA BEACH   ','SOLDIERS GROVE ',
			'SOLDOTNA       ','SOLEBURY       ','SOLEDAD        ','SOLOMON        ','SOLOMONS       ','SOLON          ','SOLSBERRY      ','SOLVANG        ','SOMERDALE      ','SOMERS         ',
			'SOMERS POINT   ','SOMERSET       ','SOMERSWORTH    ','SOMERTON       ','SOMERVILLE     ','SOMIS          ','SOMONAUK       ','SONOMA         ','SONORA         ','SOPERTON       ',
			'SOQUEL         ','SORRENTO       ','SOUDERTON      ','SOUND BEACH    ','SOUR LAKE      ','SOUTH AMANA    ','SOUTH AMBOY    ','SOUTH BARRE    ','SOUTH BAY      ','SOUTH BEACH    ',
			'SOUTH BELOIT   ','SOUTH BEND     ','SOUTH BERWICK  ','SOUTH BETHLEHEM','SOUTH BOSTON   ','SOUTH BOUND BRO','SOUTH BURLINGTO','SOUTH BYRON    ','SOUTH CASCO    ','SOUTH CHARLESTO',
			'SOUTH CHINA    ','SOUTH DARTMOUTH','SOUTH DEERFIELD','SOUTH DENNIS   ','SOUTH EASTON   ','SOUTH EGREMONT ','SOUTH EL MONTE ','SOUTH ELGIN    ','SOUTH GATE     ','SOUTH GLASTONBU',
			'SOUTH GLENS FAL','SOUTH GRAFTON  ','SOUTH HACKENSAC','SOUTH HADLEY   ','SOUTH HAMILTON ','SOUTH HARWICH  ','SOUTH HAVEN    ','SOUTH HERO     ','SOUTH HILL     ','SOUTH HOLLAND  ',
			'SOUTH HUTCHINSO','SOUTH JORDAN   ','SOUTH KENT     ','SOUTH LAKE TAHO','SOUTH LANCASTER','SOUTH LEBANON  ','SOUTH LYON     ','SOUTH MILLS    ','SOUTH MILWAUKEE','SOUTH MONTROSE ',
			'SOUTH ORANGE   ','SOUTH ORLEANS  ','SOUTH OTSELIC  ','SOUTH OZONE PAR','SOUTH PADRE ISL','SOUTH PARIS    ','SOUTH PARK     ','SOUTH PASADENA ','SOUTH PEKIN    ','SOUTH PITTSBURG',
			'SOUTH PLAINFIEL','SOUTH POINT    ','SOUTH PORTLAND ','SOUTH PORTSMOUT','SOUTH PRAIRIE  ','SOUTH RANGE    ','SOUTH RICHMOND ','SOUTH RIVER    ','SOUTH ROCKWOOD ','SOUTH ROYALTON ',
			'SOUTH SAINT PAU','SOUTH SALEM    ','SOUTH SAN FRANC','SOUTH SIOUX CIT','SOUTH THOMASTON','SOUTH VIENNA   ','SOUTH WALES    ','SOUTH WALPOLE  ','SOUTH WEBSTER  ','SOUTH WELLFLEET',
			'SOUTH WEST CITY','SOUTH WILLIAMSO','SOUTH WINDHAM  ','SOUTH WINDSOR  ','SOUTH WOODSTOCK','SOUTH YARMOUTH ','SOUTHAMPTON    ','SOUTHAVEN      ','SOUTHBOROUGH   ','SOUTHBRIDGE    ',
			'SOUTHBURY      ','SOUTHEASTERN   ','SOUTHERN PINES ','SOUTHFIELD     ','SOUTHFIELDS    ','SOUTHGATE      ','SOUTHINGTON    ','SOUTHLAKE      ','SOUTHOLD       ','SOUTHPORT      ',
			'SOUTHSIDE      ','SOUTHWEST HARBO','SOUTHWICK      ','SOUTHWORTH     ','SPALDING       ','SPANAWAY       ','SPANGLE        ','SPANISH FORK   ','SPANISH FORT   ','SPARKILL       ',
			'SPARKS         ','SPARKS GLENCOE ','SPARROW BUSH   ','SPARROWS POINT ','SPARTA         ','SPARTANBURG    ','SPARTANSBURG   ','SPEARFISH      ','SPEARSVILLE    ','SPEEDWELL      ',
			'SPENCER        ','SPENCERPORT    ','SPENCERTOWN    ','SPENCERVILLE   ','SPEONK         ','SPERRY         ','SPERRYVILLE    ','SPICELAND      ','SPICER         ','SPICEWOOD      ',
			'SPINDALE       ','SPINNERSTOWN   ','SPIRIT LAKE    ','SPIRO          ','SPLENDORA      ','SPOFFORD       ','SPOKANE        ','SPOONER        ','SPOTSWOOD      ','SPOTSYLVANIA   ',
			'SPRAKERS       ','SPRECKELS      ','SPRING         ','SPRING BRANCH  ','SPRING BROOK   ','SPRING CITY    ','SPRING CREEK   ','SPRING GREEN   ','SPRING GROVE   ','SPRING HILL    ',
			'SPRING HOPE    ','SPRING HOUSE   ','SPRING LAKE    ','SPRING MILLS   ','SPRING PARK    ','SPRING VALLEY  ','SPRINGBORO     ','SPRINGDALE     ','SPRINGER       ','SPRINGERTON    ',
			'SPRINGERVILLE  ','SPRINGFIELD    ','SPRINGFIELD GAR','SPRINGHILL     ','SPRINGLAKE     ','SPRINGPORT     ','SPRINGTOWN     ','SPRINGVILLE    ','SPRINGWATER    ','SPRUCE PINE    ',
			'SPURLOCKVILLE  ','SQUAW VALLEY   ','ST JOHN        ','ST THOMAS      ','STAATSBURG     ','STACY          ','STAFFORD       ','STAFFORD SPRING','STAFFORDSVILLE ','STAMFORD       ',
			'STAMPING GROUND','STAMPS         ','STANARDSVILLE  ','STANCHFIELD    ','STANDISH       ','STANFIELD      ','STANFORD       ','STANFORDVILLE  ','STANHOPE       ','STANLEY        ',
			'STANTON        ','STANWOOD       ','STAPLES        ','STAPLETON      ','STAR           ','STAR CITY      ','STAR TANNERY   ','STARBUCK       ','STARKSBORO     ','STARKVILLE     ',
			'STARLIGHT      ','STATE CENTER   ','STATE COLLEGE  ','STATE LINE     ','STATE ROAD     ','STATE UNIVERSIT','STATELINE      ','STATEN ISLAND  ','STATESBORO     ','STATESVILLE    ',
			'STAUNTON       ','STAYTON        ','STEAMBOAT SPRIN','STEDMAN        ','STEELE         ','STEELEVILLE    ','STEEP FALLS    ','STEGER         ','STEILACOOM     ','STELLA         ',
			'STEM           ','STENNIS SPACE C','STEPHENS       ','STEPHENS CITY  ','STEPHENSON     ','STEPHENTOWN    ','STEPHENVILLE   ','STERLING       ','STERLING CITY  ','STERLING FOREST',
			'STERLING HEIGHT','STERRETT       ','STETSON        ','STETSONVILLE   ','STEUBEN        ','STEUBENVILLE   ','STEVENS        ','STEVENS POINT  ','STEVENSON      ','STEVENSON RANCH',
			'STEVENSVILLE   ','STEVINSON      ','STEWART        ','STEWARTSTOWN   ','STEWARTSVILLE  ','STEWARTVILLE   ','STILESVILLE    ','STILL RIVER    ','STILLMAN VALLEY','STILLWATER     ',
			'STILWELL       ','STINSON BEACH  ','STIRLING       ','STOCKBRIDGE    ','STOCKDALE      ','STOCKERTOWN    ','STOCKHOLM      ','STOCKTON       ','STODDARD       ','STOKESDALE     ',
			'STONE HARBOR   ','STONE MOUNTAIN ','STONE RIDGE    ','STONEHAM       ','STONEWALL      ','STONINGTON     ','STONY BROOK    ','STONY POINT    ','STONY RIDGE    ','STORM LAKE     ',
			'STORMVILLE     ','STORRS MANSFIEL','STOTTS CITY    ','STOUGHTON      ','STOVER         ','STOW           ','STOWE          ','STRAFFORD      ','STRASBURG      ','STRATFORD      ',
			'STRATHAM       ','STRATHMERE     ','STRATHMORE     ','STRATTON       ','STRAWBERRY     ','STRAWBERRY PLAI','STREAMWOOD     ','STREET         ','STREETMAN      ','STREETSBORO    ',
			'STRONG         ','STRONGSVILLE   ','STROUD         ','STROUDSBURG    ','STRUM          ','STRUTHERS      ','STRYKER        ','STRYKERSVILLE  ','STUART         ','STUARTS DRAFT  ',
			'STUDIO CITY    ','STUDLEY        ','STURBRIDGE     ','STURGEON BAY   ','STURGEON LAKE  ','STURGIS        ','STURTEVANT     ','STUTTGART      ','STUYVESANT     ','SUAMICO        ',
			'SUBLETTE       ','SUBLIMITY      ','SUCCASUNNA     ','SUDBURY        ','SUDLERSVILLE   ','SUFFERN        ','SUFFIELD       ','SUFFOLK        ','SUGAR GROVE    ','SUGAR HILL     ',
			'SUGAR LAND     ','SUGAR LOAF     ','SUGAR TREE     ','SUGAR VALLEY   ','SUGARCREEK     ','SUGARLOAF      ','SUGARLOAF SHORE','SUISUN CITY    ','SUITLAND       ','SULLIVAN       ',
			'SULLIVANS ISLAN','SULPHUR        ','SULPHUR SPRINGS','SULTAN         ','SUMERDUCK      ','SUMMERDALE     ','SUMMERFIELD    ','SUMMERLAND     ','SUMMERLAND KEY ','SUMMERS        ',
			'SUMMERTOWN     ','SUMMERVILLE    ','SUMMIT         ','SUMMIT HILL    ','SUMMIT POINT   ','SUMNER         ','SUMNEYTOWN     ','SUMRALL        ','SUMTER         ','SUN CITY       ',
			'SUN CITY CENTER','SUN CITY WEST  ','SUN PRAIRIE    ','SUN VALLEY     ','SUNAPEE        ','SUNBURST       ','SUNBURY        ','SUNDERLAND     ','SUNFIELD       ','SUNLAND        ',
			'SUNNYSIDE      ','SUNNYVALE      ','SUNOL          ','SUNRAY         ','SUNRISE        ','SUNRISE BEACH  ','SUNSET         ','SUNSET BEACH   ','SUPERIOR       ','SUPPLY         ',
			'SUQUAMISH      ','SURFSIDE       ','SURING         ','SURPRISE       ','SURREY         ','SURRY          ','SUSANVILLE     ','SUSQUEHANNA    ','SUSSEX         ','SUTHERLAND     ',
			'SUTHERLIN      ','SUTTER         ','SUTTER CREEK   ','SUTTON         ','SUTTONS BAY    ','SUWANEE        ','SWAINSBORO     ','SWAMPSCOTT     ','SWANSBORO      ','SWANSEA        ',
			'SWANTON        ','SWANZEY        ','SWARTHMORE     ','SWARTZ CREEK   ','SWEDESBORO     ','SWEENY         ','SWEET HOME     ','SWEET SPRINGS  ','SWEET VALLEY   ','SWEET WATER    ',
			'SWEETWATER     ','SWIFTWATER     ','SWISHER        ','SWOOPE         ','SYCAMORE       ','SYKESTON       ','SYKESVILLE     ','SYLACAUGA      ','SYLMAR         ','SYLVA          ',
			'SYLVANIA       ','SYLVESTER      ','SYOSSET        ','SYRACUSE       ','SYRIA          ','TABOR          ','TABOR CITY     ','TACOMA         ','TAFT           ','TAFTON         ',
			'TAFTVILLE      ','TAHLEQUAH      ','TAHOE CITY     ','TAHOE VISTA    ','TAHOMA         ','TAHUYA         ','TAKOMA PARK    ','TALALA         ','TALBOTT        ','TALISHEEK      ',
			'TALL TIMBERS   ','TALLADEGA      ','TALLAHASSEE    ','TALLAPOOSA     ','TALLASSEE      ','TALLEVAST      ','TALLMADGE      ','TALLMAN        ','TALLULA        ','TAMAQUA        ',
			'TAMARAC        ','TAMIMENT       ','TAMMS          ','TAMPA          ','TAMPICO        ','TAMUNING       ','TAMWORTH       ','TANEYTOWN      ','TANGERINE      ','TANNERSVILLE   ',
			'TAOS           ','TAPPAHANNOCK   ','TAPPAN         ','TARBORO        ','TARIFFVILLE    ','TARPON SPRINGS ','TARRYTOWN      ','TARZANA        ','TASWELL        ','TATAMY         ',
			'TAUNTON        ','TAVARES        ','TAVERNIER      ','TAWAS CITY     ','TAYLOR         ','TAYLOR MILL    ','TAYLOR RIDGE   ','TAYLORS        ','TAYLORS FALLS  ','TAYLORSVILLE   ',
			'TAYLORVILLE    ','TAZEWELL       ','TEA            ','TEAGUE         ','TEANECK        ','TEASDALE       ','TEATICKET      ','TEAYS          ','TECUMSEH       ','TEHACHAPI      ',
			'TEKAMAH        ','TELEPHONE      ','TELFORD        ','TELL CITY      ','TELLURIDE      ','TEMECULA       ','TEMPE          ','TEMPERANCE     ','TEMPLE         ','TEMPLE CITY    ',
			'TEMPLE HILLS   ','TEMPLETON      ','TEN MILE       ','TENAFLY        ','TENINO         ','TENNENT        ','TENNESSEE COLON','TENNESSEE RIDGE','TENNYSON       ','TERLINGUA      ',
			'TERRA BELLA    ','TERRACE PARK   ','TERRE HAUTE    ','TERREBONNE     ','TERRELL        ','TERRY          ','TERRYVILLE     ','TESUQUE        ','TETON VILLAGE  ','TEWKSBURY      ',
			'TEXARKANA      ','TEXAS CITY     ','TEXHOMA        ','TEXICO         ','THACKER        ','THATCHER       ','THE DALLES     ','THE PLAINS     ','THE SEA RANCH  ','THEODORE       ',
			'THERMOPOLIS    ','THETFORD CENTER','THIBODAUX      ','THIEF RIVER FAL','THIELLS        ','THIENSVILLE    ','THOMASTON      ','THOMASVILLE    ','THOMPSON       ','THOMPSON RIDGE ',
			'THOMPSONS STATI','THOMPSONTOWN   ','THOMPSONVILLE  ','THOMSON        ','THONOTOSASSA   ','THORNBURG      ','THORNDALE      ','THORNDIKE      ','THORNTON       ','THORNTOWN      ',
			'THORNVILLE     ','THORNWOOD      ','THOROFARE      ','THORSBY        ','THOUSAND OAKS  ','THOUSAND PALMS ','THREE BRIDGES  ','THREE OAKS     ','THREE RIVERS   ','THREE SPRINGS  ',
			'THURMAN        ','THURMONT       ','THURSTON       ','TICKFAW        ','TICONDEROGA    ','TIFFIN         ','TIFTON         ','TIGERTON       ','TIJERAS        ','TILLAMOOK      ',
			'TILLAR         ','TILLER         ','TILLSON        ','TILTONSVILLE   ','TIMBERLAKE     ','TIMNATH        ','TINIAN         ','TINLEY PARK    ','TIOGA          ','TIPP CITY      ',
			'TIPTON         ','TITUS          ','TITUSVILLE     ','TIVERTON       ','TIVOLI         ','TOANO          ','TOBACCOVILLE   ','TOBYHANNA      ','TOCCOA         ','TODDVILLE      ',
			'TOGIAK         ','TOK            ','TOLAR          ','TOLEDO         ','TOLLAND        ','TOLLESON       ','TOLLEY         ','TOLLHOUSE      ','TOLUCA LAKE    ','TOM BEAN       ',
			'TOMAH          ','TOMAHAWK       ','TOMALES        ','TOMBALL        ','TOMBSTONE      ','TOME           ','TOMKINS COVE   ','TOMS RIVER     ','TONAWANDA      ','TONEY          ',
			'TONGANOXIE     ','TONKAWA        ','TONOPAH        ','TONTITOWN      ','TOOELE         ','TOOMSUBA       ','TOPANGA        ','TOPEKA         ','TOPONAS        ','TOPPING        ',
			'TOPSFIELD      ','TOPSHAM        ','TOPTON         ','TOQUERVILLE    ','TORONTO        ','TORRANCE       ','TORREON        ','TORRINGTON     ','TOTOWA         ','TOWACO         ',
			'TOWANDA        ','TOWNSEND       ','TOWNSHIP OF WAS','TOWNVILLE      ','TOWSON         ','TRABUCO CANYON ','TRACY          ','TRACY CITY     ','TRACYS LANDING ','TRACYTON       ',
			'TRAFFORD       ','TRANQUILLITY   ','TRANSFER       ','TRAPPE         ','TRASKWOOD      ','TRAVELERS REST ','TRAVERSE CITY  ','TRAVIS AFB     ','TREADWELL      ','TREASURE ISLAND',
			'TREGO          ','TREMONT        ','TREMPEALEAU    ','TRENTON        ','TRES PINOS     ','TREVOR         ','TREVORTON      ','TREXLERTOWN    ','TREYNOR        ','TRIANGLE       ',
			'TRIMBLE        ','TRINIDAD       ','TRINITY        ','TRINITY CENTER ','TRION          ','TRIPLER ARMY ME','TRIPOLI        ','TROPHY CLUB    ','TROUP          ','TROUPSBURG     ',
			'TROUT RUN      ','TROUTDALE      ','TROUTMAN       ','TROUTVILLE     ','TROY           ','TRUCKEE        ','TRUE           ','TRUFANT        ','TRUMANN        ','TRUMANSBURG    ',
			'TRUMBULL       ','TRURO          ','TRUSSVILLE     ','TRUXTON        ','TRYON          ','TUALATIN       ','TUBAC          ','TUCKAHOE       ','TUCKER         ','TUCKERTON      ',
			'TUCSON         ','TUJUNGA        ','TUKWILA        ','TULARE         ','TULETA         ','TULLAHOMA      ','TULLY          ','TULSA          ','TUNICA         ','TUNKHANNOCK    ',
			'TUNNEL HILL    ','TUOLUMNE       ','TUPELO         ','TURKEY CREEK   ','TURLOCK        ','TURNER         ','TURNERS        ','TURNERS FALLS  ','TURTLE CREEK   ','TURTLE LAKE    ',
			'TUSCALOOSA     ','TUSCARORA      ','TUSCOLA        ','TUSCUMBIA      ','TUSKEGEE       ','TUSKEGEE INSTIT','TUSTIN         ','TUTTLE         ','TUXEDO         ','TUXEDO PARK    ',
			'TWAIN HARTE    ','TWENTYNINE PALM','TWIN FALLS     ','TWIN LAKE      ','TWIN LAKES     ','TWIN PEAKS     ','TWINSBURG      ','TWO RIVERS     ','TYBEE ISLAND   ','TYLER          ',
			'TYLERSPORT     ','TYLERTOWN      ','TYNGSBORO      ','TYRONE         ','U S A F ACADEMY','UDALL          ','UHRICHSVILLE   ','UKIAH          ','ULSTER         ','ULSTER PARK    ',
			'ULYSSES        ','UMPIRE         ','UNADILLA       ','UNALASKA       ','UNCASVILLE     ','UNDERHILL      ','UNDERWOOD      ','UNICOI         ','UNION          ','UNION BRIDGE   ',
			'UNION CITY     ','UNION DALE     ','UNION GROVE    ','UNION HALL     ','UNION LAKE     ','UNION MILLS    ','UNION PIER     ','UNION POINT    ','UNION SPRINGS  ','UNION STAR     ',
			'UNIONDALE      ','UNIONTOWN      ','UNIONVILLE     ','UNITY          ','UNIVERSAL CITY ','UNIVERSITY     ','UNIVERSITY PARK','UNIVERSITY PLAC','UPHAM          ','UPLAND         ',
			'UPPER BLACK EDD','UPPER DARBY    ','UPPER FALLS    ','UPPER JAY      ','UPPER MARLBORO ','UPPER SANDUSKY ','UPPERCO        ','UPPERVILLE     ','UPTON          ','URBANA         ',
			'URBANDALE      ','UTICA          ','UTOPIA         ','UVALDE         ','UWCHLAND       ','UXBRIDGE       ','VACAVILLE      ','VACHERIE       ','VADER          ','VAIL           ',
			'VAILS GATE     ','VALATIE        ','VALDEZ         ','VALDOSTA       ','VALE           ','VALENCIA       ','VALHALLA       ','VALLEJO        ','VALLES MINES   ','VALLEY         ',
			'VALLEY CENTER  ','VALLEY CITY    ','VALLEY COTTAGE ','VALLEY FALLS   ','VALLEY FORD    ','VALLEY FORGE   ','VALLEY GROVE   ','VALLEY HEAD    ','VALLEY LEE     ','VALLEY MILLS   ',
			'VALLEY PARK    ','VALLEY SPRINGS ','VALLEY STREAM  ','VALLEY VIEW    ','VALLEY VILLAGE ','VALPARAISO     ','VALRICO        ','VAN            ','VAN ALSTYNE    ','VAN BUREN      ',
			'VAN DYNE       ','VAN HORNESVILLE','VAN METER      ','VAN NUYS       ','VAN WERT       ','VANCEBORO      ','VANCOUVER      ','VANDALIA       ','VANDERBILT     ','VANDERBILT BEAC',
			'VANDERGRIFT    ','VANLEER        ','VANLUE         ','VARNEY         ','VARNVILLE      ','VARYSBURG      ','VASHON         ','VASS           ','VASSAR         ','VAUXHALL       ',
			'VEGA           ','VEGA ALTA      ','VELVA          ','VENETA         ','VENETIA        ','VENICE         ','VENTNOR CITY   ','VENTURA        ','VENUS          ','VERADALE       ',
			'VERBANK        ','VERBENA        ','VERDI          ','VERDUGO CITY   ','VERGENNES      ','VERMILION      ','VERMILLION     ','VERMONTVILLE   ','VERNAL         ','VERNON         ',
			'VERNON HILL    ','VERNON HILLS   ','VERNON ROCKVILL','VERNONIA       ','VERO BEACH     ','VERONA         ','VERPLANCK      ','VERSAILLES     ','VESTAL         ','VEYO           ',
			'VICCO          ','VICKERY        ','VICKSBURG      ','VICTOR         ','VICTORIA       ','VICTORVILLE    ','VICTORY MILLS  ','VIDALIA        ','VIDOR          ','VIENNA         ',
			'VIEWTOWN       ','VILLA HILLS    ','VILLA PARK     ','VILLA RICA     ','VILLA RIDGE    ','VILLAGE OF NAGO','VILLALBA       ','VILLANOVA      ','VILLAS         ','VILLE PLATTE   ',
			'VILONIA        ','VINA           ','VINCENNES      ','VINCENT        ','VINE GROVE     ','VINEBURG       ','VINELAND       ','VINEYARD HAVEN ','VINITA         ','VINT HILL FARMS',
			'VINTON         ','VIOLA          ','VIOLET         ','VIRDEN         ','VIRGIE         ','VIRGINIA       ','VIRGINIA BEACH ','VIRGINVILLE    ','VISALIA        ','VISTA          ',
			'VOLANT         ','VOLBORG        ','VOLCANO        ','VOLUNTOWN      ','VON ORMY       ','VOORHEES       ','VOORHEESVILLE  ','W HARTFORD     ','WABAN          ','WABASH         ',
			'WACCABUC       ','WACO           ','WACONIA        ','WADDELL        ','WADDINGTON     ','WADDY          ','WADE           ','WADENA         ','WADESVILLE     ','WADING RIVER   ',
			'WADMALAW ISLAND','WADSWORTH      ','WAGONER        ','WAGONTOWN      ','WAGRAM         ','WAHIAWA        ','WAHPETON       ','WAIALUA        ','WAIANAE        ','WAIKOLOA       ',
			'WAILUKU        ','WAIMANALO      ','WAIMEA         ','WAINSCOTT      ','WAIPAHU        ','WAITE PARK     ','WAITSBURG      ','WAITSFIELD     ','WAKARUSA       ','WAKE FOREST    ',
			'WAKEFIELD      ','WAKEMAN        ','WALBRIDGE      ','WALCOTT        ','WALDEN         ','WALDENBURG     ','WALDO          ','WALDOBORO      ','WALDORF        ','WALDPORT       ',
			'WALDRON        ','WALDWICK       ','WALES          ','WALESKA        ','WALFORD        ','WALKER         ','WALKERSVILLE   ','WALKERTON      ','WALKERTOWN     ','WALKERVILLE    ',
			'WALLA WALLA    ','WALLACE        ','WALLER         ','WALLINGFORD    ','WALLINGTON     ','WALLKILL       ','WALLOWA        ','WALLS          ','WALLULA        ','WALNUT         ',
			'WALNUT CREEK   ','WALNUT GROVE   ','WALNUT RIDGE   ','WALNUT SPRINGS ','WALNUTPORT     ','WALPOLE        ','WALTERBORO     ','WALTHAM        ','WALTON         ','WALTONVILLE    ',
			'WALWORTH       ','WAMEGO         ','WAMPSVILLE     ','WAMPUM         ','WANAMINGO      ','WANAQUE        ','WANATAH        ','WANETTE        ','WANTAGH        ','WAPAKONETA     ',
			'WAPPAPELLO     ','WAPPINGERS FALL','WAPWALLOPEN    ','WARBA          ','WARBRANCH      ','WARD           ','WARD COVE      ','WARE           ','WAREHAM        ','WARETOWN       ',
			'WARING         ','WARMINSTER     ','WARNER         ','WARNER ROBINS  ','WARNER SPRINGS ','WARNERS        ','WARREN         ','WARRENDALE     ','WARRENSBURG    ','WARRENTON      ',
			'WARRENVILLE    ','WARRINGTON     ','WARRIOR        ','WARRIORS MARK  ','WARROAD        ','WARSAW         ','WARWICK        ','WASCO          ','WASECA         ','WASHBURN       ',
			'WASHINGTON     ','WASHINGTON COUR','WASHINGTON CROS','WASHINGTON DEPO','WASHINGTON GROV','WASHINGTONVILLE','WASHOE VALLEY  ','WASHOUGAL      ','WASILLA        ','WASKOM         ',
			'WASSAIC        ','WATCHUNG       ','WATER MILL     ','WATER VALLEY   ','WATERBORO      ','WATERBURY      ','WATERBURY CENTE','WATERFLOW      ','WATERFORD      ','WATERFORD WORKS',
			'WATERLOO       ','WATERPORT      ','WATERSMEET     ','WATERTOWN      ','WATERVILLE     ','WATERVILLE VALL','WATERVLIET     ','WATKINS        ','WATKINSVILLE   ','WATONGA        ',
			'WATSEKA        ','WATSON         ','WATSONTOWN     ','WATSONVILLE    ','WATTSBURG      ','WAUBUN         ','WAUCHULA       ','WAUCONDA       ','WAUKEE         ','WAUKEGAN       ',
			'WAUKESHA       ','WAUKOMIS       ','WAUKON         ','WAUNA          ','WAUNAKEE       ','WAUPACA        ','WAUPUN         ','WAUSA          ','WAUSAU         ','WAUSEON        ',
			'WAUTOMA        ','WAUZEKA        ','WAVELAND       ','WAVERLY        ','WAWAKA         ','WAXAHACHIE     ','WAXHAW         ','WAYCROSS       ','WAYLAND        ','WAYMART        ',
			'WAYNE          ','WAYNESBORO     ','WAYNESBURG     ','WAYNESVILLE    ','WAYSIDE        ','WAYZATA        ','WEARE          ','WEATHERFORD    ','WEATHERLY      ','WEATOGUE       ',
			'WEAVERVILLE    ','WEBB CITY      ','WEBBERVILLE    ','WEBSTER        ','WEDOWEE        ','WEED           ','WEEDSPORT      ','WEEKI WACHEE   ','WEEPING WATER  ','WEIDMAN        ',
			'WEIMAR         ','WEINER         ','WEIR           ','WEIRTON        ','WEISER         ','WELCH          ','WELCHES        ','WELCOME        ','WELDONA        ','WELLBORN       ',
			'WELLESLEY      ','WELLESLEY HILLS','WELLFLEET      ','WELLFORD       ','WELLINGTON     ','WELLS          ','WELLS RIVER    ','WELLSBORO      ','WELLSTON       ','WELLSVILLE     ',
			'WELSH          ','WENATCHEE      ','WENDELL        ','WENHAM         ','WENONAH        ','WENTWORTH      ','WENTZVILLE     ','WERNERSVILLE   ','WESLACO        ','WEST ALEXANDRIA',
			'WEST ALTON     ','WEST BABYLON   ','WEST BARNSTABLE','WEST BEND      ','WEST BERLIN    ','WEST BLOCTON   ','WEST BLOOMFIELD','WEST BOXFORD   ','WEST BOYLSTON  ','WEST BRANCH    ',
			'WEST BRIDGEWATE','WEST BROOKFIELD','WEST BROOKLYN  ','WEST BURKE     ','WEST CARROLLTON','WEST CHATHAM   ','WEST CHAZY     ','WEST CHESTER   ','WEST CHESTERFIE','WEST CHICAGO   ',
			'WEST COLUMBIA  ','WEST CORNWALL  ','WEST COVINA    ','WEST COXSACKIE ','WEST CREEK     ','WEST DENNIS    ','WEST DES MOINES','WEST DOVER     ','WEST EDMESTON  ','WEST END       ',
			'WEST FALLS     ','WEST FALMOUTH  ','WEST FARGO     ','WEST FARMINGTON','WEST FORK      ','WEST FRANKFORT ','WEST FRIENDSHIP','WEST GLOVER    ','WEST GRANBY    ','WEST GREENWICH ',
			'WEST GROVE     ','WEST HARRISON  ','WEST HARTFORD  ','WEST HARTLAND  ','WEST HAVEN     ','WEST HAVERSTRAW','WEST HELENA    ','WEST HEMPSTEAD ','WEST HENRIETTA ','WEST HILLS     ',
			'WEST HURLEY    ','WEST HYANNISPOR','WEST ISLIP     ','WEST JEFFERSON ','WEST JORDAN    ','WEST KENNEBUNK ','WEST KINGSTON  ','WEST LAFAYETTE ','WEST LEBANON   ','WEST LEYDEN    ',
			'WEST LIBERTY   ','WEST LINN      ','WEST LONG BRANC','WEST MCLEAN    ','WEST MEDFORD   ','WEST MEMPHIS   ','WEST MIFFLIN   ','WEST MILFORD   ','WEST MILTON    ','WEST MONROE    ',
			'WEST NEW YORK  ','WEST NEWBURY   ','WEST NEWTON    ','WEST NOTTINGHAM','WEST NYACK     ','WEST OLIVE     ','WEST ORANGE    ','WEST OSSIPEE   ','WEST PADUCAH   ','WEST PALM BEACH',
			'WEST PARIS     ','WEST PARK      ','WEST PLAINS    ','WEST POINT     ','WEST RICHLAND  ','WEST RIVER     ','WEST ROXBURY   ','WEST RUTLAND   ','WEST SACRAMENTO','WEST SALEM     ',
			'WEST SAND LAKE ','WEST SAYVILLE  ','WEST SHOKAN    ','WEST SIMSBURY  ','WEST SOMERSET  ','WEST SPRINGFIEL','WEST STOCKBRIDG','WEST SUFFIELD  ','WEST TERRE HAUT','WEST TISBURY   ',
			'WEST TOWNSEND  ','WEST UNION     ','WEST UNITY     ','WEST VALLEY    ','WEST WAREHAM   ','WEST WARREN    ','WEST WARWICK   ','WEST WENDOVER  ','WEST YARMOUTH  ','WEST YELLOWSTON',
			'WESTAMPTON     ','WESTBORO       ','WESTBOROUGH    ','WESTBROOK      ','WESTBROOKVILLE ','WESTBURY       ','WESTBY         ','WESTCHESTER    ','WESTERLO       ','WESTERLY       ',
			'WESTERN        ','WESTERN SPRINGS','WESTERVILLE    ','WESTFIELD      ','WESTFIELD CENTE','WESTFORD       ','WESTHAMPTON    ','WESTHAMPTON BEA','WESTHOFF       ','WESTLAKE       ',
			'WESTLAKE VILLAG','WESTLAND       ','WESTLEY        ','WESTMINSTER    ','WESTMONT       ','WESTMORELAND   ','WESTMORLAND    ','WESTON         ','WESTPORT       ','WESTPORT POINT ',
			'WESTTOWN       ','WESTVILLE      ','WESTWEGO       ','WESTWOOD       ','WETHERSFIELD   ','WETMORE        ','WETUMPKA       ','WEWAHITCHKA    ','WEWOKA         ','WEXFORD        ',
			'WEYAUWEGA      ','WEYERS CAVE    ','WEYMOUTH       ','WHARTON        ','WHATLEY        ','WHEAT RIDGE    ','WHEATFIELD     ','WHEATLAND      ','WHEATON        ','WHEELER        ',
			'WHEELER ARMY AI','WHEELERSBURG   ','WHEELING       ','WHEELWRIGHT    ','WHIPPANY       ','WHITE          ','WHITE BLUFF    ','WHITE CASTLE   ','WHITE CITY     ','WHITE CLOUD    ',
			'WHITE HALL     ','WHITE HAVEN    ','WHITE HEATH    ','WHITE HORSE BEA','WHITE HOUSE    ','WHITE LAKE     ','WHITE MARSH    ','WHITE MOUNTAIN ','WHITE OAK      ','WHITE PIGEON   ',
			'WHITE PINE     ','WHITE PLAINS   ','WHITE RIVER JUN','WHITE SALMON   ','WHITE SANDS MIS','WHITE SHIELD   ','WHITE SULPHUR S','WHITEFIELD     ','WHITEFISH      ','WHITEFORD      ',
			'WHITEHALL      ','WHITEHOUSE     ','WHITEHOUSE STAT','WHITELAND      ','WHITEMAN AIR FO','WHITESBORO     ','WHITESBURG     ','WHITESTONE     ','WHITESTOWN     ','WHITEVILLE     ',
			'WHITEWATER     ','WHITEWOOD      ','WHITEWRIGHT    ','WHITFIELD      ','WHITING        ','WHITINGHAM     ','WHITINSVILLE   ','WHITMAN        ','WHITMORE LAKE  ','WHITNEY        ',
			'WHITSETT       ','WHITTAKER      ','WHITTIER       ','WICHITA        ','WICHITA FALLS  ','WICKENBURG     ','WICKLIFFE      ','WIGGINS        ','WILBERFORCE    ','WILBRAHAM      ',
			'WILBURTON      ','WILCOX         ','WILDER         ','WILDOMAR       ','WILDWOOD       ','WILKES BARRE   ','WILKESBORO     ','WILKESON       ','WILKINSON      ','WILLACOOCHEE   ',
			'WILLARD        ','WILLARDS       ','WILLCOX        ','WILLIAMS       ','WILLIAMS BAY   ','WILLIAMSBURG   ','WILLIAMSON     ','WILLIAMSPORT   ','WILLIAMSTON    ','WILLIAMSTOWN   ',
			'WILLIAMSVILLE  ','WILLIFORD      ','WILLIMANTIC    ','WILLINGBORO    ','WILLINGTON     ','WILLIS         ','WILLISTON      ','WILLISTON PARK ','WILLITS        ','WILLMAR        ',
			'WILLOUGHBY     ','WILLOW CITY    ','WILLOW CREEK   ','WILLOW GROVE   ','WILLOW RIVER   ','WILLOW SPRING  ','WILLOW SPRINGS ','WILLOW STREET  ','WILLOW WOOD    ','WILLOWS        ',
			'WILLS POINT    ','WILMER         ','WILMERDING     ','WILMETTE       ','WILMINGTON     ','WILMORE        ','WILSON         ','WILSONVILLE    ','WILTON         ','WIMAUMA        ',
			'WIMBERLEY      ','WIMBLEDON      ','WINAMAC        ','WINCHENDON     ','WINCHESTER     ','WINCHESTER CENT','WIND GAP       ','WINDBER        ','WINDER         ','WINDERMERE     ',
			'WINDFALL       ','WINDHAM        ','WINDSOR        ','WINDSOR LOCKS  ','WINDSOR MILL   ','WINFIELD       ','WINGATE        ','WINGDALE       ','WINGO          ','WINLOCK        ',
			'WINNEBAGO      ','WINNEMUCCA     ','WINNETKA       ','WINNIE         ','WINNSBORO      ','WINONA         ','WINONA LAKE    ','WINOOSKI       ','WINSLOW        ','WINSTED        ',
			'WINSTON        ','WINSTON SALEM  ','WINTER         ','WINTER GARDEN  ','WINTER HARBOR  ','WINTER HAVEN   ','WINTER PARK    ','WINTER SPRINGS ','WINTERPORT     ','WINTERS        ',
			'WINTERSET      ','WINTERVILLE    ','WINTHROP       ','WINTHROP HARBOR','WIOTA          ','WIRTZ          ','WISCASSET      ','WISCONSIN DELLS','WISCONSIN RAPID','WISE           ',
			'WISHEK         ','WITTENBERG     ','WITTENSVILLE   ','WITTMANN       ','WITTS SPRINGS  ','WIXOM          ','WOBURN         ','WOLBACH        ','WOLCOTT        ','WOLCOTTVILLE   ',
			'WOLF POINT     ','WOLFEBORO      ','WOLFFORTH      ','WOLFLAKE       ','WOMELSDORF     ','WONDER LAKE    ','WONEWOC        ','WOOD DALE      ','WOOD RIDGE     ','WOOD RIVER     ',
			'WOOD RIVER JUNC','WOODACRE       ','WOODBINE       ','WOODBOURNE     ','WOODBRIDGE     ','WOODBURN       ','WOODBURY       ','WOODBURY HEIGHT','WOODCLIFF LAKE ','WOODFORD       ',
			'WOODHAVEN      ','WOODINVILLE    ','WOODLAKE       ','WOODLAND       ','WOODLAND HILLS ','WOODLAND PARK  ','WOODLAWN       ','WOODLYN        ','WOODMERE       ','WOODRIDGE      ',
			'WOODRUFF       ','WOODS CROSS    ','WOODS HOLE     ','WOODSBORO      ','WOODSFIELD     ','WOODSIDE       ','WOODSON        ','WOODSTOCK      ','WOODSTOCK VALLE','WOODSTOWN      ',
			'WOODSVILLE     ','WOODVILLE      ','WOODWARD       ','WOODWAY        ','WOODWORTH      ','WOODY CREEK    ','WOOLWICH       ','WOONSOCKET     ','WOOSTER        ','WORCESTER      ',
			'WORDEN         ','WORLAND        ','WORONOCO       ','WORTH          ','WORTHING       ','WORTHINGTON    ','WORTON         ','WRAY           ','WRENS          ','WRENTHAM       ',
			'WRIGHT         ','WRIGHT CITY    ','WRIGHTSTOWN    ','WRIGHTSVILLE   ','WRIGHTSVILLE BE','WRIGHTWOOD     ','WURTSBORO      ','WYALUSING      ','WYANDANCH      ','WYANDOTTE      ',
			'WYCKOFF        ','WYCOMBE        ','WYLIE          ','WYMORE         ','WYNANTSKILL    ','WYNCOTE        ','WYNNE          ','WYNNEWOOD      ','WYOMING        ','WYTHEVILLE     ',
			'XENIA          ','YACOLT         ','YAKIMA         ','YAKUTAT        ','YALE           ','YAMHILL        ','YANKEETOWN     ','YANKTON        ','YANTIS         ','YAPHANK        ',
			'YARMOUTH       ','YARMOUTH PORT  ','YAUCO          ','YAZOO CITY     ','YELLOW SPRINGS ','YELM           ','YERINGTON      ','YERMO          ','YIGO           ','YODER          ',
			'YONA           ','YONKERS        ','YORBA LINDA    ','YORK           ','YORK BEACH     ','YORK HARBOR    ','YORK HAVEN     ','YORK NEW SALEM ','YORK SPRINGS   ','YORKLYN        ',
			'YORKSHIRE      ','YORKTOWN       ','YORKTOWN HEIGHT','YORKVILLE      ','YOSEMITE       ','YOUNG AMERICA  ','YOUNG HARRIS   ','YOUNGSTOWN     ','YOUNGSVILLE    ','YOUNGTOWN      ',
			'YOUNGWOOD      ','YOUNTVILLE     ','YPSILANTI      ','YREKA          ','YUBA CITY      ','YUCAIPA        ','YUCCA VALLEY   ','YUKON          ','YULAN          ','YULEE          ',
			'YUMA           ','ZACHARY        ','ZAMORA         ','ZANESFIELD     ','ZANESVILLE     ','ZEBULON        ','ZEELAND        ','ZEIGLER        ','ZENDA          ','ZEPHYR COVE    ',
			'ZEPHYRHILLS    ','ZILLAH         ','ZIMMERMAN      ','ZION           ','ZIONSVILLE     ','ZOLFO SPRINGS  ','ZUMBRO FALLS   ','ZUMBROTA       ','ZUNI           ','ZWINGLE        '];

SET OF STRING2 SetStates := [
			'LA','PA','MD','NC','MD','TX','TX','IL','MA','LA','WI','NJ','CA','MD','MD','VA','NY','MI','MA','MA',
			'GA','OK','GA','AK','MN','NY','PA','OH','IL','WA','IA','CA','WI','TX','MI','NC','TX','GU','MA','KS',
			'CA','PR','CA','NC','HI','SC','GA','IA','AZ','OH','AL','FL','CA','TX','NM','CO','MI','IN','NC','MN',
			'NY','MN','RI','PA','NM','VT','PA','NM','SD','TN','NY','WV','VA','IL','AR','AL','VA','NY','FL','ME',
			'NY','MI','IL','CA','TX','TX','PA','CA','NJ','MI','NY','TX','MI','NJ','NJ','CO','NJ','NJ','OH','PA',
			'PA','MI','MA','WA','CO','WA','MI','ME','MI','GA','UT','IL','NH','CA','KS','CA','IL','FL','CA','VA',
			'NY','MI','NH','NH','PA','CA','OK','WV','OK','MN','KY','PA','TX','CA','NE','NY','IA','WA','NV','TX',
			'NY','PA','IN','OH','ND','CA','ID','UT','GA','WI','IA','MA','IL','MA','VA','OR','NY','OH','OH','CT',
			'MO','LA','MT','WA','OK','CA','HI','TX','PA','IA','AK','AK','KS','AL','IN','WA','TN','MN','SC','MD',
			'NY','CA','NC','TX','IN','MN','CA','IA','MI','TX','UT','NJ','MD','MD','AL','PA','MN','ME','CT','CA',
			'AZ','NM','WI','CA','CO','CA','AZ','FL','NY','NC','PA','FL','FL','CA','WI','MO','GA','CA','MD','NY',
			'AL','LA','GA','TX','WY','VA','MO','CA','NY','IN','OH','CA','OH','NC','FL','IL','PA','NC','PA','NY',
			'NY','WI','PA','IL','KS','IN','ND','TX','WA','AZ','AZ','AR','KS','OK','TX','IL','KS','MI','NY','LA',
			'KS','GA','CA','TX','WI','CA','CA','TX','CO','NY','CA','NJ','NJ','AR','RI','VA','MA','MA','AR','NC',
			'NC','MA','CT','IL','IL','TN','IL','MA','OH','ID','OH','CO','MA','PA','NY','CA','TX','KS','NJ','PA',
			'GA','CA','ID','AR','NH','GA','PA','NY','NJ','NJ','MI','AL','TN','AL','MI','MA','MA','CA','KS','MI',
			'NY','ME','MI','MA','NJ','ME','CO','PA','IA','IN','GA','TX','OH','AL','IL','NJ','PA','NJ','MD','NY',
			'CA','CA','IN','TX','OH','NJ','OH','FL','PA','GA','PA','SC','AL','TX','VA','NC','MA','VA','NE','TX',
			'NM','CA','FL','NY','MN','MI','PA','AZ','MN','NC','CO','WI','AL','KS','PA','WA','FL','OR','CA','PA',
			'AR','ND','KS','CA','NY','NY','MS','GA','SC','TX','NY','NY','MO','SD','MD','SC','MI','TX','NY','MI',
			'OR','AL','NC','CA','MI','CT','AZ','NJ','ME','ME','WI','MI','MI','HI','OH','WV','KY','CA','KY','IN',
			'TX','LA','AR','NJ','NJ','NE','OH','VT','WI','MO','MA','SC','MI','VT','GU','IL','AK','CA','OK','IL',
			'PA','NY','MI','PA','FL','CO','FL','KS','NJ','NY','ME','LA','NY','MO','AR','NY','LA','MI','WA','MN',
			'NV','NC','MN','AR','GA','MN','MI','AL','FL','MS','NY','MS','OH','PR','NM','CO','NJ','MN','NY','TX',
			'NJ','NJ','NJ','NY','CT','CA','VA','ME','TN','DE','WI','MI','MN','IL','NE','KY','SC','TX','KY','PA',
			'KY','NY','NY','MI','OR','VA','OR','IL','PA','MN','MA','WV','MA','NY','IL','TX','NJ','NE','AR','PA',
			'IN','SC','IL','IL','TN','KY','TX','OK','MD','MD','MD','MA','ND','MS','WI','MI','NC','WA','ME','ND',
			'NJ','KY','WI','ME','TN','CA','CA','AR','OH','OH','MO','OH','LA','SD','FL','NJ','KS','IL','OH','PA',
			'FL','FL','OH','PA','NY','FL','IL','WA','CA','WA','NJ','NY','VT','NY','TX','CO','PA','NJ','NH','WI',
			'OH','PA','TX','MD','CA','NJ','MS','MN','NY','CA','MN','OR','MD','ME','WI','CA','IA','SC','NH','PA',
			'IL','AZ','PA','MO','WA','MI','OH','AR','MI','KY','SD','NJ','TX','CA','NJ','MI','NY','PA','OH','KS',
			'ME','MA','NJ','NY','NY','MO','PA','MI','AL','KS','AR','CO','TX','LA','IL','AL','NC','IL','CT','DE',
			'ME','CA','PA','MD','GA','NY','CO','IA','MD','OH','CO','MA','CA','MO','IN','ME','CA','CA','WI','WV',
			'AK','CA','FL','MD','OH','MI','IL','MT','MT','TX','SD','CA','MT','MA','MT','AL','MS','ME','NY','MI',
			'MO','PA','MN','IL','PA','AL','AZ','GA','MD','ND','MI','OK','AL','WI','WA','MT','WI','SD','NC','NY',
			'WI','MO','MN','ID','OH','VA','GA','MA','MO','OK','NJ','NE','NC','MD','OH','NE','VA','CA','NJ','PA',
			'GA','WA','PA','IA','WI','OH','TX','MO','MA','UT','PA','LA','NY','NJ','IA','MI','RI','OH','WI','NJ',
			'MI','TX','NY','NJ','CA','PA','NJ','MO','NY','NY','AL','TN','NC','VA','PA','NV','IA','ME','IL','CA',
			'WI','MS','NY','GA','PA','MO','VA','TX','OK','VA','SC','CA','AR','SC','PA','AL','FL','FL','CA','CA',
			'TX','LA','GA','TX','NJ','MS','NY','PA','ID','IL','NY','NC','NC','NY','VT','TN','AL','GA','MA','WI',
			'IA','VT','IL','TX','FL','CA','FL','MO','MT','KS','ID','AR','CA','NC','VA','AR','MD','NJ','NC','ME',
			'IN','NJ','TX','OR','CA','NH','NM','LA','MA','PA','WA','CT','ND','NY','CO','NV','CA','WI','CA','NJ',
			'UT','IN','IL','LA','LA','NH','ME','ME','ND','IL','PA','MD','MO','PA','SD','MA','MA','VA','WI','MT',
			'MD','VA','PA','CA','VA','MA','MI','MI','FL','NE','MT','MD','CT','PA','CA','FL','FL','OH','KY','PA',
			'ME','NJ','MO','TX','MO','IL','MN','MA','NJ','PA','KY','VT','VA','MD','CT','MO','MI','MA','AL','GA',
			'VT','CA','MO','IN','TX','CA','LA','TX','OH','IL','PA','NY','PA','GA','WA','VA','TX','TX','AL','WV',
			'TN','NC','AK','ME','NY','MA','AL','UT','NY','NJ','TX','NY','NY','NJ','IL','PA','MA','MI','ME','NJ',
			'AL','NJ','UT','CO','NY','WI','IL','AR','MD','CA','VA','OK','MI','CT','NY','VA','NY','TX','MT','MT',
			'OH','VA','NY','MA','PA','WI','PA','OK','IA','NY','NY','MN','CA','VA','MD','OH','MS','SD','AR','MD',
			'ME','MA','MO','NY','OH','IL','GA','TX','NJ','IN','FL','NY','OH','PA','CO','IL','LA','MI','TX','MT',
			'NJ','NC','AL','IN','IN','VT','TX','GA','WV','AL','ID','GA','CO','TN','WA','NY','WI','TX','MD','AR',
			'ME','MD','PA','PA','NC','NY','MS','AZ','MD','ME','WV','GA','PA','MI','KS','KY','ME','KS','IL','NJ',
			'CA','NJ','CA','CO','NY','CO','IL','VA','GA','NC','TX','AZ','TX','VA','IL','MO','WV','NV','FL','LA',
			'CA','NY','NC','PA','OH','WA','TX','VA','KY','TX','TX','ID','CA','VT','TX','WI','ME','TN','WV','NY',
			'IL','CA','NY','MI','MI','MD','LA','PA','TX','FL','MD','NY','PA','IN','NC','MT','WI','OR','WI','OR',
			'MA','CO','MA','MI','MI','CA','MD','VT','OK','TX','MI','KY','PR','GA','CA','NC','ME','NY','ID','IL',
			'AL','CA','CO','GA','CA','NJ','MO','CA','CA','CA','CA','FL','MO','MD','CA','IL','KY','NY','OK','GA',
			'IA','WA','CA','WA','CA','NY','MA','IN','PA','IN','SC','DE','MO','TX','GA','NY','CA','WV','HI','PA',
			'NC','CA','AZ','TN','TX','NY','IN','WI','KY','FL','CA','CA','SC','KY','NH','KY','OH','OH','NY','NY',
			'NY','OR','NH','NC','NY','NY','KS','OH','MN','CA','CO','PA','PR','NH','TX','CT','FL','IL','TX','CA',
			'TX','OR','FL','VA','FL','ME','MO','NJ','NJ','ME','CA','MD','CA','WV','VA','AL','HI','FL','TX','AL',
			'IL','CA','OH','AZ','LA','ME','MO','NY','MI','NV','IL','PA','IL','NM','NJ','OR','IL','CA','CA','IL',
			'CA','WA','PA','CA','GA','MI','IL','NC','PR','NC','WY','IL','CA','CO','NC','OK','MS','ND','TX','OH',
			'VA','PA','VA','NM','NV','MI','IA','NJ','GA','IL','TX','CA','MO','MA','PA','NC','AZ','MD','OR','WI',
			'MI','IL','AR','OK','WA','MI','WY','FL','PA','CA','OH','ME','NY','NC','CO','VT','NY','SD','CA','CA',
			'AZ','PR','PA','GA','VA','PA','VA','CA','WA','VA','KY','IL','NY','MD','OK','NY','NY','ND','KY','AZ',
			'AR','VT','SC','CA','IN','NY','NY','AR','MI','AL','UT','TX','NM','IA','CA','NJ','TX','NJ','IN','TX',
			'IA','MI','UT','WI','NY','PA','GA','AR','PR','OH','MI','ND','MN','NH','VA','NH','FL','MI','NY','NH',
			'IA','AR','NH','NH','PA','CT','OH','NY','IN','NY','AR','KY','IN','SC','NY','KY','RI','NY','MI','OR',
			'NY','NY','WA','AL','PA','VA','WI','CA','MI','CA','IL','KY','PA','NY','MO','OH','PA','LA','PA','IL',
			'PA','NY','MN','IL','TX','OH','MN','IL','TX','VA','KS','NC','SC','CT','WV','NY','TX','MD','OH','MA',
			'PA','VA','WV','AR','SC','RI','MI','NC','MD','VA','MA','MA','MA','MI','WI','MN','NY','MN','MS','AL',
			'CA','FL','TN','WA','NY','NY','IL','MI','OK','WA','WA','MA','IA','PA','NY','WA','RI','SC','NC','AR',
			'OH','NJ','IL','PA','MI','VA','MD','MD','MA','SC','VA','PA','PA','MO','OH','OH','IN','MD','ME','MA',
			'PA','MD','WY','PA','IL','IL','CA','IL','GA','OK','CA','MA','AL','TX','MD','VA','WI','OH','MA','OR',
			'WI','WA','NC','MI','NC','TX','VA','CA','CA','AZ','FL','WI','MN','MN','NY','VT','WV','NC','OK','MT',
			'LA','OK','IL','TN','VA','VI','IL','AK','CA','AL','MD','LA','VA','MD','NY','IN','TX','NY','KS','OH',
			'MT','MN','NY','FL','CA','CA','OR','KS','PA','MT','AL','FL','IA','CA','OK','NY','NY','IL','PA','IA',
			'PA','CO','AZ','GA','ID','SC','PA','NJ','MO','MS','WA','TN','NC','OR','VA','NY','MI','WV','KS','IL',
			'DE','PA','CA','NY','WA','AK','IN','IA','MD','UT','WA','PA','FL','FL','TX','CA','NC','NY','SC','FL',
			'OH','MO','OH','FL','ND','NJ','NJ','NJ','PA','NY','NY','VA','TX','CT','NY','MI','NY','WI','MI','IA',
			'MN','NJ','SC','IN','NM','MI','NY','GA','CA','PA','IN','PA','AL','CA','PA','UT','CA','PA','NC','CT',
			'WI','NY','GA','WI','PA','MD','FL','FL','FL','AL','WY','VA','ID','NY','KS','PA','MA','NY','MN','AL',
			'GA','KS','VT','NY','NY','NY','NY','TX','MI','CT','TX','IA','NC','WI','MD','WA','NY','TX','PA','TX',
			'TN','NJ','MS','TX','TN','CA','PA','IA','MN','MI','IL','NJ','VA','VA','MD','TX','CO','GA','CA','NJ',
			'SC','IN','ME','OH','AL','MI','OH','OH','CA','WA','KS','OK','WI','GA','NY','TX','CO','MI','OH','CO',
			'MD','MI','CA','MO','PA','WA','OR','NY','NY','IL','CO','NY','GA','OH','PA','PA','PA','IN','NC','MD',
			'TX','PA','NY','NY','MI','NH','NJ','IN','OH','MI','GA','PA','MN','TN','NJ','MD','TX','CA','AZ','PA',
			'NY','AL','NY','OK','SC','KS','NY','NY','PA','OH','TX','TX','CA','OR','WY','FL','FL','IA','NY','PA',
			'NC','OR','KY','GA','OK','AK','WV','NY','MS','GA','NC','IL','TN','KY','NY','AZ','NY','CT','NY','NC',
			'CA','CA','CA','TX','NM','TX','PA','TN','PA','TX','AZ','CA','CO','NE','NY','IN','OR','IN','CT','TN',
			'OH','TX','CA','CA','CO','WI','NY','MO','AL','LA','TN','CA','MI','MA','TX','WI','PA','IL','TN','IA',
			'IL','WA','VA','VT','CA','LA','AL','OK','WA','SC','KY','NY','CA','CO','NC','PA','PA','NJ','TX','WI',
			'TX','AL','PA','NJ','RI','ND','NY','GA','IN','GA','WV','IL','NJ','PA','NC','PA','NE','SD','IA','FL',
			'IA','NJ','PA','CO','OH','CA','FL','KY','OR','NE','VA','VA','KY','CA','KY','NY','NY','CT','SD','MN',
			'NY','AL','TX','TX','SC','VA','WI','NY','AR','TN','NJ','MI','NY','NY','NC','ME','TX','IN','MD','PA',
			'VA','VA','NV','FL','MO','MI','IL','FL','AL','WI','NY','TX','TN','AL','WV','NC','VA','OR','CA','VA',
			'ME','TN','ME','TN','MA','IA','MA','TN','CA','WA','NC','OH','NE','MD','OK','OH','WA','NY','IN','VT',
			'OH','KY','TX','CO','GA','FL','AL','MI','DE','IL','VA','GA','TX','IL','NE','VA','VA','TX','TX','PA',
			'WI','IL','CA','IL','ME','MD','MD','UT','TX','NC','CA','PA','CT','TN','FL','WV','CT','GA','NY','MI',
			'IL','KY','AL','PA','AR','IL','NY','IN','WA','CA','MN','PA','IA','NC','MD','FL','OK','IL','MI','MI',
			'WV','IL','GA','OH','FL','CT','WI','OH','WI','AR','KS','MI','IA','NJ','MD','KY','MI','MI','AL','FL',
			'GA','TN','ID','IA','GU','MA','CT','NC','NJ','IL','ME','CA','CO','WI','OH','FL','ND','MN','OH','FL',
			'IL','CA','CO','TX','TX','WI','FL','CA','NY','VA','WI','OH','DE','PA','LA','NY','NY','KS','SD','OH',
			'WV','NY','PA','IN','IN','OH','FL','PA','AK','MI','FL','NJ','WA','AL','GA','IN','LA','TX','WI','MA',
			'MA','ME','TX','CO','TX','NJ','NY','NY','LA','VT','VT','LA','PA','PA','MD','LA','AR','ND','IA','IL',
			'CA','CA','OH','TX','FL','LA','MI','MN','PA','LA','ND','TX','PA','IA','IL','VA','MO','CA','OH','CA',
			'NY','CA','MS','TX','MD','WI','ND','TN','PA','MA','IA','AK','MT','CA','IN','PA','MN','TX','MI','PA',
			'CA','VA','MD','IL','CO','IL','ME','IL','TN','NY','TX','MN','KS','WI','AL','CO','VA','IL','AR','GA',
			'PA','NE','PA','IA','AL','MA','MA','NJ','MI','VT','IL','CA','WV','IA','ND','KS','TX','GA','WI','PA',
			'DE','ME','NY','MI','TN','IL','CA','WI','PA','IL','WI','CA','PA','MA','CO','UT','MD','OH','PA','WI',
			'MO','TX','TX','PA','OK','PA','VA','KY','PA','MI','PA','IL','NY','CA','LA','OH','IN','IA','NC','OR',
			'IN','VA','UT','MN','CA','TX','VA','NJ','PA','NH','SC','PA','CA','PA','TX','MD','OR','FL','MD','TN',
			'PA','NC','VA','FL','CA','KY','ND','MA','LA','IL','WA','PA','IL','CO','OK','NC','NY','PA','LA','AK',
			'MO','VA','WA','MA','IN','TN','IA','TX','PA','TN','AZ','NE','NY','OR','IA','TX','TX','OR','WI','TN',
			'MD','NY','IL','VA','MO','SC','IL','NY','NY','VT','NC','PA','TX','NY','ME','MA','MA','NJ','VT','PA',
			'VT','IL','NY','OH','VT','MA','VT','IL','NY','VT','NC','MA','CT','MN','NY','PA','RI','CT','NH','NY',
			'NJ','CT','CT','VT','MT','CA','NY','MI','CT','NH','MI','MI','OH','ME','OH','MA','CT','ME','NY','VT',
			'ME','IL','VT','NY','NY','MD','NY','NY','NJ','MA','MA','FL','OH','NY','IL','PA','ME','MO','PA','RI',
			'NY','VT','NY','NY','NJ','IL','MA','NY','PA','PA','NY','MA','MI','MA','PA','VT','WI','NH','MA','MA',
			'ME','WA','ME','CT','CT','AL','NY','CT','MA','MA','OH','WI','PA','MI','NY','OR','WA','CO','FL','MI',
			'GA','NJ','WA','WI','PA','CO','AL','IN','ME','KY','NC','VT','MN','NC','MO','MA','ME','SC','PA','SC',
			'MN','MD','MD','PA','TX','IN','NJ','SC','NY','OK','WA','MI','TX','OH','CA','MI','IL','LA','SC','PA',
			'NC','NJ','NJ','FL','AK','AL','PA','MN','KY','CA','TX','CA','CA','AR','CA','CA','CO','CA','AZ','CA',
			'TX','FL','NM','OK','CA','CA','CA','AR','WI','AL','CO','AL','GA','MN','NY','IL','WI','IL','MO','OH',
			'CO','CA','IL','TX','ME','PA','NC','TN','KY','PA','NY','OK','CA','IL','MD','WI','SD','MI','MN','IN',
			'WI','WI','NC','WV','PA','MO','AL','NV','MD','MD','WV','IL','GA','WV','ND','WA','FL','NY','GA','IN',
			'MD','GA','CT','ND','VA','IL','KS','SD','PA','NC','WI','SD','WA','TX','AK','LA','IL','OR','NY','OH',
			'NY','NJ','NC','AL','WI','TX','IL','MO','LA','PA','CA','MI','IL','NV','OH','MN','ND','NC','AR','CA',
			'KY','PA','IA','ID','MD','TX','MI','KS','PA','CA','CA','NY','IL','NC','AR','CO','NJ','IN','NJ','OK',
			'GA','TX','PA','OH','VT','AL','WA','UT','WA','NH','NH','IA','PA','PA','KY','NC','PA','UT','CA','MI',
			'CA','MN','KS','IL','NM','CA','NY','CT','NJ','VT','MI','PA','OR','NM','NJ','AK','FL','CO','SC','TN',
			'LA','NH','IN','GA','NC','PA','WI','OH','KS','OK','OR','TX','LA','CA','AR','TX','FL','SC','CO','PA',
			'NY','IA','IL','IN','MI','WA','AL','IL','WA','VA','HI','NJ','MN','MO','RI','VA','GA','PA','PA','MN',
			'AL','PA','MO','NJ','NJ','CA','AK','OH','GA','IL','WA','KY','VA','VA','ME','MA','PA','PA','NC','IN',
			'PA','CO','NY','OK','IL','WI','NC','WA','WI','MA','CA','CA','WV','NV','PA','VA','TX','KY','CT','MD',
			'MA','VA','TX','OK','NJ','NJ','NY','ND','MN','IL','IA','IN','OH','LA','NJ','NM','MI','NY','IN','VA',
			'PA','MI','MD','SD','PA','AL','NC','MA','WY','PA','WA','MA','FL','OK','PA','NY','MI','MO','DE','IN',
			'MN','FL','NY','NV','ID','TX','VT','UT','VA','MI','MN','MO','NY','CA','MI','WI','CA','VA','KY','IL',
			'MD','PA','CA','CO','ID','TX','WI','MN','IN','NY','VA','KY','NY','MA','RI','MA','GA','NH','CO','FL',
			'AZ','NJ','NJ','SD','MI','KY','TX','KY','PA','GA','KY','NJ','OH','MI','VA','MO','PA','GA','AR','AL',
			'IL','FL','FL','NY','MT','TX','NJ','NY','FL','MO','IL','PA','TX','GA','VA','TX','IN','NY','NY','PA',
			'PA','AL','PA','WI','WI','CA','WI','VA','MO','NJ','AR','MS','NC','CA','OR','MD','NY','CA','MN','GA',
			'CA','NY','MA','CA','CA','MO','VA','NJ','TX','AR','TX','IL','NY','WI','VA','GA','NC','IN','PR','NE',
			'KY','CO','VA','IA','NY','VA','MD','MT','AZ','CA','CA','KY','WY','FL','KS','VA','MO','OH','PA','CO',
			'SD','SC','AL','AZ','NJ','VA','NY','CO','FL','FL','LA','GA','AL','FL','SD','NY','AK','KS','MN','AL',
			'KS','IL','OK','AR','GA','TX','NM','KY','ND','GA','AK','FL','PA','IN','FL','TX','GA','CA','IN','OK',
			'RI','MI','OH','CO','WI','UT','AZ','SC','CA','IN','PA','NC','MI','MI','WA','WI','IL','WI','MS','MA',
			'NH','IN','IN','NH','MI','DE','IL','MA','OH','NJ','IL','NY','LA','NJ','TX','WI','CO','MI','MN','OH',
			'CA','WV','MI','DE','MD','VA','VA','OH','NY','VA','IL','KY','PA','NJ','WA','MO','FL','TX','NY','IN',
			'CA','IN','MO','OR','NJ','ME','NY','CA','CA','WA','NE','ME','PA','TX','TX','MO','VA','KS','TX','MD',
			'CO','IA','FL','VA','CA','TX','KY','AL','NY','IL','NC','PA','AL','AL','SC','MI','FL','MD','VA','KS',
			'CT','ND','MD','CO','OH','TN','LA','NM','OH','PA','OH','NM','CA','IA','TX','NY','MD','TX','WV','NY',
			'PA','KS','CA','KS','IL','ID','CA','AL','ME','MA','NV','AR','TX','NC','NY','KS','IN','MD','OH','NY',
			'VA','OK','NJ','IN','NC','NY','WV','OR','NC','OR','OH','TX','TN','MS','GA','MN','CT','IL','LA','ID',
			'WI','IL','NE','NV','WI','TX','NH','SC','NE','IL','PA','NC','TN','WV','PA','NY','CA','NY','NE','NJ',
			'NJ','GA','MD','OH','PA','FL','NC','TX','PA','WA','AZ','IL','PA','NY','CO','NH','CO','NJ','GA','VT',
			'NH','NH','TX','CA','IL','PA','AK','CO','VA','NC','TX','NJ','MI','PA','WV','IL','KY','NJ','ND','CT',
			'NH','VA','MD','NY','MD','IL','NY','MD','CA','IL','NJ','NY','PA','NY','PA','NJ','PA','TX','NY','IL',
			'ND','IL','CA','IL','MT','NJ','MD','NY','OH','NY','NY','PA','CA','MD','GA','PA','OK','NY','PA','PA',
			'IL','PA','WA','WI','NY','CO','AZ','LA','VA','NJ','VA','OH','VT','NY','MN','MI','KS','IL','TX','KS',
			'NH','WA','OR','CA','CO','AZ','NY','NC','VA','CA','IL','TX','OK','CA','VA','GA','VA','TX','IL','MN',
			'KS','TN','MI','VA','AZ','SC','AL','VA','TX','IL','NY','WV','IN','IN','FL','AR','MI','MO','IN','MS',
			'ND','FL','NH','KY','MO','KS','LA','LA','CA','TX','VT','AL','MI','AZ','LA','ND','ND','MI','NY','VT',
			'CO','CO','MI','MN','TX','MI','OH','OR','TX','CA','PA','MO','TX','MI','NC','IN','ID','CA','IL','WA',
			'NY','VT','AL','IL','MI','NH','NM','OR','IL','UT','PA','IL','TX','WA','TX','MD','MI','CA','OH','CA',
			'PA','AR','MO','MI','GA','SC','MI','IL','GA','GA','MA','KS','MT','IL','NJ','MD','NY','NY','NY','CO',
			'SC','WI','NJ','FL','NJ','AR','MA','MN','WI','PA','CO','AL','MO','WY','IL','CA','NJ','FL','VA','WA',
			'MD','AR','ME','PA','WI','RI','TN','MA','NY','NY','NH','NY','WI','NY','CT','IN','NC','VT','IN','PA',
			'IL','NY','SC','ME','LA','NJ','MO','NY','SC','MI','OH','MS','OR','LA','CA','GA','IN','NC','IA','NC',
			'TN','IA','TX','MI','MI','MI','LA','CT','VA','OK','PA','AL','FL','OH','MO','CA','TX','TX','GA','AZ',
			'CA','CA','PR','CA','LA','NY','NY','CT','AL','FL','AL','MS','CO','VA','CO','MD','TX','AL','MS','AL',
			'IL','CA','KY','OK','IA','TX','OK','PA','GA','MI','PA','PA','MD','CO','CA','LA','NJ','NJ','CT','NJ',
			'NJ','MI','CT','GU','WI','KY','IN','NY','GA','HI','ID','FL','NJ','NJ','HI','WI','MD','CA','VA','FL',
			'TX','ME','TN','MO','KS','TX','WV','LA','CT','MN','SC','IN','PA','LA','NJ','MA','IL','MD','CT','NY',
			'NH','TX','SC','HI','HI','HI','AL','NY','CA','NY','IN','NY','MO','VA','MA','ID','MA','WA','DE','NC',
			'CA','MI','PA','KY','KY','MA','VA','TX','IA','PA','SC','TX','PA','KS','MI','WV','AL','ME','NY','OK',
			'NY','DE','NJ','MN','SD','NY','PA','PA','VA','MO','RI','KY','KY','TN','MI','MI','CT','IN','WI','DE',
			'MO','NY','AL','TN','OH','GA','MA','AL','LA','MA','MA','CT','ND','NJ','NJ','OH','TX','MI','MI','NY',
			'AR','PA','MA','CA','MA','WI','MS','IN','LA','NY','HI','FL','NC','PA','MA','NY','PA','MT','MD','NC',
			'CA','IA','KY','HI','TX','GA','PA','CT','NJ','NY','CO','MA','VA','NC','MN','VA','AL','KS','KS','MO',
			'CA','KY','SD','IL','AL','MI','WI','MO','MS','NJ','PA','AL','WI','CA','AK','TX','MA','AZ','UT','CT',
			'MN','WV','AL','MS','KY','ND','GA','MT','CA','WI','OR','PA','PA','NJ','TX','UT','IN','CA','MI','NY',
			'AL','IA','TN','OK','NH','MN','NC','NY','IL','PA','AR','GA','CA','MO','CA','AZ','NY','NE','MO','MN',
			'OR','PA','NY','SD','CA','NM','FL','VA','PA','IL','MI','IL','PA','NC','CA','KS','ND','NY','TX','NY',
			'ID','IL','FL','GA','IA','MN','NJ','HI','KY','NC','MI','IL','NY','CT','MO','NJ','NY','NC','MO','FL',
			'VT','MD','NY','KY','AL','NJ','NY','IL','TX','MO','NY','NJ','IL','AZ','WI','UT','SD','NY','FL','PA',
			'MI','CO','KY','NC','NJ','NJ','VA','PA','CA','HI','NY','SC','MN','AR','MN','VT','GA','MA','NY','OK',
			'ME','TX','VA','TN','WI','NJ','IN','NM','FL','NJ','MT','NC','DE','TX','KY','AL','MN','IL','GA','TN',
			'AZ','KS','WI','LA','OK','NH','NE','OH','PA','FL','MI','NY','NY','PA','NY','ME','MO','MA','NM','MI',
			'NC','MS','FL','NJ','WI','PA','FL','MN','OH','MI','KS','MO','NY','CA','PA','HI','CO','CA','AK','OH',
			'IA','IL','CA','OK','FL','HI','TX','SC','NY','NY','PA','PA','IA','TX','UT','HI','HI','MI','OR','WA',
			'NC','TX','NH','PA','HI','UT','IL','NY','NJ','ME','AL','NC','RI','OH','IL','NY','MN','KY','IA','CA',
			'PA','WA','ND','WI','MS','NY','KY','NC','NY','AR','PA','AL','WI','GA','SD','AR','AR','MI','MI','MS',
			'WI','LA','MA','MO','TX','MO','PA','NY','MI','MN','MI','SD','FL','OH','MA','NC','WI','VA','IL','NY',
			'MI','TX','SC','AR','MD','CA','NY','CO','MI','GA','ME','MA','TX','TN','VA','IA','PA','PA','MD','NY',
			'NC','IN','IN','PA','PA','WV','CA','PA','CA','NY','MI','MD','IL','VA','AL','NC','FL','NM','NY','MD',
			'OH','WV','TX','WI','KS','TX','WV','MA','MA','MD','UT','MD','VT','UT','MI','OK','ID','ID','CO','TX',
			'IN','AL','CA','CO','MD','NY','IL','WA','MI','NJ','PA','FL','CA','CA','GU','NV','KY','OK','FL','MD',
			'CO','MA','MI','FL','OH','NC','ID','CA','PA','IN','WA','CA','PA','TX','IN','IN','IL','CA','TX','MI',
			'SC','OK','FL','MI','MN','NH','MN','FL','WV','CA','WI','CA','MI','LA','IA','IA','TX','MA','TX','VT',
			'WI','SC','MI','WI','OH','NJ','MI','MN','MI','CA','TX','NY','PA','PA','MN','NJ','MI','FL','NJ','IL',
			'NY','VT','NY','VT','SC','CA','NY','NY','MS','WA','MD','IL','NY','IL','UT','VA','CT','VA','TX','MS',
			'OH','NY','FL','FL','IL','MN','NH','NY','MA','MO','NY','OH','NY','PA','CA','WV','WI','LA','MD','IN',
			'IN','OK','NV','LA','PA','IA','TN','NY','VA','OH','GA','NM','AL','OH','MI','KY','PA','OK','CA','UT',
			'FL','NY','PA','NJ','PA','IL','MD','IA','KS','OH','CT','WI','PA','NJ','TN','MI','SC','VT','TX','WI',
			'NY','IA','IL','NY','AR','IL','CA','OK','ME','TN','ME','TX','VT','MO','MD','MN','NY','TX','CA','TX',
			'TX','PA','GA','TX','KS','CA','WI','PA','NE','OR','FL','IL','TX','HI','HI','HI','HI','HI','HI','MI',
			'MT','MI','UT','ID','HI','PA','HI','IL','NC','KS','IL','KS','WI','HI','HI','HI','IL','TX','AK','MN',
			'MN','GA','NY','TX','TX','WI','HI','AZ','UT','HI','HI','NJ','MO','NJ','NJ','HI','KS','MD','MI','VA',
			'CA','NY','CO','NY','LA','HI','IL','TX','ID','LA','CA','TN','TX','PA','WY','TX','TX','IL','AK','NC',
			'VA','NJ','IN','ID','TX','NJ','WA','WV','NE','ME','ME','TX','LA','GA','MO','PA','WA','MI','WI','MD',
			'OH','MI','CA','OH','VA','LA','NJ','CA','MN','AR','IA','WV','NY','CA','NC','TX','CO','WI','VA','AK',
			'ID','WA','NY','KY','NY','MI','IL','IN','WI','WI','FL','FL','FL','FL','MD','NJ','NE','FL','VA','NY',
			'WI','WI','HI','HI','TX','NC','OH','TX','AL','VT','CT','MS','SD','MO','WI','PA','IN','KY','IL','MI',
			'NY','NC','VA','CA','AK','VA','PA','AK','VA','OK','KS','GA','CA','OH','NC','NY','CA','TX','MI','GA',
			'PA','TN','IL','TN','MO','MI','OH','NC','PA','CO','TX','IL','KY','MO','NY','PA','NM','FL','ME','CO',
			'NC','OH','NC','OR','AK','WI','NC','CA','IN','TX','MO','NC','IN','IL','AK','WI','IN','HI','CA','MS',
			'TX','IN','WI','SD','OK','CO','TX','TX','HI','PA','PA','ID','PA','NC','HI','PA','TX','PA','PA','CA',
			'WA','WA','MN','CA','WI','KS','NY','TN','IN','OR','CA','IL','CA','CA','CA','PA','CO','TX','CA','CA',
			'MO','IA','CA','OR','LA','MO','TX','CA','CA','MI','TN','UT','CA','TX','CO','NE','MO','FL','WA','PA',
			'LA','NH','CA','IN','SC','FL','WI','LA','PA','IL','IN','NY','CA','CA','CA','CA','HI','PA','WV','HI',
			'MI','TX','MI','FL','MI','PA','CA','MN','IL','FL','LA','CO','MN','TX','MN','VT','CA','CA','WI','CO',
			'NY','FL','PA','AZ','FL','NJ','NJ','CA','IL','CA','TX','NC','NY','FL','WI','OH','MI','MI','OR','MO',
			'FL','GA','NY','NY','MO','CA','IN','WA','WI','NY','IL','IN','FL','FL','IL','WA','NJ','FL','CA','CA',
			'OH','MI','IN','NY','AR','MI','TX','NV','IA','FL','ND','TX','MO','PA','NM','IL','CA','WI','PA','WY',
			'NJ','PA','PA','SC','MA','VA','PA','SC','MD','WI','NJ','PA','PA','MI','ND','MI','IN','MI','CO','MO',
			'WY','NY','TX','PR','FL','ND','CA','LA','WI','TX','IN','NM','NV','TX','TX','NY','CA','PA','SC','MS',
			'FL','FL','NV','TX','MD','VA','FL','OH','SC','NC','PA','AR','WV','NJ','AZ','TX','GA','HI','CA','NJ',
			'PA','IN','GA','MO','FL','OK','UT','IA','IA','IL','CO','IL','TX','TX','KS','MO','KS','FL','LA','KS',
			'TX','PA','MT','NJ','CT','IL','NY','AL','NJ','MO','VA','PA','LA','MO','OH','UT','FL','PA','PA','MA',
			'AL','OH','MI','CA','IL','CA','PA','LA','PA','PA','SD','NC','TN','MI','MA','IL','IN','PA','MA','KS',
			'MI','NJ','MD','NJ','AR','MI','MO','UT','ME','TX','AK','MA','PA','DE','CO','OH','PA','OH','NY','PA',
			'TX','KY','MD','MT','KS','TX','OH','NJ','TX','WA','MD','IL','LA','MO','VA','FL','VA','PA','HI','GA',
			'NC','GA','NY','ME','TN','ME','NE','NJ','PA','NY','IL','GA','ME','IL','NJ','TX','TX','NY','NJ','NY',
			'UT','NM','OK','KS','OH','MN','PA','AL','WV','MO','MD','IN','NC','MI','TX','ME','ME','IL','OH','AZ',
			'FL','GA','GA','OH','PA','WI','RI','DE','TX','NY','NJ','OH','SC','NY','SC','AR','NJ','NY','NJ','TX',
			'CA','PA','CO','CA','IA','ME','PA','TN','NY','MI','GA','IL','NY','PA','NY','CA','TX','KY','IA','CA',
			'NC','PA','VA','VA','NY','CA','OH','NV','IN','PA','PA','CA','CA','IL','WI','CA','CA','AR','NH','MO',
			'TX','CA','IA','MO','CA','NJ','MD','IA','VA','NY','MN','MO','IL','PA','MN','NJ','FL','MA','CO','NJ',
			'KS','TX','LA','FL','AR','MN','IN','TN','CA','WA','TX','MO','OH','TX','TX','MN','MS','VA','CA','CA',
			'CA','CA','CA','TX','CA','NM','CA','CA','IA','IL','MD','VA','CA','TN','OH','VA','KS','KY','GA','OH',
			'WY','IL','VA','VA','IL','MA','SD','AL','ID','VA','MO','FL','AL','WI','PA','IA','TX','OH','MS','CA',
			'PA','ID','MI','MA','GA','TX','SC','AZ','TX','NJ','PA','MI','MA','MI','VA','MD','WY','LA','OK','MD',
			'TN','FL','MN','WI','PA','TN','SC','NH','NY','NE','VA','NH','PA','WA','NJ','KS','WI','NY','MA','FL',
			'MA','WA','CA','MS','IL','TX','HI','TX','AR','GA','WA','FL','NY','OH','IL','ME','ME','PA','MI','IL',
			'MI','OH','MI','GA','PA','CA','OK','TN','VA','MN','TN','OR','IA','CA','MS','UT','MS','AL','IL','NY',
			'NY','NJ','NC','VA','OH','PA','FL','KS','IL','HI','FL','ID','NJ','TX','NE','MA','CA','OH','MT','WI',
			'IL','AR','NY','NY','CA','LA','WV','NJ','VA','NJ','VA','WI','MI','TX','KY','VT','ND','ND','LA','NY',
			'KS','CA','PA','AR','IN','MI','MI','IL','MI','CO','WI','MN','NY','OK','SC','PA','MA','TX','NY','TN',
			'CT','WA','MS','CA','IL','NJ','MI','MN','NJ','ND','RI','LA','NC','MI','OH','KS','MN','IL','MN','NJ',
			'WA','IL','RI','NJ','PA','OK','AZ','FL','AR','GA','MA','MD','MI','CA','FL','OR','PA','NY','OH','NY',
			'FL','NJ','FL','WI','AZ','NY','NY','CA','CA','IL','MN','WI','IL','PA','CA','IL','IN','CA','IN','LA',
			'OK','VT','MA','OK','NJ','NJ','MI','MI','LA','MD','PA','NC','IL','CA','IA','MO','NC','MA','NE','IA',
			'MO','OH','MT','TX','CA','WV','VA','IL','AR','FL','DE','NY','MO','MD','OR','WA','TN','FL','IL','MA',
			'WI','IL','WV','NY','NY','NY','NY','NY','MD','OH','NY','NY','PA','NJ','CA','CO','AL','FL','WA','MA',
			'MA','WA','ME','MI','IL','NC','NY','IL','IN','MD','SC','OH','AR','HI','OR','LA','WI','IA','PR','NY',
			'MN','UT','AR','AL','MA','TN','FL','TX','NJ','GA','WI','MO','MN','WI','IL','NJ','PA','FL','ID','MS',
			'AL','TX','KY','IA','SC','SC','PA','IN','SC','AR','OH','TN','WI','VA','AR','NC','NY','TX','MD','GA',
			'PA','PA','AL','TX','VA','IL','NC','KS','TN','GA','PA','PA','OK','TX','CA','WA','CA','MS','MD','GA',
			'IL','WA','CA','OK','OR','KS','WA','WV','CA','MS','GA','NC','CA','ME','PA','VA','NY','MI','IN','MA',
			'MN','PA','WA','OH','IL','IN','MA','OK','FL','FL','VA','TX','FL','IL','MI','MI','TN','AR','TX','WI',
			'MS','NJ','CA','MI','IL','CA','CA','ND','MI','WI','WI','IN','OH','WI','LA','CA','PA','WA','PA','NH',
			'NY','KS','ID','AL','PA','GU','TX','OR','IN','NY','VA','WI','IN','MA','NH','MI','FL','NC','WI','PA',
			'AZ','MI','TX','MO','LA','IL','MA','IL','GA','NJ','TX','NY','PA','CA','FL','FL','FL','OH','WA','IN',
			'TN','MI','NJ','TX','NY','CT','NY','OH','MD','NY','MA','WV','OH','FL','NY','IN','OH','OH','KY','NJ',
			'MA','CT','VT','MI','TX','AL','NJ','MD','UT','AL','CA','NC','OK','PA','PA','PA','MN','TN','SD','ME',
			'MT','MI','HI','WA','PA','NY','CA','CA','AL','NJ','MA','GA','GA','MO','IL','NY','IA','MD','NY','TN',
			'CO','NJ','ME','MA','WY','DE','IL','IN','CA','NY','NJ','GA','ME','CA','WA','OR','MN','WI','FL','NV',
			'WI','NJ','NY','VA','WI','OH','AR','WV','UT','OH','NY','OH','IL','MN','FL','MN','MN','NY','WI','WI',
			'IL','ND','ND','NJ','OH','CO','CA','NH','IN','WI','TX','CA','CA','MS','MT','TX','IA','IN','NJ','UT',
			'MO','AL','NC','IA','NY','CA','SC','CO','CA','OH','AZ','MI','NY','PA','PA','CA','CA','IL','OR','GA',
			'IL','FL','UT','PA','TX','WV','SC','OH','NC','WI','IL','VA','MO','GU','MD','OR','NJ','NJ','PA','MA',
			'NC','MO','NJ','AL','CA','NY','ME','PA','NH','MI','TX','CA','NY','DE','NJ','CO','TN','CA','CA','CA',
			'WA','AL','KS','AL','MD','PA','IA','PA','VT','MO','MN','VA','VA','FL','CT','CO','CT','AL','NY','NY',
			'NJ','WY','MT','WV','IN','NC','NJ','NC','MN','LA','CA','PA','CT','NM','CA','PA','NY','KY','NC','GA',
			'AZ','CA','VT','TX','LA','CA','KY','NC','WV','NJ','NM','NY','AZ','KY','AR','MI','ME','AR','AL','TN',
			'NJ','CO','WI','FL','TN','PA','CA','OH','LA','MO','PA','IL','GA','CO','AR','MO','VA','WA','PA','OR',
			'WI','CA','MS','WA','AL','NH','GA','MN','SD','KS','WV','AL','MD','OR','NJ','CA','PA','TN','MI','OH',
			'ME','FL','NJ','NJ','OH','CA','NC','PA','KS','WI','AR','VA','PA','TN','NY','NJ','AZ','WV','MI','NC',
			'WV','MS','OH','OH','TN','PA','IL','IL','MD','NJ','MD','CA','NY','KY','NJ','NY','WA','OH','NY','KY',
			'CA','TN','NY','MO','ID','ID','MN','NJ','AR','PA','MO','NJ','NY','WA','PA','VA','IA','IL','NC','CA',
			'IL','TX','WA','WI','FL','IL','KY','AL','OR','NJ','MI','SC','KS','IN','PA','IL','TN','KY','MI','MI',
			'MI','OH','IN','TX','SD','KS','NC','NC','CA','IL','NE','IL','SC','CA','PA','ID','IA','AL','WI','GA',
			'WI','MI','OK','MI','OK','FL','PA','MD','KY','MO','SC','OR','CT','WA','IL','TX','NC','MA','ID','KY',
			'MD','PA','MA','NY','CA','WA','IL','FL','MI','IN','PA','RI','VA','NY','PA','WA','WI','OH','NH','TN',
			'MN','DE','TX','MS','LA','CO','MA','CA','NJ','PA','VA','MI','CT','TX','OH','TX','NJ','PA','NC','NE',
			'CO','NY','MA','MA','CA','TX','WI','MI','OH','OR','NE','WI','WI','NE','NV','VA','OH','TX','AK','KS',
			'IL','IA','WI','UT','NJ','FL','MN','MS','NY','NJ','PA','KS','NJ','MN','WV','MO','CA','IN','PA','CA',
			'WI','IL','MI','MA','IL','NC','PA','MO','NH','MA','TX','CT','AL','NJ','MI','KS','CT','TX','OH','PA',
			'VA','NY','PA','OH','PA','IL','NH','PA','NJ','SC','PA','MI','CT','PA','WI','PA','PA','WI','ME','NJ',
			'NY','NY','CT','NC','PA','WI','PA','MI','NY','LA','NH','PA','VA','OH','IL','OH','WI','WI','MI','MO',
			'AL','WV','MD','CT','WI','LA','PA','IN','NY','PA','OH','ID','FL','MN','CT','PA','MN','OH','PA','AZ',
			'LA','NY','ND','IN','FL','PA','ME','MA','PA','MN','NJ','IA','TX','PA','IL','NY','NY','OK','NJ','NY',
			'OR','TN','FL','MD','NY','MA','CA','MA','WA','NY','AL','NY','NY','NH','NJ','CA','NH','OK','NC','LA',
			'CA','WA','PA','NH','GA','AR','CA','CA','VA','NJ','MA','MA','NH','MA','MA','NY','CT','PA','PA','WI',
			'NY','NY','IL','CA','FL','KY','NY','GA','NY','KS','MN','OK','MI','WV','WA','IN','AK','NE','CA','MN',
			'WV','NY','CO','MO','OK','ME','IN','AZ','VA','IL','TX','TN','AK','MA','MO','LA','GA','VA','AR','AL',
			'OK','GA','NJ','IL','ME','TN','PA','MI','MA','ME','NJ','MA','SC','IL','NY','OH','MD','OH','VT','NJ',
			'ME','MD','MA','OH','MI','CT','MA','NJ','CT','MA','SC','MA','MA','IL','NY','VT','NH','MA','MA','PA',
			'MA','IA','MA','VT','CA','FL','CT','WI','MA','CT','CT','NH','VT','MA','ME','VT','CA','CA','CA','VT',
			'OH','IN','RI','WA','NV','FL','OH','IA','OH','AR','IN','MA','WV','FL','FL','ME','VT','SC','OH','MA',
			'FL','OR','NE','AK','VT','FL','WI','RI','MA','FL','TX','OH','OH','IN','UT','RI','SD','RI','CT','NY',
			'VT','MA','MA','IN','PA','ME','ME','IN','NC','CT','ME','MA','MA','MA','IL','ME','OH','CT','IL','NY',
			'CA','NJ','SD','ND','MA','KS','IA','ME','MA','CT','PA','AL','OR','IN','NH','CA','OH','MI','OK','MS',
			'PA','CA','MI','CO','TX','NJ','NY','IL','MA','IL','WI','IL','AR','VA','WA','OH','CA','NC','IL','IL',
			'NJ','CA','PA','GA','MA','CA','NJ','IN','NY','FL','MI','NJ','PA','VA','PA','NY','VA','CT','GA','KS',
			'TN','FL','CA','VA','NY','MA','MD','NJ','NJ','NC','WA','WA','MS','DE','WV','CA','NJ','CA','NJ','GA',
			'FL','FL','WI','WI','NC','IA','IL','TX','MD','AL','TX','IL','IN','NE','NE','UT','NY','WI','MN','IL',
			'GA','ME','AL','PA','VA','CA','WA','OK','WI','OK','OH','FL','OK','OK','MI','OK','OK','IA','WA','ME',
			'KS','NY','NJ','NY','WV','PA','CT','TN','CT','MI','CT','ME','CT','ME','NY','PA','FL','NJ','MO','PA',
			'WA','MS','TN','MI','MN','OH','IL','CO','WA','IL','PA','NE','GA','WI','WV','WA','VA','IL','MI','NY',
			'AL','SD','MI','MI','CA','TN','WI','FL','IL','AL','LA','CO','AL','NJ','TX','AL','IA','CA','TX','FL',
			'NY','CA','IL','IL','WA','MI','NY','CO','TX','PA','IL','OR','OH','PA','UT','WV','SD','CA','NY','ME',
			'IL','FL','VA','MA','FL','WA','ME','MN','CA','ME','ME','PA','OH','WA','MI','OH','PA','MO','MN','KS',
			'WI','IL','MI','IN','WI','MI','FL','MN','IN','NY','NH','PA','MA','OH','NY','MS','NY','WA','MA','WA',
			'IN','NY','MI','OH','MI','MI','IN','MN','MO','PA','IA','NV','NY','FL','OK','MN','NY','AL','KY','IN',
			'KY','MD','MD','ME','MI','NV','MA','CA','MD','NY','MO','NY','HI','MO','CA','CA','CA','WI','CA','SC',
			'KY','VA','AS','CO','HI','NV','HI','TX','MI','OH','NY','KY','CA','IL','FL','NY','ME','TX','CO','NY',
			'NJ','PA','FL','FL','FL','FL','CA','FL','CA','CA','TX','CO','PA','GA','MO','IA','CA','CA','TX','IL',
			'CA','IL','IL','IL','TX','SC','IL','OK','FL','FL','CA','KS','PA','NE','CO','CA','AZ','IN','AR','CA',
			'NJ','WI','MO','NY','UT','WI','IL','MD','MO','MN','IL','CO','IN','PA','WV','PA','VA','SD','MD','MD',
			'NJ','MO','FL','NJ','WV','MD','ME','CA','MS','WA','RI','CA','MS','NJ','VT','OH','NY','NJ','FL','ME',
			'NY','NY','MO','MD','AZ','OH','LA','IA','NJ','CA','NY','NC','MI','CT','OK','VT','SC','NY','IL','RI',
			'MA','ID','OH','MN','AZ','AR','MA','PA','GA','ME','NJ','CA','AR','VA','HI','HI','LA','TX','TX','MN',
			'CA','IL','KS','PA','NY','MO','NJ','OH','NY','TN','IL','MS','NY','SC','AL','IA','MI','SC','NJ','ND',
			'NH','FL','PA','GA','KY','NY','VA','OH','ND','VA','PA','CA','NY','NY','FL','CA','TX','MN','NJ','PA',
			'NJ','WV','PA','NJ','PA','IN','CO','CA','FL','MI','AZ','IA','IL','TX','MA','NJ','PA','MN','NM','IL',
			'MN','AZ','PA','OK','MS','VT','PA','TX','NJ','CA','FL','MD','OH','TX','MD','NJ','IN','CA','MS','CA',
			'NH','IN','MI','PA','MO','WI','KY','CO','NC','TX','TX','CA','NY','AL','AL','PA','WV','MT','WI','NJ',
			'IL','OR','VA','KY','ME','MD','PA','MS','OK','OH','WI','MI','TX','CA','PA','SC','IN','NY','OH','SD',
			'MI','NY','TN','AL','MD','TN','KY','PA','MN','CA','MO','NC','TX','AZ','MI','IL','CO','AL','NJ','AR',
			'NJ','NY','MN','CA','PA','NC','NY','KY','CT','GA','NY','CA','ID','FL','AZ','PA','TN','NC','MS','CA',
			'AZ','AL','KY','NV','CA','TX','PA','MN','OH','NJ','NY','AL','NC','CA','NY','NJ','IN','TX','PA','VT',
			'NY','PA','NJ','VA','CA','CA','NM','WI','OH','NJ','MT','NJ','TX','CT','MI','NH','TX','FL','FL','TX',
			'CT','LA','MO','NE','MO','NY','WI','MO','NY','NE','CA','NC','AL','PA','OR','MO','IN','OH','IL','WI',
			'MI','CT','TN','CA','NJ','MT','WI','NJ','SC','AR','VT','PA','MA','AR','ID','OK','MD','PA','PA','PA',
			'NY','NC','MO','PA','CA','MD','PA','CA','WA','ME','PA','IA','LA','CA','MT','SC','PA','CT','CT','CA',
			'FL','NY','NJ','NJ','OK','PR','LA','NY','TX','ID','MN','FL','FL','MI','MS','GA','MD','TX','NC','CA',
			'MT','MO','IL','MS','CT','VA','PA','LA','WA','TX','TX','TX','IL','FL','NY','OH','NY','MD','WI','NY',
			'WA','WA','VA','CA','CA','MI','TX','NY','NY','TX','WA','PA','NJ','NJ','TX','FL','WA','NJ','NJ','FL',
			'SC','FL','LA','MD','WA','WI','PA','MO','MO','GA','NM','ME','NY','WI','CA','OR','CA','VA','MI','TX',
			'ID','IA','OK','MD','WI','NY','MI','TX','PA','PA','NY','NY','WA','VT','VA','NY','VA','CA','GA','CO',
			'TX','TN','NC','VA','WI','NE','SD','IN','WI','WI','AR','LA','CA','AL','AZ','AZ','MI','PA','WA','KS',
			'UT','WV','LA','MA','MD','VA','MD','NJ','NJ','HI','OR','SD','MN','WV','VT','OH','IA','PA','ME','IL',
			'NC','PA','TX','SC','WA','RI','MA','UT','OK','CO','HI','VA','WA','FL','PA','OK','VA','NY','NE','NY',
			'TX','MS','CT','FL','NY','VT','HI','MO','WA','MD','CT','PA','VA','OK','PA','VT','AZ','NY','NY','MD',
			'MI','CT','TX','MI','KS','VA','AR','NY','GA','KY','LA','WI','KY','VA','OH','NC','AL','LA','IN','NJ',
			'TX','AL','NY','OR','AL','NC','CO','CA','NC','NJ','CA','CA','CA','CA','CA','CA','CA','TX','NM','NJ',
			'IA','MD','NC','UT','TX','WI','CO','IL','TX','WV','IL','MI','IL','NJ','ID','NM','NY','OH','WA','WV',
			'MD','WY','MI','OH','OH','MO','MO','LA','MA','MA','ME','PA','WI','MA','TN','AR','NJ','AL','CA','TN',
			'IL','CO','PA','NY','PA','GA','NM','TX','NC','MN','GA','IL','CT','CT','CT','SD','NY','CA','IL','WA',
			'WA','CA','CA','CA','CA','PA','CA','MO','WI','PA','VA','WV','IN','MI','WI','TX','GA','NY','MA','DE',
			'NC','IA','PA','MD','TX','SC','VA','NY','NY','PA','NV','IN','NY','WA','MN','OH','GA','CA','CA','LA',
			'VA','MA','GA','ID','NY','GA','OH','NY','WI','VA','OR','TX','CA','WI','MN','WI','TN','TX','TX','ND',
			'PA','SC','MT','OH','NY','VT','IA','WI','TX','NC','PA','IN','GA','MS','IL','OH','OR','TN','MD','MD',
			'SC','CA','CT','NJ','MS','WV','MD','TN','SC','SC','NJ','PA','PA','PA','NC','CO','NY','MI','ID','MI',
			'VA','PA','CA','GA','NH','VA','KY','VA','WI','NJ','PA','IL','WI','NJ','TX','CA','TX','CA','NM','AZ',
			'AZ','CA','TN','CA','VA','ID','GA','TX','MD','AR','MD','NJ','WI','IL','IL','TX','MI','CA','MD','NY',
			'IA','WY','FL','MI','TX','VA','VA','NC','KY','LA','LA','GA','WI','AL','MO','PA','IA','IL','MS','WV',
			'TX','NE','MA','IL','NJ','MO','MN','WA','MI','IL','OH','IL','NY','IL','MO','WY','WI','NY','NJ','OR',
			'NY','OH','TX','KY','TN','NC','DE','FL','CA','GA','TX','IL','TN','MD','NY','TX','NC','TN','MO','GA',
			'CO','NJ','NC','NY','MD','OH','CA','NY','NJ','SC','MN','MI','MO','OR','CA','MD','AR','NC','MO','MS',
			'CA','IL','IN','MN','NH','CO','TX','AR','NY','MI','IL','IN','MI','WA','NY','PA','IL','NY','PR','TX',
			'KS','CA','TX','NY','MI','MI','KS','NC','TX','OR','NY','VA','IL','NJ','CA','NJ','MN','TX','WI','MI',
			'TX','AR','MA','NY','NY','CA','OH','PA','GA','GA','MN','WI','FL','NY','NC','CA','VA','IL','SC','TX',
			'NY','NY','MA','CA','TX','MA','NC','ME','MA','UT','AR','MI','FL','PA','TX','GA','WI','VA','OH','MI',
			'PA','ND','NM','NM','RI','CA','NJ','IA','NJ','CA','ID','NC','VA','PA','NY','MN','UT','MN','PA','MO',
			'TX','KY','OH','AR','IN','VA','LA','VA','CA','NC','VA','MA','GA','NH','NH','OK','ME','MD','MN','TX',
			'AZ','ME','CA','NJ','NJ','KY','PA','FL','AZ','NY','MA','NY','MI','ID','MI','AZ','MO','LA','MO','IL',
			'ID','FL','LA','MN','ID','MN','MI','OH','MN','WI','ME','LA','LA','UT','DE','WI','TX','MI','CA','SC',
			'OR','OH','MI','MD','IL','MN','IN','ND','MI','VT','NY','MO','MD','MO','ID','LA','GA','MD','SC','ND',
			'AZ','OH','MN','MN','NC','MN','MO','FL','MT','LA','GA','PA','MO','MP','TX','NY','AK','GA','TN','MA',
			'CO','KS','CA','MI','NH','NY','OK','UT','NY','MS','KY','WA','AL','NM','CA','TX','CA','TX','TX','TX',
			'CA','CA','AZ','CA','CA','CA','CA','CA','CA','PR','CA','CA','CA','CA','PR','CA','CA','CA','CA','CO',
			'CA','CA','CA','CA','CA','CA','CA','CA','CA','CA','CA','TX','CA','NY','NH','NH','WV','MI','OK','FL',
			'GA','TX','NM','IL','NH','ID','VA','MN','OH','IL','UT','NY','CT','PA','NC','MD','WV','CO','CA','FL',
			'CA','CA','CA','CA','IN','CA','TX','CA','CA','CA','CA','CA','GU','CA','FL','NM','CA','CA','UT','CA',
			'OK','AL','MI','FL','TX','NY','OH','MS','WI','MN','PA','FL','FL','MS','MI','NY','MA','MN','WI','MI',
			'RI','NY','CA','GA','MN','GA','MA','VT','PA','PA','NJ','NY','IL','MN','WI','OR','ME','NY','PA','NY',
			'IL','NY','NY','IN','TX','IL','PA','NY','WI','HI','NY','MI','LA','NY','TX','NE','NY','NY','PA','PA',
			'OR','PA','IN','MA','NJ','CA','CT','NC','PA','AR','IL','KS','WV','MI','CA','NE','AL','IN','AZ','KY',
			'MI','PA','TX','NY','NJ','GA','NJ','WA','SC','NY','TX','CA','ME','ME','TX','OH','NV','AR','ME','ME',
			'CA','NJ','NJ','WA','WA','ME','FL','CA','KY','OH','NJ','AL','MO','KS','KS','AZ','WA','MA','CA','FL',
			'TX','WA','DE','NY','MI','PA','NY','IN','PA','AL','TN','MS','FL','AL','MO','MS','MO','NY','GA','WA',
			'IA','NJ','IL','OH','NC','PA','CO','MD','MD','KS','TN','OH','TN','PA','NJ','NJ','PA','WI','IN','IL',
			'PA','OR','MD','WV','OH','MN','CA','MN','FL','NC','PA','PA','NY','PA','GA','ME','MA','OH','PA','KS',
			'FL','MD','PA','MD','PA','CA','OH','CA','PA','SC','WI','ME','OK','KS','PA','WI','WI','VT','OH','MO',
			'VT','MT','MI','TN','IA','VT','VT','MA','WI','ID','IA','PA','NY','CT','IA','WV','NY','MI','WV','KY',
			'TX','MA','NY','AR','CT','CA','PA','IL','IA','OR','MN','PA','OH','CA','PA','CA','WV','WI','VA','PA',
			'IN','MA','PA','IN','PA','NY','NY','WA','NJ','NY','ID','WY','AZ','OH','LA','PA','NY','NY','MA','MA',
			'MO','NJ','OH','CA','CA','AZ','PA','TN','MO','AL','NC','AR','TX','CO','WA','NM','GA','NH','MD','FL',
			'CA','WA','SC','CO','OR','IL','CA','PA','KY','CT','WV','IA','IA','SD','PA','SD','OR','AK','MI','NY',
			'NJ','PA','VA','IL','ME','NC','PA','LA','NY','PA','TX','LA','MN','PA','LA','WI','NY','NY','NY','CA',
			'AR','CA','TX','UT','AL','KY','MD','IL','NY','TN','PA','GA','NC','GA','WA','WA','MD','PA','CO','CO',
			'TX','WI','GA','NM','CA','TN','NY','NY','CA','WI','AK','PA','CA','KS','MD','IA','IN','CA','NJ','CT',
			'NJ','MA','NH','AZ','MA','CA','IL','CA','CA','GA','CA','FL','PA','NY','TX','IA','NJ','VT','FL','OR',
			'IL','IN','ME','NY','VA','NJ','VT','NY','ME','OH','ME','MA','MA','MA','MA','MA','CA','IL','CA','CT',
			'NY','MA','NJ','MA','MA','MA','MI','VT','VA','IL','KS','UT','CT','CA','MA','OH','MI','NC','WI','PA',
			'NJ','MA','NY','NY','TX','ME','PA','CA','IL','TN','NJ','OH','ME','KY','WA','MI','NY','NJ','MI','VT',
			'MN','NY','CA','NE','ME','OH','NY','MA','OH','MA','MO','KY','CT','CT','VT','MA','PA','MS','MA','MA',
			'CT','PA','NC','MI','NY','MI','CT','TX','NY','NC','WV','ME','MA','WA','MI','WA','WA','UT','AL','NY',
			'NV','MD','NY','MD','NJ','SC','PA','SD','LA','TN','OK','NY','NY','IN','NY','OK','VA','IN','MN','TX',
			'NC','PA','ID','OK','TX','NH','WA','WI','NJ','VA','NY','CA','TX','TX','NY','PA','NV','WI','IL','FL',
			'NC','PA','MI','PA','MN','OH','PA','AR','OK','IL','AZ','MA','NY','LA','TX','IN','PA','IN','NY','NC',
			'WV','CA','VI','VI','NY','MN','KS','CT','KY','CT','KY','AR','VA','MN','MI','NC','CA','NY','NJ','NY',
			'KY','WA','MN','AL','ID','AR','VA','MN','VT','MS','PA','IA','PA','MS','NC','AR','NV','NY','GA','NC',
			'VA','OR','CO','NC','AL','IL','ME','IL','WA','NC','NC','MS','AR','VA','MI','NY','TX','VA','TX','NY',
			'MI','AL','ME','WI','ME','OH','PA','WI','MD','CA','MD','CA','MS','PA','NJ','MN','IN','MA','IL','OK',
			'KS','CA','NJ','GA','TX','PA','NJ','CA','NH','NC','NJ','GA','NY','MA','LA','CT','NY','NY','OH','IA',
			'NY','CT','MO','WI','MO','MA','VT','MO','OH','CT','NH','NJ','CA','CO','CA','TN','IL','MD','TX','OH',
			'ME','OH','OK','PA','WI','OH','OH','NY','FL','VA','CA','VA','MA','WI','MN','KY','WI','AR','NY','WI',
			'KS','OR','NJ','MA','MD','NY','CT','VA','IL','NH','TX','NY','TN','GA','OH','PA','FL','CA','MD','IN',
			'SC','LA','TX','WA','VA','PA','NC','CA','FL','AR','TN','SC','NJ','PA','WV','ME','PA','MS','SC','AZ',
			'FL','AZ','WI','ID','NH','MT','PA','MA','MI','CA','NY','CA','CA','TX','FL','MO','TX','CA','NE','NC',
			'WA','CA','WI','AZ','ND','ME','CA','PA','WI','VA','OR','CA','CA','MA','MI','GA','GA','MA','NC','MA',
			'MD','NH','PA','MI','NJ','TX','OR','MO','PA','AL','TX','PA','IA','VA','IL','ND','MD','AL','CA','NC',
			'OH','GA','NY','NY','VA','IA','NC','WA','CA','PA','CT','OK','CA','CA','CA','WA','MD','OK','TN','LA',
			'MD','AL','FL','GA','AL','FL','OH','NY','IL','PA','FL','PA','IL','FL','IL','GU','NH','MD','FL','NY',
			'NM','VA','NY','NC','CT','FL','NY','CA','IN','PA','MA','FL','FL','MI','TX','KY','IL','SC','MN','KY',
			'IL','VA','SD','TX','NJ','UT','MA','WV','OK','CA','NE','TX','PA','IN','CO','CA','AZ','MI','PA','CA',
			'MD','CA','TN','NJ','WA','NJ','TX','TN','IN','TX','CA','OH','IN','OR','TX','MS','CT','NM','WY','MA',
			'TX','TX','OK','NM','WV','AZ','OR','VA','CA','AL','WY','VT','LA','MN','NY','WI','CT','NC','ND','NY',
			'TN','PA','NY','IL','FL','VA','PA','MA','TX','IN','OH','NY','NJ','AL','CA','CA','NJ','MI','CA','PA',
			'IA','MD','OR','LA','NY','OH','GA','WI','NM','OR','AR','OR','NY','OH','NC','CO','MP','IL','PA','OH',
			'IN','AL','NJ','RI','NY','VA','NC','PA','GA','IA','AK','AK','TX','OH','CT','AZ','ND','CA','CA','TX',
			'WI','WI','CA','TX','AZ','NM','NY','NJ','NY','AL','KS','OK','AZ','AR','UT','MS','CA','IN','CO','VA',
			'MA','ME','PA','UT','OH','CA','NM','CT','NJ','NJ','KS','MT','NJ','PA','MD','CA','CA','TN','MD','WA',
			'PA','CA','PA','MD','AR','SC','MI','CA','NY','FL','WI','MS','WI','NJ','CA','WI','PA','PA','IA','VA',
			'MO','CA','NC','CA','GA','HI','WI','TX','TX','NY','PA','OR','NC','VA','OH','CA','WV','MI','AR','NY',
			'NE','IA','AL','NY','NC','OR','AZ','NY','GA','NJ','AZ','CA','WA','SD','TX','TN','NY','OK','MS','PA',
			'GA','CA','MS','LA','CA','ME','MO','MA','PA','ND','AL','MD','IL','AL','AL','AL','CA','OK','NC','NY',
			'CA','CA','ID','MI','WI','CA','OH','WI','GA','TX','PA','MS','MA','GA','CO','KS','OH','CA','PA','NY',
			'KS','AR','NY','AK','CT','VT','IA','TN','KY','MD','OH','PA','AL','VA','MI','IN','MI','GA','NY','MO',
			'NY','OH','CT','WI','TX','MS','PA','WA','ND','CA','PA','PA','MD','NY','MD','OH','MD','VA','MA','IL',
			'IA','PA','TX','TX','PA','MA','CA','LA','WA','CO','NY','NY','AK','GA','NC','PA','NY','CA','MO','NE',
			'CA','OH','NY','NY','CA','PA','WV','AL','MD','TX','MO','CA','NY','TX','CA','IN','FL','TX','TX','AR',
			'WI','NY','IA','CA','OH','NC','WA','IL','MI','FL','PA','TN','OH','WV','SC','NY','WA','NC','MI','NJ',
			'TX','PR','ND','OR','PA','FL','NJ','CA','TX','WA','NY','AL','NV','CA','IL','OH','SD','MI','UT','IL',
			'VA','IL','CT','OR','FL','MO','NY','OH','NY','UT','KY','OH','MS','NY','TX','CA','NY','LA','TX','VA',
			'VA','KY','IL','GA','IL','MA','PR','PA','NJ','LA','AR','AL','IN','KY','KY','CA','NJ','MA','OK','VA',
			'VA','ID','LA','IL','KY','IL','VA','PA','CA','CA','PA','MT','CA','CT','TX','NJ','NY','CT','MA','IN',
			'NY','TX','MN','AZ','NY','KY','NC','MN','IN','NY','SC','OH','OK','PA','NC','HI','ND','HI','HI','HI',
			'HI','HI','HI','NY','HI','MN','WA','VT','IN','NC','MA','OH','OH','IA','NY','AR','FL','ME','MD','OR',
			'IN','NJ','MI','GA','IA','MN','MD','IN','NC','MI','WA','NC','TX','PA','NJ','NY','OR','MS','WA','CA',
			'CA','CA','AR','TX','PA','NH','SC','MA','NE','IL','WI','KS','NY','PA','MN','NJ','IN','OK','NY','OH',
			'MO','NY','PA','MN','KY','AR','AK','MA','MA','NJ','TX','PA','OK','GA','CA','NY','MI','PA','NY','GA',
			'IL','PA','AL','PA','MN','IN','MD','CA','MN','ME','DC','OH','PA','CT','MD','NY','NV','WA','AK','TX',
			'NY','NJ','NY','MS','ME','CT','VT','NM','MI','NJ','IA','NY','MI','CT','OH','NH','NY','MN','GA','OK',
			'IL','AL','PA','CA','PA','MN','FL','IL','IA','IL','WI','OK','IA','WA','WI','WI','WI','NE','WI','OH',
			'WI','WI','IN','NE','IN','TX','NC','GA','MI','PA','MI','GA','PA','NC','WV','MN','NH','TX','PA','CT',
			'NC','MO','MI','SD','AL','CA','NY','FL','NE','MI','TX','AR','KS','WV','ID','WV','OR','NC','CO','FL',
			'MA','MA','MA','SC','KS','VT','VT','PA','OH','OH','LA','WA','NC','MA','NJ','MO','MO','PA','TX','OH',
			'MO','NY','MA','WI','NJ','AL','MI','MA','MA','IA','MA','MA','IL','VT','OH','MA','NY','PA','NH','IL',
			'SC','CT','CA','NY','NJ','MA','IA','VT','NY','NC','NY','MA','ND','ME','AR','IL','MD','VT','CT','RI',
			'PA','NY','VT','CT','CT','NY','AR','NY','NY','CA','NY','MA','NY','OH','UT','ME','RI','IN','IN','NY',
			'WV','OR','NJ','VA','MA','AR','PA','NJ','OH','LA','NJ','MA','MA','NH','NY','MI','NJ','NH','KY','FL',
			'ME','NY','MO','PA','WA','MD','MA','VT','CA','WI','NY','NY','NY','CT','KY','MA','MA','CT','IN','MA',
			'MA','OH','OH','NY','MA','MA','RI','NV','MA','MT','NJ','MO','MA','CT','NY','NY','WI','IL','NY','RI',
			'NE','IL','OH','MA','OH','MA','NY','NY','TX','LA','CA','MI','CA','CA','IL','NH','CA','MO','MA','MA',
			'PA','IL','LA','CA','CT','MI','AL','FL','OK','PA','WI','VA','MA','TX','AL','CO','IN','WY','IL','IN',
			'HI','OH','IL','KY','NJ','SD','TN','LA','OR','MI','AR','PA','IL','MA','TN','MI','VA','AZ','TX','MI',
			'MI','NY','VT','WA','NM','ND','WV','ME','MT','MD','WI','TX','NJ','IN','MO','TX','GA','NY','IN','NC',
			'CO','SD','TX','MS','NJ','VT','MA','MA','MI','TX','NC','MI','CA','KS','TX','AZ','OH','CO','OH','MA',
			'OK','NE','TN','CA','NJ','PA','NC','WA','IN','GA','UT','MD','AZ','CA','WI','MA','NY','IN','SC','PA',
			'IL','AR','CT','NJ','CT','MI','TN','NY','CA','MN','OH','ND','CA','PA','MN','NC','IL','PA','OH','CA',
			'TX','AL','PA','IL','NC','KY','WY','OR','CT','FL','TX','ND','IN','MA','IN','CT','PA','PA','GA','FL',
			'IN','NH','VT','CT','MD','KS','IN','NY','KY','WA','IL','NV','IL','TX','TX','MS','IN','VT','IN','CT',
			'GA','NC','WI','FL','ME','FL','CO','FL','ME','CA','IA','GA','NY','IL','IA','VA','ME','WI','WI','VA',
			'ND','WI','KY','AZ','AR','MI','MA','NE','CT','IN','MT','NH','TX','IN','PA','IL','WI','IL','NJ','NE',
			'RI','CA','IA','NY','NJ','KY','NJ','NJ','NJ','VA','NY','WA','TX','WA','CA','CO','TN','PA','NY','IL',
			'UT','UT','MA','MD','OH','NY','IL','IL','CT','NJ','NH','MA','OK','TX','LA','CO','ME','RI','OH','VT',
			'MT','WY','MA','IL','SD','MA','MD','CO','GA','MA','WY','MO','NJ','GA','NC','CA','NY','PA','NY','MI',
			'NJ','PA','TX','NE','NY','PA','AR','OK','MN','VA','OH','WA','WA','AK','VA','OR','FL','SD','TX','NY',
			'ME','MA','PR','MS','OH','WA','NV','CA','GU','CO','GU','NY','CA','PA','ME','ME','PA','PA','PA','DE',
			'OH','IN','NY','IL','KY','MN','GA','FL','LA','AZ','PA','CA','MI','CA','CA','CA','CA','OK','NY','FL',
			'AZ','LA','CA','OH','OH','GA','MI','IL','WI','NV','FL','WA','MN','IL','PA','FL','MN','MN','VA','IA'];

SET OF STRING5 SetZips := [
			'70510','17301','20606','28315','21005','79311','79604','61410','02351','70420',
			'54101','08201','95220','21520','20607','23301','12404','49610','01720','02743',
			'30102','74821','30103','99546','55909','13606','19501','43802','60101','99101',
			'50003','92301','53001','78101','49221','27006','79220','96919','01001','66930',
			'91376','00603','92536','27910','96701','29805','30410','52201','85321','44319',
			'35007','32615','94502','78516','88310','81101','49706','47320','28001','56007',
			'11507','55301','02802','18210','87122','05440','18011','87511','57001','37701',
			'14004','24910','20105','61231','72002','35010','22314','13607','32420','04002',
			'14803','48610','60102','91803','78332','77411','15001','92656','07820','49010',
			'14706','75002','48101','07401','07711','80510','08501','08720','44601','15413',
			'15101','49805','02134','98524','80420','99103','48003','04535','49707','30022',
			'84004','60803','03602','91701','66834','91003','62411','32715','95221','24517',
			'13302','49302','03809','03810','16601','96101','73521','25003','73717','56710',
			'42122','15612','77511','95002','68304','11930','52203','98526','89020','79106',
			'10501','19002','46911','45102','58004','94589','83211','84003','31709','54001',
			'50014','01913','60666','01004','20106','97101','11701','43002','43903','06231',
			'63431','71403','59711','98221','73005','92802','96703','77514','18320','52205',
			'99556','99504','67001','36420','46013','98303','37705','55304','29510','20762',
			'14709','95222','27501','77515','46703','56712','94508','50021','48108','75409',
			'84711','08801','21405','20701','36207','17003','55303','04911','06401','95843',
			'85086','88021','54409','94509','81120','92539','85278','32320','13732','27502',
			'15613','33572','32703','92308','54911','64724','30802','95003','20608','11931',
			'35016','70032','30104','78336','82510','24053','63432','95912','14009','46030',
			'45304','95521','43502','27263','32618','61910','15615','28704','19003','10502',
			'10503','53503','17303','62611','67004','46501','58005','76226','98603','85601',
			'85223','71999','67005','74901','76003','60005','66712','48005','10504','70512',
			'67515','30619','95004','75750','54410','93421','90702','75411','80005','11692',
			'93203','08802','07712','72513','02804','20147','01430','01431','71822','27203',
			'28814','01330','06278','60911','62612','37015','62808','01222','44004','83420',
			'43103','81612','02702','19014','11102','93423','78002','66002','08004','19310',
			'30606','94027','83801','72823','03811','30313','16111','11509','08401','07716',
			'48411','36502','38004','35954','48412','02703','02763','95301','67730','48703',
			'12912','04211','48326','02466','08106','04332','80610','15713','51005','47001',
			'30106','78716','44010','36003','62907','08202','15312','07001','20609','12018',
			'95224','93424','46710','75630','44011','07717','44012','33825','19311','30002',
			'15618','29429','36505','76624','24054','28513','01432','23009','68925','76098',
			'87410','91702','33827','11702','56435','48413','15005','86321','56621','27503',
			'80421','54202','35019','66404','17502','98110','32531','97814','93384','19004',
			'72010','58521','66006','91706','10505','13027','38824','30107','29002','76821',
			'12019','12020','63011','57003','21201','29003','48414','78003','12506','49013',
			'97106','35542','28604','92220','48807','06750','85221','08803','04609','04004',
			'53913','49908','49710','96862','44203','25504','40906','92222','40004','46106',
			'77413','71110','72923','08005','08006','68309','43713','05821','53507','63012',
			'02630','29812','49101','05641','96921','60010','99723','92311','74003','60103',
			'19504','13734','48705','18321','33831','81621','32423','66007','07920','14013',
			'04653','71220','14020','64011','72503','14810','70809','49015','98604','56515',
			'89820','27809','56623','72011','31515','56425','48707','36507','33744','39521',
			'11706','39422','44140','00961','88023','81122','07002','55003','11361','77520',
			'08721','08008','08722','12508','06403','95903','22712','04611','37708','19701',
			'54922','49614','56211','62618','68310','41311','29905','77706','41203','15009',
			'42320','14812','13305','49782','97004','23015','97006','60912','19505','55308',
			'01223','25801','01730','10507','60499','77831','07921','68314','72012','16822',
			'46107','29842','60401','62414','37018','42323','78102','74421','21014','20611',
			'21017','01007','58316','38826','54003','48809','27009','98528','04915','58622',
			'07718','41514','53004','04917','37020','91307','90202','72715','43906','45305',
			'65013','43310','70037','57717','33430','08502','67013','62810','43717','15012',
			'33756','33786','43311','16823','11426','34420','62223','98009','90706','98228',
			'08031','11710','05101','11713','77418','80512','16617','07719','03220','53512',
			'45714','15922','76513','20705','94920','07823','39038','56601','14712','95005',
			'56626','97707','20612','04733','53102','94510','52721','29512','03442','19020',
			'60106','85602','15314','63736','99320','49022','45816','72712','49616','40403',
			'57004','07621','78004','94707','07922','48072','13736','15530','44814','66408',
			'04612','01337','07924','12023','13028','63822','19506','49103','35546','66409',
			'72616','80513','78605','70342','60402','35020','28016','62010','06524','19930',
			'04217','94511','15102','20816','30620','11714','80805','52722','21610','44815',
			'81023','01915','90211','63532','47512','04007','92314','92315','53103','25505',
			'99652','95305','33043','21711','44611','49307','60511','59520','59716','79720',
			'57216','93920','59011','01821','59106','36006','39531','04920','13903','48415',
			'65438','19421','55310','62415','19508','35210','85603','30621','21813','58502',
			'49309','74008','36314','54106','98010','59414','53515','57718','28711','13612',
			'54615','65321','56630','83221','43004','24060','31516','01504','65322','74631',
			'08012','68928','28320','20710','43909','68008','24527','96103','07825','15717',
			'31723','98222','18610','51630','53516','45107','78606','65014','01008','84511',
			'19510','70717','10913','08504','51523','49228','02807','44817','54724','07003',
			'48304','76626','12721','07403','92316','17815','08804','63627','13739','13308',
			'35031','37617','28605','23308','19422','89004','52726','04614','60406','92317',
			'53517','38610','11715','30513','17214','64015','24605','76352','74333','20135',
			'29910','92226','72316','29016','16827','35956','33921','33428','94922','94923',
			'78006','70427','30622','75417','07603','39629','11716','17007','83712','60490',
			'14715','28422','28423','12814','05732','37025','36511','31005','01009','54107',
			'50035','05340','60913','75418','32425','91902','34133','63628','59823','66012',
			'83805','72416','92003','28607','24065','72927','21713','07005','27011','04538',
			'47106','08505','79007','97009','92004','03303','87068','71171','02115','15531',
			'98021','06404','58318','13310','80306','89005','95006','54512','91905','08805',
			'84010','46504','60914','70343','70039','03304','04287','04008','58418','62316',
			'19511','20718','63334','17507','57719','01719','01921','22620','54725','59013',
			'20841','23917','19512','95416','23827','01505','49712','49713','33424','68010',
			'59771','21612','06334','18812','91010','34201','34217','45308','40009','15015',
			'04411','07720','65614','76825','63827','60408','56401','02184','07826','19316',
			'40108','05733','22714','20613','06405','65615','48614','02020','36009','30517',
			'05304','92227','64624','47834','77422','92821','70517','76424','44141','62230',
			'15533','11697','18031','30110','98310','23022','76629','77833','35034','24818',
			'37024','28712','99785','04412','13029','02631','36426','84719','10510','08723',
			'77611','11932','13030','08302','60455','15017','02324','49106','04009','08730',
			'35035','08203','84302','80602','11718','54110','61517','72021','20862','94005',
			'24203','74010','49229','06016','11693','20137','12025','75929','59317','59015',
			'44147','22815','14420','02302','15824','53520','18322','74013','51007','10461',
			'10708','55007','95007','22430','20833','44403','39602','57006','72417','21022',
			'04616','02446','65619','11225','44142','62910','30205','77423','07926','47923',
			'34605','14817','45309','19008','80021','62817','70518','48416','79316','59417',
			'08015','27214','35741','46112','47220','05037','76801','31519','26525','36010',
			'83604','31523','80723','38547','98606','12916','54204','77805','20616','72089',
			'04219','20617','19009','19010','28713','10511','39322','85326','21717','04220',
			'26201','30625','18912','49620','67834','40010','04416','66013','61314','07828',
			'93427','08310','90621','81211','14231','80425','60089','24529','30518','27506',
			'75757','86430','78163','23024','62912','63629','25413','89007','32110','70041',
			'91507','14818','28425','15021','43407','98148','76354','22015','42717','75932',
			'76097','83318','94011','05406','78611','53922','04922','37029','26335','12027',
			'60521','95225','14028','48059','48519','20866','70431','18324','79012','33513',
			'20618','12028','16001','47223','27509','59701','54927','97522','54514','97109',
			'02532','80103','01922','48418','49315','92230','20818','05647','73527','75135',
			'49601','42211','00726','31728','91372','28467','04619','13616','83607','61011',
			'35040','92231','80808','30703','93518','07830','65018','93505','92320','92233',
			'94515','32011','63534','20620','95418','60409','42029','11933','74531','30807',
			'52730','98282','93012','98607','93428','11411','02238','47327','16403','46113',
			'29020','19934','65020','76520','31730','13031','95709','25820','96861','17011',
			'28547','95419','86322','38550','75422','10916','47108','53010','42719','32426',
			'91906','95226','29322','41301','03741','41519','44614','43110','14424','14822',
			'13032','97013','03034','28715','13743','14717','67333','44406','55009','91309',
			'81212','15317','00729','03224','75103','06020','32533','62625','79015','91386',
			'78133','97417','32920','23310','33914','04107','63703','08204','08210','03902',
			'92624','20791','95010','26711','23829','35742','96704','33924','76435','35549',
			'62901','92007','43315','85377','70520','04736','64834','11514','48117','89822',
			'62626','17013','61725','88221','07072','97111','62231','93923','93924','62821',
			'95609','98014','15106','96140','30521','48723','60188','28019','00979','28428',
			'82054','60110','93014','80612','27510','73727','39426','58421','78834','43112',
			'23314','15722','23315','87517','89702','48419','51510','07008','30121','62918',
			'75633','93609','63830','02330','18913','27511','85222','21719','97014','54205',
			'48725','62420','72421','73016','98815','49318','82601','32730','16623','91384',
			'44824','04421','13744','28429','80104','05735','12033','57223','94552','95012',
			'85738','00962','18032','31804','24070','17820','20143','92234','98612','20119',
			'41129','61817','13033','21228','74015','12414','14719','58220','42127','85331',
			'72718','05142','29033','93430','47928','14824','13035','72930','49621','35959',
			'84720','78612','87008','50613','92321','07009','75106','07927','46303','78613',
			'52405','49319','84013','53012','11516','19423','30125','72932','00735','45822',
			'49233','58530','55012','03813','22437','03226','33514','48015','11934','03814',
			'52213','72027','03227','03815','18034','06409','43011','11720','47840','11721',
			'72719','42328','47330','29630','12035','42330','02863','11722','49622','97502',
			'13036','10917','98531','35960','16828','20120','54824','95307','49033','90703',
			'61818','42215','19317','13319','63740','44022','18914','70043','17201','61822',
			'15622','12919','55316','61015','75758','43727','55317','60410','77530','20151',
			'66720','27515','29036','06235','25508','10514','77426','20621','44024','01339',
			'15022','23030','25414','72933','29404','02813','49720','28208','20622','22911',
			'01507','01508','02712','49623','54621','55318','12920','55923','38731','36518',
			'91313','32324','37419','99003','14722','12921','60922','49721','74426','98532',
			'98816','01824','52215','19012','13746','99004','02814','29520','28719','72529',
			'45618','08003','61016','18035','48616','23321','20732','21915','01225','29323',
			'23831','19017','19425','63017','43728','44026','46304','21620','04938','02467',
			'15024','20825','82007','19319','60664','60411','95712','60415','30707','73018',
			'95973','01013','35044','79201','21916','24319','54420','45601','02535','97624',
			'53014','98325','28720','48054','28023','76633','23336','91710','91709','86323',
			'32428','54729','55013','55719','13037','05737','25235','27817','73020','59422',
			'71227','74337','61924','37037','24073','00824','62822','99567','91910','36521',
			'21623','70525','23833','20733','14428','46723','78108','13039','67835','45244',
			'59215','55014','10919','32113','95621','91715','97015','67525','15025','59634',
			'35045','32710','50524','91711','74017','14031','14032','60514','15623','51632',
			'16214','80428','86324','30523','83812','29821','18411','08020','65025','38614',
			'99403','37041','28433','97016','24076','12513','48017','25043','67432','62824',
			'19703','15323','94517','13322','98922','99704','47426','50428','21722','84089',
			'98235','15535','33762','33767','76033','95227','27012','12819','29632','34712',
			'44109','65631','45002','33440','58016','07010','07721','07014','19018','12065',
			'12042','24226','79836','06413','12514','48038','12515','54929','48420','50325',
			'55720','07624','29710','46120','88101','48049','14724','31303','92236','15423',
			'47427','17866','35449','93210','16627','84017','93614','19320','27521','06414',
			'53526','12043','31014','54622','19330','21030','32926','32932','33097','36523',
			'82414','24230','83816','12045','67337','17728','02025','12047','55321','35452',
			'30628','67701','05446','13324','10516','11724','14033','77331','49036','06021',
			'76834','52035','27235','53017','20741','99324','11356','77842','19426','76034',
			'38017','08108','39428','76233','38450','94014','18915','50056','55322','49038',
			'61241','07067','22443','23834','21917','79512','80908','31737','92324','07722',
			'29209','46725','04623','44028','35051','48421','43231','45830','95932','99114',
			'67030','73529','54113','30629','11725','75428','80022','48382','43116','80432',
			'20627','49321','94521','64020','19331','98237','97823','14435','10920','61729',
			'80433','13748','30288','44030','16316','16406','15425','47331','28613','21918',
			'77304','19428','13325','13044','49042','03229','07961','46919','45832','49722',
			'30012','18219','55723','38503','08511','21723','75558','95614','85228','18036',
			'13326','36020','12517','74022','29038','67837','13626','11726','18037','44321',
			'75019','76522','95228','97423','82925','33134','33065','52241','11727','15108',
			'27926','97019','40701','31015','73632','99574','26529','14036','38835','30531',
			'28031','61319','37047','41731','14830','86325','12518','06754','12520','27927',
			'92879','92625','92178','78404','87048','75939','16407','37721','15829','75110',
			'85652','94976','81321','68331','10567','46730','97339','47112','06807','37722',
			'43812','78614','92626','94931','81223','53527','12419','63338','35453','71327',
			'37048','96022','48039','02635','78014','54828','16915','62237','38326','51501',
			'60478','98239','23837','05825','91724','70435','36321','74429','98923','29330',
			'40013','12051','95013','81625','28032','16319','16066','08512','75114','54520',
			'79731','35053','16410','07016','02910','58327','12521','30630','47933','30631',
			'24931','62922','08514','19430','27522','15732','68729','57435','51526','32112',
			'52136','07626','16630','81225','44827','93432','32539','40014','97426','68333',
			'23930','24431','41030','94525','42217','13327','10517','06416','57020','56716',
			'12052','35054','77532','79322','29332','22625','53528','10518','71635','38557',
			'08515','48422','10519','10520','28033','04738','76036','46307','21032','19021',
			'22932','23039','89402','34681','63019','49920','60012','34428','36907','53110',
			'12729','77954','38451','35058','25510','28723','22701','97734','90230','23040',
			'04021','37050','04110','37724','02637','50061','01026','37052','95015','99118',
			'27929','43412','69025','21226','74023','43511','98240','11935','46920','05738',
			'44223','41031','77410','80514','30019','33523','36853','49724','19939','61428',
			'22448','30533','75638','61018','68731','22193','24083','79022','75372','17313',
			'53926','61925','94017','61320','04543','20872','20628','84783','77430','28724',
			'92629','18916','06811','37725','33004','25832','06239','30633','12929','48819',
			'61732','40422','36526','19023','72834','60561','14040','47940','98241','93522',
			'55325','17018','52807','28036','21035','33314','73030','61020','48350','48423',
			'26142','62520','30534','45440','32114','06241','53532','43318','54115','71832',
			'66018','49725','52742','07723','20751','41812','48128','48127','36022','32713',
			'30035','37324','83323','52101','96912','02027','06417','28525','08023','61733',
			'04627','94576','80105','54424','44411','33443','58731','56444','43512','32433',
			'60115','92014','81132','78840','78617','53018','32720','93215','12053','20144',
			'53115','43015','19706','18327','70528','14042','13753','66418','57022','44620',
			'26531','12054','15626','46922','46923','45833','33445','17314','99737','49046',
			'32725','07627','98244','36732','30535','46310','70727','75020','54208','02638',
			'02639','04945','76207','80228','79323','07834','14043','13754','70633','05829',
			'05830','70634','16727','15627','20855','70030','72040','58733','50310','60018',
			'91916','92240','43516','75123','32541','70047','48243','56502','19432','71328',
			'58301','78016','19333','50623','61840','23840','63841','94528','44412','91765',
			'12824','95619','39525','75640','20842','53808','58602','37055','18519','02715',
			'50624','99576','59725','94929','47018','17019','56529','79027','48821','18328',
			'93618','23842','20753','62530','80814','62830','04224','61021','37057','10522',
			'77334','55927','67801','53533','35061','81323','23843','60419','71941','31745',
			'15628','68832','15033','51235','35062','02125','02124','08317','49323','05251',
			'62021','93620','25833','50433','58735','67039','75560','30133','53118','17315',
			'19902','04426','12522','49047','37059','60516','90241','54734','19335','61736',
			'54735','96109','18901','01826','80515','84020','20630','43821','19025','54009',
			'64742','78619','78620','17518','74030','18222','24549','41035','17220','48428',
			'15801','62832','12056','91009','71235','43016','47527','52001','28333','97021',
			'47848','24325','84022','55815','91917','79029','22026','07628','15431','03046',
			'29334','17020','95430','16635','75138','21222','97115','34698','20754','37327',
			'18512','28334','22027','34434','95937','42528','58329','01827','70728','62239',
			'98327','15110','61024','81302','74701','27706','13054','18642','70529','99692',
			'63745','23050','98019','02332','46311','38024','52040','79607','16636','38028',
			'85925','68347','12057','97022','50533','77434','78852','97524','54521','37060',
			'21919','12058','60518','22936','63045','29642','62024','14051','14052','05649',
			'27018','17316','77435','12059','04544','02333','01515','08816','05832','16029',
			'05650','62240','12060','44033','05076','02641','05253','61025','11369','05448',
			'28726','02717','06026','56721','12061','18041','02818','06423','03826','11937',
			'07936','06108','06027','05837','59635','92650','11730','49727','06243','03827',
			'48823','49051','43319','04228','43920','01028','06333','04630','11554','05740',
			'04430','61244','05651','11940','12062','21631','11731','11732','07017','02643',
			'01029','32131','44413','14056','61611','17520','04230','63845','17317','02914',
			'11942','05041','14445','11518','07073','62207','02537','11733','18817','18301',
			'13057','02718','48730','01438','18046','05043','53120','03830','02032','02538',
			'04030','98802','04234','06088','06028','36260','10709','06242','02642','01027',
			'44095','54626','18044','48021','11941','97420','98245','80615','33840','48827',
			'31024','07724','98328','54702','15931','81418','36024','47339','04428','42038',
			'27289','05653','55347','27932','65462','02539','04556','29824','19028','29712',
			'56128','21037','21040','16412','78539','46124','08820','29438','13335','73083',
			'98026','48829','77957','43518','93523','49112','62025','71331','29541','18330',
			'27243','08215','08234','32542','99702','36613','15330','55931','40117','92020',
			'77437','92244','94530','71730','95762','94018','81628','95618','85335','91731',
			'79912','33150','87529','73036','90245','94803','95433','72333','54427','36323',
			'80106','36530','30635','56531','13060','60119','54428','61324','65026','45321',
			'80025','95431','60123','76481','03903','15037','27906','37643','42701','17023',
			'12523','73644','95758','60007','21920','54739','57025','49629','55330','46516',
			'53020','53121','28621','26241','19027','65644','35620','89801','21075','21922',
			'25071','62932','31308','26346','58436','98926','34222','12428','30294','47429',
			'21041','30540','06029','58054','24087','61431','67439','57706','16117','27822',
			'53122','57736','98541','78112','99506','71424','60126','97437','11003','43416',
			'10523','07407','27244','35458','53929','78543','62028','63343','70532','19520',
			'95626','48832','60421','89315','44035','56028','58228','28594','71740','94608',
			'40019','18049','50536','83617','21727','75440','49630','66801','15834','92023',
			'91426','13763','62933','27823','72046','80110','07632','47118','07726','73706',
			'31749','75120','17025','45323','05450','36330','98022','84627','98823','03042',
			'03234','52045','18417','16509','41018','28339','18920','84726','95320','49829',
			'92029','55733','66423','60129','87532','95627','12066','06426','07021','05452',
			'48732','19029','97023','87016','08319','99725','33928','80517','29918','37330',
			'70730','03750','46524','30724','28729','17319','54627','44119','66025','74432',
			'97401','76040','70535','95501','72631','75124','32726','29048','80620','16033',
			'13637','50707','60203','47714','49631','98201','36401','60805','98247','24550',
			'96706','08025','55331','64024','02822','23350','30212','15632','19341','55934',
			'35746','18419','65648','07704','07410','95628','99709','45324','30213','61739',
			'99011','40118','22033','22039','04937','02719','15538','19030','28340','46928',
			'16224','80440','14450','73737','62208','53931','28341','98024','54742','02720',
			'96028','92028','25419','89496','18615','22046','78113','40119','06031','21047',
			'02541','24328','77960','74935','07023','07931','11690','58109','55021','62838',
			'52046','47850','45325','71241','07727','87402','48333','11738','47340','23901',
			'16121','48622','20632','57438','17321','35555','28306','01745','82005','19053',
			'98003','01030','33930','73937','17322','13638','49408','63026','19944','47532',
			'56537','32034','12734','89408','83830','75125','05456','84523','24088','49409',
			'56540','63028','12067','95629','49633','54524','93015','24090','40022','62534',
			'21048','15332','93622','80520','83236','78623','54212','56723','46038','06390',
			'22939','40023','12524','01518','02823','01420','31750','03447','80815','32136',
			'86001','08821','07836','57028','48134','41219','78941','41139','19522','31309',
			'41041','08822','45326','48505','22627','63346','16640','30725','72634','36441',
			'62839','32140','34436','11002','59833','78114','07932','10921','33034','63031',
			'60422','19031','75022','30542','24091','79235','47119','11352','13337','18051',
			'19032','36535','19033','54937','53125','92610','53537','23850','65652','08863',
			'71742','39074','28043','92339','97116','21050','11375','94933','55025','30298',
			'95942','12777','02644','95631','95436','63348','23055','08731','75126','72335',
			'76041','62535','12827','53538','22060','31995','28307','47648','00934','68023',
			'42223','80521','24437','50501','12828','23604','20755','59636','85670','92310',
			'96032','40121','82212','33329','66027','23801','65473','45845','17224','80621',
			'57741','29708','36856','86426','07703','23651','10922','80701','33906','33931',
			'71243','30742','35968','34954','57532','13339','99505','66442','56449','36362',
			'66701','60037','73503','72906','31315','79735','88119','41075','58335','31030',
			'99703','32547','19034','46816','32038','76133','31808','95540','46040','73647',
			'02825','49834','44830','80817','54629','84632','85268','29644','92728','46130',
			'18923','27524','48835','48836','98333','53933','60021','54836','39483','01703',
			'03043','47946','47649','03580','48734','19945','60423','02038','45629','07417',
			'60131','11010','70438','08322','75763','53126','80116','48026','56544','43822',
			'93225','25082','49733','19946','21705','22407','22405','43019','14063','22940',
			'62243','41528','15042','07728','98249','64746','32439','78357','13068','46737',
			'95231','47432','63036','97736','08825','04745','11366','93720','93626','98250',
			'68359','04547','18818','77546','75035','63748','22630','66763','76641','21532',
			'81521','52749','34731','22211','92835','77441','42041','35068','12072','62244',
			'27526','18925','36741','35902','29341','48436','32614','20884','24333','66739',
			'06335','58035','20765','80622','44833','37066','70354','87017','45631','16641',
			'43119','87301','95632','51020','77551','12074','21054','77962','25243','12831',
			'15334','67846','92846','67050','61038','83622','90249','35071','04345','01440',
			'89410','72732','75048','27529','10923','66032','46738','20896','44231','10524',
			'22463','74736','07027','46408','27831','14067','26624','97119','28052','97346',
			'44040','76528','37738','39553','30218','55334','06755','61928','70734','83832',
			'53127','61254','68361','89411','53128','78022','03751','29440','69341','61039',
			'18053','27019','38138','25420','17325','14068','95441','12075','68840','08026',
			'08027','30810','21056','43431','15044','33534','27249','78942','16732','98332',
			'85234','60136','19525','12076','80623','03249','80624','07933','30543','05904',
			'03237','03837','75644','95020','61436','16417','99587','81523','24340','28627',
			'75647','07934','48624','19035','26268','61533','42142','08028','58236','06033',
			'03838','23058','21057','13777','21060','62034','11542','20812','95442','60137',
			'08826','11545','19342','11004','19037','07028','17327','76043','12737','62536',
			'58740','60022','91205','60139','59330','08029','21737','13343','43739','12527',
			'12077','19343','95943','20769','30427','19036','74033','12801','15116','19038',
			'60025','17329','98619','54013','11547','81601','85501','71030','23061','08030',
			'23062','45732','05839','12078','56547','49055','67052','62035','76044','67053',
			'03045','98251','97525','95717','80401','86413','10526','27532','22720','93116',
			'60029','77963','73739','93926','23063','30641','24556','76908','61742','55027',
			'67735','37072','48438','24095','85338','29445','35466','22942','76363','62939',
			'14461','26720','46527','47433','34734','71643','49326','64454','46741','38745',
			'58445','32440','03240','42344','64029','67737','71245','70052','91394','76048',
			'05840','36541','48439','86023','70643','58208','58204','49417','14072','05458',
			'81502','80447','48837','55604','75054','49503','44045','97347','75140','92313',
			'16420','63943','76050','49468','27939','46530','83530','95746','62040','98252',
			'10527','05654','35747','60940','48032','03753','87020','97526','62943','84029',
			'17028','61326','75844','98546','76099','21638','49240','95945','45330','95444',
			'17030','72736','65037','49637','31032','29645','49738','60030','30017','30726',
			'01230','67530','59406','60088','07838','20634','11024','11739','14741','80632',
			'29056','54302','08812','32043','08219','72638','02041','55338','54941','18054',
			'80819','35074','65332','82935','61534','92341','07935','33413','23356','98253',
			'20768','72058','04418','17225','53129','02827','37743','01301','12833','12435',
			'03840','11740','54126','11944','06436','47345','27417','05842','47240','18426',
			'62428','11548','29616','04442','70739','08323','64034','10925','29651','48137',
			'43523','38902','97030','70053','95948','30223','46319','28530','50111','27837',
			'38565','50112','79039','48138','48236','48230','70740','06349','24441','74344',
			'16127','36451','34736','43125','63040','93483','77619','75845','30813','85283',
			'95445','91743','00969','95446','70542','12084','12085','06437','35563','32562',
			'36542','39501','81042','23065','81230','21010','75058','35976','38849','35748',
			'60031','95322','40142','73044','50115','77444','73942','16327','31312','49841',
			'19436','19437','21207','81637','91745','70645','07601','07840','06438','08035',
			'08033','48440','06439','96910','54014','41222','47346','12836','31632','96708',
			'83333','33845','08036','07508','96712','53130','21227','94019','24558','33009',
			'77964','04347','38040','65255','67056','76117','26269','71339','06514','55340',
			'29547','46742','18427','70403','08037','01036','60140','21074','06247','11946',
			'03844','77622','29406','96714','96715','96716','35077','13783','93230','12741',
			'46340','12087','63401','23069','01731','83334','02341','98340','19951','27941',
			'90710','49740','16421','42048','40143','01037','24101','76548','51537','19438',
			'29448','78552','16037','67058','48225','25425','35078','04079','13787','73045',
			'10926','19952','07640','55032','57032','10528','15636','16927','22802','64701',
			'02830','40027','40330','37752','48028','49420','06147','47348','53029','19953',
			'65039','10530','35640','37074','44632','30643','01451','35749','70058','02645',
			'02646','06791','58042','07604','07420','43525','76052','48840','49058','10706',
			'72640','19040','01038','95233','01937','54440','39404','47639','71037','11788',
			'96717','32333','28532','19041','01831','10927','19083','59501','21078','27258',
			'90716','51023','42348','96719','75765','31036','18428','06440','07641','10532',
			'81639','01039','23072','28904','55940','20168','36040','67601','67060','63851',
			'94544','41702','57242','60429','35750','48030','54531','63042','39083','07730',
			'18201','36345','54532','95448','99743','77859','01346','85928','84032','06248',
			'55342','25427','36264','39439','40949','58341','30545','59601','92342','53137',
			'97835','17406','18055','08828','78023','84526','47436','92544','48626','11550',
			'35978','51541','37075','73742','03242','56551','27842','14467','61537','18332',
			'72065','30815','95638','63048','94547','85615','13350','68029','65041','55811',
			'97838','16148','13652','57744','90254','87537','34442','20172','18430','62948',
			'49744','60941','17033','27944','92340','67062','58639','13654','76643','11557',
			'83336','61745','33017','30546','52233','55746','07842','96853','42050','28601',
			'49060','60457','11801','06441','64037','08829','12440','27262','63049','32643',
			'05459','20777','10928','41076','36041','07422','10930','60035','77562','65669',
			'12441','08520','60040','85236','54129','84056','57745','10931','32046','16040',
			'49746','80733','41049','27278','07642','07205','24343','18927','95324','96720',
			'14468','29925','55037','72738','56647','05461','31313','02043','14743','73047',
			'04041','77563','24347','37343','54635','07423','46342','88240','33455','07030',
			'59452','28537','19707','77447','42748','35571','56339','60194','30230','38462',
			'86025','67851','54745','70744','74848','03245','68949','43527','18928','34690',
			'49423','13354','14470','16648','11423','04042','65672','01746','88330','48442',
			'28445','38635','33022','07733','54636','19043','34218','56341','44633','48842',
			'66436','65043','11742','92250','17532','96725','80734','92548','99603','44235',
			'52236','60456','96141','74035','34446','96726','78861','29654','14471','14472',
			'18431','19344','51542','75446','84314','96810','96728','49640','97031','98548',
			'28538','75561','03106','15050','96729','84315','60942','12090','07843','04847',
			'36043','28348','02832','43976','61565','12533','55343','42240','52237','95449',
			'15445','98550','58047','53032','38637','14843','42749','28742','14844','72512',
			'19044','35980','54944','30548','57747','71914','71909','49931','48629','38850',
			'54082','70360','01236','63051','77018','65333','16841','11414','49329','55349',
			'48843','57748','34737','44425','01452','28539','53033','24104','61748','12839',
			'49426','77336','29450','72348','20637','95326','12537','80821','49748','30646',
			'04644','02047','77338','38343','22639','50123','17036','15639','21031','12442',
			'28070','46748','47542','16652','19006','25715','92605','18622','90255','11746',
			'48070','20639','60142','22640','35801','27541','32544','88043','12747','21643',
			'44839','25526','76053','53034','67501','78634','26273','02601','02647','20783',
			'84318','21082','05750','84319','48140','74745','83631','83403','80452','79329',
			'47950','35981','92549','81137','21754','13357','62539','98624','48444','08526',
			'16655','34143','92251','91932','96917','89451','41051','73552','32903','20640',
			'80454','01151','49749','33785','45015','28079','83632','92210','15701','46236',
			'98342','92201','15052','77968','46048','47618','60041','90304','78025','48141',
			'29349','74036','32148','49643','56649','03845','55076','34451','25428','93527',
			'54945','95640','48846','70647','52244','50126','76367','01938','79527','05845',
			'54442','29063','49801','53035','43932','07845','49644','56455','49938','92604',
			'75017','10533','16656','15642','55040','08830','49849','33036','08732','60042',
			'11558','05846','11749','05463','29451','95641','11751','11752','38754','98027',
			'20645','60143','14851','62849','84738','23866','06442','22945','76458','39202',
			'45334','11372','32234','32240','62950','55752','03452','11430','02130','64647',
			'11947','45335','13078','18929','91935','26378','53546','70749','21084','47438',
			'47546','74346','89019','70544','15644','50129','37760','10535','22724','43128',
			'31527','87025','35085','45841','49428','41537','19046','74037','95450','84035',
			'34957','11753','15937','07310','17740','62052','20794','50648','67854','43986',
			'06351','54748','18229','08041','37080','49751','29455','05656','78636','53038',
			'12094','50131','62951','12095','72350','60435','93928','73049','04648','37659',
			'04649','78645','05466','64801','21085','55352','13361','76058','92252','78026',
			'75660','16844','31046','76849','66441','93529','53039','18230','68955','97911',
			'33477','60458','76247','96730','96731','96732','96734','96745','96741','49005',
			'59903','49646','84036','83536','96743','16735','96744','60901','28083','67454',
			'61933','66115','53139','96746','96755','96709','62955','78118','99610','56050',
			'55944','31047','10536','77450','75142','54130','96748','86033','84037','96749',
			'96750','07734','64060','07032','08832','96739','67067','21756','48320','24566',
			'93531','12943','80643','12944','71047','96752','62853','76248','83837','71441',
			'95451','37348','77565','19347','83101','75143','76539','60946','99611','28349',
			'23944','08824','46755','83537','78119','07033','98028','25248','68034','04043',
			'04046','76060','70065','30152','63857','19348','99337','48006','53140','20891',
			'44240','49330','94904','43326','23084','70444','07847','95452','55946','72083',
			'52632','26276','12446','93630','27284','78028','80644','54135','22947','99901',
			'83340','99141','14478','42053','11415','49648','61443','46939','53040','54216',
			'33149','33051','33037','33041','21757','07735','69144','32656','23947','12751',
			'53042','53812','96753','96754','75662','27948','44637','76540','35645','05751',
			'06419','39556','57355','65686','54136','19442','46760','41539','62540','49788',
			'12106','27021','23085','93930','99612','22485','19406','99613','23086','73750',
			'67068','31547','93633','45034','28086','11754','93631','78638','49802','31548',
			'18826','37665','60145','37082','64061','49752','44428','28504','18930','80117',
			'75956','60146','42054','63501','13082','17536','87117','34746','03904','80457',
			'27544','45645','27949','97601','99925','54749','27545','94548','46148','78870',
			'65336','27950','46534','61448','99619','53044','46902','96756','95550','39090',
			'77625','46347','54137','57245','74554','80459','76227','76249','96790','17834',
			'19443','83634','18058','28449','96760','19530','78640','16847','15450','91011',
			'98629','98257','55947','91224','54601','66040','13084','37766','46940','97850',
			'95329','60526','90631','94020','92092','15753','81050','77568','91941','90637',
			'65337','52054','90623','97739','70068','63549','77571','91744','92253','48145',
			'37086','84745','91750','78121','81055','68128','63055','33975','98509','18623',
			'70445','03247','92694','47954','29456','32159','54848','70503','19444','60147',
			'46761','12540','92651','92654','92607','94938','96761','18931','26731','96762',
			'48848','75666','48632','33850','49650','18436','92352','56149','60044','32054',
			'70606','81235','56055','75065','55042','05657','92531','92630','53147','80827',
			'11755','33851','18624','86406','32744','07034','07849','93532','60156','93240',
			'77566','28746','12846','32746','53551','44429','48849','48359','97034','65049',
			'33538','31636','10537','12946','63367','91361','46405','98258','54539','14085',
			'60046','46349','33853','33461','60047','98349','08733','33801','95453','92040',
			'43440','48850','46536','14750','72846','48144','79331','89828','50140','32336',
			'58458','76550','65681','17537','87540','61046','93534','54540','19350','82520',
			'07850','17040','17538','29356','01237','23089','19047','29834','20703','53046',
			'08734','19446','19050','49946','58750','48909','46537','48446','80535','65534',
			'82072','10538','78046','00669','33777','58251','94939','70373','54947','75770',
			'46764','88006','89116','78561','75849','12110','95330','15650','29565','39335',
			'33313','33351','89028','78843','20724','24352','32567','43135','29360','28352',
			'18059','72941','25535','08735','85339','75166','30553','96765','90260','08045',
			'15055','47025','30045','64062','32058','73507','84040','52753','51031','61752',
			'80461','61047','77574','78641','66048','65536','66856','34461','71346','66050',
			'78946','19450','59456','07852','06339','60530','13363','35094','08220','64086',
			'20177','19533','71446','64761','44431','84043','33936','18002','18235','01524',
			'35646','45856','49654','91946','60439','93245','17043','71447','19534','19052',
			'57039','28645','37772','48050','01242','62255','46765','17540','01453','67074',
			'48367','07737','20650','07605','72354','49655','63056','84639','04456','79336',
			'99625','01054','19054','19958','81327','43035','17339','45338','14092','17044',
			'75029','40507','20653','59923','67901','77575','43532','07938','78642','99019',
			'21762','60048','71348','65542','23090','33074','22726','15658','96766','30047',
			'27546','31051','14485','04048','37681','04049','68524','07035','19352','10540',
			'60069','30817','04849','60712','07738','75771','75563','11757','08021','14858',
			'84042','87029','73052','67456','43442','55045','18932','36266','26384','65052',
			'21090','47441','28646','48634','76462','04250','04252','60532','44253','85340',
			'33547','30122','30038','43136','17543','54140','02837','19961','75068','13365',
			'07643','45742','29075','11363','29566','72219','07739','14755','08834','79339',
			'93543','17340','80122','95953','50558','04254','17045','38570','12758','48153',
			'31052','62661','12759','17745','13092','95237','78644','40036','52635','93932',
			'28097','17840','22508','23092','11560','95241','43138','89021','46947','17747',
			'17342','92354','94021','60148','53048','90717','93438','72847','03053','64070',
			'75453','93545','52755','63060','90806','07740','21092','52756','24569','11109',
			'55356','65590','61333','18334','56347','07853','34228','01106','80503','08403',
			'67352','75607','70652','32750','72086','55046','47553','37350','95650','99148',
			'79342','65054','44055','76655','79343','55357','39096','22199','90721','93440',
			'94023','90006','93635','78566','95032','87031','93441','93402','52254','61334',
			'20711','22511','95651','37774','44842','23093','66053','40242','30250','45140',
			'82431','61111','20180','22949','61937','01850','57548','36751','83637','24570',
			'64763','33470','36551','54446','16659','52156','79413','45648','39452','92356',
			'15754','83542','49431','01056','31316','75902','29078','85309','78648','08048',
			'18933','48157','01462','48635','22835','20657','82225','70071','73054','21093',
			'37779','33549','56156','54217','18709','37098','29365','03768','11563','68746',
			'24506','03082','19354','98264','07071','66451','53944','14098','01903','32444',
			'01940','98037','90262','38645','60534','78052','96863','75147','72103','30126',
			'98935','32063','14502','44056','61115','04654','04655','17750','49757','61755',
			'49701','45746','48042','31216','18062','93639','73446','37116','24572','56063',
			'37354','97741','50156','95954','39111','84044','39652','36555','61853','10541',
			'10542','07430','28650','23102','45039','19451','32751','67101','62958','96768',
			'32950','83252','08328','75148','68402','02148','90264','43535','59402','53049',
			'60150','72104','11565','10543','93546','70554','25635','08050','23103','08736',
			'20113','54949','49659','78652','40962','05255','58554','58757','70471','11030',
			'66502','90266','17545','72442','46150','49660','49854','61546','49253','80829',
			'54220','56001','13104','74044','29102','15550','02345','78653','11949','38236',
			'06250','98831','38855','95336','60950','08738','49663','55955','08051','58256',
			'02838','71449','27956','49664','44137','66507','55358','60151','55359','08052',
			'98038','61547','02839','07040','17951','74045','85653','33050','72648','30148',
			'01945','20658','49067','92518','34146','97454','19061','13403','43334','12455',
			'33093','08402','32446','54227','85239','13110','14102','93933','90295','62061',
			'55047','54143','62959','15759','95338','62257','46770','96120','46056','71351',
			'74644','05344','01752','73055','08053','08223','49435','49855','70072','21104',
			'16046','28754','61341','94940','50158','65706','28103','02648','68404','50160',
			'63357','43445','59926','78655','94553','25401','24112','60951','72366','32569',
			'19964','12116','63043','21105','97036','98270','37801','34753','62258','02649',
			'54856','62664','26542','13804','11378','11758','11762','13662','21650','44648',
			'11950','11951','18336','07747','95655','80830','36052','33993','98560','02126',
			'02739','99349','04459','49071','60443','28104','11952','61938','47142','21767',
			'29662','43537','72113','96770','97037','70555','53948','50161','00682','12543',
			'55360','84643','72106','35114','01754','37807','32066','76064','08330','30558',
			'53050','63454','55956','53560','60444','07428','17049','32062','83638','39647',
			'35111','79752','41544','51548','29458','29570','17233','46055','29835','72101',
			'45652','37353','53558','22840','71654','28649','13101','76657','21541','31054',
			'15136','15132','36456','75070','22102','62859','27301','66054','37110','31055',
			'17344','17051','74501','78501','96056','98438','96057','39648','21647','30253',
			'60050','98558','95519','74851','97128','67460','99021','25682','95722','39653',
			'30256','27302','92254','04256','17050','23111','12118','49332','47957','02052',
			'55049','19063','99022','44256','60157','47260','02053','74855','32934','32951',
			'23410','75454','32666','60161','48454','48122','38128','71953','76859','54952',
			'39114','07945','95460','49072','61342','92584','94026','58558','49858','53052',
			'54751','46539','44061','53097','70075','95340','16137','98040','17236','03253',
			'13806','66512','83642','35759','19066','96916','79536','97532','47861','11566',
			'22116','54452','46411','01860','03054','49667','32953','27957','53056','19539',
			'85213','49668','75180','65058','70001','61548','01844','62960','30439','08840',
			'76667','13114','15552','95346','33154','33119','33138','45343','99023','46360',
			'38357','49254','08056','78056','12850','06456','11953','45863','21220','11379',
			'02346','26149','44652','32068','12122','46540','44062','45760','40965','08846',
			'01949','06457','05757','49333','79704','36350','07432','21543','84047','36053',
			'92655','28544','73140','17058','17844','17059','56353','38358','57252','04658',
			'59301','48381','96789','98012','17751','11765','94941','94030','36054','07041',
			'01527','31061','30442','65707','62962','11764','52308','21108','12546','37682',
			'80543','07946','04462','02054','82644','19966','62260','47145','96062','10546',
			'08340','30257','04463','95036','98354','97862','56354','53213','32754','89423',
			'54644','07803','11501','23117','53565','44440','71851','26150','84752','44657',
			'13115','45653','61759','55402','34755','55345','55361','13116','54548','54859',
			'60447','58701','58704','08341','45865','81645','91752','03853','46544','54228',
			'78572','91345','92692','39762','59801','77459','51555','47446','08342','84532',
			'65270','36609','27028','51556','12548','95350','29838','81143','94035','44260',
			'86440','49950','10547','19540','19541','93501','95245','60448','97038','30258',
			'61266','32577','84645','15061','79756','25636','29461','43542','27559','54755',
			'60449','24121','65708','96927','21111','97361','07750','08852','15063','02350',
			'28111','63456','08831','36461','91016','10952','04464','19453','03057','49437',
			'75853','94037','11954','19710','07043','81144','37356','90640','93943','91755',
			'98563','35115','67867','36117','20886','18936','52310','17754','05602','65591',
			'55363','22520','24122','34756','06353','80132','06469','35004','12958','12959',
			'07074','82721','59464','26836','47032','28114','08057','28117','56560','71060',
			'93020','18507','06354','87732','94556','16663','13118','40351','28557','30259',
			'85540','92557','05660','76671','70381','95038','42437','28655','26505','07751',
			'87035','11955','86038','41063','72368','48857','04952','72110','35116','38361',
			'07950','80465','53571','32668','37814','19067','93442','45152','70559','63066',
			'19070','60053','31638','81146','71659','63362','23120','98837','16859','97040',
			'54455','94038','39563','98564','35650','03254','31768','55364','57646','67107',
			'26041','35474','21771','97362','07856','95656','18343','37645','48046','45868',
			'04660','32757','08059','07970','43338','95140','28120','17065','67108','53572',
			'71957','22842','17552','37121','10549','08054','85619','26678','48458','28123',
			'26679','39119','45154','43760','38474','18344','60056','62548','20712','08061',
			'21545','96067','11766','40353','07878','12457','98273','43340','13810','40047',
			'92561','37683','12763','65711','83647','83648','55768','07046','71956','18707',
			'65548','07092','10953','98043','17554','24363','51039','62550','27958','91759',
			'62549','76252','98275','53149','33860','62262','40155','35118','97042','08062',
			'48861','29574','67110','47305','17756','60060','38058','42765','48747','49862',
			'49259','44262','46321','75778','57559','67111','27855','28906','95247','62966',
			'68409','62668','29576','92562','15668','83344','52761','35661','53573','31066',
			'53150','49442','74401','48014','73064','34251','17067','21773','41549','65778',
			'29572','97457','06355','98937','61057','75964','27959','01908','83686','42544',
			'20662','18634','02554','10954','94559','98565','60540','34116','49261','46550',
			'19072','02882','24124','12764','17555','98638','53058','43830','03061','37228',
			'55769','19969','78059','39120','71457','81236','01760','91950','08063','15065',
			'24578','49762','06770','76127','44662','77868','07752','18064','28761','68410',
			'80466','13120','02492','02494','92363','77461','54956','49866','44441','97131',
			'68413','54456','54457','68756','89191','22958','45764','76070','99760','66757',
			'62447','51559','53059','84648','07754','32266','55053','38651','11767','08853',
			'18240','67560','07857','55772','26681','64772','95959','47150','15670','95042',
			'54757','62265','48047','02746','62670','28562','16242','65063','03070','01531',
			'78132','06050','36351','08903','49117','67470','06840','77357','45344','16105',
			'23415','10956','17856','43762','17070','62074','03855','15067','08533','29809',
			'16664','49446','06812','15944','54229','17349','16141','53574','04260','08224',
			'10958','13413','06504','27562','17557','53061','18938','48165','11042','70562',
			'03071','15068','23124','45871','60451','43764','53950','54961','48460','63869',
			'35761','26155','21775','06776','53152','70126','17350','46163','12561','17352',
			'44663','83655','34656','56071','06777','17560','56072','45157','17960','85087',
			'70760','10805','58356','47161','32170','15672','04762','02456','18066','56073',
			'07976','50210','77358','16142','61465','13122','10040','74857','07101','13811',
			'97132','38059','32669','20664','12550','01951','91320','01950','98056','12852',
			'36270','14108','14867','03856','07435','91322','03801','74647','28657','71461',
			'95360','99025','17073','03857','30271','72112','92663','92657','23608','07860',
			'02459','02461','03859','02462','02464','12128','06470','19073','17241','54151',
			'14304','14109','62551','94946','32578','40356','13812','30565','12965','67561',
			'56074','73066','49120','25978','99026','46164','99639','68760','93444','56468',
			'25143','12130','80544','65714','73068','04555','46060','85621','20181','62075',
			'76559','37135','99762','02495','64668','70079','30092','23510','72658','35762',
			'73069','31771','08739','60706','04957','37828','19404','49262','01845','04958',
			'07031','02760','29860','60542','11703','45872','20714','45052','05257','07047',
			'03906','20852','01862','44450','48461','06471','01535','08902','06059','02355',
			'29405','02650','01863','60064','14514','05759','03860','02747','02764','16428',
			'02356','52316','02556','05473','93643','33903','06254','53951','01536','06060',
			'06255','03862','05052','01066','04853','05474','95660','91393','91605','05665',
			'44451','46366','02852','98259','89032','33068','43060','52317','44452','72117',
			'46962','02059','25688','33167','33160','04265','05666','29597','44070','01537',
			'33408','97133','69101','99705','05053','34286','53153','02911','01864','33708',
			'76180','44039','44133','46165','84054','02857','57049','02896','06359','14120',
			'05859','02652','01538','47265','19454','04061','04267','46555','28659','06256',
			'04097','01060','01532','01534','60062','04662','44067','06472','60164','11768',
			'91326','07647','57465','58267','02766','66060','50211','04268','02061','06360',
			'19074','36866','97461','46556','03290','94947','44072','48376','74048','39346',
			'18636','92567','49448','80648','77976','07110','10960','62269','02557','60523',
			'53154','60452','72660','23416','98277','45656','92345','28465','60453','60304',
			'07438','93022','15071','31772','01068','93644','07436','47660','11364','33311',
			'48649','08107','15139','22730','19456','14518','22124','06779','30566','67749',
			'38240','34476','95465','22125','11770','02065','21843','08740','07756','28469',
			'98640','98569','39565','19970','24870','93445','07757','92051','08231','31773',
			'32179','34761','53066','54153','27960','51458','60460','78370','21113','35120',
			'79768','62870','47562','68113','69153','84403','13669','54459','56358','61348',
			'31068','03907','36271','16301','23129','93023','98840','73762','53069','74446',
			'45053','34973','73763','74859','48864','73135','74447','51355','98359','04467',
			'66051','11804','08857','12136','26845','18518','06870','37138','06371','49673',
			'06372','04064','06475','04468','11568','18068','34677','08858','65064','19547',
			'98279','38654','38475','49076','56277','44138','62450','81062','98516','60461',
			'18447','68137','31775','54963','25545','98570','23417','60955','49765','13421',
			'35121','57564','49264','49265','91762','37363','53070','33054','62872','36801',
			'70571','81426','36467','07649','77632','36561','51041','93646','78372','32067',
			'10962','95662','61060','62971','98280','48324','14127','81063','75683','18069',
			'61061','97045','45054','19075','84057','25148','57467','94563','13424','04472',
			'60467','32824','20128','02653','32176','98843','04473','55960','95966','04474',
			'04066','17353','44667','98360','48462','44076','17961','65065','56360','66064',
			'54020','61274','48750','47037','54904','49077','34229','55369','46777','10562',
			'03864','16667','02655','43061','13126','39657','13825','99344','01253','99027',
			'47163','10963','49078','45875','49267','48464','47970','56571','65348','18942',
			'52501','89040','14521','32766','74055','55060','13827','35763','42304','47665',
			'40359','20736','21117','04854','48867','89832','01540','93035','20745','11771',
			'65721','11416','96776','63069','93950','90272','94044','53953','91333','29372',
			'42001','20129','96799','81147','96778','89060','96779','78659','49955','44077',
			'14870','41240','92059','60067','32177','12463','04354','75802','81526','10964',
			'07650','18070','32905','33480','34991','32137','92260','34684','92264','93551',
			'75152','80133','18071','30268','63461','52324','94302','96073','76484','62359',
			'92060','60463','60465','60464','79065','29583','62557','74951','32404','32413',
			'91412','66071','19301','68133','81635','95969','85253','46166','72450','90723',
			'07653','53954','65275','13131','84098','54552','60466','20667','63601','56470',
			'60068','80138','47368','19457','26101','19365','23421','57366','21120','21234',
			'08859','63870','34219','07054','26287','21849','04047','91114','39581','99301',
			'02859','93447','39571','07055','05861','43062','11772','07544','32925','04765',
			'12563','12137','63662','20670','86334','45879','70763','51046','08066','92061',
			'14525','28130','49079','06379','74056','05761','29585','12564','62558','02861',
			'01612','83661','45880','56362','85541','72751','01960','17563','30269','04108',
			'07977','93553','71964','24134','96782','96860','70452','77581','78061','56363',
			'93953','61063','67120','18452','11958','64078','08067','45660','10566','37143',
			'61555','39145','10803','29123','35125','50219','49769','29669','08068','58271',
			'03275','33028','18072','30567','40055','14526','24137','44264','58362','22846',
			'15765','95946','14527','13132','32079','94951','75856','56279','08069','18943',
			'08110','26415','18073','08070','16865','47369','81240','95663','32508','49449',
			'85385','52068','60468','79353','01463','07440','17565','56472','87042','62272',
			'56573','85542','18944','74059','39573','05151','18074','76486','08535','92570',
			'32348','21128','43552','79070','21903','08862','46970','94060','39465','94975',
			'03458','47567','49770','16050','63070','53072','40056','80831','27040','78691',
			'78577','92371','14532','36869','35581','19103','26416','59858','54555','08865',
			'61864','97370','20131','42366','04562','21131','19460','39466','74752','43147',
			'54964','49774','75471','90662','17762','29673','46562','10968','44082','57501',
			'49339','14533','37863','36064','21208','37367','41250','19026','56473','95664',
			'63663','27041','76258','85543','48169','62274','80470','36768','08741','71601',
			'07058','12566','55063','95665','16868','27042','10969','42635','06061','31822',
			'12567','91962','83850','33781','85935','18946','37686','27043','39149','94564',
			'86510','35126','41555','89043','95666','78063','18947','56164','45356','08854',
			'12139','35765','28768','93448','13136','08071','46167','75686','15203','05762',
			'14534','18640','08867','24139','92870','95667','87043','53577','43064','07060',
			'59859','08536','79073','06062','49080','03865','75025','33564','33317','77363',
			'06479','70764','65552','68653','64079','12568','53818','64477','12901','68048',
			'90296','27313','35127','17246','97455','65725','46779','45162','62677','53158',
			'48069','06063','37146','94566','08232','59254','54467','07978','29845','72127',
			'05056','19462','02367','72455','83201','74902','21851','18350','18346','19366',
			'12140','27964','65726','15474','93042','21777','18950','94956','98281','04274',
			'16342','50226','71467','95726','59860','29126','19367','06258','06259','91766',
			'33064','13138','07442','07444','74601','00716','70454','12770','76259','83852',
			'56575','32082','32004','48340','38863','31322','20837','76487','28308','94567',
			'59255','63901','61065','39470','06064','23662','16743','70767','98363','78373',
			'77642','77650','61275','33949','10573','43452','13833','21904','54469','12466',
			'98364','98339','23138','93044','93043','48060','78578','11776','12771','77979',
			'98365','16870','07758','07865','77651','32127','98366','07064','08241','34668',
			'29935','34952','70083','20677','98368','53074','15946','63373','63873','30450',
			'88130','04068','12859','54159','93257','97223','94028','23704','49776','79356',
			'83854','52162','74953','20859','53820','13699','48876','75076','19465','17901',
			'12601','12570','98370','05764','24279','10576','24637','92074','30127','81243',
			'75473','37849','27966','23139','53955','68050','57649','47869','53821','53578',
			'72753','70769','93651','36066','86301','86314','49777','15142','98050','67570',
			'84501','25555','70770','01965','20678','23875','21853','08542','08550','96722',
			'97754','57773','55372','25164','05765','45669','50229','16052','04669','60070',
			'27314','19076','75078','29127','99350','02903','02657','84605','74361','81005',
			'96788','24301','99165','33950','15767','73080','20132','10577','69157','10578',
			'76566','39475','06260','32185','10579','05346','96784','63960','98375','21132',
			'06375','18951','22134','74363','17566','05059','85242','11427','12804','21658',
			'49082','06262','75474','49876','67752','23141','72131','11959','30568','41557',
			'70394','53408','40160','24141','43066','28376','35131','70657','47573','07065',
			'76077','35906','12976','97048','35986','27650','80832','92065','27316','07446',
			'92066','95741','91730','92270','90275','92091','92688','78575','87557','08073',
			'50231','21133','27317','84064','78150','53075','81648','60470','79366','25438',
			'61866','49676','61278','08869','83858','87740','12143','44266','98051','26164',
			'21557','82301','48096','43943','43067','65555','64083','70578','02767','02768',
			'04355','19612','54652','02137','37149','72461','07701','35582','96080','37150',
			'62278','80545','18076','12571','17356','30272','87558','78662','28377','55066',
			'30074','60961','06896','06875','06876','57469','12978','92373','61949','98073',
			'98054','90277','94065','95044','95470','18352','93654','65737','53959','17084',
			'22539','25270','46171','48757','53579','78377','30452','11374','02769','19971',
			'27323','50669','17569','21136','75784','29128','22734','13438','11960','16053',
			'89510','47978','13680','98055','56284','44867','30735','95672','91337','70084',
			'20191','02151','30273','83440','12148','31076','43068','12572','54501','22542',
			'97049','76078','92377','54470','56367','54868','37370','77873','75080','58652',
			'18954','29729','59259','44286','13439','05476','52585','53581','76118','28574',
			'18955','47374','31324','39476','60471','43344','97371','37151','21139','20680',
			'29129','93555','06877','07660','39158','26753','21660','37152','29472','29130',
			'07451','15853','19078','18077','28456','81650','12471','49276','83442','48041',
			'22650','16248','92378','31326','03461','24149','40162','24586','54471','08551',
			'17967','60072','53960','08242','78582','95673','78066','95471','87174','85648',
			'85263','94571','38063','95366','24150','83443','30738','76471','21911','71665',
			'21140','07661','54022','60305','60171','76114','48218','95367','20738','11901',
			'52327','82501','33569','49277','78379','22737','24034','27870','40979','71469',
			'70455','31078','54023','36567','63072','19551','52328','62454','38664','25173',
			'78380','68430','01542','61068','07662','65279','56578','98579','48309','61070',
			'44084','61071','12775','61201','64482','82083','53961','12575','07866','97136',
			'11694','43149','76567','42274','37853','28379','19732','32955','95677','30153',
			'78381','61072','37153','20850','11571','75087','28138','37854','64861','30740',
			'81067','08553','27803','11778','21778','44116','94572','13682','08554','29376',
			'55374','49779','65742','97537','94927','21779','72135','27571','65401','39159',
			'90274','60008','46371','55969','03869','80474','78584','72136','13440','48065',
			'60446','47981','48174','98940','11779','17572','62082','11575','00742','79358',
			'67132','93560','78953','12776','48653','48654','67133','28382','76570','97470',
			'11422','22967','60172','07204','91770','08556','55068','77471','54974','48066',
			'77583','72571','02131','11576','11577','94957','43460','15772','30741','30077',
			'56579','54474','33947','12150','27572','95975','20142','60073','29474','78680',
			'12473','12979','01367','91748','75088','01969','27573','04275','02120','84067',
			'71968','48068','33421','19468','75189','30662','53078','22968','43462','49780',
			'15679','58368','88345','88346','02916','95679','07760','50237','08078','92382',
			'83350','27045','24368','16249','14543','55069','84069','55971','18956','64484',
			'75785','41169','43348','72802','46979','24588','71272','22546','94573','28139',
			'23147','01543','30171','03870','03871','74072','04280','21780','56580','77655',
			'85247','04072','95851','07663','07458','40370','16433','34695','85546','11963',
			'02562','11962','48602','83860','49881','85629','63073','70774','63074','60964',
			'83445','32085','70085','55375','83272','56080','48081','43950','56303','54024',
			'04774','70775','70776','84770','19733','54558','78152','48656','94574','29920',
			'97051','45883','49781','20684','62281','56081','46785','58369','48879','05819',
			'13452','64504','20685','63136','83861','70582','31558','20686','29135','58370',
			'86511','43072','55113','55071','28384','56082','63376','33703','59866','70087',
			'31522','17252','63670','96950','76571','14779','99714','31784','37373','01970',
			'81201','67401','93915','48176','03268','12577','74955','84147','12578','38866',
			'40372','98075','36477','87831','95249','76906','94960','78209','75972','78586',
			'92410','94066','85550','92672','92171','91773','91340','94105','91778','00683',
			'94963','94074','92583','95132','00927','95045','92675','94578','94580','81152',
			'93403','92078','91108','95046','94402','94806','90734','94964','94912','94583',
			'93452','78067','92143','14132','03269','03872','26430','49343','74063','32087',
			'31082','78383','87047','62882','03873','83864','23150','55072','44871','60548',
			'84094','13145','06482','16145','27046','20860','25275','81151','93657','33957',
			'92705','93111','95052','91350','47579','95065','77510','90670','93453','93458',
			'90402','93061','96915','95407','32459','88008','93460','92070','84655','92071',
			'74067','36571','48881','34235','77585','12866','45171','38666','54870','56377',
			'16055','32937','32189','39574','49453','12477','01906','56379','53080','49783',
			'02874','13456','94966','30571','55378','31408','01256','05154','18353','18840',
			'08872','11782','61075','55073','54977','97056','04070','10583','17088','12154',
			'60173','12305','12155','46375','78154','60176','18078','12156','54476','96857',
			'12157','49087','70395','12870','78956','68661','12985','12871','17972','19473',
			'97374','18354','47273','02066','07076','95565','06264','27874','18355','72142',
			'62225','67871','25560','49088','95066','69361','35768','47170','85255','42164',
			'49454','18504','75158','11579','08750','31561','08243','98380','29940','11783',
			'75159','90740','04674','04675','77474','45679','89046','72145','04973','04974',
			'93955','08751','08752','98134','98644','04075','32978','95472','42455','44672',
			'07094','35771','65302','67361','67135','86339','98284','02771','92273','33584',
			'78155','98942','19975','11784','48045','17870','12158','47172','18960','36703',
			'38375','39479','33775','36575','63876','38668','64865','13148','30276','98382',
			'51054','08557','62884','45062','28578','17360','80546','21144','21146','67137',
			'37862','44273','37375','15954','07077','08080','15143','53584','47274','60550',
			'17255','97539','20764','25918','43947','55074','93263','55379','32579','28470',
			'17872','17876','12480','15560','30172','04076','02067','44274','19079','67758',
			'32959','21782','16150','21861','19554','96019','43349','93664','18708','29152',
			'54166','04975','74804','66211','18356','53081','53085','05866','44054','63468',
			'05482','59474','48316','37162','50243','05483','05485','02070','54871','83274',
			'52332','15774','11965','06484','51601','25442','10587','48883','25443','40165',
			'76311','01770','13460','72150','06784','91403','17090','61281','52073','97140',
			'56676','18655','44878','95682','16748','96088','26431','54170','22971','17257',
			'46565','01464','17260','47581','18458','12481','11786','98155','07078','14548',
			'83352','82649','85902','44676','71119','17361','10588','12873','01072','02564',
			'64088','08081','45365','96125','91024','85635','15860','37377','63801','36919',
			'27344','72761','77656','81652','98287','88061','30173','03875','20904','34488',
			'92676','98315','29145','80498','97381','61282','93063','18407','40067','06070',
			'24976','51250','51109','57109','15561','57262','97759','99835','49885','13152',
			'08558','19474','23968','60076','04976','28776','18357','71475','10973','18080',
			'79364','70777','56172','15684','70461','53086','12159','12160','10974','95683',
			'71762','95977','78159','84335','36877','42171','21783','62285','11787','37166',
			'17576','30082','28460','30078','98296','98065','21863','16874','81654','81615',
			'79550','54171','30025','87801','95728','37379','14551','14555','92075','54655',
			'99669','18963','93960','67480','20688','52333','47459','93464','08083','06071',
			'08244','02726','03878','85350','02143','93066','60552','95476','95370','30457',
			'95073','32776','18964','11789','77659','52334','08879','05670','33493','97366',
			'61080','46680','03908','12161','24592','08880','05407','14557','04077','45368',
			'04358','02748','01373','02660','02375','01258','91733','60177','90280','06073',
			'12803','01560','07606','01075','01982','02661','49090','05486','23970','60473',
			'67505','84095','06785','96156','01561','45065','48178','27976','53172','18843',
			'07079','02662','13155','11420','78597','04281','15129','91031','61564','37380',
			'07080','45680','04106','41174','98385','49963','11419','08882','48179','05068',
			'55075','10590','94080','68776','04858','45369','14139','02071','45682','02663',
			'64863','41503','06266','06074','05071','02664','18966','38671','01772','01550',
			'06488','19399','28387','48076','10975','48195','06489','76092','11971','28461',
			'25187','04679','01077','98386','49886','98387','99031','84660','36527','10976',
			'89436','21152','12780','21219','07871','29305','16434','57783','71277','37870',
			'73084','14559','12165','46788','11972','74073','22740','47385','56288','78669',
			'28160','18968','83869','74959','77372','03462','99207','54801','08884','22553',
			'12166','93962','77382','78070','14140','19475','89815','53588','60081','34609',
			'27882','19477','49456','16875','55384','45370','16435','72765','73458','62887',
			'85938','01103','11413','71075','79082','47386','18081','47462','14560','28777',
			'25565','93675','00831','00804','12580','55079','67578','06076','41256','06904',
			'40379','71860','22973','55080','48658','28163','94309','12581','07874','14561',
			'40380','98292','56479','36578','83669','71667','22654','56381','05487','39759',
			'18461','50247','16805','39362','28676','72467','89449','10309','30458','28625',
			'24401','97383','80477','28391','35987','62288','04085','60475','98388','28582',
			'27581','39529','71764','22655','49887','12169','76401','20164','76951','10979',
			'48310','35147','04488','54480','04680','43953','17578','54481','21153','91381',
			'21666','95374','39767','17363','08886','55976','46180','01467','61084','74075',
			'66085','94970','07980','30281','78160','18083','07460','95219','03464','27357',
			'08247','30087','12484','02180','71078','06378','11790','10980','43463','50588',
			'12582','06268','65756','53589','65078','01775','05672','65757','44680','06615',
			'03885','08248','93267','80836','95375','37871','60107','21154','75859','44241',
			'04983','44149','74079','18360','54770','44471','43557','14145','34994','24477',
			'91604','23162','01566','54235','55783','42459','53177','72160','12173','54173',
			'67877','97385','07876','01776','21668','10901','06078','23434','60554','03585',
			'77478','10981','38380','30746','44681','18249','33044','94585','20746','47882',
			'29482','70663','75483','98294','22742','17093','27358','93067','33042','72769',
			'38483','29483','07901','18250','25446','04292','18084','39482','29150','85372',
			'33573','85375','53590','83353','03782','59482','17801','01375','48890','91041',
			'11104','94085','94586','79086','33323','65079','76270','90742','68978','28462',
			'98392','90743','54174','85387','58785','04684','96130','18847','53089','23885',
			'97479','95982','95685','01590','49682','30024','30401','01907','28584','02777',
			'21561','03446','19081','48473','08085','77480','97386','65351','18656','36782',
			'79556','18370','52338','24479','60178','58486','21784','35151','91342','28779',
			'43560','31791','11791','13215','22743','51653','28463','98408','93268','18464',
			'06380','74465','96146','96148','96142','98588','20912','74080','37877','70464',
			'20690','35160','32312','30176','36078','34270','44278','10982','62688','18252',
			'33321','18371','62988','33619','61283','96931','03886','21787','32777','12485',
			'87571','22560','10983','27886','06081','34689','10591','91356','47175','18085',
			'02780','32778','33070','48763','76574','41015','61284','29687','55084','40071',
			'62568','24651','57064','75860','07666','84773','02536','25569','74873','93561',
			'68061','75488','18969','47586','81435','92592','85281','48182','19560','91780',
			'20757','93465','37880','07670','98589','07763','75861','37178','47637','79852',
			'93270','45174','47803','97760','75160','39170','06786','87574','83025','01876',
			'75505','77590','73949','88135','25694','85552','97058','20198','95497','36582',
			'82443','05075','70302','56701','10984','53092','06787','27361','58278','10985',
			'37179','17094','12784','61285','33592','22565','19372','01079','76687','46071',
			'43076','10594','08086','35171','91362','92276','08887','49128','93271','17264',
			'51654','21788','97482','70466','12883','44883','31793','54486','87059','97141',
			'71670','97484','12486','43963','27583','80547','96952','60477','16946','45371',
			'46072','36080','08560','02878','12583','23168','27050','18466','30577','52341',
			'99678','99780','76476','43697','06084','85353','58787','93667','91610','75489',
			'54660','54487','94971','77377','85638','87060','10986','08753','14150','35773',
			'66086','74653','85354','72770','84074','39364','90290','46571','80479','23169',
			'01983','04086','19562','84774','43964','90510','87061','06790','07511','07082',
			'67144','59644','07676','16360','21286','92678','95376','37387','20779','98393',
			'15085','93668','16154','21673','72167','29690','49696','94535','13846','33706',
			'54888','38876','54661','08628','95075','53179','17881','18087','51575','22172',
			'64492','95570','27370','96091','30753','96859','54564','76262','75789','14885',
			'17771','97060','28166','24175','45374','96162','25988','49347','72472','14886',
			'68980','50257','35173','13158','28782','97062','85646','10707','30084','08087',
			'85718','91043','98188','57476','78162','37388','13159','74128','38676','18657',
			'30755','95379','38804','70585','95380','04282','65765','01376','15145','58575',
			'35406','21790','61953','35674','36083','36087','92782','73089','28784','10987',
			'95383','92277','83301','49457','53181','92391','44087','54241','31328','75709',
			'18971','39667','01879','30290','80840','67146','44683','95482','18850','12487',
			'67880','71971','13849','99685','06382','05489','51576','37692','41091','21791',
			'45390','18470','35175','24176','48387','46382','49129','30669','13160','64494',
			'11553','44685','06085','54488','78148','38677','16802','98467','58789','91784',
			'18972','19082','21156','12987','20792','43351','21155','20184','01568','61803',
			'50322','16362','78884','78802','19480','01569','95696','70090','98593','81658',
			'12584','12184','99686','31601','28168','16059','10595','94590','63087','68064',
			'92082','44280','10989','12185','94972','19481','26060','35989','20692','76689',
			'63088','95252','11581','76272','91617','46383','33595','75790','75495','72956',
			'54979','13475','50261','91408','45891','28586','98665','62471','49795','34107',
			'15690','37181','45890','25696','29944','14167','98070','28394','48768','07088',
			'79092','00692','58790','97487','15367','34292','08406','93002','76084','99037',
			'12585','36091','89439','91046','62994','44089','57069','49096','84078','62892',
			'24597','60061','06066','97064','32968','65769','10596','45380','13850','84782',
			'41773','43464','39183','14564','77904','92393','12884','71373','77662','22180',
			'22746','41017','60181','30180','62996','01718','00766','19085','08251','70586',
			'72173','35593','47591','41386','40175','95487','08361','02568','74301','20187',
			'24179','83872','70092','62690','41572','62691','23454','19564','93291','92084',
			'16156','59351','95689','06384','78073','08043','12186','06107','02468','46992',
			'10597','76706','55387','85355','13694','40076','28395','56482','47638','11792',
			'29487','44282','74467','19376','28396','96786','58074','96791','96792','96738',
			'96793','96795','96796','11975','96797','56387','99361','05673','46573','27588',
			'01880','44889','43465','52773','12586','72475','32694','04572','20602','97394',
			'46182','07463','48027','30183','52351','56484','21793','46574','27051','49459',
			'99362','28466','77484','19086','07057','12589','97885','38680','99363','91789',
			'94595','95690','72476','76690','18088','03608','29488','02454','68461','62894',
			'53184','66547','13163','16157','55983','07465','46390','74878','11793','45895',
			'63966','12590','18660','55793','40874','72176','99928','01082','02571','08758',
			'78074','18974','74469','31098','92086','13164','48089','15095','12885','30828',
			'60555','18976','35180','16877','56763','46582','21912','93280','56093','04786',
			'20037','43160','18977','06794','20880','10992','89704','98671','99654','75692',
			'12592','07069','11976','38965','04087','06720','05677','87421','48327','08089',
			'50703','14571','49969','06795','43566','03215','12189','55389','30677','73772',
			'60970','35181','17777','95076','16442','56589','33873','60084','50263','60087',
			'53189','73773','52172','98395','53597','54981','53963','68786','54401','43567',
			'54982','53826','47989','68462','46794','75167','28173','31502','49348','18472',
			'48184','30830','15370','28786','24985','55391','03281','76086','18255','06089',
			'28787','64870','48892','57274','36278','96094','13166','34607','68463','48893',
			'78962','72479','66781','26062','83672','24801','97067','27374','80653','32094',
			'02482','02481','02667','29385','67152','05774','05081','16901','45692','43968',
			'70591','98807','27591','01984','08090','64873','63385','19565','78599','45381',
			'63386','11707','02668','53095','08091','35184','48323','01885','01583','52358',
			'02379','01585','61378','05871','45449','02669','12992','19380','03466','60185',
			'29169','06796','91790','12192','08092','02670','50266','05356','13485','27376',
			'14170','02574','58078','04992','72774','62896','21794','05875','06090','02817',
			'19390','10604','05084','06091','06516','10993','72390','11552','14586','91308',
			'12491','02672','11795','43162','84088','04094','02892','47906','47991','13489',
			'26074','97068','07764','22103','02156','72303','15122','07480','45383','71294',
			'07093','01985','02465','03291','10994','49460','07052','03890','42086','33403',
			'04289','12493','65775','19486','99353','20778','02132','05777','95605','54669',
			'12196','11796','12494','06092','42564','01089','01266','06093','47885','02575',
			'01474','45693','43570','14171','02576','01092','02893','89883','02673','59758',
			'08060','64498','01581','06498','12785','11590','54667','60154','12193','02891',
			'68464','60558','43082','01086','44251','01886','11977','11978','77994','70669',
			'91359','48186','95387','92685','60559','03467','92281','64098','02790','02791',
			'19395','61883','70094','96137','06109','49895','36093','32465','74884','15090',
			'54983','24486','02190','77488','36482','80033','46392','82201','60189','46393',
			'96854','45694','60090','41669','07981','57276','37187','70788','97503','49349',
			'71612','18661','61884','02381','37188','48383','23183','85912','75693','49099',
			'49971','10605','05001','98672','88002','58540','24986','04353','59937','21160',
			'54773','75791','08889','46184','65305','76273','30185','11357','46075','28472',
			'81527','57793','75491','39193','08759','05361','01588','02382','48189','76692',
			'27377','48190','90603','67232','76305','85390','44092','80654','45384','01095',
			'74578','68982','38589','92595','08260','18701','28697','98396','46186','31650',
			'84340','21874','85643','95987','53191','01096','14589','47993','29697','17098',
			'62693','72482','06226','08046','06279','48191','38076','11596','95490','56201',
			'44094','58384','95573','19090','55795','27592','60480','17584','45696','95988',
			'75169','36587','15148','60091','28412','40390','83014','97070','06897','33598',
			'78676','58492','46996','01475','47394','06094','18091','15963','30680','34786',
			'46076','03087','05089','06096','21244','67156','47994','12594','42088','98596',
			'61088','89445','60093','77665','75494','38967','46590','05404','47598','06098',
			'30187','27103','54896','34787','04693','33881','80482','32719','04496','95694',
			'50273','30683','13697','60096','50274','24184','04578','53965','54495','24293',
			'58495','54499','41274','85361','72686','48393','01888','68882','06716','46795',
			'59201','03894','79382','46796','19567','60097','53968','60191','07075','68883',
			'02894','94973','51579','12788','07095','42170','08096','08097','07677','22580',
			'11421','98072','75865','98674','91365','80866','37191','19094','11598','60517',
			'84086','84087','02543','21798','43793','11377','62695','60098','06282','08098',
			'03785','01784','73801','76712','71485','81656','04579','02895','44691','05682',
			'59088','82401','01097','60482','57077','01098','21678','80758','30833','02093',
			'82732','63390','08562','31096','28480','92397','12790','18853','11798','48192',
			'07481','18980','75098','68466','12198','19095','72396','73098','55092','24382',
			'45385','98675','98909','99689','23897','97148','34498','57078','75497','11980',
			'04096','02675','00698','39194','45387','98597','89447','92398','96929','80864',
			'96914','10710','92885','17402','03910','03911','17370','17371','17372','19736',
			'45388','47396','10598','60560','42566','55397','30582','32466','70592','85363',
			'15697','94599','48198','96097','95992','92399','92286','73099','12792','32097',
			'85367','70791','95698','43360','43701','30295','49464','62999','53195','89448',
			'33541','98953','55398','60099','18092','33890','55991','55992','23898','52079'];




//Data File Generation:

BlankSet := DATASET([{0,'','','','','','','','',[]}],Layout_Combined);
CountCSZ := 9540;

//generate 1,000,000 unique records
Layout_Combined CreateRecs(Layout_Combined L, INTEGER C,INTEGER W) := TRANSFORM
  SELF.FirstName := IF(W=1,SetFnames[C],L.FirstName);
  SELF.LastName  := IF(W=2,SetLnames[C],L.LastName);
  SELF := L;
END;
base_fn  := NORMALIZE( BlankSet, P_Mult1, CreateRecs(LEFT, COUNTER,1));
base_fln := NORMALIZE( base_fn , P_Mult2, CreateRecs(LEFT, COUNTER,2));

//populate the rest of the Person fields
Layout_Combined PopulateRecs(Layout_Combined L, Layout_Combined R,INTEGER HashVal) := TRANSFORM
	CSZ_Rec            := (HashVal % CountCSZ) + 1;
	SELF.PersonID      := IF(L.PersonID=0,Std.System.Thorlib.Node()+1,L.PersonID + CLUSTERSIZE);
  SELF.MiddleInitial := SetMiddleInitials[(HashVal % 100) + 1 ];	
  SELF.Gender        := CHOOSE((HashVal % 2) + 1,'F','M');
  SELF.Street        := SetStreets[(HashVal % 2400) + 1 ];
  SELF.City          := SetCity[CSZ_Rec];
  SELF.State         := SetStates[CSZ_Rec];
  SELF.Zip           := SetZips[CSZ_Rec];
  SELF               := R;
END;
base_fln_dist := DISTRIBUTE(base_fln,HASH32(FirstName,LastName));
base_people   := ITERATE(base_fln_dist,PopulateRecs(LEFT,RIGHT,HASHCRC(RIGHT.FirstName,RIGHT.LastName)),LOCAL);
base_people_dist := DISTRIBUTE(base_people,HASH32(PersonID));

//create child records
BlankKids := DATASET([{0,'','','','','',0,0,0,0}],Layout_Accounts_Link);
SetLinks  := SET(base_people,PersonID);

SetIndustrycodes := ['BB','DC','ON','FM','FP','FF','FC','FA','FZ','CG','FS','OC',
									   'ZZ','HZ','UT','HF','CS','DM','JA','FY','HT','UE','DZ','AT'];
SetAcctRates := ['1','0','9','*','Z','5','B','2','3','4','A','7','8','E','C'];
SetDateYears := ['1987','1988','1989','1990','1991','1992','1993','1994','1995','1996',
                 '1997','1998','1999','2000','2001','2002','2003','2004','2005','2006'];
SetMonthDays := [31,28,31,30,31,30,31,31,30,31,30,31];
SetNarrs     := [229,158,2,0,66,233,123,214,169,248,67,127,168,65,208,
                 114,73,218,238,57,125,113,88,247,244,121,54,220,98,97];

Layout_Accounts_Link CreateKids(Layout_Accounts_Link L,INTEGER C) := TRANSFORM
  CSZ_IDX       := C % CountCSZ + 1;
  HashVal       := HASH32(SetCity[CSZ_IDX],SetStates[CSZ_IDX],SetZips[CSZ_IDX]);
	DateMonth     := HashVal % 12 + 1;
  SELF.PersonID := CHOOSE(TRUNCATE(C / TotalParents) + 1,
													IF(C%2=0,
														 SetLinks[C % TotalParents + 1],
														 SetLinks[TotalParents - (C % TotalParents)]),
													IF(C%3<>0,
														 SetLinks[C % TotalParents + 1],
														 SetLinks[TotalParents - (C % TotalParents)]),
													IF(C%5=0,
														 SetLinks[C % TotalParents + 1],
														 SetLinks[TotalParents - (C % TotalParents)]),
													IF(C%7<>0,
														 SetLinks[C % TotalParents + 1],
														 SetLinks[TotalParents - (C % TotalParents)]),
													SetLinks[C % TotalParents + 1]);
	SELF.Account      := (STRING)HashVal;
	SELF.OpenDate     := SetDateYears[DateMonth] + INTFORMAT(DateMonth,2,1) + INTFORMAT(HashVal % SetMonthDays[DateMonth] + 1,2,1);
	SELF.IndustryCode := SetIndustrycodes[HashVal % 24 + 1];
	SELF.AcctType     := CHOOSE( HashVal % 5 + 1,'O','R','I','9',' ');
	SELF.AcctRate     := SetAcctRates[HashVal % 15 + 1];
	SELF.Code1        := SetNarrs[HashVal % 15 + 1];
	SELF.Code2        := SetNarrs[HashVal % 15 + 16];
	SELF.HighCredit   := HashVal % 50000;
	SELF.Balance      := TRUNCATE((HashVal % 50000)*((HashVal%100+1)/100));
END;

base_kids      := NORMALIZE(BlankKids,TotalChildren,CreateKids(LEFT,COUNTER));
base_kids_dist := DISTRIBUTE(base_kids,HASH32(PersonID));

//Add child records to each parent
Layout_Combined AddKids(Layout_Combined L, base_kids R) := TRANSFORM
  SELF.Accounts := L.Accounts + ROW({R.Account,R.OpenDate,R.IndustryCode,R.AcctType,
																		 R.AcctRate,R.Code1,R.Code2,R.HighCredit,R.Balance},Layout_Accounts);
  SELF := L;
  END;
base_combined := DENORMALIZE( base_people_dist , 
															base_kids_dist, 
															LEFT.PersonID = RIGHT.PersonID,
															AddKids(LEFT, RIGHT));

//write files to disk
O1 := OUTPUT(PROJECT(base_people_dist,Layout_Person),,'~PROGGUIDE::EXAMPLEDATA::People',OVERWRITE);
O2 := OUTPUT(base_kids_dist,,'~PROGGUIDE::EXAMPLEDATA::Accounts',OVERWRITE);
O3 := OUTPUT(base_combined,,'~PROGGUIDE::EXAMPLEDATA::PeopleAccts',OVERWRITE);

P1 := PARALLEL(O1,O2,O3);

D1 := DATASET('~PROGGUIDE::EXAMPLEDATA::People',{Layout_Person,UNSIGNED8 RecPos{VIRTUAL(fileposition)}}, THOR);
D2 := DATASET('~PROGGUIDE::EXAMPLEDATA::Accounts',{Layout_Accounts_Link,UNSIGNED8 RecPos{VIRTUAL(fileposition)}}, THOR);
D3 := DATASET('~PROGGUIDE::EXAMPLEDATA::PeopleAccts',{Layout_Combined,UNSIGNED8 RecPos{VIRTUAL(fileposition)}},THOR);

I1 := INDEX(D1,{PersonID,RecPos},'~PROGGUIDE::EXAMPLEDATA::KEYS::People.PersonID');
I2 := INDEX(D2,{PersonID,RecPos},'~PROGGUIDE::EXAMPLEDATA::KEYS::Accounts.PersonID');
I3 := INDEX(D3,{PersonID,RecPos},'~PROGGUIDE::EXAMPLEDATA::KEYS::PeopleAccts.PersonID');

I4 := INDEX(D1,{LastName,FirstName,RecPos},'~PROGGUIDE::EXAMPLEDATA::KEYS::People.LastName.FirstName');
I5 := INDEX(D1,{PersonID},{FirstName,LastName,MiddleInitial,Gender,Street,City,State,Zip,RecPos},'~PROGGUIDE::EXAMPLEDATA::KEYS::People.PersonID.Payload');
I6 := INDEX(D2,{PersonID},{Account,OpenDate,IndustryCode,AcctType,AcctRate,Code1,Code2,HighCredit,Balance,RecPos},'~PROGGUIDE::EXAMPLEDATA::KEYS::Accounts.PersonID.Payload');
I7 := INDEX(D1,{LastName,FirstName},{D1},'~PROGGUIDE::EXAMPLEDATA::KEYS::People.LastName.FirstName.Payload');
I8 := INDEX(D1,{State,City,Zip,Lastname,Firstname},{D1},'~PROGGUIDE::EXAMPLEDATA::KEYS::People.State.City.Zip.LastName.FirstName.Payload');

B1 := BUILDINDEX(I1,OVERWRITE);
B2 := BUILDINDEX(I2,OVERWRITE);
B3 := BUILDINDEX(I3,OVERWRITE);

B4 := BUILDINDEX(I4,OVERWRITE);
B5 := BUILDINDEX(I5,OVERWRITE);
B6 := BUILDINDEX(I6,OVERWRITE);
B7 := BUILDINDEX(I7,OVERWRITE);
B8 := BUILDINDEX(I8,OVERWRITE);

P2 := PARALLEL(B1,B2,B3,B4,B5,B6,B7,B8);

SEQUENTIAL(P1,P2);

//*****************************************************************************
//This code creates an XML dataset of area codes and their associated timezones

InDS := DATASET([
					{201,'','Eastern Time Zone'},
					{202,'','Eastern Time Zone'},
					{203,'','Eastern Time Zone'},
					{204,'','Central Time Zone'},
					{205,'','Central Time Zone'},
					{206,'','Pacific Time Zone'},
					{207,'','Eastern Time Zone'},
					{208,'','Mountain and Pacific Time Zones'},
					{209,'','Pacific Time Zone'},
					{210,'','Central Time Zone'},
					{212,'','Eastern Time Zone'},
					{213,'','Pacific Time Zone'},
					{214,'','Central Time Zone'},
					{215,'PA Pennsylvania (Philadelphia area, overlays with 267 and 445)','Eastern Time Zone'},
					{216,'OH Ohio (Cleveland area)','Eastern Time Zone'},
					{217,'IL Illinois (Champaign, Decatur, Urbana, Springfield and central Illinois)','Central Time Zone'},
					{218,'MN Minnesota (Duluth, Thief River Falls, Brainerd, International Falls and northern Minnesota)','Central Time Zone'},
					{219,'IN Indiana (Gary, Valparaiso, Michigan City, Goodland, Fowler and northwestern Indiana)','Central and Eastern Time Zones'},
					{224,'IL Illinois (Waukegan, Des Plaines, northwest Chicago suburbs and northeastern Illinois, overlays with 847)','Central Time Zone'},
					{225,'LA Louisiana (Baton Rouge, New Roads, White Castle and central eastern Louisiana)','Central Time Zone'},
					{228,'MS Mississippi (Gulfport, Pascagoula, Biloxi, Bay St Louis and southern Mississippi gulf coast)','Central Time Zone'},
					{229,'GA Georgia (Albany, Valdosta, Bainbridge, Americus, Fitzgerald and southwestern Georgia)','Eastern Time Zone'},
					{231,'MI Michigan (Traverse City, Ludington, Muskegon, Petoskey and northwestern Michigan)','Eastern Time Zone'},
					{234,'OH Ohio (Youngstown, Warren, Akron, Canton and northeastern Ohio, overlays with 330)','Eastern Time Zone'},
					{239,'FL Florida (Fort Meyers, Naples, Everglades and southwestern Florida)','Eastern Time Zone'},
					{240,'MD Maryland (Hagerstown, Rockville, Cumberland and western Maryland, overlays with 301)','Eastern Time Zone'},
					{242,'BAHAMAS (all of Bahamas)','Atlantic Time Zone'},
					{246,'BARBADOS (all of Barbados)','Atlantic Time Zone'},
					{248,'MI Michigan (Troy, Oakland County, Pontiac, Southfield, Rochester Hills and northwestern Detroit suburbs)','Eastern Time Zone'},
					{250,'BC British Columbia (all except Vancouver area)','Mountain and Pacific Time Zones'},
					{251,'AL Alabama (Mobile, Jackson and southwestern Alabama)','Central Time Zone'},
					{252,'NC North Carolina (Greenville, Kitty Hawk, Rocky Mount and northeastern North Carolina)','Eastern Time Zone'},
					{253,'WA Washington (Tacoma, Auburn, Puyallup, Enumclaw, Spanaway and south Seattle suburbs)','Pacific Time Zone'},
					{254,'TX Texas (Waco, Killeen, Belton, Stephenville and north central Texas)','Central Time Zone'},
					{256,'AL Alabama (Florence, Huntsville, Gadsden, Anniston and northern and eastern Alabama)','Central Time Zone'},
					{260,'IN Indiana (Fort Wayne, Decatur, Angola, Wabash and northeastern Indiana)','Central and Eastern Time Zones'},
					{262,'WI Wisconsin (Menomonee Falls, Waukesha, Racine and southeastern Wisconsin excluding Milwaukee area)','Central Time Zone'},
					{264,'ANGUILLA (all of Anguilla)','Atlantic Time Zone'},
					{267,'PA Pennsylvania (Philadelphia area, overlays with 215 and 445)','Eastern Time Zone'},
					{268,'ANTIGUA and BARBUDA (all of Antigua and Barbuda)','Atlantic Time Zone'},
					{270,'KY Kentucky (Paducah, Bowling Green, Hopkinsville, Owensboro and western Kentucky)','Central Time Zone'},
					{276,'VA Virginia (Abingdon, Wytheville, Martinsville, Bluefield and western Virginia)','Eastern Time Zone'},
					{281,'TX Texas (Spring, Katy, Houston area, overlays with 713 and 832)','Central Time Zone'},
					{284,'BRITISH VIRGIN ISLANDS (all of the British Virgin Islands)','Atlantic Time Zone'},
					{289,'ON Ontario (Hamilton, Toronto suburbs and central southeastern Ontario, overlays with 905)','Eastern Time Zone'},
					{301,'MD Maryland (Hagerstown, Rockville, Cumberland and western Maryland, overlays with 240)','Eastern Time Zone'},
					{302,'DE Delaware (all of Delaware)','Eastern Time Zone'},
					{303,'CO Colorado (Boulder, Longmont, Aurora, Denver and central Colorado, overlays with 720)','Mountain Time Zone'},
					{304,'WV West Virginia (all of West Virginia)','Eastern Time Zone'},
					{305,'FL Florida (Miami, Homestead, Coral Gables, Key West and southeastern Florida, overlays with 786)','Eastern Time Zone'},
					{306,'SK Saskatchewan (all of Saskatchewan)','Central and Mountain Time Zones'},
					{307,'WY Wyoming (all of Wyoming)','Mountain Time Zone'},
					{308,'NE Nebraska (North Platte, Scottsbluff, McCook, Grand Island and western Nebraska)','Central and Mountain Time Zones'},
					{309,'IL Illinois (Peoria, Moline, Rock Island, Galesburg and central western Illinois)','Central Time Zone'},
					{310,'CA California (Malibu, Torrance, Beverley Hills, Santa Monica, Catalina and western Los Angeles suburbs)','Pacific Time Zone'},
					{311,'NON-EMERGENCY ACCESS',''},
					{312,'IL Illinois (downtown central Chicago area)','Central Time Zone'},
					{313,'MI Michigan (Dearborn, Detroit and inner Detroit suburbs)','Eastern Time Zone'},
					{314,'MO Missouri (St Louis, Florissant, Crestwood, Affton, Granite City and surrounding suburbs)','Central Time Zone'},
					{315,'NY New York (Watertown, Utica, Syracuse and north central New York)','Eastern Time Zone'},
					{316,'KS Kansas ( Wichita, Augusta, El Dorado, Mulvane and the Wichita surrounding area)','Central Time Zone'},
					{317,'IN Indiana (Indianapolis, Greenwood, Mooresville, Beech Grove and central Indiana)','Central and Eastern Time Zones'},
					{318,'LA Louisiana (Shreveport, Monroe, Alexandria, Fisher, Tallulah and northern Louisiana)','Central Time Zone'},
					{319,'IA Iowa (Burlington, Iowa City, Cedar Rapids, Waterloo and east central and southeastern Iowa)','Central Time Zone'},
					{320,'MN Minnesota (St Cloud, Morris, Hutchinson, Sandstone, Appleton and central Minnesota)','Central Time Zone'},
					{321,'FL Florida (Orlando, Cocoa Beach, St Cloud and central eastern Florida, overlays with 407)','Eastern Time Zone'},
					{323,'CA California (Florence and Los Angeles excluding downtown Los Angeles)','Pacific Time Zone'},
					{330,'OH Ohio (Youngstown, Warren, Akron, Canton and northeastern Ohio, overlays with 234)','Eastern Time Zone'},
					{334,'AL Alabama ( Montgomery, Auburn, Dothan, Selma and southeastern Alabama)','Central Time Zone'},
					{336,'NC North Carolina (Winston-Salem, Greensboro, North Wilkesboro and northwest North Carolina)','Eastern Time Zone'},
					{337,'LA Louisiana (Leesville, Lake Charles, Lafayette, De Ridder and southwestern Louisiana)','Central Time Zone'},
					{339,'MA Massachusetts (Saugus, Norwood and east central Massachusetts, overlays with 781)','Eastern Time Zone'},
					{340,'US VIRGIN ISLANDS (all of the US Virgin Islands)','Atlantic Time Zone'},
					{345,'CAYMAN ISLANDS (all of the Cayman Islands)','Eastern Time Zone'},
					{347,'NY New York (Flushing, Jamaica, Brooklyn, Staten Island, Bronx and Queens, overlays with 718 and 917)','Eastern Time Zone'},
					{351,'MA Massachusetts (Fitchburg, Peabody and northeastern Massachusetts, overlays with 978)','Eastern Time Zone'},
					{352,'FL Florida (Gainesville, Ocala, Inverness, Dunnellon and central Florida)','Eastern Time Zone'},
					{360,'WA Washington (Bellingham, Vancouver, Aberdeen, Olympia and western Washington except Seattle area)','Pacific Time Zone'},
					{361,'TX Texas (Corpus Christi, Victoria, George West and southeastern Texas)','Central Time Zone'},
					{386,'FL Florida (Daytona Beach, Lake City, Live Oak, Crescent City and northern and eastern Florida)','Eastern Time Zone'},
					{401,'RI Rhode Island (all of Rhode Island)','Eastern Time Zone'},
					{402,'NE Nebraska (Valentine, Lincoln, Norfolk, Omaha, Superior, Crofton and eastern Nebraska)','Central Time Zone'},
					{403,'AB Alberta (Calgary, Banff, Red Deer, Medicine Hat, Lethbridge and southern Alberta)','Mountain Time Zone'},
					{404,'GA Georgia (central Atlanta area, overlays with 470 and 678)','Eastern Time Zone'},
					{405,'OK Oklahoma (Oklahoma City, Edmond, Norman, Shawnee, Chickasha and central Oklahoma)','Central Time Zone'},
					{406,'MT Montana (all of Montana)','Mountain Time Zone'},
					{407,'FL Florida (Orlando, Cocoa Beach, St Cloud and central eastern Florida, overlays with 321)','Eastern Time Zone'},
					{408,'CA California (Los Gatos, Milpitas, Sunnyvale, Cupertino and San Jose area)','Pacific Time Zone'},
					{409,'TX Texas (Beaumont, Galveston, Port Arthur, Jasper and southeastern Texas)','Central Time Zone'},
					{410,'MD Maryland (Annapolis, Baltimore, Salisbury and eastern Maryland, overlays with 443)','Eastern Time Zone'},
					{411,'LOCAL DIRECTORY ASSISTANCE',''},
					{412,'PA Pennsylvania (Pittsburgh area, McKeesport, Braddock, Duquesne, overlays with 878)','Eastern Time Zone'},
					{413,'MA Massachusetts (Pittsfield, Springfield, Holyoke, Greenfield and western Massachusetts)','Eastern Time Zone'},
					{414,'WI Wisconsin (Milwaukee, Greenfield, Oak Creek and Milwaukee suburbs)','Central Time Zone'},
					{415,'CA California (Sausalito, San Rafael, Novato, San Quentin, San Francisco and bay area)','Pacific Time Zone'},
					{416,'ON Ontario (Toronto area, overlays with 647)','Eastern Time Zone'},
					{417,'MO Missouri (Joplin, Springfield, West Plains, Lamar, Lebanon and southwestern Missouri)','Central Time Zone'},
					{418,'QC Quebec (Quebec and eastern Quebec)','Eastern Time Zone'},
					{419,'OH Ohio (Toledo, Mansfield, Lima, Bryan, Sandusky, Bowling Green and northwestern Ohio, overlays with 567)','Eastern Time Zone'},
					{423,'TN Tennessee (Bristol, Sweetwater, Chattanooga, and southeastern and north eastern Tennessee)','Central and Eastern Time Zones'},
					{425,'WA Washington (north and east Seattle suburbs including Everett, Bellevue, Redmond, Renton and Issaquah)','Pacific Time Zone'},
					{434,'VA Virginia (Lynchburg, Danville, South Hill, Charlottesville and south central Virginia)','Eastern Time Zone'},
					{435,'UT Utah (Logan, St George, Moab and all of Utah excluding Salt Lake City, Ogden, Provo and central Utah)','Mountain Time Zone'},
					{440,'OH Ohio (Elyria, Lorain, Oberlin, Wellington and north central Ohio)','Eastern Time Zone'},
					{441,'BERMUDA (all of Bermuda)','Atlantic Time Zone'},
					{443,'MD Maryland (Annapolis, Baltimore, Salisbury and eastern Maryland, overlays with 410)','Eastern Time Zone'},
					{445,'PA Pennsylvania (Philadelphia area, overlays with 215 and 267)','Eastern Time Zone'},
					{450,'QC Quebec (central southern Quebec excluding Montreal)','Eastern Time Zone'},
					{456,'INTERNATIONAL INBOUND',''},
					{469,'TX Texas (Dallas area, overlays with 214 and 972)','Central Time Zone'},
					{470,'GA Georgia (Atlanta, Gainesville and north central Georgia, overlays with 404 and 678 and 770)','Eastern Time Zone'},
					{473,'GRENADA (all of Grenada)','Atlantic Time Zone'},
					{475,'CT Connecticut ( Bridgeport, New Haven, Waterbury and southwestern Connecticut, overlays with 203)','Eastern Time Zone'},
					{478,'GA Georgia (Macon, Warner Robins, Swainsboro, Wadley, Milledgeville, Perry and central Georgia)','Eastern Time Zone'},
					{479,'AR Arkansas (Fort Smith, Fayetteville and northwestern Arkansas)','Central Time Zone'},
					{480,'AZ Arizona (Chandler, eastern Phoenix area and eastern Phoenix suburbs only)','Mountain and Pacific Time Zones'},
					{484,'PA Pennsylvania (Reading, Allentown, Chester and southeastern Pennsylvania, overlays with 610 and 835)','Eastern Time Zone'},
					{500,'PERSONAL COMMUNICATIONS SERVICES',''},
					{501,'AR Arkansas (Little Rock, Hot Springs and central Arkansas)','Central Time Zone'},
					{502,'KY Kentucky (Louisville, Frankfort, Shelbyville and north central Kentucky)','Eastern Time Zone'},
					{503,'OR Oregon (Portland, Salem, Tillamook, Astoria and northwestern Oregon, overlays with 971)','Pacific Time Zone'},
					{504,'LA Louisiana (New Orleans, Kenner, Metairie and surrounding areas)','Central Time Zone'},
					{505,'NM New Mexico (all of New Mexico)','Mountain Time Zone'},
					{506,'NB New Brunswick (all of New Brunswick)','Atlantic Time Zone'},
					{507,'MN Minnesota (Rochester, Mankato, Worthington, Marshall and southern Minnesota)','Central Time Zone'},
					{508,'MA Massachusetts (Worcester, New Bedford and southeastern Massachusetts, overlays with 774)','Eastern Time Zone'},
					{509,'WA Washington (Spokane, Yakima, Walla Walla, Moses Lake, Ellensburg and eastern Washington)','Pacific Time Zone'},
					{510,'CA California (Hayward, Berkeley, Oakland, Richmond and Fremont areas)','Pacific Time Zone'},
					{512,'TX Texas (Austin, Lampasas, Bastrop, Milam and central Texas)','Central Time Zone'},
					{513,'OH Ohio (Cincinnati, Middletown, Hamilton, Norwood, Lebanon and southwestern Ohio)','Eastern Time Zone'},
					{514,'QC Quebec (Montreal area)','Eastern Time Zone'},
					{515,'IA Iowa (Des Moines, Ames, Fort Dodge, Jefferson, Algona, Indianola and north central Iowa)','Central Time Zone'},
					{516,'NY New York (Nassau County, Levittown, Hicksville, Massapequa and western Long Island)','Eastern Time Zone'},
					{517,'MI Michigan (Jackson, Lansing, Howell, Deerfield, Addison and south central Michigan)','Eastern Time Zone'},
					{518,'NY New York (Plattsburgh, Saranac Lake, Albany and northeastern New York)','Eastern Time Zone'},
					{519,'ON Ontario (London, Windsor and southwestern Ontario)','Eastern Time Zone'},
					{520,'AZ Arizona (Tucson and southeastern Arizona)','Mountain and Pacific Time Zones'},
					{530,'CA California (Alturas, Chico, Redding, Placerville, Truckee and northeastern California)','Pacific Time Zone'},
					{540,'VA Virginia (Roanoke, Harrisonburg, Winchester, Fredericksburg and northern Virginia)','Eastern Time Zone'},
					{541,'OR Oregon (Medford, Eugene, Ontario, Burns and all of Oregon except northwestern Oregon)','Mountain and Pacific Time Zones'},
					{551,'NJ New Jersey (Hackensack, Jersey City, and northeast New Jersey, overlays with 201)','Eastern Time Zone'},
					{559,'CA California (Fresno, Madera, Hanford, Visalia and central California)','Pacific Time Zone'},
					{561,'FL Florida (West Palm Beach, Chosen, Vero Beach, Boca Raton and central eastern Florida)','Eastern Time Zone'},
					{562,'CA California (Long Beach, Lakewood, Bellflower and southwestern Los Angeles suburbs)','Pacific Time Zone'},
					{563,'IA Iowa (Decorah, Dubuque, Clinton, Davenport and eastern and northeastern Iowa)','Central Time Zone'},
					{567,'OH Ohio (Toledo, Mansfield, Lima, Bryan, Sandusky and northwestern Ohio, overlays with 419)','Eastern Time Zone'},
					{570,'PA Pennsylvania (Scranton, Williamsport, Wilkes-Barre, Susquehanna and northeastern Pennsylvania)','Eastern Time Zone'},
					{571,'VA Virginia (Alexandria, Washington DC suburbs, Arlington and northeastern Virginia, overlays with 703)','Eastern Time Zone'},
					{573,'MO Missouri (Jefferson City, Hannibal, Poplar Bluff and eastern Missouri excluding St Louis)','Central Time Zone'},
					{574,'IN Indiana ( South Bend, Logansport, Elkhart, Nappanee and north central Indiana)','Central and Eastern Time Zones'},
					{580,'OK Oklahoma (Guymon, Hugo, Enid, Lawton, Ardmore, Elk City and southern and western Oklahoma)','Central Time Zone'},
					{585,'NY New York (Rochester, Wellsville, Batavia, Olean and western New York)','Eastern Time Zone'},
					{586,'MI Michigan (Port Huron, Flint, Flushing, Warren and eastern Michigan, overlays with 810)','Eastern Time Zone'},
					{900,'900 SERVICES',''},
					{600,'CANADA/SERVICES',''},
					{601,'MS Mississippi (Jackson, Meridian, Natchez, McComb, Hattiesburg and central Mississippi)','Central Time Zone'},
					{602,'AZ Arizona (Central Phoenix only)','Mountain and Pacific Time Zones'},
					{603,'NH New Hampshire (all of New Hampshire)','Eastern Time Zone'},
					{604,'BC British Columbia (Vancouver, Richmond, Abbotsford, Whistler and southwestern BC, overlays with 778)','Pacific Time Zone'},
					{605,'SD South Dakota (all of South Dakota)','Central and Mountain Time Zones'},
					{606,'KY Kentucky (Ashland, Hazard, Somerset, London, Corbin, Pikeville, Maysville and eastern Kentucky)','Eastern Time Zone'},
					{607,'NY New York (Binghamton, Elmira, Bath, Norwich and south central New York)','Eastern Time Zone'},
					{608,'WI Wisconsin (Madison, La Crosse, Platteville, Janesville and southwestern Wisconsin)','Central Time Zone'},
					{609,'NJ New Jersey (Atlantic City, Brown Mills, Trenton, and central and southeastern New Jersey)','Eastern Time Zone'},
					{610,'PA Pennsylvania (Reading, Allentown, Chester and southeastern Pennsylvania, overlays with 484 and 835)','Eastern Time Zone'},
					{611,'REPAIR SERVICE',''},
					{612,'MN Minnesota (Central Minneapolis, Fort Snelling, St Anthony and Richfield)','Central Time Zone'},
					{613,'ON Ontario (Ottawa and southeastern Ontario)','Eastern Time Zone'},
					{614,'OH Ohio (Columbus area)','Eastern Time Zone'},
					{615,'TN Tennessee (Nashville, Murfreesboro, Springfield, Lebanon, Dickson and north central Tennessee)','Central Time Zone'},
					{616,'MI Michigan (Battle Creek, Grand Rapids, Kalamazoo and southwestern Michigan)','Eastern Time Zone'},
					{617,'MA Massachusetts (Boston, Cambridge and east central Massachusetts, overlays with 857)','Eastern Time Zone'},
					{618,'IL Illinois (Carbondale, Alton, Centralia, Mount Vernon and southern Illinois)','Central Time Zone'},
					{619,'CA California (National City, Chula Vista, Imperial Beach, Otay and the San Diego area)','Pacific Time Zone'},
					{620,'KS Kansas (Dodge City, Great Bend, Parsons, Liberal and southern Kansas)','Central and Mountain Time Zone'},
					{623,'AZ Arizona (Buckeye, Peoria, western Phoenix area and western Phoenix suburbs only)','Mountain and Pacific Time Zones'},
					{626,'CA California (Arcadia, Temple City, Covina, Pasadena and eastern Los Angeles suburbs)','Pacific Time Zone'},
					{630,'IL Illinois (Aurora, Batavia, Geneva and western Chicago suburbs)','Central Time Zone'},
					{631,'NY New York (Manorville, Huntington, Lindenhurst, Islip, Deer Park and Eastern Long Island)','Eastern Time Zone'},
					{636,'MO Missouri (Chesterfield, Union, De Soto, Troy and east central Missouri)','Central Time Zone'},
					{641,'IA Iowa (Mason City, Oskaloosa, Creston, Pella, Ottumwa, Britt, Clear Lake, Fairfield and central Iowa)','Central Time Zone'},
					{646,'NY New York (New York City Manhattan area, overlays with 212 and 917)','Eastern Time Zone'},
					{647,'ON Ontario (Toronto area, overlays with 416)','Eastern Time Zone'},
					{649,'TURKS and CAICOS (all of Turks and Caicos)','Eastern Time Zone'},
					{650,'CA California (San Mateo, Palo Alto, Redwood City, Menlo Park and southern San Francisco suburbs)','Pacific Time Zone'},
					{651,'MN Minnesota (St Paul, Lindstrom, Red Wing, Hastings and east central Minnesota)','Central Time Zone'},
					{660,'MO Missouri (Marshall, Sedalia, Macon, Trenton, Maryville and north central Missouri)','Central Time Zone'},
					{661,'CA California (Bakersfield, Mojave, Santa Clarita, Palmdale and south central California)','Pacific Time Zone'},
					{662,'MS Mississippi (Greenville, Tupelo, Winona, Columbus, Holly Springs and northern Mississippi)','Central Time Zone'},
					{664,'MONTSERRAT (all of Montserrat)','Atlantic Time Zone'},
					{670,'COMMONWEALTH OF THE NORTHERN MARIANA ISLANDS (all of CNMI)','Pacific Guam Time Zone'},
					{671,'GUAM (all of Guam)','Pacific Guam Time Zone'},
					{678,'GA Georgia (Atlanta, Gainesville, Griffin and north central Georgia, overlays 404 and and 470 and 770)','Eastern Time Zone'},
					{682,'TX Texas (Fort Worth, Arlington, Grandview, Weatherford, Rhome, overlays with 817)','Central Time Zone'},
					{700,'IC SERVICES',''},
					{701,'ND North Dakota (all of North Dakota)','Mountain and Central Time Zones'},
					{702,'NV Nevada (Las Vegas, Henderson and extreme southern Nevada)','Pacific Time Zone'},
					{703,'VA Virginia (Alexandria, Washington DC suburbs, Arlington and northeastern Virginia, overlays with 571)','Eastern Time Zone'},
					{704,'NC North Carolina (Charlotte, Kingstown and south central North Carolina, overlays with 980)','Eastern Time Zone'},
					{705,'ON Ontario (North Bay and northeastern Ontario)','Eastern Time Zone'},
					{706,'GA Georgia (Augusta, Columbus, Lagrange, Rome, Dalton and northern and west central Georgia)','Eastern Time Zone'},
					{707,'CA California (Santa Rosa, Fort Bragg, Crescent City, Eureka, Ukiah and northwestern California)','Pacific Time Zone'},
					{708,'IL Illinois (Chicago Heights, Tinley Park and southern Chicago suburbs)','Central Time Zone'},
					{709,'NF Newfoundland (all of Newfoundland)','Newfoundland Time Zone'},
					{710,'US GOVERNMENT',''},
					{711,'TRS ACCESS',''},
					{712,'IA Iowa (Estherville, Council Bluffs, Sioux City, Sheldon, Denison and western Iowa)','Central Time Zone'},
					{713,'TX Texas (Spring, Katy, Houston area, overlays with 281 and 832)','Central Time Zone'},
					{714,'CA California (Huntington Beach, Orange, Garden Grove, Tustin, Anaheim and northern Orange County)','Pacific Time Zone'},
					{715,'WI Wisconsin (Rhinelander, Wausau, Eau Claire, Rice Lake, Ashland and northern Wisconsin)','Central Time Zone'},
					{716,'NY New York (Buffalo, Jamestown, Niagara Falls, Tonawanda and western New York)','Eastern Time Zone'},
					{717,'PA Pennsylvania (Harrisburg, Gettysburg, Lancaster, York and south central Pennsylvania)','Eastern Time Zone'},
					{718,'NY New York (Flushing, Jamaica, Brooklyn, Staten Island, Bronx and Queens, overlays with 347 and 917)','Eastern Time Zone'},
					{719,'CO Colorado (Leadville, Pueblo, Colorado Springs, Trinidad and southeastern Colorado)','Mountain Time Zone'},
					{720,'CO Colorado (Boulder, Longmont, Aurora, Denver and central Colorado, overlays with 303)','Mountain Time Zone'},
					{724,'PA Pennsylvania (New Castle, Washington, Uniontown and south western Pennsylvania, overlays with 878)','Eastern Time Zone'},
					{727,'FL Florida (Clearwater, St Petersburg, Dunedin and the west central Florida gulf coast)','Eastern Time Zone'},
					{731,'TN Tennessee (Union City, Jackson, Dyersburg, Paris, Bolivar and western Tennessee)','Central Time Zone'},
					{732,'NJ New Jersey (New Brunswick, Neptune, Lakewood, and east central New Jersey, overlays with 848)','Eastern Time Zone'},
					{734,'MI Michigan (Ann Arbor, Monroe, Wayne, Ypsilanti and southwestern Detroit suburbs)','Eastern Time Zone'},
					{740,'OH Ohio (Jackson, Lancaster, Marietta, Cambridge, Zanesville, New Castle and southeastern Ohio)','Eastern Time Zone'},
					{754,'FL Florida (Fort Lauderdale, Pompano Beach, overlays with 954)','Eastern Time Zone'},
					{757,'VA Virginia (Hampton, Norfolk, Williamsburg, Newport News, Virginia Beach and southeastern Virginia)','Eastern Time Zone'},
					{758,'ST LUCIA (all of St Lucia)','Atlantic Time Zone'},
					{760,'CA California (Bishop, Ridgecrest, Indio, Barstow, El Centro, Palm Springs and southeastern California)','Pacific Time Zone'},
					{763,'MN Minnesota (Maple Grove, Monticello, Elk River, Fridley, Blaine, and northwest Minneapolis area)','Central Time Zone'},
					{765,'IN Indiana (Lafayette, Marion, Muncie, Richmond and central Indiana excluding Indianapolis)','Central and Eastern Time Zone'},
					{767,'DOMINICA (all of Dominica)','Atlantic Time Zone'},
					{770,'GA Georgia (Marietta, Cedartown, and north central Georgia, overlays with 470 and 678)','Eastern Time Zone'},
					{773,'IL Illinois (Cicero, Berwyn, Oak Park and Chicago excluding downtown Chicago)','Central Time Zone'},
					{774,'MA Massachusetts (Worcester and southeastern Massachusetts, overlays with 508)','Eastern Time Zone'},
					{775,'NV Nevada (Reno, Elko, Ely and all of Nevada excluding Las Vegas and extreme southern Nevada)','Pacific Time Zone'},
					{778,'BC British Columbia (Vancouver, Richmond, Abbotsford and southwestern BC overlays with 604)','Pacific Time Zone'},
					{780,'AB Alberta (Edmonton, Jasper, Grande Prairie, Peace River and northern Alberta)','Mountain Time Zone'},
					{781,'MA Massachusetts (Saugus, Norwood and east central Massachusetts, overlays with 339)','Eastern Time Zone'},
					{784,'ST VINCENT AND THE GRENADINES (all of St Vincent and the Grenadines)','Atlantic Time Zone'},
					{785,'KS Kansas (Colby, Topeka, Salina, Manhattan, Lawrence and northern Kansas)','Mountain and Central Time Zones'},
					{786,'FL Florida (Miami, Homestead, Coral Gables, Key West and southeastern Florida, overlays with 305)','Eastern Time Zone'},
					{787,'PR PUERTO RICO (all of Puerto Rico, overlays with 939)','Atlantic Time Zone'},
					{800,'TOLL FREE SERVICES',''},
					{801,'UT Utah (Salt Lake City, Ogden, Provo, Park City, Payson, Bountiful and central Utah)','Mountain Time Zone'},
					{802,'VT Vermont (all of Vermont)','Eastern Time Zone'},
					{803,'SC South Carolina (Columbia, Rock Hill, Sumter, Aiken and central South Carolina)','Eastern Time Zone'},
					{804,'VA Virginia (Richmond, Petersburg, West Point, Chester and east central Virginia)','Eastern Time Zone'},
					{805,'CA California (Santa Barbara, San Luis Obispo, Lompoc and central western coastal California)','Pacific Time Zone'},
					{806,'TX Texas (Amarillo, Lubbock, Canadian, Perryton, Shamrock, Dalhart and Texas panhandle)','Central Time Zone'},
					{807,'ON Ontario (Thunder Bay and western Ontario)','Central and Eastern Time Zones'},
					{808,'HI Hawaii (all of Hawaii)','Hawaiian Time Zone'},
					{809,'DOMINICAN REPUBLIC (all of the Dominican Republic)','Atlantic Time Zone'},
					{810,'MI Michigan (Port Huron, Flint, Flushing, Warren and eastern Michigan, overlays with 586)','Eastern Time Zone'},
					{811,'BUSINESS OFFICE',''},
					{812,'IN Indiana (Evansville, New Albany, Terre Haute, Bloomington and southern Indiana)','Central and Eastern Time Zones'},
					{813,'FL Florida (Tampa, Hillsborough, Plant City, Port Tampa and central western Florida)','Eastern Time Zone'},
					{814,'PA Pennsylvania (Erie, Warren, Altoona, Johnstown, Meyersdale and central and northwestern Pennsylvania)','Eastern Time Zone'},
					{815,'IL Illinois (La Salle, De Kalb, Rockford, Freeport and northern Illinois excluding Chicago area)','Central Time Zone'},
					{816,'MO Missouri (Kansas City, St Joseph, Independence, Harrisonville and west central Missouri)','Central Time Zone'},
					{817,'TX Texas (Fort Worth, Arlington, Grandview, Weatherford, Rhome, overlays with 682)','Central Time Zone'},
					{818,'CA California ( Glendale, San Fernando, Burbank and northern Los Angeles suburbs)','Pacific Time Zone'},
					{819,'QC Quebec (Western Quebec)','Eastern Time Zone'},
					{822,'TOLL FREE SERVICES',''},
					{828,'NC North Carolina (Asheville, Brevard, Morganton, Murphy and western North Carolina)','Eastern Time Zone'},
					{830,'TX Texas (Uvalde, New Braunfels, Kerrville, Eagle Pass and southwest Texas)','Central Time Zone'},
					{831,'CA California (Salinas, Hollister, Monterey, Santa Cruz and central western coastal California)','Pacific Time Zone'},
					{832,'TX Texas (Spring, Katy, Houston area, overlays with 281 and 713)','Central Time Zone'},
					{833,'TOLL FREE SERVICES',''},
					{835,'PA Pennsylvania (Reading, Allentown, and southeastern Pennsylvania, overlays with 484 and 610)','Eastern Time Zone'},
					{843,'SC South Carolina (Florence, Myrtle Beach, Charleston, Hilton Head Island and eastern South Carolina)','Eastern Time Zone'},
					{844,'TOLL FREE SERVICES',''},
					{845,'NY New York ( Poughkeepsie, Middletown, West Point, Newburgh and southeastern New York)','Eastern Time Zone'},
					{847,'IL Illinois (Waukegan, Des Plaines, northwest Chicago suburbs and northeastern Illinois, overlays with 224)','Central Time Zone'},
					{848,'NJ New Jersey (New Brunswick, Neptune, and east central New Jersey, overlays with 732)','Eastern Time Zone'},
					{850,'FL Florida ( Pensacola, Tallahassee, Panama City and the Florida panhandle)','Central and Eastern Time Zones'},
					{855,'TOLL FREE SERVICES',''},
					{856,'NJ New Jersey (Vineland, Cherry Hill, Camden, Millville, and southwestern New Jersey)','Eastern Time Zone'},
					{857,'MA Massachusetts (Boston, Cambridge and east central Massachusetts, overlays with 617)','Eastern Time Zone'},
					{858,'CA California (Del Mar, La Jolla and northern San Diego suburbs)','Pacific Time Zone'},
					{859,'KY Kentucky (Lexington, Richmond, Danville, Covington, Mount Sterling and north central Kentucky)','Eastern Time Zone'},
					{860,'CT Connecticut (Bristol, Hartford, Norwich and northern and eastern Connecticut, overlays with 959)','Eastern Time Zone'},
					{862,'NJ New Jersey (Newark, Paterson and northwestern New Jersey, overlays with 973)','Eastern Time Zone'},
					{863,'FL Florida (Avon Park, Clewiston, Lakeland, Bartow, Sebring, Winter Haven and south central Florida)','Eastern Time Zone'},
					{864,'SC South Carolina (Greenville, Spartanburg, Anderson and western South Carolina)','Eastern Time Zone'},
					{865,'TN Tennessee (Knoxville, Newport, Jefferson City, Oak Ridge and east central Tennessee)','Eastern Time Zone'},
					{866,'TOLL FREE SERVICES',''},
					{867,'YK Yukon and Northwest Territories (Yukon and Northwest Territories)','Pacific through the Atlantic Time Zones'},
					{868,'TRINIDAD AND TOBAGO (all of Trinidad and Tobago)','Atlantic Time Zone'},
					{869,'ST KITTS AND NEVIS (all of St Kitts and Nevis)','Atlantic Time Zone'},
					{870,'AR Arkansas (Texarkana, Mountain Home, Pine Bluff and southern, eastern and northeastern Arkansas)','Central Time Zone'},
					{876,'JAMAICA (all of Jamaica)','Eastern Time Zone'},
					{877,'TOLL FREE SERVICES',''},
					{878,'PA Pennsylvania (Pittsburgh, New Castle, and southwestern Pennsylvania, overlays with 412 and 724)','Eastern Time Zone'},
					{880,'PAID 800 SERVICE FROM CARIBBEAN TO THE US AND CANADA OR FROM CANADA TO THE US',''},
					{881,'PAID 888 SERVICE FROM CARIBBEAN TO THE US AND CANADA OR FROM CANADA TO THE US',''},
					{882,'PAID 877 SERVICE FROM CARIBBEAN TO THE US AND CANADA OR FROM CANADA TO THE US',''},
					{888,'TOLL FREE SERVICES',''},
					{901,'TN Tennessee (Memphis, Covington, Somerville and south western Tennessee)','Central Time Zone'},
					{902,'NS Nova Scotia (all of Nova Scotia and Prince Edward Island)','Atlantic Time Zone'},
					{903,'TX Texas (Tyler, Sherman, Longview, Palestine and northeastern Texas)','Central Time Zone'},
					{904,'FL Florida (Jacksonville, St Augustine, Starke, Green Cove Springs and northeastern Florida)','Eastern Time Zone'},
					{905,'ON Ontario (Hamilton, Toronto suburbs and central southeastern Ontario, overlays with 289)','Eastern Time Zone'},
					{906,'MI Michigan (Ironwood, Marquette, Sault Ste Marie, Escanaba and upper Michigan)','Central and Eastern Time Zones'},
					{907,'AK Alaska (all of Alaska)','Aleutian and Alaskan Time Zones'},
					{908,'NJ New Jersey (Washington, Elizabeth, Warren, Plainfield and west central New Jersey)','Eastern Time Zone'},
					{909,'CA California (San Bernardino, Temecula, Ontario, Pomona, Chino and Riverside areas)','Pacific Time Zone'},
					{910,'NC North Carolina (Fayetteville, Wilmington, Lumberton and southeastern North Carolina)','Eastern Time Zone'},
					{911,'EMERGENCY',''},
					{912,'GA Georgia ( Savannah, Vidalia, Waycross, Brunswick, Douglas and southeastern Georgia)','Eastern Time Zone'},
					{914,'NY New York (White Plains, Yonkers, Pelham, Westchester, Peekskill and southeastern New York)','Eastern Time Zone'},
					{915,'TX Texas (El Paso, Alpine, Midland, Abilene, Del Rio, San Angelo, Odessa and western Texas)','Mountain and Central Time Zones'},
					{916,'CA California (Sacramento area)','Pacific Time Zone'},
					{917,'NY New York (New York City Manhattan area, overlays with 212 and 646)','Eastern Time Zone'},
					{918,'OK Oklahoma (Tulsa, Bartlesville, McAlester, Muskogee, Henrietta and northeastern Oklahoma)','Central Time Zone'},
					{919,'NC North Carolina (Raleigh, Durham, Chapel Hill, Oxford and north central North Carolina)','Eastern Time Zone'},
					{920,'WI Wisconsin (Sheboygan, Oshkosh, Green Bay, Manitowoc, Fond Du Lac and eastern Wisconsin)','Central Time Zone'},
					{925,'CA California (Pleasanton, Martinez, Concord, Livermore, Walnut Creek and Dublin areas)','Pacific Time Zone'},
					{928,'AZ Arizona (Flagstaff, Kingman, Prescott, Yuma and northern and western Arizona)','Mountain and Pacific Time Zones'},
					{931,'TN Tennessee (Clarksville, Columbia, Manchester, Cookeville and central Tennessee)','Central Time Zone'},
					{936,'TX Texas (Nacogdoches, Lufkin, Conroe, Huntsville, Center and southeastern Texas)','Central Time Zone'},
					{937,'OH Ohio (Marysville, Springfield, Dayton, Hillsboro and southwestern Ohio excluding Cincinnati area)','Eastern Time Zone'},
					{939,'PR PUERTO RICO (all of Puerto Rico, overlays with 787)','Atlantic Time Zone'},
					{940,'TX Texas (Vernon, Wichita Falls, Denton, Gainesville, Decatur and north central Texas)','Central Time Zone'},
					{941,'FL Florida ( Bradenton, Port Charlotte, Sarasota, Punta Gorda and the west central Florida coast)','Eastern Time Zone'},
					{949,'CA California (Laguna Niguel, Irvine, El Toro, Newport Beach, Corona Del Mar and southern Orange County)','Pacific Time Zone'},
					{952,'MN Minnesota (Bloomington, Minnetonka, Chaska and southwest Minneapolis area)','Central Time Zone'},
					{954,'FL Florida (Fort Lauderdale, Pompano Beach, overlays with 754)','Eastern Time Zone'},
					{956,'TX Texas (Laredo, Brownsville, McAllen, Harlingen and southern Texas)','Central Time Zone'},
					{959,'CT Connecticut (Bristol, Hartford, Norwich and northern and eastern Connecticut, overlays with 860)','Eastern Time Zone'},
					{970,'CO Colorado (Aspen, Durango, Grand Junction, Fort Collins and northern and western Colorado)','Mountain Time Zone'},
					{971,'OR Oregon (Portland, Salem, Hillsboro, Beaverton and northwestern Oregon, overlays with 503)','Pacific Time Zone'},
					{972,'TX Texas (Dallas area, overlays with 214 and 469)','Central Time Zone'},
					{973,'NJ New Jersey (Newark, Paterson and northwestern New Jersey, overlays with 862)','Eastern Time Zone'},
					{978,'MA Massachusetts (Fitchburg, Peabody and northeastern Massachusetts, overlays with 351)','Eastern Time Zone'},
					{979,'TX Texas (Wharton, Bryan, Bay City, College Station, Lake Jackson and southeastern Texas)','Central Time Zone'},
					{980,'NC North Carolina (Charlotte, Kingstown and south central North Carolina, overlays with 704)','Eastern Time Zone'},
					{985,'LA Louisiana (Houma, Slidell and southeastern Louisiana excluding New Orleans)','Central Time Zone'},
					{989,'MI Michigan (Alpena, Mt Pleasant, Bay City, Saginaw, Midland, Owosso and central Michigan)','Eastern Time Zone'}
					],{,maxlength(1000) UNSIGNED2 code,STRING description,STRING timezone});

LayoutXML := RECORD,maxlength(1000) 
  STRING line
END;

CRLFTT := (STRING)x'0D0A0909';
CRLFT  := (STRING)x'0D0A09';
CRLF   := (STRING)x'0D0A';

LayoutXML ParseData(InDS L, INTEGER C) := TRANSFORM
  HasState := L.description[3] = '' AND L.description[1..2] NOT IN ['US','ST'];
	SELF.line := CHOOSE(C,
	                    '<area>' + CRLFT + '<code>' + CRLFTT + (STRING)L.code + CRLFT + '</code>',
	                    '\t<state>' + CRLFTT + IF(HasState,L.description[1..2],'') + CRLFT + '</state>',
	                    '\t<description>' + CRLFTT + XMLENCODE(IF(HasState,L.description[4..],L.description)) + CRLFT + '</description>',
	                    '\t<zone>' + CRLFTT + L.timezone + CRLFT + '</zone>' + CRLF + '</area>');
END;

XMLdata := NORMALIZE(InDS,4,ParseData(LEFT,COUNTER));

OUTPUT(XMLdata,,'~PROGGUIDE::EXAMPLEDATA::XML_timezones',CSV(HEADING('<?xml version=1.0 ...?>\n<timezones>\n','</timezones>\n')),OVERWRITE);

UCCDS := DATASET([
						{'  <Filing number="5200105">'},
						{'    <Transaction ID="5">'},
						{'	<StartDate>08/01/2001</StartDate>'},
						{'	<LapseDate>08/01/2006</LapseDate>'},
						{'	<FormType>UCC 1 FILING STATEMENT</FormType>'},
						{'	<AmendType>NONE</AmendType>'},
						{'	<AmendAction>NONE</AmendAction>'},
						{'	<EnteredDate>08/02/2002</EnteredDate>'},
						{'	<ReceivedDate>08/01/2002</ReceivedDate>'},
						{'	<ApprovedDate>08/02/2002</ApprovedDate>'},
						{'	<Debtor entityId="19">'},
						{'	  <IsBusiness>true</IsBusiness>'},
						{'	  <OrgName><![CDATA[BOGUS LABORATORIES, INC.]]></OrgName>'},
						{'	  <Status>ACTIVE</Status>'},
						{'	  <Address1><![CDATA[334 SOUTH 900 WEST]]></Address1>'},
						{'	  <Address4><![CDATA[SALT LAKE CITY 45 84104]]></Address4>'},
						{'	  <City><![CDATA[SALT LAKE CITY]]></City>'},
						{'	  <State>UTAH</State>'},
						{'	  <Zip>84104</Zip>'},
						{'	  <OrgType>CORP</OrgType>'},
						{'	  <OrgJurisdiction><![CDATA[SALT LAKE CITY]]></OrgJurisdiction>'},
						{'	  <OrgID>654245-0142</OrgID>'},
						{'	  <EnteredDate>08/02/2002</EnteredDate>'},
						{'	</Debtor>'},
						{'	<Debtor entityId="7">'},
						{'	  <IsBusiness>false</IsBusiness>'},
						{'	  <FirstName><![CDATA[FRED]]></FirstName>'},
						{'	  <LastName><![CDATA[JONES]]></LastName>'},
						{'	  <Status>ACTIVE</Status>'},
						{'	  <Address1><![CDATA[1038 E. 900 N.]]></Address1>'},
						{'	  <Address4><![CDATA[OGDEN 45 84404]]></Address4>'},
						{'	  <City><![CDATA[OGDEN]]></City>'},
						{'	  <State>UTAH</State>'},
						{'	  <Zip>84404</Zip>'},
						{'	  <OrgType>NONE</OrgType>'},
						{'	  <EnteredDate>08/02/2002</EnteredDate>'},
						{'	</Debtor>'},
						{'	<SecuredParty entityId="20">'},
						{'	  <IsBusiness>true</IsBusiness>'},
						{'	  <OrgName><![CDATA[WELLS FARGO BANK]]></OrgName>'},
						{'	  <Status>ACTIVE</Status>'},
						{'	  <Address1><![CDATA[ATTN: LOAN OPERATIONS CENTER]]></Address1>'},
						{'	  <Address3><![CDATA[P.O. BOX 9120]]></Address3>'},
						{'	  <Address4><![CDATA[BOISE 13 83707-2203]]></Address4>'},
						{'	  <City><![CDATA[BOISE]]></City>'},
						{'	  <State>IDAHO</State>'},
						{'	  <Zip>83707-2203</Zip>'},
						{'	  <Status>ACTIVE</Status>'},
						{'	  <EnteredDate>08/02/2002</EnteredDate>'},
						{'	</SecuredParty>'},
						{'	<Collateral>'},
						{'	  <Action>ADD</Action>'},
						{'	  <Description><![CDATA[ALL ACCOUNTS]]></Description>'},
						{'	  <EffectiveDate>08/01/2002</EffectiveDate>'},
						{'	</Collateral>'},
						{'    </Transaction>'},
						{'    <Transaction ID="375799">'},
						{'	<StartDate>08/01/2002</StartDate>'},
						{'	<LapseDate>08/01/2006</LapseDate>'},
						{'	<FormType>UCC 3 AMENDMENT</FormType>'},
						{'	<AmendType>TERMINATION BY DEBTOR</AmendType>'},
						{'	<AmendAction>NONE</AmendAction>'},
						{'	<EnteredDate>02/23/2004</EnteredDate>'},
						{'	<ReceivedDate>02/18/2004</ReceivedDate>'},
						{'	<ApprovedDate>02/23/2004</ApprovedDate>'},
						{'    </Transaction>'},
						{'  </Filing>'}
					],{,maxlength(1000) STRING line});

OUTPUT(UCCDS,,'~PROGGUIDE::EXAMPLEDATA::XML_UCC',CSV(HEADING('<UCC>\n','</UCC>\n')),OVERWRITE);
