
/**
 * CorbaHelloServer.java
 *
 *
 * Created: Thu Aug 19 22:37:39 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */
package corba;

import corba.HelloApp.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import org.omg.CORBA.*;

public class CorbaHelloServer {
    
    public CorbaHelloServer() {
	
    }
    
    public static void main(String[] args) {
	try {
	    // create a Hello implementation object
	    ORB orb = ORB.init(args, null);
	    HelloServant helloRef = new HelloServant();
	    orb.connect(helloRef);

	    // find the name server
	    org.omg.CORBA.Object objRef = 
		orb.resolve_initial_references("NameService");
	    NamingContext ncRef = NamingContextHelper.narrow(objRef);

	    // bind the Hello service to the name server
	    NameComponent nc = new NameComponent("Hello", "");
	    NameComponent path[] = {nc};
	    ncRef.rebind(path, helloRef);

	    // sleep
	    java.lang.Object sleep = new java.lang.Object();
	    synchronized(sleep) {
		sleep.wait();
	    }
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }
    
} // CorbaHelloServer

class HelloServant extends _HelloImplBase {
    public String sayHello() {
	return("hello world");
    }
}
