
/**
 * FooLandlord.java
 *
 *
 * Created: Mon Jun 14 22:48:11 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */

package foolandlord;

import com.sun.jini.lease.landlord.*;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.Lease;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.Remote;
import java.util.Map;

public class FooLandlord extends  UnicastRemoteObject 
                         implements Landlord {

    FooLeaseManager manager;

    public FooLandlord() throws java.rmi.RemoteException {
	manager = new FooLeaseManager(this);
    }
    
    public void cancel(Object cookie) {
	manager.cancel(cookie);
    }

    public Map cancelAll(Object[] cookies) {
	return manager.cancelAll(cookies);
    }

    public long renew(java.lang.Object cookie,
		      long extension) 
	throws net.jini.core.lease.LeaseDeniedException,
	       net.jini.core.lease.UnknownLeaseException {
	LeasedResource resource = manager.getResource(cookie);
	if (resource != null) {
	    return manager.getPolicy().renew(resource, extension);
	}
	return -1;
    }

    public Lease newFooLease(Foo foo, long duration) 
	throws LeaseDeniedException {
	FooLeasedResource r = new FooLeasedResource(foo);
	return manager.getPolicy().leaseFor(r, duration);
    }

    public Landlord.RenewResults renewAll(java.lang.Object[] cookies,
					  long[] extensions) {
	long[] granted = new long[cookies.length];
	Exception[] denied = new Exception[cookies.length];

	for (int n = cookies.length; --n >= 0; ) {
	    try {
		granted[n] = renew(cookies[n], extensions[n]);
		denied[n] = null;
	    } catch(Exception e) {
		granted[n] = -1;
		denied[n] = e;
	    }
	}
	return new Landlord.RenewResults(granted, denied);
    }
} // FooLandlord
