
/**
 * GetService.java
 *
 *
 * Created: Mon Mar  6 02:03:13 2000
 *
 * @author Jan Newmarch
 * @version 1.0
 */
package nameserver;

import java.net.*;
import common.FileClassifier;
import java.io.*;
import net.jini.core.lookup.ServiceItem;

public class GetService  {
    
    public static void main(String[] argv) {
	new GetService();
    }

    public GetService() {
	URL url = null;
	URLConnection connection = null;
	Object obj = null;
	int length = 0;
	InputStream in = null;

	try {
	    url = new URL("http://localhost:8000/common.FileClassifier");
	    connection = url.openConnection();
	    obj = connection.getContent();
	    length = connection.getContentLength();
	    in = connection.getInputStream();
	} catch(Exception e) {
	    e.printStackTrace();
	}
	String type = connection.getContentType();
	System.out.println("Type " + type);
	System.out.println("Class " + obj.toString());
	System.out.println("Length " + length);

	// We haven't installed a handler for type application/x-jini,
	// so getContent() won't have given us the right type.
	// Do all the work of reading and creating the object ourselves
	byte[] bytes = new byte[length];
	int nread = -1;
	try {
	    nread = in.read(bytes);
	} catch(Exception e) {
	    e.printStackTrace();
	}
	System.out.println("Reading " + length + " got " + nread);
	
	ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
	Object obj1 = null;
	try {
	    ObjectInputStream oin = new ObjectInputStream(bin);
	    obj1 = oin.readObject();
	} catch(Exception e) {
	    e.printStackTrace();
	}

	// This should be a ServiceItem
	System.out.println("Byte object is " + obj1.toString());

	// We asked for a FileClassifier, see if we got one
	ServiceItem item = null;
	FileClassifier classifier = null;
	try {
	    item = (ServiceItem) obj1;
	    classifier = (FileClassifier) item.service;
	} catch(Exception e) {
	    e.printStackTrace();
	}

	// We got a FileClassifier, use it
	try {
	    System.out.println("File type for .txt is " + 
			       classifier.getMIMEType("abc.txt"));
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }

    
} // GetService
