
package rcx.jini;

import java.rmi.RMISecurityManager;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.core.lookup.ServiceID;
// import com.sun.jini.lease.LeaseRenewalManager;
// import com.sun.jini.lookup.JoinManager;
// import com.sun.jini.lookup.ServiceIDListener;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.lookup.ServiceIDListener;
import net.jini.core.entry.Entry;

import net.jini.lookup.ui.MainUI;
import net.jini.lookup.ui.factory.FrameFactory;
import net.jini.lookup.ui.factory.JFrameFactory;
import net.jini.lookup.entry.UIDescriptor;
import net.jini.lookup.ui.attribute.UIFactoryTypes;

import java.rmi.MarshalledObject;
import java.io.IOException;
import java.util.Set;
import java.util.HashSet;


/**
 * RCXServer2.java
 *
 *
 * Created: Wed Mar 17 14:23:44 1999
 *
 * @author Jan Newmarch
 * @version 1.4
 *    uses new service ui
 *    uses 1.1 JoinManager
 *    removed second proxy, now just use RMI proxy
 *    added LeaseRenewalManager
 *    moved sleep() from constructor to main()
 */

public class RCXServer2 implements ServiceIDListener {

    protected RCXPortImpl impl;
    protected LeaseRenewalManager leaseManager = new LeaseRenewalManager();
    
    public static void main(String argv[]) {
	new RCXServer2();
	// remember to keepalive!
    }

    public RCXServer2() {
	try {
	    impl = new RCXPortImpl();
	} catch(Exception e) {
            System.err.println("New impl: " + e.toString());
            System.exit(1);
	}

	// set RMI security manager
	System.setSecurityManager(new RMISecurityManager());

	// define UI entries
	// generic UI
	Set genericAttribs = new HashSet();
	Set typeNames = new HashSet();
	typeNames.add(FrameFactory.TYPE_NAME);
	genericAttribs.add(new UIFactoryTypes(typeNames));
	MarshalledObject genericFactory = null;
	try {
	    genericFactory = new MarshalledObject(new
						  RCXLoaderFrameFactory());
	} catch(Exception e) {
	    e.printStackTrace();
	    System.exit(2);
	}
	UIDescriptor genericDesc = new UIDescriptor(MainUI.ROLE,
						    FrameFactory.TOOLKIT,
						    genericAttribs,
						    genericFactory);

	// car UI
	Set carAttribs = new HashSet();
	typeNames = new HashSet();
	typeNames.add(JFrameFactory.TYPE_NAME);
	carAttribs.add(new UIFactoryTypes(typeNames));
	MarshalledObject carFactory = null;
	try {
	    carFactory = new MarshalledObject(new CarJFrameFactory());
	} catch(Exception e) {
	    e.printStackTrace();
	    System.exit(2);
	}
	UIDescriptor carDesc = new UIDescriptor(MainUI.ROLE,
						JFrameFactory.TOOLKIT,
						carAttribs,
						carFactory);
	Entry[] entries = {genericDesc, carDesc};

	// find, register, lease, etc
	try {
	    LookupDiscoveryManager mgr = 
		new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS,
					   null /* unicast locators */,
					   null /* DiscoveryListener */);
	    JoinManager joinMgr = new JoinManager(impl,
						  entries,
						  this,
						  mgr,
						  new LeaseRenewalManager());
	} catch(java.io.IOException e) {
	    e.printStackTrace();
	}
    }
    
    public void serviceIDNotify(ServiceID serviceID) {
	System.out.println("Got service ID " + serviceID.toString());
    }
} // RCXServer2
