
package rcx.jini;

import java.rmi.RMISecurityManager;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;


/**
 * JiniRCXPort.java
 *
 *
 * Created: Wed Mar 17 14:29:15 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */

public class JiniRCXPort implements DiscoveryListener {

    protected Entry[] entries = null;
    /**
     * List of ports discovered
     */
    protected Vector ports = new Vector();
    /**
     * List of listeners for messages from RCX's
     */    
    protected Vector listeners = new Vector();

    public JiniRCXPort(Entry[] entries) {
	System.setSecurityManager(new RMISecurityManager());
	this.entries = entries;

	LookupDiscovery discover = null;
        try {
            discover = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        } catch(Exception e) {
            System.err.println(e.toString());
            System.exit(1);
        }

        discover.addDiscoveryListener(this);

    }
    
    public void discovered(DiscoveryEvent evt) {

        ServiceRegistrar[] registrars = evt.getRegistrars();
	Class [] classes = new Class[] {RCXPortInterface.class};
	RCXPortInterface port = null;
	ServiceTemplate template = new ServiceTemplate(null, classes, 
						       entries);
 
        for (int n = 0; n < registrars.length; n++) {
	    // System.out.println("Service found");
            ServiceRegistrar registrar = registrars[n];
	    try {
		port = (RCXPortInterface) registrar.lookup(template);
	    } catch(java.rmi.RemoteException e) {
		e.printStackTrace();
		continue;
	    }
	    if (port == null) {
		// System.out.println("port null");
		continue;
	    }

	    // check that we haven't seen this port before
	    // from some other locator, and if it is new
	    // add it to the list of ports
	    ports.add(port);

	    // add an EventHandler as an RCX Port listener
	    try {
		port.addListener(new EventHandler(port));
	    } catch(Exception e) {
		e.printStackTrace();
	    }

	}
    }

    public void discarded(DiscoveryEvent evt) {
	// empty
    }

    public void addRCXListener(RCXListener listener) {
	listeners.add(listener);
    }

    public boolean write(byte[] bArray) {
	RCXPortProxy port;

	for (Enumeration enum = ports.elements() ; enum.hasMoreElements() ;) {
	     port = (RCXPortProxy) enum.nextElement();
	     port.write(bArray);
	}	
    }

    public byte[] parseString(String str) {
	RCXPortProxy port;
	
	for (Enumeration enum = ports.elements() ; enum.hasMoreElements() ;) {
	    port = (RCXPortProxy) enum.nextElement();
	    port.parseString(str);
	}	
    }

    class EventHandler extends UnicastRemoteObject 
                       implements RemoteEventListener {

	protected RCXPortInterface port = null;

        public EventHandler(RCXPortInterface port) throws RemoteException {
            super() ;
	    this.port = port;
        }

        public void notify(RemoteEvent evt) throws UnknownEventException, 
                                                 java.rmi.RemoteException {
	    // System.out.println(evt.toString());
    
	    // Time consuming work should be done elsewhere
	    // than in this method e.g. in a new Thread
	    long id = evt.getID();
	    long seqNo = evt.getSequenceNumber();
	    RCXListener listener;

	    if (id == RCXPortInterface.MESSAGE_EVENT) {
		// System.out.println("MESSAGE: " + port.getMessage(seqNo));

		for (Enumeration enum = listeners.elements() ; enum.hasMoreElements() ;) {
		    listener = (RCXListener) enum.nextElement();
		    listener.receivedMessage(port.getMessage(seqNo));
		}	

	    } else if (id == RCXPortInterface.ERROR_EVENT) {
		// System.out.println("ERROR: " + port.getError(seqNo));

		for (Enumeration enum = listeners.elements() ; enum.hasMoreElements() ;) {
		    listener = (RCXListener) enum.nextElement();
		    listener.receivedMessage(port.getError(seqNo));
		}	
	    } else {
		throw new UnknownEventException("Unknown message " + evt.getID());
	    }
        }
    }
} // JiniRCXPort
