
package rcx.jini;

import java.rmi.RMISecurityManager;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.core.lookup.ServiceID;
// import com.sun.jini.lease.LeaseRenewalManager;
// import com.sun.jini.lookup.JoinManager;
// import com.sun.jini.lookup.ServiceIDListener;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.lookup.ServiceIDListener;

/**
 * RCXServer.java
 *
 *
 * Created: Wed Mar 17 14:23:44 1999
 *
 * @author Jan Newmarch
 * @version 1.2
 *    removed second proxy, now just use RMI proxy
 *    added LeaseRenewalManager
 *    moved sleep() from constructor to main()
 *    uses Jini 1.1 JoinManager
 */

public class RCXServer implements ServiceIDListener {

    protected RCXPortImpl impl;
    protected LeaseRenewalManager leaseManager = new LeaseRenewalManager();
    
    public static void main(String argv[]) {
	new RCXServer();
	// remember to keepalive
    }

    public RCXServer() {
	try {
	    impl = new RCXPortImpl();
	} catch(Exception e) {
            System.err.println("New impl: " + e.toString());
            System.exit(1);
	}

	// set RMI security manager
	System.setSecurityManager(new RMISecurityManager());

	// find, register, lease, etc
	try {
	    LookupDiscoveryManager mgr = 
		new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS,
					   null /* unicast locators */,
					   null /* DiscoveryListener */);
	    JoinManager joinMgr = new JoinManager(impl,
						  null,
						  this,
						  mgr,
						  new LeaseRenewalManager());
	} catch(java.io.IOException e) {
	    e.printStackTrace();
	}
    }
    
    public void serviceIDNotify(ServiceID serviceID) {
	System.out.println("Got service ID " + serviceID.toString());
    }
} // RCXServer
