/**
 * JavaHelloImpl.java
 *
 *
 * Created: Tue Aug 24 11:14:00 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */
package corba;

import org.omg.CosNaming.*;
import org.omg.CORBA.*;
import corba.HelloApp.*;

public class JavaHelloImpl implements JavaHello {
    
    protected Hello helloRef = null;
    protected String[] argv;

    public JavaHelloImpl(String[] argv) {
	this.argv = argv;
    }

    public String sayHello() {
	// Hello helloRef = null;

	if (helloRef == null) {
	    helloRef = getHelloRef();
	}
	// now invoke methods on the CORBA proxy
	String hello = helloRef.sayHello();
	return hello;
    }

    protected Hello getHelloRef() {
	ORB orb = null;
	// Act like a CORBA client
	try {
	    orb = ORB.init(argv, null);

	    // find the CORBA name server
	    org.omg.CORBA.Object objRef = 
		orb.resolve_initial_references("NameService");
	    NamingContext ncRef = NamingContextHelper.narrow(objRef);

 	    // find the CORBA Hello proxy
	    NameComponent nc = new NameComponent("Hello", "");
	    NameComponent path[] = {nc};
	    org.omg.CORBA.Object obj = ncRef.resolve(path);
	    Hello helloRef = HelloHelper.narrow(obj);
	    return helloRef;
	} catch(Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }
} // JavaHelloImpl
