package ejb;

/**
 * FileClassifierImpl.java
 *
 *
 * Created: Sun May 14 03:34:58 2000
 *
 * @author Jan Newmarch
 * @version 1.0
 */

import javax.ejb.*;
import javax.naming.*;
import java.util.Properties;
import common.MIMEType;

public class FileClassifierImpl extends java.rmi.server.UnicastRemoteObject
                                implements rmi.RemoteFileClassifier {
    private String user = null;
    private String password = "";
    private String url = "t3://localhost:7001";
    private ejb.FileClassifier classifier;

    public FileClassifierImpl(String[] args) throws java.rmi.RemoteException {
	parseArgs(args);
	try {
	    Context ctx = getInitialContext();
	    FileClassifierHome home = (FileClassifierHome) 
		ctx.lookup("ejb.FileClassifierHome");
	    classifier = home.create();
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }

    public MIMEType getMIMEType(String fileName) throws java.rmi.RemoteException {
	return classifier.getMIMEType(fileName);
    }

    private void parseArgs(String[] args) {
	if ((args == null) || (args.length == 0))
	    return;
	for (int n = 0; n < args.length; n++) {
	    if (args[n].equals("-url")) {
		url = args[++n];
	    } else if (args[n].equals("-user")) {
		user = args[++n];
	    } else if (args[n].equals("-password")) {
		password = args[++n];
	    }
	}
    }

    private Context getInitialContext() throws Exception {
	Properties props = new Properties();
	props.put(Context.INITIAL_CONTEXT_FACTORY,
		  "weblogic.jndi.T3InitialContextFactory");
	props.put(Context.PROVIDER_URL, url);
	if (user != null) {
	    props.put(Context.SECURITY_PRINCIPAL, user);
	    props.put(Context.SECURITY_CREDENTIALS, password);
	}
	return new InitialContext(props);
    }
} // FileClassifierImpl
