
/**
 * RCXPortImpl.java
 *
 *
 * Created: Wed Jun  2 23:14:58 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */

package rcx.jini;

import java.rmi.server.UnicastRemoteObject;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import rcx.*;
import java.io.*;
import java.util.*;

public class RCXPortImpl extends UnicastRemoteObject
    implements RemoteRCXPort, RCXListener {

    protected String error = null;
    protected byte[] message = null;
    protected RCXPort port = null;
    protected RemoteEventListener listener = null;
    protected long messageSeqNo, errorSeqNo;  

    public RCXPortImpl() 
	throws java.rmi.RemoteException {

	Properties parameters;
	String portName = null;
	File f = new File("parameters.txt");
        if (!f.exists()) {
            f = new File(System.getProperty("user.dir")
                         + System.getProperty("path.separator")
                         + "parameters.txt");
        }
        if (f.exists()) {
            try {
		FileInputStream fis = new FileInputStream(f);
		parameters = new Properties();
		parameters.load(fis);
		fis.close();
                portName = parameters.getProperty("port");
            } catch (IOException e) { }
        } else {
	    System.err.println("Can't find parameters.txt with \"port=...\" specified");
	    System.exit(1);
	}
	
        port = new RCXPort(portName);
        port.addRCXListener(this);
	
    }
    
    public boolean write(byte[] byteCommands)
	throws java.rmi.RemoteException {
	return port.write(byteCommands);
    }

    public byte[] parseString(String command) 
	throws java.rmi.RemoteException {
	return RCXOpcode.parseString(command);
    }

    /**
     * Received a message from the RCX.
     * Send it to the listener
     */
    public void receivedMessage(byte[] message) {

	this.message = message;

	// Send it out to listener
	if (listener == null) {
	    return;
	}

	RemoteEvent evt = new RemoteEvent(this, MESSAGE_EVENT, messageSeqNo++, null);
	try {
	    listener.notify(evt); 
	} catch(net.jini.core.event.UnknownEventException e) {
	    e.printStackTrace();
	} catch(java.rmi.RemoteException e) {
	    e.printStackTrace();
	}
    }

    /**
     * Received an error message from the RCX.
     * Send it to the listener
     */
    public void receivedError(String error) {
	// System.err.println(error);

	// Send it out to listener
	if (listener == null) {
	    return;
	}
	this.error = error;
	RemoteEvent evt = new RemoteEvent(this, ERROR_EVENT, errorSeqNo, null);
	try {
	    listener.notify(evt);
	} catch(net.jini.core.event.UnknownEventException e) {
	    e.printStackTrace();
	} catch(java.rmi.RemoteException e) {
	    e.printStackTrace();
	}
    }

    /**
     * Expected use: the RCX has returned a message, 
     * and we have informed the listeners. They query
     * this method to find the message for the message
     * seqence number they were given in the RemoteEvent.
     * We could use this as an index into a table of messages.
     */
    public byte[] getMessage(long msgSeqNo) {
	return message;
    }

    /**
     * Expected use: the RCX has returned an error message, 
     * and we have informed the listeners. They query
     * this method to find the error message for the error message
     * seqence number they were given in the RemoteEvent.
     * We could use this as an index into a table of messages.
     */
    public String getError(long errSeqNo) {
	return error;
    }

    /**
     * Add a listener for RCX messages.
     * Should allow more than one, or throw
     * TooManyListeners if more than one registers
     */
    public void addListener(RemoteEventListener listener) {
	this.listener = listener;
	messageSeqNo = 0;
	errorSeqNo = 0;
    }
} // RCXPortImpl
