
/**
 * ServiceInfo.java
 *
 *
 * Created: Fri May  4 22:38:57 2001
 *
 * @author <a href="mailto:jan.newmarch@infotech.monash.edu.au"Jan Newmarch</a>
 * @version
 */

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;


import net.jini.core.lookup.ServiceItem;
import servicefinder.ServiceFinder;

public class ServiceInfo extends HttpServlet {

    public void doGet(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        response.setContentType("text/html");

        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");

        out.println("<title>" + "Jini Service Information" + "</title>");
        out.println("</head>");
        out.println("<body>");

        HttpSession session = request.getSession();
	ServiceFinder finder = (ServiceFinder) 
	    session.getAttribute("ServiceFinder");
	if (finder == null) {
	    out.println("Can't find service finder");
	    out.println("</body> </html>");
	}

        String serviceName = request.getParameter("servicename");
	if (serviceName == null) {
	    out.println("No service parameter supplied");
	    out.println("</body> </html>");
	}

	ServiceItem[] services = null;
	try {
	    services = finder.getServices();
	} catch(java.rmi.RemoteException e) {
	    out.println("<pre>" + e.toString() + "</pre>");
	    out.println("</body>\n</html>");
	    return;
	}

	ServiceItem serviceItem = null;
	for (int n = 0; n < services.length; n++) {
	    ServiceItem item = services[n];
	    if (item.service == null) {
		continue;
	    }
	    if (item.service.getClass().getName().equals(serviceName)) {
		serviceItem = item;
		break;
	    }
	}
	if (serviceItem == null) {
	    out.println("Can't find service " + serviceName);
	    out.println("</body>\n</html>");
	    return;
	}

	printServiceInfo(out, serviceItem);

        out.println("</body>");
        out.println("</html>");
    }

    public void doPost(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        doGet(request, response);
    }

    void printServiceInfo(PrintWriter out, ServiceItem item) {
	String name = item.service.getClass().getName();

	out.println("<center> <h1> Information about service " +
		    name + "</h1> </center>");
	Object service = item.service;
	Class serviceClass = service.getClass();
	Class[] interfaces = serviceClass.getInterfaces();

	out.println("<h2> Interfaces </h2>");
	out.println("<p>This lists the interfaces that <code>" + name + 
              "</code> implements. Sublists are interfaces that the interface " +
              "itself implements. </p>");
	out.println("<p> Select an interface to see its definition </p>");
	printInterfaces(out, interfaces);
    }

    /**
     * This needs to be called recursively as we walk
     * up the tree of interface definitions
     */
    void printInterfaces(PrintWriter out, Class[] interfaces) {
	if (interfaces.length == 0) {
	    return;
	}
	out.println("<ul>");
	for (int n = 0; n < interfaces.length; n++) {
	    Class intface = interfaces[n];
	    String name = intface.getName();
	    out.println("<li> " + 
			"<a href=\"http://localhost:8088/jini/servlet/InterfaceDefinition?interface=" + 
			name + "\"> " + name +" </a>");
	    Class[] parentInterfaces = intface.getInterfaces();
	    printInterfaces(out, parentInterfaces);
	}
	out.println("</ul>");
    }
}// ServiceInfo
