
package examples.txn;

import java.rmi.Remote;
import java.rmi.RemoteException;

import net.jini.core.transaction.*;
import net.jini.core.transaction.server.*;

public interface TxnServer
        extends Remote, TransactionParticipant {

    // Bank Account methods
    public int startAccount(int SeedMoney) throws RemoteException;
    public int deposit(Transaction txn, int amount) throws RemoteException;
    public int withdraw(Transaction txn, int amount) throws RemoteException;
    public int balance() throws RemoteException;
        
    // TransactionParticipant methods
    public int prepare(TransactionManager mgr,
                   long id)
            throws UnknownTransactionException,
                   java.rmi.RemoteException;
                   
    public void abort(TransactionManager mgr, long id) 
            throws UnknownTransactionException,
                   java.rmi.RemoteException;
                  
    public int prepareAndCommit(TransactionManager mgr,
                            long id)
            throws UnknownTransactionException,
                   java.rmi.RemoteException;
                            
    public void commit(TransactionManager mgr,
                   long id)
            throws UnknownTransactionException,
                   java.rmi.RemoteException;

                                                               
}
