
/**
 * FileClassifierApplication.java
 *
 *
 * Created: Sat Jun 2 2001
 *
 * @author Jan Newmarch
 * @version 1.0
 */

package jnlp;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import java.util.StringTokenizer;
import java.util.Vector;

import net.jini.core.lookup.ServiceItem;
import common.MIMEType;
import common.FileClassifier;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import net.jini.discovery.LookupDiscovery;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.LookupCache;
import net.jini.core.lookup.ServiceItem;
import net.jini.lease.LeaseRenewalManager;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.LookupLocatorDiscovery;

import java.net.InetAddress;
import java.net.UnknownHostException;

import net.jini.core.lookup.ServiceRegistrar;

/** * JNLP application that uses the FileClassifier service
 */
public class FileClassifierApplication extends JFrame 
    implements net.jini.discovery.DiscoveryListener {
    private static final long WAITFOR = 50000L;
    ServiceItem item;
    TextField text;
    FileClassifier classifier;
    LookupCache cache;

    static public void main(String[] argv) {
	System.out.println("Found and starting");
	new FileClassifierApplication();
    }

    public FileClassifierApplication() {

	cacheFileClassifierService();

	Container contentPane = getContentPane();
	Panel top = new Panel();
	Panel bottom = new Panel();
	contentPane.add(top, BorderLayout.CENTER);
	contentPane.add(bottom, BorderLayout.SOUTH);
	
	top.setLayout(new BorderLayout());
	top.add(new Label("Filename"), BorderLayout.WEST);
	text = new TextField(20);
	top.add(text, BorderLayout.CENTER);

	bottom.setLayout(new FlowLayout());
	Button classify = new Button("Classify");
	Button quit = new Button("Quit");
	bottom.add(classify);
	bottom.add(quit);

	// listeners
	quit.addActionListener(new QuitListener());
	classify.addActionListener(new ClassifyListener());

	pack();
	setVisible(true);
    }

    protected void cacheFileClassifierService() {

       ServiceDiscoveryManager clientMgr = null;
        LookupLocatorDiscovery discovery = null;
	LookupLocator[] locators = null;

	// set the codebase before installing the security manager
	System.setProperty("java.rmi.server.codebase", 
			   System.getProperty("codebase"));
        System.setSecurityManager(new RMISecurityManager());

        try {
	    locators = getLocators();
	    discovery = new LookupLocatorDiscovery(locators);

            clientMgr = new ServiceDiscoveryManager(discovery, 
                                                new LeaseRenewalManager());
        } catch(Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
  
        Class [] classes = new Class[] {FileClassifier.class};
        ServiceTemplate template = new ServiceTemplate(null, classes, 
                                                       null);

        try {
            cache = clientMgr.createLookupCache(template, 
                                                null, /* no filter */ 
                                                null /* no listener */);
        } catch(Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /**
     * get the list of locators from properties in the JNLP file
     */
    protected LookupLocator[] getLocators() {
	Vector lookupNames = new Vector();
	String lookupStr = System.getProperty("LookupServices");
	if (lookupStr == null) {
	    return null;
	}

	// split this on whitespace
	StringTokenizer tokenizer = new StringTokenizer(lookupStr);
	while (tokenizer.hasMoreTokens()) {
	    String token = tokenizer.nextToken();
	    lookupNames.add(token);
	}
	LookupLocator[] locators = new LookupLocator[lookupNames.size()];
	for (int n = 0; n < locators.length; n++) {
	    LookupLocator loc = null;
	    try {
		loc = new LookupLocator((String) lookupNames.elementAt(n));
	    } catch(Exception e) {
		// empty - just add a null element
	    }
	    locators[n] = loc;
	}
	return locators;
    }

    class QuitListener implements ActionListener {
	public void actionPerformed(ActionEvent evt) {
	    System.exit(0);
	}
    }

    class ClassifyListener implements ActionListener {
	public void actionPerformed(ActionEvent evt) {
	    String fileName = text.getText();
	    Component frame = text.getParent();
	    while (! (frame instanceof Frame)) {
		frame = frame.getParent();
	    }
	    final Dialog dlg = new Dialog((Frame) frame);
	    dlg.setLayout(new BorderLayout());
	    TextArea response = new TextArea(3, 20);

	    ServiceItem item = null;
	    item = cache.lookup(null);
	    
	    if (item == null) {
		JOptionPane.showMessageDialog(null, "No service available");
		return;
	    }
	    FileClassifier classifier = (FileClassifier) item.service;
	    
	    MIMEType type = null;
	    try {
		type = classifier.getMIMEType(fileName);
		if (type == null) {
		    response.setText("The type of file " + fileName +
				     " is unknown");
		} else {
		    response.setText("The type of file " + fileName +
				     " is " + type.toString());
		}
	    } catch(RemoteException e) {
		response.setText(e.toString());
	    }

	    Button ok = new Button("ok");
	    ok.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    dlg.setVisible(false);
		}
	    });

	    dlg.add(response, BorderLayout.CENTER);
	    dlg.add(ok, BorderLayout.SOUTH);
	    dlg.setSize(300, 100);
	    dlg.setVisible(true);
	}
    }

    public void discovered(net.jini.discovery.DiscoveryEvent e) {
	System.out.println("discovered");
	 ServiceRegistrar[] registrars = e.getRegistrars();
	 for (int n = 0; n < registrars.length; n++) {
	     ServiceRegistrar reg = registrars[n];
	     try {
		 System.out.println("  discovered " +
				reg.getLocator().getHost());
	     } catch(java.rmi.RemoteException ex) {
	     }
	 }
    }

    public void discarded(net.jini.discovery.DiscoveryEvent e) {
	System.out.println("discarded");
	 ServiceRegistrar[] registrars = e.getRegistrars();
	 for (int n = 0; n < registrars.length; n++) {
	     ServiceRegistrar reg = registrars[n];
	     try {
		 System.out.println("  discarded " +
				reg.getLocator().getHost());
	     } catch(java.rmi.RemoteException ex) {
	     }
	 }
    }
} // FileClassifierApplication
