/*************************************************************
 *
 *  GridBagJPanel
 *
 *  class to simplify using the GridBagLayout manager and make the
 *  application code more readable
 *
 *  extends JPanel by adding a method, add, which accepts a
 *  string representation of the constraints. For example a call which looks like:
 *
 *  fooPanel.add(new Canvas(),"w=1 h=1 a=n in=10,5,10,5")
 *
 *  will add a canvas to the panel fooPanel, with:
 *	gridwidth = 1 
 *	gridheight = 1
 *	anchor = NORTH
 *	insets = 10,5,10,5
 *
 * all other parameters will take default values
 *
 * magic string tokens:
 *  w = gridwidth, takes an int or one of the tokens rem (REMAINDER) or rel (RELATIVE)
 *  h = gridheight, ditto
 *  x = gridx, takes an int or the token rel
 *  y = gridy, ditto
 *  f = fill, takes one of the tokens none hor (HORIZONTAL) ver (VERTICAL) both
 *  a = anchor, takes one of n s e w ne nw se sw c for the compass point
 *  ix= ipadx, takes an int
 *  iy= ipady, takes an int
 *  in= insets, takes four ints separated by commas
 *  wx= weightx, takes an int or a float
 *  wy= weighty, ditto
 *
 * a parse error generates a generic exception. This makes error detection
 * simple during development, without cluttering up the code with
 * try/catch blocks to catch exceptions which would never occur in production
 *
 *  the constructor automatically creates a GridBagLayout manager for the GridBagPanel,
 *  so it is unnecessary to use setLayout to add one. In fact, setLayout is overridden
 *  and is a noop for this container.
 *
 *  Author: Brian Jeltema
 *
 ********************************************************************************/


import java.awt.GridBagLayout ;
import java.awt.GridBagConstraints ;
import java.util.* ;
import javax.swing.* ;
import java.awt.* ;

public class GridBagJPanel extends JPanel {

  static final boolean debug = false ;

  public GridBagJPanel() {

    // super() called by default
    setLayout(new GridBagLayout()) ;
  }

//
// add adds a component to the panel, using
// the constraintString to build a GridBagConstraints object.

  public void add(Component component, String constraintString) {
    GridBagParsedConstraints gbc = new GridBagParsedConstraints(constraintString) ;
    ((GridBagLayout)getLayout()).setConstraints(component,gbc) ;
    add(component) ;
  }
}
