/*
 * LunchServerInterface
 *
 * This is the remote interface for the service, used by the RMI proxy.
 * This interface should not be needed if only the sockets proxy is
 * implemented (though I haven't tested that)
 *
 * Authors: Steve Fritzinger and Brian Jeltema
 */

import java.rmi.*;
import java.util.Hashtable;
import net.jini.core.event.* ;

public interface LunchServerInterface extends Remote {
    public void registerPref(String name, String food) throws RemoteException;
    public void changePref(String name, String food) throws RemoteException;
    public Hashtable getLunchers() throws RemoteException;
    public void clearServer() throws RemoteException;
    public void dump() throws RemoteException;
    public EventRegistration registerListener(RemoteEventListener listener,long duration) throws RemoteException ;
}
