
import net.jini.discovery.IncomingMulticastRequest;
import net.jini.discovery.OutgoingUnicastResponse;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.io.*;
import java.rmi.MarshalledObject;

public class LookupService  {

    public static String ADDRESS = "224.0.1.85";
    public static int PORT = 4160;
    
    public static void main(String[] argv) {
	new LookupService();
    }

    public LookupService() {
	try {

	    InetAddress group = null;
	    MulticastSocket s = null;
	    group = InetAddress.getByName(ADDRESS);
	    s = new MulticastSocket(PORT);
	    s.joinGroup(group);

	    byte[] buf = new byte[512];
	    DatagramPacket recv = new DatagramPacket(buf, buf.length);
	    s.receive(recv);
	    
	    IncomingMulticastRequest request = new IncomingMulticastRequest(recv);
	    System.out.println("Address " + request.getAddress().toString());
	    System.out.println("Port " + request.getPort());
	    String[] groups = request.getGroups();
	    if (groups == null)
		System.out.println("Groups null");
	    else {
		System.out.println("Groups " + groups.length + " ");
		for (int n = 0; n < groups.length; n++)
		    System.out.println(groups[n] + " ");
	    }


	    Socket responseSocket = null;
	    responseSocket = new Socket(request.getAddress(), request.getPort());
	    InputStream in = responseSocket.getInputStream();
	    DataInputStream din = new DataInputStream(in);
	    int protoVersion = din.readInt();
	    System.out.println("Version " + protoVersion);

	    OutputStream out = responseSocket.getOutputStream();
	    // ObjectOutputStream objOut = new ObjectOutputStream(out);
	    AttackRegistrar registrar = new AttackRegistrar();

	    OutgoingUnicastResponse.marshal(out, registrar, request.getGroups());  
	    /*
	    MarshalledObject marshalledRegistrar = new MarshalledObject(registrar);
System.out.println("Codebases " + 
java.rmi.server.RMIClassLoader.getClassAnnotation(marshalledRegistrar.getClass()));
	    objOut.writeObject(marshalledRegistrar);
	    objOut.writeInt(0);
	    */
	    responseSocket.close();
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }
} // LookupService
