
/**
 * JavaMeetingImpl.java
 *
 *
 * Created: Thu Aug 26 15:33:24 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */
package corba.RoomBookingImpl;

import corba.RoomBooking.*;
import org.omg.CORBA.*;
import corba.common.*;

/**
 * A portable Java object representing a CORBA object.
 * It carries a stringified version of the CORBA reference
 * for reconstruction on JVM's which have a CORBA orb.
 * It exposes the attributes of the CORBA object to non-CORBA
 * applications by copying the attribute values on construction.
 */
public class JavaMeetingImpl implements JavaMeeting {
    protected String purpose;
    protected String participants;
    protected String corbaObj;

    /**
     * get the purpose of a meeting for a Java client
     * unaware of CORBA
     */ 
    public String getPurpose() {
	return purpose;
    }

    /**
     * get the participants of a meeting for a Java client
     * unaware of CORBA
     */ 
    public String getParticipants() {
	return participants;
    }

    /**
     * reconstruct a meeting using a CORBA orb in the target JVM
     */
    public Meeting getMeeting(ORB orb) {
	org.omg.CORBA.Object obj = orb.string_to_object(corbaObj);
	Meeting m = MeetingHelper.narrow(obj);
	return m;
    }

    /**
     * construct a portable Java representation of the CORBA
     * Meeting, using the CORBA orb on the source JVM
     */
    public JavaMeetingImpl(Meeting m, ORB orb) {
	purpose = m.purpose();
	participants = m.participants();
	corbaObj = orb.object_to_string(m);
    }
    
} // JavaMeetingImpl
