import java.io.Serializable;
import net.jini.core.entry.Entry;

/**
 * A JavaBeans(TM) component that encapsulates a Protocol object.
 *
 */
public class Protocol implements EntryBean, Serializable {
    private static final long serialVersionUID = -6026791845102735793L;
    
    /**
     * The Protocol object associated with this JavaBeans component.
     *
     * @serial
     */
    protected Protocol assoc;

    /**
     * Construct a new JavaBeans component, linked to a new empty Protocol object.
     */
    public Protocol() {
	assoc = new Protocol();
    }

    /**
     * Make a link to an Entry object.
     *
     * @param e the Entry object to link to
     * @exception java.lang.ClassCastException the Entry is not of the
     * correct type for this JavaBeans component
     */
    public void makeLink(Entry e) {
	assoc = (Protocol) e;
    }

    /**
     * Return the Protocol linked to by this JavaBeans component.
     */
    public Entry followLink() {
	return assoc;
    }

    /**
     * Return the value of the name field in the object linked to by
     * this JavaBeans component.
     */
    public String getProtocol() {
	return assoc.name;
    }

    /**
     * Set the value of the name field in the object linked to by this
     * JavaBeans component.
     */
    public void setProtocol(String x) {
	assoc.name = x;
    }
}
