/*
 * This source code (.java) file is Copyright  2000 Bill Venners. All rights reserved. 
 * This file accompanies the Jini Service UI Draft Specification, written by Bill
 * Venners and published on the World Wide Web at:
 * 
 *     http://www.artima.com/jini/serviceui/DraftSpec.html,
 *
 * This source file may not be copied, modified, or redistributed EXCEPT as allowed
 * by the following statements: From February 7, 2000 through March 6, 2000, you may
 * copy and/or modify these files to test and experiment with the Service UI API,
 * described in the Jini Service UI Draft Specification. Any bug fixes must be given
 * back to Bill Venners. You may not redistribute this file or any binary (such
 * as .class) files generated from this file. You may not distribute modified versions
 * this files or any binary (such as .class) files generated from modified versions of
 * this file. You may not remove this copyright notice. You may not use this file in
 * printed media without the express permission of Bill Venners. And if that weren't
 * enough, you must destroy all copies of this file, and any binary (such as
 * .class) files generated from this file, by March 7, 2000.
 *
 * BILL VENNERS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THIS
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * BILL VENNERS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY A LICENSEE AS A RESULT
 * OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/
package net.jini.lookup.ui.factory;

import java.awt.Dialog;
import java.awt.Frame;

/**
 * UI factory for a modal or non-modal AWT <CODE>Dialog</CODE> with a
 * predetermined title.
 *
 * <P>If the UI generated by the method declared in this interface implements
 * <CODE>javax.accessibility.Accessible</CODE> and supports the Java Accessibility
 * API, an <CODE>AccessibleUI</CODE> attribute
 * should be placed in the <CODE>UIDescriptor</CODE>'s <CODE>attributes</CODE> set.
 */
public interface DialogFactory extends java.io.Serializable {

    /**
     * Convenience constant to use in the <CODE>toolkit</CODE>
     * field of <CODE>UIDescriptor</CODE>s that contain a
     * <CODE>DialogFactory</CODE>.
    */
    String toolkit = "java.awt";

    /**
     * Convenience constant to use in the <CODE>UIFactoryTypes</CODE>
     * set in the <CODE>attributes</CODE> set of <CODE>UIDescriptor</CODE>s
     * that contain a <CODE>DialogFactory</CODE>.
    */
    String typeName = "net.jini.lookup.ui.factory.DialogFactory";

    /**
     * Returns a non-modal <CODE>Dialog</CODE> with predetermined title 
     * and the specified owner <CODE>Dialog</CODE>.
     */
    Dialog getDialog(Object roleObject, Dialog owner);

    /**
     * Returns a non-modal <CODE>Dialog</CODE> with predetermined title and the
     * specified owner <CODE>Frame</CODE>.
     */
    Dialog getDialog(Object roleObject, Frame owner);

    /**
     * Returns a <CODE>Dialog</CODE> with predetermined title and the
     * specified modality and owner <CODE>Dialog</CODE>.
     */
    Dialog getDialog(Object roleObject, Dialog owner,
        boolean modal);

    /**
     * Returns a <CODE>Dialog</CODE> with predetermined title and the
     * specified modality and owner <CODE>Frame</CODE>.
     */
    Dialog getDialog(Object roleObject, Frame owner,
         boolean modal);
}
