/*
 * Decompiled with CFR 0.152.
 */
package audio.httpsource;

import audio.httpsource.DirectoryServerOpt;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.util.Vector;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;

public class DirDirectoryServer {
    private Vector dirs = new Vector();

    public DirDirectoryServer(String dirStr) {
        LeaseRenewalManager leaseRenewalManager = new LeaseRenewalManager();
        LookupDiscoveryManager lookupDiscoveryManager = null;
        try {
            lookupDiscoveryManager = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        File dir = new File(dirStr);
        String[] files = dir.list(new FilenameFilter(){

            public boolean accept(File d, String name) {
                System.out.println("Checking file " + name);
                return name.endsWith(".cfg");
            }
        });
        System.out.println("Dir length: " + files.length);
        for (int n = 0; n < files.length; ++n) {
            this.dirs.add(new DirectoryServerOpt(new String[]{dirStr + "/" + files[n]}, leaseRenewalManager, lookupDiscoveryManager));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Object keepAlive;
        System.setSecurityManager(new RMISecurityManager());
        DirDirectoryServer dd = new DirDirectoryServer(argv[0]);
        Object object = keepAlive = new Object();
        synchronized (object) {
            try {
                keepAlive.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

