/*
 * Decompiled with CFR 0.152.
 */
package servlet;

import common.FileClassifier;
import common.MIMEType;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RMISecurityManager;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryManager;

public class FileClassifierServlet
extends HttpServlet {
    private LookupCache cache;

    public void init() {
        Class[] classArray;
        ServiceDiscoveryManager serviceDiscoveryManager = null;
        System.setSecurityManager(new RMISecurityManager());
        try {
            classArray = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)classArray, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        classArray = new Class[]{FileClassifier.class};
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
        try {
            this.cache = serviceDiscoveryManager.createLookupCache(serviceTemplate, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = "<!DOCTYPE HTML PUBLIC \"-//W3C/DTD HTML 4.0 Transitional//EN\"\n";
        printWriter.println(string + "<HTML>\n" + "<head><title>File Classifier</title></head>\n" + "<body>\n" + "<h1> File Classifier </h1>");
        String string2 = httpServletRequest.getParameter("filename");
        if (string2 == null || string2.length() == 0) {
            this.showFirstPage(printWriter);
        } else {
            this.handleForm(string2, printWriter);
        }
        printWriter.println("</BODY> </HTML>");
    }

    public void showFirstPage(PrintWriter printWriter) {
        printWriter.println("<form action=\"http://localhost:8088/jini/servlet/servlet.FileClassifierServlet\">\nFile Name <input type=\"textfield\" name=\"filename\">\n<br>\n<input type=\"Submit\">\n</form>\n");
    }

    public void handleForm(String string, PrintWriter printWriter) {
        printWriter.println("<h1>Filename: " + string + "</h1>\n");
        ServiceItem serviceItem = null;
        serviceItem = this.cache.lookup(null);
        if (serviceItem == null) {
            printWriter.println("<P>No service- try again later</P>");
            return;
        }
        FileClassifier fileClassifier = (FileClassifier)serviceItem.service;
        MIMEType mIMEType = null;
        try {
            mIMEType = fileClassifier.getMIMEType(string);
        }
        catch (Exception exception) {
            printWriter.println("<pre>" + exception.toString() + "</pre>");
            return;
        }
        if (mIMEType == null) {
            printWriter.println("<P>Unknown file type</P>");
        } else {
            printWriter.println("<P>Type is: " + mIMEType.toString() + "</P>");
        }
    }
}

