/*
 * Decompiled with CFR 0.152.
 */
package audio.client;

import audio.client.ClientFrame;
import audio.client.GUIClient;
import audio.client.LabelCellRenderer;
import audio.client.PlayFrame;
import audio.client.SourceSink;
import audio.common.AlreadyPlayingException;
import audio.common.AlreadyRecordingException;
import audio.common.ComparableServiceItem;
import audio.common.NoSuchListenerException;
import audio.common.NotRecordingException;
import audio.common.Sink;
import audio.common.Source;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceItem;

public class ClientFrame
extends JFrame
implements ActionListener,
ListSelectionListener,
TreeSelectionListener,
TreeExpansionListener,
RemoteEventListener {
    private GUIClient client;
    private JList sources = new JList();
    private JList sinks = new JList();
    private JTree directories = new JTree();
    private JButton playFolderBtn = new JButton("Play folder");
    private JButton playSourcesBtn = new JButton("Play sources");
    private JButton stopBtn = new JButton("Stop");
    private Remote proxy;

    public ClientFrame() {
        super("Audio Router");
        this.makeLayout();
        this.addListeners();
        this.setupLists();
    }

    public void setClient(GUIClient client) {
        this.client = client;
    }

    private void makeLayout() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel bottom = new JPanel();
        JTabbedPane top = new JTabbedPane();
        contentPane.add((Component)bottom, "South");
        contentPane.add((Component)top, "Center");
        JPanel dirPane = new JPanel();
        JPanel sourcePane = new JPanel();
        JPanel sinkPane = new JPanel();
        top.add("Folders", dirPane);
        top.add("Sources", sourcePane);
        top.add("Sinks", sinkPane);
        dirPane.setLayout(new BorderLayout());
        JScrollPane js0 = new JScrollPane();
        js0.getViewport().setView(this.directories);
        dirPane.add((Component)js0, "Center");
        sourcePane.setLayout(new BorderLayout());
        JScrollPane js1 = new JScrollPane();
        js1.getViewport().setView(this.sources);
        sourcePane.add((Component)js1, "Center");
        sinkPane.setLayout(new BorderLayout());
        JScrollPane js2 = new JScrollPane();
        js2.getViewport().setView(this.sinks);
        sinkPane.add((Component)js2, "Center");
        bottom.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 3));
        buttons.add(this.playFolderBtn);
        buttons.add(this.playSourcesBtn);
        bottom.add((Component)buttons, "Center");
    }

    private void addListeners() {
        this.playFolderBtn.addActionListener(this);
        this.playSourcesBtn.addActionListener(this);
        this.stopBtn.addActionListener(this);
        this.directories.addTreeSelectionListener(this);
        this.directories.addTreeExpansionListener(this);
        this.sources.addListSelectionListener(this);
        this.sinks.addListSelectionListener(this);
    }

    private void setupLists() {
        LabelCellRenderer labelRend = new LabelCellRenderer();
        this.directories.setCellRenderer(labelRend);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Directories");
        this.directories.setModel(new DefaultTreeModel(root));
        this.sources.setCellRenderer(labelRend);
        this.sources.setModel(new DefaultListModel());
        this.sinks.setCellRenderer(labelRend);
        this.sinks.setModel(new DefaultListModel());
    }

    public void actionPerformed(ActionEvent evt) {
        Object[] sourceSels = null;
        if (evt.getSource() == this.playSourcesBtn) {
            sourceSels = this.sources.getSelectedValues();
        } else if (evt.getSource() == this.playFolderBtn) {
            TreePath[] selectionPaths = this.directories.getSelectionPaths();
            if (selectionPaths == null) {
                sourceSels = null;
            } else {
                sourceSels = new Object[selectionPaths.length];
                for (int n = 0; n < sourceSels.length; ++n) {
                    Object lastComponent;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPaths[n].getLastPathComponent();
                    sourceSels[n] = lastComponent = node.getUserObject();
                }
            }
        }
        if (sourceSels == null || sourceSels.length == 0) {
            JOptionPane.showMessageDialog(null, "No source selected", "Source is null", 0);
            return;
        }
        Object[] sinkSels = this.sinks.getSelectedValues();
        if (sinkSels == null || sinkSels.length == 0) {
            JOptionPane.showMessageDialog(null, "No sink selected", "Sink is null", 0);
            return;
        }
        ServiceItem[] sourceSelections = new ServiceItem[sourceSels.length];
        for (int n = 0; n < sourceSels.length; ++n) {
            sourceSelections[n] = (ServiceItem)sourceSels[n];
        }
        ServiceItem[] sinkSelections = new ServiceItem[sinkSels.length];
        for (int n = 0; n < sinkSels.length; ++n) {
            sinkSelections[n] = (ServiceItem)sinkSels[n];
        }
        new PlayFrame(this.client).play(sourceSelections, sinkSelections[0]);
    }

    private void play(ServiceItem[] sourceSelections, ServiceItem sinkItem) {
        if (sourceSelections == null || sourceSelections.length == 0) {
            System.out.println("Play: null sources");
            return;
        }
        Source source = (Source)sourceSelections[0].service;
        Sink sink = (Sink)sinkItem.service;
        ServiceItem[] rest = new ServiceItem[sourceSelections.length - 1];
        for (int n = 0; n < rest.length; ++n) {
            rest[n] = sourceSelections[n + 1];
        }
        MarshalledObject<SourceSink> handback = null;
        try {
            handback = new MarshalledObject<SourceSink>(new SourceSink(rest, sinkItem));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            if (this.proxy == null) {
                // empty if block
            }
            System.out.println("Added source " + source + " proxy " + this.proxy);
            sink.addSinkListener((RemoteEventListener)this.proxy, handback);
            System.out.println("Added sink " + sink + " proxy " + this.proxy + " handback " + handback.get().sources);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Setting sink to: " + sink);
            source.addSink(sink);
            System.out.println("Setting source to: " + source);
            sink.addSource(source);
            System.out.println("Playing " + sourceSelections[0].attributeSets[0]);
            source.play();
            sink.record();
        }
        catch (AlreadyPlayingException e) {
            JOptionPane.showMessageDialog(null, "Source already playing", "Play error", 0);
        }
        catch (AlreadyRecordingException e) {
            JOptionPane.showMessageDialog(null, "Sink already recording", "Record error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stop(ServiceItem[] sourceSelections, ServiceItem sinkItem) {
        System.out.println("Stopping");
        Sink sink = (Sink)sinkItem.service;
        try {
            sink.stop();
        }
        catch (NotRecordingException e) {
            JOptionPane.showMessageDialog(null, "Sink not recording", "Record stop error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notify(RemoteEvent evt) {
        Object src = evt.getSource();
        System.out.println("Updating " + src);
        if (src instanceof Sink && evt.getID() == 1L) {
            System.out.println("Sink stopped event");
            Sink sink = (Sink)src;
            try {
                sink.removeSinkListener((RemoteEventListener)this.proxy);
            }
            catch (RemoteException e) {
            }
            catch (NoSuchListenerException e) {
                // empty catch block
            }
            MarshalledObject handback = evt.getRegistrationObject();
            SourceSink ss = null;
            try {
                ss = (SourceSink)handback.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            ServiceItem[] sources = ss.sources;
            ServiceItem sinkItem = ss.sink;
            System.out.println("  stop -> play: sources " + sources + " sink " + sink);
            this.play(sources, sinkItem);
        } else if (src instanceof Source && evt.getID() == 1L) {
            System.out.println("Source stopped event");
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        JTree tree = (JTree)evt.getSource();
        TreePath selectionPath = tree.getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        Object lastComponent = node.getUserObject();
        System.out.println("Selection: " + lastComponent.toString());
        if (!node.isLeaf()) {
            TreePath[] childPaths = new TreePath[node.getChildCount()];
            Object[] selPathObjects = selectionPath.getPath();
            int selPathObjectsLength = selPathObjects.length;
            int n = 0;
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                Object[] childPathObjects = new Object[selPathObjectsLength + 1];
                for (int m = 0; m < selPathObjectsLength; ++m) {
                    childPathObjects[m] = selPathObjects[m];
                }
                childPathObjects[selPathObjectsLength] = children.nextElement();
                childPaths[n++] = new TreePath(childPathObjects);
            }
            tree.setSelectionPaths(childPaths);
        }
    }

    public void treeCollapsed(TreeExpansionEvent evt) {
        System.out.println("Tree collapsed " + evt.getPath());
    }

    public void treeExpanded(TreeExpansionEvent evt) {
        System.out.println("Tree expanded " + evt.getPath());
    }

    public DefaultMutableTreeNode addDirectory(ServiceItem item) {
        DefaultTreeModel model = (DefaultTreeModel)this.directories.getModel();
        DefaultMutableTreeNode newNode = this.addDirectoryTreeNode(new ComparableServiceItem(item), model);
        return newNode;
    }

    public void addDirectoryElement(Object node, ServiceItem item) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node;
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ComparableServiceItem(item));
        1 addDirElmt = new /* Unavailable Anonymous Inner Class!! */;
        SwingUtilities.invokeLater((Runnable)addDirElmt);
    }

    public void removeDirectory(ServiceItem item) {
        DefaultTreeModel model = (DefaultTreeModel)this.directories.getModel();
        this.removeTreeItem(new ComparableServiceItem(item), model);
    }

    private DefaultMutableTreeNode addDirectoryTreeNode(ComparableServiceItem item, DefaultTreeModel model) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(item);
        2 insertElement = new /* Unavailable Anonymous Inner Class!! */;
        try {
            SwingUtilities.invokeAndWait((Runnable)insertElement);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return newNode;
    }

    private DefaultMutableTreeNode removeTreeItem(ComparableServiceItem item, DefaultTreeModel model) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(item);
        3 removeElement = new /* Unavailable Anonymous Inner Class!! */;
        try {
            SwingUtilities.invokeAndWait((Runnable)removeElement);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return newNode;
    }

    public void addSource(ServiceItem item) {
        DefaultListModel model = (DefaultListModel)this.sources.getModel();
        this.insertListItem(new ComparableServiceItem(item), model);
    }

    public void removeSource(ServiceItem item) {
        DefaultListModel model = (DefaultListModel)this.sources.getModel();
        4 removeElement = new /* Unavailable Anonymous Inner Class!! */;
        SwingUtilities.invokeLater((Runnable)removeElement);
    }

    public void addSink(ServiceItem item) {
        DefaultListModel model = (DefaultListModel)this.sinks.getModel();
        this.insertListItem(new ComparableServiceItem(item), model);
    }

    public void removeSink(ServiceItem item) {
        DefaultListModel model = (DefaultListModel)this.sinks.getModel();
        5 removeElement = new /* Unavailable Anonymous Inner Class!! */;
        SwingUtilities.invokeLater((Runnable)removeElement);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
    }

    private void insertListItem(ComparableServiceItem item, DefaultListModel model) {
        6 insertElement = new /* Unavailable Anonymous Inner Class!! */;
        try {
            SwingUtilities.invokeAndWait((Runnable)insertElement);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

