/*
 * Decompiled with CFR 0.152.
 */
package audio.httpsource;

import audio.common.Directory;
import audio.http.HttpMP3SourceImpl;
import audio.http.HttpOggSourceImpl;
import audio.http.HttpSourceImpl;
import audio.http.HttpWAVSourceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.Vector;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Name;

public class DirectoryServerOpt
implements Directory,
DiscoveryListener {
    private ServiceID serviceID = null;
    private ServiceID[] serviceIDs;
    protected Remote proxy;
    protected HttpSourceImpl impl;
    private Entry[] dirEntries;
    private String cdInfo;
    private URL url = null;
    private Exporter exporter = null;
    private String cdIndexDiscID;
    private String cddbDiscID;
    private URL[] trackURLs;
    private String[] trackNames;
    private Configuration config;
    private File serviceIDFile;
    private LeaseRenewalManager leaseRenewalManager;
    private LookupDiscoveryManager mgr;
    private Vector sources = new Vector();

    public DirectoryServerOpt(String[] configArgs, LeaseRenewalManager leaseRenewalManager, LookupDiscoveryManager lookupDiscoveryManager) {
        this.leaseRenewalManager = leaseRenewalManager;
        this.mgr = lookupDiscoveryManager;
        System.out.println("1");
        this.getConfiguration(configArgs);
        System.out.println("2");
        this.cdInfo = this.getCDInfo();
        System.out.println("3");
        System.out.println("4");
        this.mgr.addDiscoveryListener((DiscoveryListener)this);
    }

    public void discovered(DiscoveryEvent e) {
        ServiceRegistrar[] regs = e.getRegistrars();
        for (int m = 0; m < regs.length; ++m) {
            ServiceRegistrar reg = regs[m];
            System.out.println("5");
            for (int n = 0; n < this.trackURLs.length; ++n) {
                this.makeFileService(reg, n, this.trackURLs[n]);
            }
            this.makeDirService(reg);
        }
    }

    public void discarded(DiscoveryEvent e) {
    }

    public ServiceID[] getServiceIDs() throws RemoteException {
        return this.serviceIDs;
    }

    private void getConfiguration(String[] configArgs) {
        Class cls;
        try {
            this.config = ConfigurationProvider.getInstance((String[])configArgs);
            System.out.println("Config is " + this.config);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            cls = Entry[].class;
            System.out.println(cls.toString());
            this.dirEntries = (Entry[])this.config.getEntry("HttpFileSourceServer", "entries", cls);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            this.cdIndexDiscID = (String)this.config.getEntry("HttpFileSourceServer", "cdIndexDiscID", String.class);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            this.cddbDiscID = (String)this.config.getEntry("HttpFileSourceServer", "cddbDiscID", String.class, null);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            cls = URL[].class;
            System.out.println(cls.toString());
            this.trackURLs = (URL[])this.config.getEntry("HttpFileSourceServer", "trackURLs", cls);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
            this.trackURLs = new URL[0];
        }
        try {
            cls = String[].class;
            System.out.println(cls.toString());
            this.trackNames = (String[])this.config.getEntry("HttpFileSourceServer", "trackNames", cls);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            this.serviceIDFile = (File)this.config.getEntry("HttpFileSourceServer", "serviceIDFile", File.class);
            this.getOrMakeServiceIDs(this.serviceIDFile);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
    }

    private void getOrMakeServiceIDs(File serviceIDFile) {
        this.serviceIDs = new ServiceID[this.trackURLs.length];
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(serviceIDFile));
            this.serviceID = (ServiceID)ois.readObject();
            System.out.println("Got dir service id " + this.serviceID);
            for (int n = 0; n < this.trackURLs.length; ++n) {
                this.serviceIDs[n] = (ServiceID)ois.readObject();
                System.out.println("Got service id " + this.serviceIDs[n]);
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't get service IDs - generating new ones");
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serviceIDFile));
                Uuid uuid = UuidFactory.generate();
                this.serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                oos.writeObject(this.serviceID);
                for (int n = 0; n < this.serviceIDs.length; ++n) {
                    Uuid uuidFile = UuidFactory.generate();
                    ServiceID id = new ServiceID(uuidFile.getMostSignificantBits(), uuidFile.getLeastSignificantBits());
                    oos.writeObject(id);
                    this.serviceIDs[n] = id;
                    System.out.println("Generating service id " + this.serviceIDs[n]);
                }
            }
            catch (Exception e2) {
                System.out.println("Couldn't save ids");
                e2.printStackTrace();
            }
        }
    }

    private void makeDirService(ServiceRegistrar registrar) {
        try {
            this.exporter = (Exporter)this.config.getEntry("HttpFileSourceServer", "exporter", Exporter.class);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            System.out.println("Export dir using exporter " + this.exporter);
            this.proxy = this.exporter.export((Remote)this);
        }
        catch (ExportException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        ServiceRegistration sr = null;
        try {
            sr = registrar.register(new ServiceItem(this.serviceID, (Object)this.proxy, this.dirEntries), Long.MAX_VALUE);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.leaseRenewalManager.renewUntil(sr.getLease(), Long.MAX_VALUE, null);
    }

    private void makeFileService(ServiceRegistrar registrar, int index, URL url) {
        Exporter exporter;
        block11: {
            exporter = null;
            try {
                exporter = (Exporter)this.config.getEntry("HttpFileSourceServer", "exporter", Exporter.class);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
                System.exit(1);
            }
            String urlStr = url.toString();
            System.out.println("URL is " + urlStr);
            try {
                if (urlStr.endsWith("wav")) {
                    this.impl = new HttpWAVSourceImpl(url);
                    break block11;
                }
                if (urlStr.endsWith("mp3")) {
                    this.impl = new HttpMP3SourceImpl(url);
                    break block11;
                }
                if (urlStr.endsWith("ogg")) {
                    this.impl = new HttpOggSourceImpl(url);
                    break block11;
                }
                System.out.println("Can't handle presentation type: " + url);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.sources.add(this.impl);
        try {
            System.out.println("Export file " + url + " using exporter " + exporter);
            this.proxy = exporter.export((Remote)this.impl);
        }
        catch (ExportException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        String trackInfo = this.getTrackInfo(index);
        Entry[] entries = new Entry[]{new Name(trackInfo)};
        ServiceRegistration sr = null;
        try {
            sr = registrar.register(new ServiceItem(this.serviceIDs[index], (Object)this.proxy, entries), Long.MAX_VALUE);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.leaseRenewalManager.renewUntil(sr.getLease(), Long.MAX_VALUE, null);
    }

    private JoinManager registerService(Remote proxy, ServiceID serviceID, Entry[] entries) {
        JoinManager joinMgr = null;
        try {
            System.out.println("Registering with id " + serviceID);
            joinMgr = new JoinManager((Object)proxy, entries, serviceID, (DiscoveryManagement)this.mgr, this.leaseRenewalManager);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return joinMgr;
    }

    public String getTrackInfo(int index) {
        if (this.trackNames != null && this.trackNames.length > index && this.trackNames[index] != null) {
            return this.cdInfo + ": " + this.trackNames[index];
        }
        String indexStr = null;
        indexStr = index < 9 ? "0" + (index + 1) : "" + (index + 1);
        return this.cdInfo + ": Track " + indexStr;
    }

    public String getCDInfo() {
        if (this.dirEntries == null) {
            return "";
        }
        for (int n = 0; n < this.dirEntries.length; ++n) {
            if (!(this.dirEntries[n] instanceof Name)) continue;
            return ((Name)this.dirEntries[n]).name;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Object keepAlive;
        LeaseRenewalManager leaseRenewalManager = new LeaseRenewalManager();
        LookupDiscoveryManager lookupDiscoveryManager = null;
        try {
            lookupDiscoveryManager = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.setSecurityManager(new RMISecurityManager());
        DirectoryServerOpt ds = new DirectoryServerOpt(argv, leaseRenewalManager, lookupDiscoveryManager);
        Object object = keepAlive = new Object();
        synchronized (object) {
            try {
                keepAlive.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

