/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.FileClassifier;
import java.awt.Frame;
import java.rmi.RMISecurityManager;
import java.util.Set;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.entry.UIDescriptor;
import net.jini.lookup.ui.attribute.UIFactoryTypes;
import net.jini.lookup.ui.factory.FrameFactory;

public class TestFrameUI {
    private static final long WAITFOR = 100000L;

    public static void main(String[] stringArray) {
        new TestFrameUI();
        try {
            Thread.currentThread();
            Thread.sleep(200000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TestFrameUI() {
        Class[] classArray;
        ServiceDiscoveryManager serviceDiscoveryManager = null;
        System.setSecurityManager(new RMISecurityManager());
        try {
            classArray = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)classArray, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        classArray = new Class[]{FileClassifier.class};
        UIDescriptor uIDescriptor = new UIDescriptor("net.jini.lookup.ui.MainUI", "java.awt", null, null);
        Entry[] entryArray = null;
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, entryArray);
        ServiceItem serviceItem = null;
        try {
            serviceItem = serviceDiscoveryManager.lookup(serviceTemplate, null, 100000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (serviceItem == null) {
            System.out.println("no service");
            System.exit(1);
        }
        if (serviceItem.service == null) {
            System.out.println("service is null");
            System.exit(1);
        }
        this.checkUI(serviceItem);
    }

    private void checkUI(ServiceItem serviceItem) {
        Entry[] entryArray = serviceItem.attributeSets;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            if (!(entry instanceof UIDescriptor)) continue;
            this.checkForAWTFrame(serviceItem, (UIDescriptor)entry);
        }
    }

    private void checkForAWTFrame(ServiceItem serviceItem, UIDescriptor uIDescriptor) {
        Set set = uIDescriptor.attributes;
        for (Object e : set) {
            UIFactoryTypes uIFactoryTypes;
            if (!(e instanceof UIFactoryTypes) || !(uIFactoryTypes = (UIFactoryTypes)e).isAssignableTo(FrameFactory.class)) continue;
            FrameFactory frameFactory = null;
            try {
                frameFactory = (FrameFactory)uIDescriptor.getUIFactory(this.getClass().getClassLoader());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            System.out.println("calling frame with " + serviceItem);
            Frame frame = frameFactory.getFrame((Object)serviceItem);
            frame.setVisible(true);
        }
    }
}

