/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.io.File;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import rmi.RemoteFileClassifier;

public class FileClassifierServerAuth
implements LeaseListener {
    private LeaseRenewalManager leaseManager = new LeaseRenewalManager();
    private ServiceID serviceID = null;
    private RemoteFileClassifier impl;
    private File serviceIdFile;
    private Configuration config;
    static final String TRUST_LOG = "net.jini.security.trust";
    static final String INTEGRITY_LOG = "net.jini.security.integrity";
    static final String POLICY_LOG = "net.jini.security.policy";
    static final Logger trustLogger = Logger.getLogger("net.jini.security.trust");
    static final Logger integrityLogger = Logger.getLogger("net.jini.security.integrity");
    static final Logger policyLogger = Logger.getLogger("net.jini.security.policy");
    private static FileHandler trustFh;
    private static FileHandler integrityFh;
    private static FileHandler policyFh;
    private static FileClassifierServerAuth server;
    static final String DISCOVERY_LOG = "net.jini.security.trust";
    static final Logger logger;
    private static FileHandler fh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        FileClassifierServerAuth.installLoggers();
        FileClassifierServerAuth.init(stringArray);
        Object object2 = object = new Object();
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void init(final String[] stringArray) {
        try {
            LoginContext loginContext = new LoginContext("security.FileClassifierServerAuth");
            if (loginContext == null) {
                System.out.println("No login context");
                server = new FileClassifierServerAuth(stringArray);
            } else {
                loginContext.login();
                System.out.println("Login succeeded as " + loginContext.getSubject().toString());
                Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        server = new FileClassifierServerAuth(stringArray);
                        return null;
                    }
                }, null);
            }
        }
        catch (LoginException loginException) {
            loginException.printStackTrace();
            System.exit(3);
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
            System.exit(3);
        }
    }

    public FileClassifierServerAuth(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        Exporter exporter = null;
        String string = null;
        try {
            this.config = ConfigurationProvider.getInstance((String[])stringArray);
            exporter = (Exporter)this.config.getEntry("security.FileClassifierServer", "exporter", Exporter.class);
            string = (String)this.config.getEntry("security.FileClassifierServer", "serviceName", String.class);
        }
        catch (ConfigurationException configurationException) {
            System.err.println("Configuration error: " + configurationException.toString());
            System.exit(1);
        }
        try {
            this.impl = (RemoteFileClassifier)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        Remote remote = null;
        try {
            remote = exporter.export((Remote)this.impl);
            System.out.println("Proxy is " + remote.toString());
        }
        catch (ExportException exportException) {
            exportException.printStackTrace();
            System.exit(1);
        }
        JoinManager joinManager = null;
        try {
            LookupDiscoveryManager lookupDiscoveryManager = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            joinManager = new JoinManager((Object)remote, null, this.serviceID, (DiscoveryManagement)lookupDiscoveryManager, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void installLoggers() {
        try {
            trustFh = new FileHandler("log.server.trust.txt");
            integrityFh = new FileHandler("log.server.integrity.txt");
            policyFh = new FileHandler("log.server.policy.txt");
            trustFh.setFormatter(new SimpleFormatter());
            integrityFh.setFormatter(new SimpleFormatter());
            policyFh.setFormatter(new SimpleFormatter());
            trustLogger.addHandler(trustFh);
            integrityLogger.addHandler(integrityFh);
            policyLogger.addHandler(policyFh);
            trustLogger.setLevel(Level.ALL);
            integrityLogger.setLevel(Level.ALL);
            policyLogger.setLevel(Level.ALL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void getServiceID() {
        Uuid uuid = UuidFactory.generate();
        this.serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public void serviceIDNotify(ServiceID serviceID) {
        System.out.println("got service ID " + serviceID.toString());
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }

    public void notify(LeaseRenewalEvent leaseRenewalEvent) {
        System.out.println("Lease expired " + leaseRenewalEvent.toString());
    }

    static {
        logger = Logger.getLogger("net.jini.security.trust");
    }
}

