/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.FileClassifier;
import common.MIMEType;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryManager;

public class CachedClientLookup {
    private static final long WAITFOR = 100000L;

    public static void main(String[] stringArray) {
        new CachedClientLookup();
        try {
            Thread.currentThread();
            Thread.sleep(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public CachedClientLookup() {
        Class[] classArray;
        ServiceDiscoveryManager serviceDiscoveryManager = null;
        LookupCache lookupCache = null;
        System.setSecurityManager(new RMISecurityManager());
        try {
            classArray = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)classArray, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        classArray = new Class[]{FileClassifier.class};
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
        try {
            lookupCache = serviceDiscoveryManager.createLookupCache(serviceTemplate, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        ServiceItem serviceItem = null;
        while (serviceItem == null) {
            System.out.println("no service yet");
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            serviceItem = lookupCache.lookup(null);
        }
        FileClassifier fileClassifier = (FileClassifier)serviceItem.service;
        if (fileClassifier == null) {
            System.out.println("Classifier null");
            System.exit(1);
        }
        try {
            String string = "file1.txt";
            MIMEType mIMEType = fileClassifier.getMIMEType(string);
            this.printType(string, mIMEType);
            string = "file2.rtf";
            mIMEType = fileClassifier.getMIMEType(string);
            this.printType(string, mIMEType);
            string = "file3.abc";
            mIMEType = fileClassifier.getMIMEType(string);
            this.printType(string, mIMEType);
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException.toString());
        }
        System.exit(0);
    }

    private void printType(String string, MIMEType mIMEType) {
        System.out.print("Type of " + string + " is ");
        if (mIMEType == null) {
            System.out.println("null");
        } else {
            System.out.println(mIMEType.toString());
        }
    }
}

