/*
 * Decompiled with CFR 0.152.
 */
package socket;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import socket.FileClassifierProxy;
import socket.FileServerImpl;

public class FileClassifierServer
implements DiscoveryListener,
LeaseListener {
    protected FileClassifierProxy proxy;
    protected LeaseRenewalManager leaseManager = new LeaseRenewalManager();

    public static void main(String[] stringArray) {
        new FileClassifierServer();
        try {
            Thread.sleep(1000000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FileClassifierServer() {
        try {
            new FileServerImpl().start();
        }
        catch (Exception exception) {
            System.err.println("New impl: " + exception.toString());
            System.exit(1);
        }
        System.setSecurityManager(new RMISecurityManager());
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            System.exit(1);
        }
        this.proxy = new FileClassifierProxy(string);
        LookupDiscovery lookupDiscovery = null;
        try {
            lookupDiscovery = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        lookupDiscovery.addDiscoveryListener((DiscoveryListener)this);
    }

    public void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            System.out.println("found registrars");
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
            ServiceItem serviceItem = new ServiceItem(null, (Object)this.proxy, null);
            ServiceRegistration serviceRegistration = null;
            try {
                serviceRegistration = serviceRegistrar.register(serviceItem, Long.MAX_VALUE);
            }
            catch (RemoteException remoteException) {
                System.err.print("Register exception: ");
                remoteException.printStackTrace();
                continue;
            }
            try {
                System.out.println("service registered at " + serviceRegistrar.getLocator().getHost());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.leaseManager.renewUntil(serviceRegistration.getLease(), Long.MAX_VALUE, (LeaseListener)this);
        }
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }

    public void notify(LeaseRenewalEvent leaseRenewalEvent) {
        System.out.println("Lease expired " + leaseRenewalEvent.toString());
    }
}

