/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.FileClassifier;
import common.MIMEType;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

public class TestFileClassifierProxyPreparer
implements DiscoveryListener {
    private Configuration config;
    static final String TRUST_LOG = "net.jini.security.trust";
    static final String INTEGRITY_LOG = "net.jini.security.integrity";
    static final String POLICY_LOG = "net.jini.security.policy";
    static final Logger trustLogger = Logger.getLogger("net.jini.security.trust");
    static final Logger integrityLogger = Logger.getLogger("net.jini.security.integrity");
    static final Logger policyLogger = Logger.getLogger("net.jini.security.policy");
    private static FileHandler trustFh;
    private static FileHandler integrityFh;
    private static FileHandler policyFh;

    public static void main(String[] stringArray) throws ConfigurationException {
        TestFileClassifierProxyPreparer.installLoggers();
        new TestFileClassifierProxyPreparer(stringArray);
        try {
            Thread.currentThread();
            Thread.sleep(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TestFileClassifierProxyPreparer(String[] stringArray) throws ConfigurationException {
        this.config = ConfigurationProvider.getInstance((String[])stringArray);
        System.setSecurityManager(new RMISecurityManager());
        LookupDiscovery lookupDiscovery = null;
        try {
            lookupDiscovery = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        lookupDiscovery.addDiscoveryListener((DiscoveryListener)this);
    }

    private static void installLoggers() {
        try {
            trustFh = new FileHandler("log.client.trust.txt");
            integrityFh = new FileHandler("log.client.integrity.txt");
            policyFh = new FileHandler("log.client.policy.txt");
            trustFh.setFormatter(new SimpleFormatter());
            integrityFh.setFormatter(new SimpleFormatter());
            policyFh.setFormatter(new SimpleFormatter());
            trustLogger.addHandler(trustFh);
            integrityLogger.addHandler(integrityFh);
            policyLogger.addHandler(policyFh);
            trustLogger.setLevel(Level.ALL);
            integrityLogger.setLevel(Level.ALL);
            policyLogger.setLevel(Level.ALL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
        Class[] classArray = new Class[]{FileClassifier.class};
        FileClassifier fileClassifier = null;
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            System.out.println("Lookup service found");
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
            try {
                fileClassifier = (FileClassifier)serviceRegistrar.lookup(serviceTemplate);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                System.exit(4);
                continue;
            }
            if (fileClassifier == null) {
                System.out.println("Classifier null");
                continue;
            }
            System.out.println("Getting the proxy");
            BasicProxyPreparer basicProxyPreparer = null;
            try {
                basicProxyPreparer = (ProxyPreparer)this.config.getEntry("client.TestFileClassifierProxyPreparer", "preparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            }
            catch (ConfigurationException configurationException) {
                configurationException.printStackTrace();
                basicProxyPreparer = new BasicProxyPreparer();
            }
            System.out.println("Preparing the proxy");
            try {
                fileClassifier = (FileClassifier)basicProxyPreparer.prepareProxy((Object)fileClassifier);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                System.exit(3);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                System.exit(6);
            }
            System.out.println("Calling the proxy");
            try {
                String string = "file1.txt";
                MIMEType mIMEType = fileClassifier.getMIMEType(string);
                this.printType(string, mIMEType);
                string = "file2.rtf";
                mIMEType = fileClassifier.getMIMEType(string);
                this.printType(string, mIMEType);
                string = "file3.abc";
                mIMEType = fileClassifier.getMIMEType(string);
                this.printType(string, mIMEType);
            }
            catch (RemoteException remoteException) {
                System.out.println("Failed to call method");
                System.err.println(remoteException.toString());
                System.exit(5);
                continue;
            }
            System.exit(0);
        }
    }

    private void printType(String string, MIMEType mIMEType) {
        System.out.print("Type of " + string + " is ");
        if (mIMEType == null) {
            System.out.println("null");
        } else {
            System.out.println(mIMEType.toString());
        }
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }
}

