/*
 * Decompiled with CFR 0.152.
 */
package audio.httpsource;

import audio.http.HttpMP3SourceImpl;
import audio.http.HttpOggSourceImpl;
import audio.http.HttpSourceImpl;
import audio.http.HttpWAVSourceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;

public class FileServer {
    private Remote proxy;
    private HttpSourceImpl impl;
    private static String configFile;
    private Entry[] entries;
    private File serviceIDFile;
    private ServiceID serviceID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Object keepAlive;
        configFile = argv[0];
        FileServer serv = new FileServer(argv);
        Object object = keepAlive = new Object();
        synchronized (object) {
            try {
                keepAlive.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public FileServer(String[] argv) {
        Exporter exporter;
        block12: {
            URL url = null;
            exporter = null;
            if (argv.length != 1) {
                System.err.println("Usage: FileServer config_file");
                System.exit(1);
            }
            String[] configArgs = argv;
            try {
                Configuration config = ConfigurationProvider.getInstance((String[])configArgs);
                exporter = (Exporter)config.getEntry("HttpFile", "exporter", Exporter.class);
                url = (URL)config.getEntry("HttpFile", "url", URL.class);
                this.serviceIDFile = (File)config.getEntry("HttpFile", "serviceIDFile", File.class);
                this.getOrMakeServiceID(this.serviceIDFile);
                Class<?> cls = Class.forName("[Lnet.jini.core.entry.Entry;");
                System.out.println(cls.toString());
                this.entries = (Entry[])config.getEntry("HttpFile", "entries", cls);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
                System.exit(1);
            }
            String urlStr = url.toString();
            try {
                if (urlStr.endsWith("wav")) {
                    this.impl = new HttpWAVSourceImpl(url);
                    break block12;
                }
                if (urlStr.endsWith("mp3")) {
                    this.impl = new HttpMP3SourceImpl(url);
                    break block12;
                }
                if (urlStr.endsWith("ogg")) {
                    this.impl = new HttpOggSourceImpl(url);
                    break block12;
                }
                System.out.println("Can't handle presentation type: " + url);
                return;
            }
            catch (MalformedURLException e) {
                System.err.println(e.toString());
                System.exit(1);
            }
        }
        try {
            this.proxy = exporter.export((Remote)this.impl);
        }
        catch (ExportException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        System.setSecurityManager(new RMISecurityManager());
        JoinManager joinMgr = null;
        try {
            LookupDiscoveryManager mgr = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, new LookupLocator[]{new LookupLocator("jini://jannote.jan.home/")}, null);
            joinMgr = new JoinManager((Object)this.proxy, this.entries, this.serviceID, (DiscoveryManagement)mgr, new LeaseRenewalManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void getOrMakeServiceID(File serviceIDFile) {
        this.serviceID = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(serviceIDFile));
            this.serviceID = (ServiceID)ois.readObject();
            System.out.println("Got dir service id " + this.serviceID);
        }
        catch (Exception e) {
            System.out.println("Couldn't get service IDs - generating new one");
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serviceIDFile));
                Uuid uuid = UuidFactory.generate();
                this.serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                oos.writeObject(this.serviceID);
                oos.close();
            }
            catch (Exception e2) {
                System.out.println("Couldn't save ids");
                e2.printStackTrace();
            }
        }
    }
}

