/*
 * Decompiled with CFR 0.152.
 */
package lease;

import common.MIMEType;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import lease.FileClassifierLandlord;
import lease.RemoteLeaseFileClassifier;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;

public class FileClassifierImpl
implements RemoteLeaseFileClassifier {
    public final long DURATION = 120000L;
    protected Map map = new HashMap();
    protected transient FileClassifierLandlord landlord;

    public MIMEType getMIMEType(String string) {
        System.out.println("Called with " + string);
        int n = string.lastIndexOf(46);
        if (n == -1 || n + 1 == string.length()) {
            return null;
        }
        String string2 = string.substring(n + 1);
        MIMEType mIMEType = (MIMEType)this.map.get(string2);
        return mIMEType;
    }

    public Lease addType(String string, MIMEType mIMEType) throws LeaseDeniedException {
        if (this.map.containsKey(string)) {
            throw new LeaseDeniedException("Extension already has a MIME type");
        }
        this.map.put(string, mIMEType);
        System.out.println("type added");
        Lease lease = this.landlord.newFileClassifierLease(this, string, 120000L);
        System.out.println("Lease is " + lease);
        return lease;
    }

    public void removeType(String string) {
        this.map.remove(string);
    }

    public FileClassifierImpl() throws RemoteException {
        this.map.put("gif", new MIMEType("image", "gif"));
        this.map.put("jpeg", new MIMEType("image", "jpeg"));
        this.map.put("mpg", new MIMEType("video", "mpeg"));
        this.map.put("txt", new MIMEType("text", "plain"));
        this.map.put("html", new MIMEType("text", "html"));
        this.landlord = new FileClassifierLandlord();
    }
}

