/*
 * Decompiled with CFR 0.152.
 */
package audio.client;

import audio.common.Sink;
import audio.common.Source;
import java.rmi.RMISecurityManager;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryManager;

public class BasicClient {
    private static final long WAITFOR = 100000L;
    private ServiceDiscoveryManager clientMgr = null;

    public static void main(String[] argv) {
        new BasicClient();
        try {
            Thread.currentThread();
            Thread.sleep(200000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public BasicClient() {
        System.setSecurityManager(new RMISecurityManager());
        try {
            LookupDiscoveryManager mgr = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            this.clientMgr = new ServiceDiscoveryManager((DiscoveryManagement)mgr, new LeaseRenewalManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Sink sink = (Sink)this.getService(Sink.class);
        Source source = (Source)this.getService(Source.class);
        try {
            source.addSink(sink);
            sink.addSource(source);
        }
        catch (Exception e) {
            System.err.println("Error setting source or sink " + e);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            System.out.println("Playing...");
            source.play();
            sink.record();
        }
        catch (Exception e) {
            System.out.println("Error in playing " + e);
            System.exit(1);
        }
    }

    private Object getService(Class cls) {
        Class[] classes = new Class[]{cls};
        ServiceTemplate template = new ServiceTemplate(null, classes, null);
        ServiceItem item = null;
        try {
            item = this.clientMgr.lookup(template, null, 100000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (item == null) {
            System.out.println("no service for class " + cls);
            System.exit(1);
        }
        return item.service;
    }
}

