/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.LeaseFileClassifier;
import common.MIMEType;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;

public class TestFileClassifierLease
implements DiscoveryListener {
    public static void main(String[] stringArray) {
        new TestFileClassifierLease();
        try {
            Thread.currentThread();
            Thread.sleep(1200000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Exiting normally");
    }

    public TestFileClassifierLease() {
        System.setSecurityManager(new RMISecurityManager());
        LookupDiscovery lookupDiscovery = null;
        try {
            lookupDiscovery = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        lookupDiscovery.addDiscoveryListener((DiscoveryListener)this);
    }

    public void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
        Class[] classArray = new Class[]{LeaseFileClassifier.class};
        LeaseFileClassifier leaseFileClassifier = null;
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            System.out.println("Service found");
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
            try {
                leaseFileClassifier = (LeaseFileClassifier)serviceRegistrar.lookup(serviceTemplate);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                System.exit(2);
            }
            if (leaseFileClassifier == null) {
                System.out.println("Classifier null");
                continue;
            }
            try {
                MIMEType mIMEType = leaseFileClassifier.getMIMEType("file1.txt");
                System.out.println("Type of known type file1.txt is " + mIMEType.toString());
                mIMEType = leaseFileClassifier.getMIMEType("file1.ps");
                System.out.println("Type of unknown type file1.ps is " + mIMEType);
                Lease lease = leaseFileClassifier.addType("ps", new MIMEType("text", "postscript"));
                if (lease != null) {
                    System.out.println("Added type for ps");
                    System.out.println("lease for " + (lease.getExpiration() - System.currentTimeMillis()) / 1000L + " seconds");
                    mIMEType = leaseFileClassifier.getMIMEType("file1.ps");
                    System.out.println("Type for now known type file1.ps is " + mIMEType.toString());
                    System.out.println("Sleeping for 1 min");
                    Thread.sleep(60000L);
                    mIMEType = leaseFileClassifier.getMIMEType("file1.ps");
                    System.out.println("Type for still known type file1.ps is " + mIMEType.toString());
                    lease.renew(180000L);
                    System.out.println("renewed lease for " + (lease.getExpiration() - System.currentTimeMillis()) / 1000L + " seconds");
                    System.out.println("Sleeping for 4 min to let lease lapse");
                    Thread.sleep(240000L);
                    mIMEType = leaseFileClassifier.getMIMEType("file1.ps");
                    System.out.println("Type for now unknown type file1.ps is " + mIMEType);
                    continue;
                }
                System.err.println("was null");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }
}

