/*
 * Decompiled with CFR 0.152.
 */
package activation;

import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import net.jini.activation.ActivationExporter;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.LookupUnmarshalException;
import net.jini.discovery.RemoteDiscoveryEvent;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseRenewalSet;
import rmi.RemoteFileClassifier;

public class DiscoveryChange
implements RemoteEventListener,
ProxyAccessor {
    private LeaseRenewalSet leaseRenewalSet;
    private RemoteFileClassifier service;
    private Remote proxy;

    public DiscoveryChange(ActivationID activationID, MarshalledObject marshalledObject) throws RemoteException {
        Object[] objectArray = null;
        try {
            objectArray = (Object[])marshalledObject.get();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.service = (RemoteFileClassifier)objectArray[0];
        this.leaseRenewalSet = (LeaseRenewalSet)objectArray[1];
        ActivationExporter activationExporter = new ActivationExporter(activationID, (Exporter)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory(), false, true));
        this.proxy = activationExporter.export((Remote)((Object)this));
    }

    public void notify(RemoteEvent remoteEvent) {
        System.out.println("lookups changing... " + remoteEvent.toString());
        RemoteDiscoveryEvent remoteDiscoveryEvent = (RemoteDiscoveryEvent)remoteEvent;
        if (!remoteDiscoveryEvent.isDiscarded()) {
            ServiceItem serviceItem = new ServiceItem(null, (Object)this.service, null);
            ServiceRegistrar[] serviceRegistrarArray = null;
            try {
                serviceRegistrarArray = remoteDiscoveryEvent.getRegistrars();
            }
            catch (LookupUnmarshalException lookupUnmarshalException) {
                lookupUnmarshalException.printStackTrace();
                return;
            }
            for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
                ServiceRegistration serviceRegistration = null;
                try {
                    serviceRegistration = serviceRegistrar.register(serviceItem, Long.MAX_VALUE);
                    this.leaseRenewalSet.renewFor(serviceRegistration.getLease(), Long.MAX_VALUE);
                    continue;
                }
                catch (RemoteException remoteException) {
                    System.err.println("Register exception: " + remoteException.toString());
                }
            }
        }
    }

    public Object getProxy() {
        return this.proxy;
    }
}

