/*
 * Decompiled with CFR 0.152.
 */
package audio.pull;

import audio.pull.SinkImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Name;

public class SinkServer {
    protected Remote proxy;
    protected SinkImpl impl;
    private String sinkName = "No name";
    private ServiceID serviceID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Object keepAlive;
        new SinkServer(argv);
        Object object = keepAlive = new Object();
        synchronized (object) {
            try {
                keepAlive.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public SinkServer(String[] argv) {
        File serviceIDFile = null;
        try {
            this.impl = new SinkImpl();
        }
        catch (Exception e) {
            System.err.println("New impl: " + e.toString());
            System.exit(1);
        }
        String[] configArgs = new String[]{argv[0]};
        try {
            Configuration config = ConfigurationProvider.getInstance((String[])configArgs);
            Exporter exporter = (Exporter)config.getEntry("HttpSinkServer", "exporter", Exporter.class);
            this.proxy = exporter.export((Remote)this.impl);
            this.impl.setProxy(this.proxy);
            this.sinkName = (String)config.getEntry("HttpSinkServer", "sinkName", String.class);
            serviceIDFile = (File)config.getEntry("HttpSinkServer", "serviceIdFile", File.class);
            this.getOrMakeServiceID(serviceIDFile);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        System.setSecurityManager(new RMISecurityManager());
        JoinManager joinMgr = null;
        try {
            LookupDiscoveryManager mgr = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            joinMgr = new JoinManager((Object)this.proxy, new Entry[]{new Name(this.sinkName)}, this.serviceID, (DiscoveryManagement)mgr, new LeaseRenewalManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void getOrMakeServiceID(File serviceIDFile) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(serviceIDFile));
            this.serviceID = (ServiceID)ois.readObject();
        }
        catch (Exception e) {
            System.out.println("Couldn't get service IDs - generating new ones");
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serviceIDFile));
                Uuid uuid = UuidFactory.generate();
                this.serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                oos.writeObject(this.serviceID);
            }
            catch (Exception e2) {
                System.out.println("Couldn't save ids");
                e2.printStackTrace();
            }
        }
    }
}

