/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.MIMEType;
import common.PayableFileClassifier;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryManager;

public class TestTxn
implements TransactionParticipant {
    private static final long WAITFOR = 100000L;
    long crashCount = 0L;
    PayableFileClassifier classifier = null;
    TransactionManager mgr = null;
    long myClientID;

    public static void main(String[] stringArray) {
        new TestTxn();
        try {
            Thread.currentThread();
            Thread.sleep(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TestTxn() {
        System.setSecurityManager(new RMISecurityManager());
        this.classifier = this.findClassifier();
        long l = 0L;
        try {
            l = this.classifier.getCost();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (l > 20L) {
            System.out.println("Costs too much: " + l);
            this.classifier = null;
        }
        this.mgr = this.findTxnMgr();
        TransactionManager.Created created = null;
        System.out.println("Creating transaction");
        try {
            created = this.mgr.create(Long.MAX_VALUE);
        }
        catch (RemoteException remoteException) {
            this.mgr = null;
            return;
        }
        catch (LeaseDeniedException leaseDeniedException) {
            this.mgr = null;
            return;
        }
        long l2 = created.id;
        System.out.println("Joining transaction");
        BasicJeriExporter basicJeriExporter = new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory());
        TransactionParticipant transactionParticipant = null;
        try {
            transactionParticipant = (TransactionParticipant)basicJeriExporter.export((Remote)((Object)this));
        }
        catch (ExportException exportException) {
            exportException.printStackTrace();
            System.exit(1);
        }
        try {
            this.mgr.join(l2, transactionParticipant, this.crashCount);
        }
        catch (UnknownTransactionException unknownTransactionException) {
            unknownTransactionException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (CrashCountException crashCountException) {
            crashCountException.printStackTrace();
        }
        catch (CannotJoinException cannotJoinException) {
            cannotJoinException.printStackTrace();
        }
        new LeaseRenewalManager().renewUntil(created.lease, Long.MAX_VALUE, null);
        System.out.println("crediting...");
        try {
            this.classifier.credit(l, this.myClientID, this.mgr, l2);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        System.out.println("classifying...");
        MIMEType mIMEType = null;
        try {
            mIMEType = this.classifier.getMIMEType("file1.txt");
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException.toString());
        }
        if (mIMEType != null) {
            System.out.println("Type is " + mIMEType.toString());
            System.out.println("Calling commit");
            try {
                System.out.println("mgr state " + this.mgr.getState(l2));
                this.mgr.commit(l2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                this.mgr.abort(l2);
            }
            catch (RemoteException remoteException) {
            }
            catch (CannotAbortException cannotAbortException) {
            }
            catch (UnknownTransactionException unknownTransactionException) {
                // empty catch block
            }
        }
    }

    public PayableFileClassifier findClassifier() {
        PayableFileClassifier payableFileClassifier;
        Class[] classArray;
        ServiceDiscoveryManager serviceDiscoveryManager = null;
        try {
            classArray = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)classArray, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        classArray = new Class[]{PayableFileClassifier.class};
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
        ServiceItem serviceItem = null;
        try {
            serviceItem = serviceDiscoveryManager.lookup(serviceTemplate, null, 100000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (serviceItem == null) {
            System.out.println("no service");
            System.exit(1);
        }
        if ((payableFileClassifier = (PayableFileClassifier)serviceItem.service) == null) {
            System.out.println("Classifier null");
            System.exit(1);
        }
        return payableFileClassifier;
    }

    public TransactionManager findTxnMgr() {
        TransactionManager transactionManager;
        Class[] classArray;
        ServiceDiscoveryManager serviceDiscoveryManager = null;
        try {
            classArray = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)classArray, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        classArray = new Class[]{TransactionManager.class};
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
        ServiceItem serviceItem = null;
        try {
            serviceItem = serviceDiscoveryManager.lookup(serviceTemplate, null, 100000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (serviceItem == null) {
            System.out.println("no service");
            System.exit(1);
        }
        if ((transactionManager = (TransactionManager)serviceItem.service) == null) {
            System.out.println("Mgr null");
            System.exit(1);
        }
        return transactionManager;
    }

    public int prepare(TransactionManager transactionManager, long l) {
        System.out.println("Preparing...");
        return 3;
    }

    public void commit(TransactionManager transactionManager, long l) {
        System.out.println("committing");
    }

    public void abort(TransactionManager transactionManager, long l) {
        System.out.println("aborting");
    }

    public int prepareAndCommit(TransactionManager transactionManager, long l) {
        int n = this.prepare(transactionManager, l);
        if (n == 3) {
            this.commit(transactionManager, l);
            n = 5;
        }
        return n;
    }
}

