/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.io.File;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import rmi.RemoteFileClassifier;

public class FileClassifierServer
implements LeaseListener {
    private LeaseRenewalManager leaseManager = new LeaseRenewalManager();
    private ServiceID serviceID = null;
    private RemoteFileClassifier impl;
    private File serviceIdFile;
    private Configuration config;
    static final String DISCOVERY_LOG = "net.jini.security.trust";
    static final Logger logger = Logger.getLogger("net.jini.security.trust");
    private static FileHandler fh;
    static final String TRUST_LOG = "net.jini.security.trust";
    static final String INTEGRITY_LOG = "net.jini.security.integrity";
    static final String POLICY_LOG = "net.jini.security.policy";
    static final Logger trustLogger;
    static final Logger integrityLogger;
    static final Logger policyLogger;
    private static FileHandler trustFh;
    private static FileHandler integrityFh;
    private static FileHandler policyFh;

    private static void installLoggers() {
        try {
            trustFh = new FileHandler("log.srv.trust.txt");
            integrityFh = new FileHandler("log.srv.integrity.txt");
            policyFh = new FileHandler("log.srv.policy.txt");
            trustFh.setFormatter(new SimpleFormatter());
            integrityFh.setFormatter(new SimpleFormatter());
            policyFh.setFormatter(new SimpleFormatter());
            trustLogger.addHandler(trustFh);
            integrityLogger.addHandler(integrityFh);
            policyLogger.addHandler(policyFh);
            trustLogger.setLevel(Level.ALL);
            integrityLogger.setLevel(Level.ALL);
            policyLogger.setLevel(Level.ALL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        try {
            fh = new FileHandler("mylog.svr.txt");
            fh.setFormatter(new SimpleFormatter());
            logger.addHandler(fh);
            logger.setLevel(Level.ALL);
            FileClassifierServer.installLoggers();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        FileClassifierServer fileClassifierServer = new FileClassifierServer(stringArray);
        Object object2 = object = new Object();
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public FileClassifierServer(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        Exporter exporter = null;
        String string = null;
        try {
            this.config = ConfigurationProvider.getInstance((String[])stringArray);
            exporter = (Exporter)this.config.getEntry("security.FileClassifierServer", "exporter", Exporter.class);
            string = (String)this.config.getEntry("security.FileClassifierServer", "serviceName", String.class);
        }
        catch (ConfigurationException configurationException) {
            System.err.println("Configuration error: " + configurationException.toString());
            System.exit(1);
        }
        try {
            this.impl = (RemoteFileClassifier)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        Remote remote = null;
        try {
            remote = exporter.export((Remote)this.impl);
            System.out.println("Proxy is " + remote.toString());
        }
        catch (ExportException exportException) {
            exportException.printStackTrace();
            System.exit(1);
        }
        JoinManager joinManager = null;
        try {
            LookupDiscoveryManager lookupDiscoveryManager = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            joinManager = new JoinManager((Object)remote, null, this.serviceID, (DiscoveryManagement)lookupDiscoveryManager, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    void getServiceID() {
        Uuid uuid = UuidFactory.generate();
        this.serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public void serviceIDNotify(ServiceID serviceID) {
        System.out.println("got service ID " + serviceID.toString());
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }

    public void notify(LeaseRenewalEvent leaseRenewalEvent) {
        System.out.println("Lease expired " + leaseRenewalEvent.toString());
    }

    static {
        trustLogger = Logger.getLogger("net.jini.security.trust");
        integrityLogger = Logger.getLogger(INTEGRITY_LOG);
        policyLogger = Logger.getLogger(POLICY_LOG);
    }
}

