/*
 * Decompiled with CFR 0.152.
 */
package zeroconf;

import com.sun.jini.logging.Levels;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public class HttpServer
extends Thread {
    private static Logger logger = Logger.getLogger("zeroconf.HttpServer");
    private ServerSocket server;
    private String hostAddr;
    private String dir;
    private int port = 0;
    private HashMap map;
    private boolean verbose;
    private FilePermission perm;

    public HttpServer(String string, int n, String string2) throws IOException {
        this.init(string, n, string2, null);
    }

    public HttpServer(Configuration configuration) throws IOException {
        this.init(null, 0, null, configuration);
    }

    private void init(String string, int n, String string2, Configuration configuration) throws IOException {
        this.hostAddr = string;
        this.port = n;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separatorChar;
        }
        this.dir = string2;
        this.getConfig(configuration);
        this.server = new ServerSocket(n);
        n = this.server.getLocalPort();
        System.setProperty("java.rmi.server.codebase", "http://" + string + ":" + n + "/" + string2);
        this.perm = new FilePermission(string2 + '-', "read");
        this.map = new HashMap();
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        URL uRL = file.toURL();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.endsWith(".jar") && !string3.endsWith(".zip")) continue;
            ArrayList arrayList = new ArrayList(1);
            this.addJar(string3, arrayList, uRL);
            this.map.put(string3.substring(0, string3.length() - 4), arrayList.toArray(new JarFile[arrayList.size()]));
        }
    }

    private void getConfig(Configuration configuration) {
        String string = null;
        if (configuration != null) {
            try {
                Integer n = (Integer)configuration.getEntry("zeroconf.http", "port", Integer.class, (Object)new Integer(this.port));
                this.port = n;
                this.dir = (String)configuration.getEntry("zeroconf.http", "basedir", String.class, (Object)this.dir);
                string = (String)configuration.getEntry("zeroconf.http", "address", String.class, null);
            }
            catch (ConfigurationException configurationException) {
                logger.log(Level.SEVERE, configurationException.toString());
            }
        }
        if (string == null) {
            string = this.getLocalAddress();
        }
    }

    private String getLocalAddress() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            logger.log(Level.SEVERE, unknownHostException.toString());
        }
        return string;
    }

    private void addJar(String string, ArrayList arrayList, URL uRL) throws IOException {
        uRL = new URL(uRL, string);
        string = uRL.getFile().replace('/', File.separatorChar);
        int n = arrayList.size();
        while (--n >= 0) {
            if (!string.equals(((JarFile)arrayList.get(n)).getName())) continue;
            return;
        }
        logger.config(string);
        JarFile jarFile = new JarFile(string);
        arrayList.add(jarFile);
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return;
        }
        String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            this.addJar(stringTokenizer.nextToken(), arrayList, uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.log(Level.INFO, "HTTP Server started [{0}, port {1}]", new Object[]{this.dir, Integer.toString(this.getPort())});
        try {
            while (true) {
                new Task(this.server.accept()).start();
            }
        }
        catch (IOException iOException) {
            HttpServer httpServer = this;
            synchronized (httpServer) {
                if (!this.server.isClosed()) {
                    logger.log(Level.SEVERE, "accepting connection", iOException);
                }
                this.terminate();
            }
            return;
        }
    }

    public synchronized void terminate() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.log(Level.INFO, "HTTPServer terminated [port {0}]", Integer.toString(this.getPort()));
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    private class Task
    extends Thread {
        private Socket sock;

        public Task(Socket socket) {
            this.sock = socket;
            this.setDaemon(true);
        }

        private String getRequest() throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            String string = bufferedReader.readLine();
            System.out.println(string);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getBytes(InputStream inputStream, long l) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[(int)l];
            try {
                dataInputStream.readFully(byArray);
            }
            finally {
                dataInputStream.close();
            }
            return byArray;
        }

        private byte[] getBytes(String string) throws IOException {
            JarFile[] jarFileArray;
            int n;
            if (HttpServer.this.map != null && (n = string.indexOf(47)) > 0 && (jarFileArray = (JarFile[])HttpServer.this.map.get(string.substring(0, n))) != null) {
                String string2 = string.substring(n + 1);
                for (n = 0; n < jarFileArray.length; ++n) {
                    JarEntry jarEntry = jarFileArray[n].getJarEntry(string2);
                    if (jarEntry == null) continue;
                    return this.getBytes(jarFileArray[n].getInputStream(jarEntry), jarEntry.getSize());
                }
            }
            File file = new File(HttpServer.this.dir + string.replace('/', File.separatorChar));
            if (HttpServer.this.perm.implies(new FilePermission(file.getPath(), "read"))) {
                try {
                    return this.getBytes(new FileInputStream(file), file.length());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                byte[] byArray;
                boolean bl;
                String string;
                DataOutputStream dataOutputStream = new DataOutputStream(this.sock.getOutputStream());
                try {
                    string = this.getRequest();
                }
                catch (Exception exception) {
                    logger.log(Levels.HANDLED, "reading request", exception);
                    try {
                        this.sock.close();
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                if (string == null) {
                    return;
                }
                if (string.startsWith("SHUTDOWN *")) {
                    try {
                        new ServerSocket(0, 1, this.sock.getInetAddress());
                    }
                    catch (IOException iOException) {
                        dataOutputStream.writeBytes("HTTP/1.0 403 Forbidden\r\n\r\n");
                        dataOutputStream.flush();
                        try {
                            this.sock.close();
                            return;
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        return;
                    }
                    HttpServer.this.terminate();
                    return;
                }
                Object[] objectArray = null;
                if (logger.isLoggable(Level.FINE)) {
                    objectArray = new String[]{string, this.sock.getInetAddress().getHostName(), Integer.toString(this.sock.getPort())};
                }
                if (!(bl = string.startsWith("GET ")) && !string.startsWith("HEAD ")) {
                    logger.log(Level.FINE, "bad request \"{0}\" from {1}:{2}", objectArray);
                    dataOutputStream.writeBytes("HTTP/1.0 400 Bad Request\r\n\r\n");
                    dataOutputStream.flush();
                    return;
                }
                String string2 = string.substring(bl ? 5 : 6);
                int n = string2.indexOf(32);
                if (n > 0) {
                    string2 = string2.substring(0, n);
                }
                if (string2 == null) {
                    logger.log(Level.FINE, "bad request \"{0}\" from {1}:{2}", objectArray);
                    dataOutputStream.writeBytes("HTTP/1.0 400 Bad Request\r\n\r\n");
                    dataOutputStream.flush();
                    return;
                }
                if (objectArray != null) {
                    objectArray[0] = string2;
                }
                logger.log(Level.FINER, bl ? "{0} requested from {1}:{2}" : "{0} probed from {1}:{2}", objectArray);
                try {
                    byArray = this.getBytes(string2);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "getting bytes", exception);
                    dataOutputStream.writeBytes("HTTP/1.0 500 Internal Error\r\n\r\n");
                    dataOutputStream.flush();
                    try {
                        this.sock.close();
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                if (byArray == null) {
                    logger.log(Level.FINE, "{0} not found", string2);
                    dataOutputStream.writeBytes("HTTP/1.0 404 Not Found\r\n\r\n");
                    dataOutputStream.flush();
                    return;
                }
                dataOutputStream.writeBytes("HTTP/1.0 200 OK\r\n");
                dataOutputStream.writeBytes("Content-Length: " + byArray.length + "\r\n");
                dataOutputStream.writeBytes("Content-Type: application/java\r\n\r\n");
                if (bl) {
                    dataOutputStream.write(byArray);
                }
                dataOutputStream.flush();
                return;
            }
            catch (Exception exception) {
                logger.log(Levels.HANDLED, "writing response", exception);
                return;
            }
            finally {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

