/*
 * Decompiled with CFR 0.152.
 */
package mutable;

import common.MIMEType;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import mutable.RemoteFileClassifier;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;

public class FileClassifierImpl
implements RemoteFileClassifier,
ProxyAccessor {
    protected Map map = new HashMap();
    protected EventListenerList listenerList = new EventListenerList();
    protected long seqNum = 0L;
    protected Remote proxy;

    public MIMEType getMIMEType(String string) throws RemoteException {
        System.out.println("Called with " + string);
        int n = string.lastIndexOf(46);
        if (n == -1 || n + 1 == string.length()) {
            return null;
        }
        String string2 = string.substring(n + 1);
        MIMEType mIMEType = (MIMEType)this.map.get(string2);
        return mIMEType;
    }

    public void addType(String string, MIMEType mIMEType) throws RemoteException {
        System.out.println("type added");
        this.map.put(string, mIMEType);
        this.fireNotify(1L);
    }

    public void removeType(String string) throws RemoteException {
        System.out.println("Type removed");
        if (this.map.remove(string) != null) {
            this.fireNotify(2L);
        }
    }

    public EventRegistration addRemoteListener(RemoteEventListener remoteEventListener) throws RemoteException {
        this.listenerList.add(RemoteEventListener.class, remoteEventListener);
        return new EventRegistration(0L, (Object)this.proxy, null, 0L);
    }

    protected void fireNotify(long l) {
        RemoteEvent remoteEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RemoteEventListener.class) continue;
            RemoteEventListener remoteEventListener = (RemoteEventListener)objectArray[i + 1];
            if (remoteEvent == null) {
                remoteEvent = new RemoteEvent((Object)this.proxy, l, this.seqNum++, null);
            }
            try {
                remoteEventListener.notify(remoteEvent);
                continue;
            }
            catch (UnknownEventException unknownEventException) {
                unknownEventException.printStackTrace();
                continue;
            }
            catch (RemoteException remoteException) {
                this.listenerList.remove(RemoteEventListener.class, remoteEventListener);
                System.out.println("notification failed, listener removed");
            }
        }
    }

    public Object getProxy() {
        return this.proxy;
    }

    public FileClassifierImpl() throws RemoteException {
    }

    public FileClassifierImpl(String[] stringArray) throws RemoteException {
        this.map.put("gif", new MIMEType("image", "gif"));
        this.map.put("jpeg", new MIMEType("image", "jpeg"));
        this.map.put("mpg", new MIMEType("video", "mpeg"));
        this.map.put("txt", new MIMEType("text", "plain"));
        this.map.put("html", new MIMEType("text", "html"));
        try {
            Configuration configuration = ConfigurationProvider.getInstance((String[])stringArray);
            Exporter exporter = (Exporter)configuration.getEntry("FileClassifierServer", "exporter", Exporter.class);
            this.proxy = exporter.export((Remote)this);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

