/*
 * Decompiled with CFR 0.152.
 */
package clock.clock;

import clock.device.ClockDevice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ClockPane
extends JPanel {
    private ClockDevice clockDev;
    private Color lastBlink = Color.BLACK;
    private DateFormat dateFormat = new SimpleDateFormat("kk:mm:ss");
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 60;
    private static final String CLOCK_PANEL_IMAGE = "images/clock.jpg";
    private static final String CLOCK_PANEL_IMAGE_FILE = "resources/images/clock.jpg";
    private Image panelmage;
    private int imageWidth = 200;
    private int imageHeight = 60;
    private static final String DEFAULT_FONT_NAME = "Lucida Console";
    private static final int DEFAULT_TIME_FONT_SIZE = 48;
    private static final int DEFAULT_DATE_FONT_SIZE = 18;
    private static final int DEFAULT_SECOND_BLOCK_HEIGHT = 8;
    private static final int DEFAULT_SECOND_BLOCK_FONT_SIZE = 10;
    private Font timeFont = null;
    private Font dateFont = null;
    private Font secondFont = null;

    public ClockPane(ClockDevice clockDevice) {
        this.clockDev = clockDevice;
        this.loadImage();
        this.initPanel();
    }

    private void loadImage() {
        File file = new File(CLOCK_PANEL_IMAGE_FILE);
        try {
            this.panelmage = ImageIO.read(file);
            this.imageWidth = ((BufferedImage)this.panelmage).getWidth();
            this.imageHeight = ((BufferedImage)this.panelmage).getHeight();
            return;
        }
        catch (Exception exception) {
            URL uRL = this.getClass().getClassLoader().getResource(CLOCK_PANEL_IMAGE);
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.panelmage = imageIcon.getImage();
                this.imageWidth = imageIcon.getIconWidth();
                this.imageHeight = imageIcon.getIconHeight();
                return;
            }
            return;
        }
    }

    private Image getPaneImage() {
        return this.panelmage;
    }

    private void initPanel() {
        Image image = this.getPaneImage();
        this.setPreferredSize(new Dimension(this.imageWidth, this.imageHeight));
    }

    private Font getFont(Graphics graphics, int n) {
        Font font = new Font(DEFAULT_FONT_NAME, 0, n);
        if (font != null) {
            return font;
        }
        return graphics.getFont();
    }

    private Font getTimeFont(Graphics graphics) {
        if (this.timeFont == null) {
            this.timeFont = this.getFont(graphics, 48);
        }
        return this.timeFont;
    }

    private Font getDateFont(Graphics graphics) {
        if (this.dateFont == null) {
            this.dateFont = this.getFont(graphics, 18);
        }
        return this.dateFont;
    }

    private Font getSecondFont(Graphics graphics) {
        if (this.secondFont == null) {
            this.secondFont = this.getFont(graphics, 10);
        }
        return this.secondFont;
    }

    private void drawClockInfo(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = false;
        try {
            bl = this.clockDev.isValidTime();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (bl) {
            graphics.setColor(Color.BLACK);
        } else if (this.lastBlink == Color.WHITE) {
            graphics.setColor(Color.BLACK);
            this.lastBlink = Color.BLACK;
        } else {
            graphics.setColor(Color.WHITE);
            this.lastBlink = Color.WHITE;
        }
        Date date = null;
        try {
            date = this.clockDev.getTime();
        }
        catch (RemoteException remoteException) {
            date = new Date(0L);
        }
        String string = this.dateFormat.format(date);
        Font font = this.getTimeFont(graphics);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        int n5 = (n - n3) / 2;
        int n6 = (n2 + n4) / 2;
        int n7 = n4 / 8 / 2;
        graphics.drawString(string, n5, n6);
        String string2 = "Time";
        Font font2 = this.getDateFont(graphics);
        graphics.setFont(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics();
        Rectangle2D rectangle2D2 = fontMetrics2.getStringBounds(string2, graphics);
        graphics.drawString(string2, (n - (int)rectangle2D2.getWidth()) / 2, n6 - n4 - n7);
    }

    private void clear(Graphics graphics) {
        graphics.setColor(Color.GRAY);
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void drawPanelImage(Graphics graphics) {
        if (this.getPaneImage() == null) {
            return;
        }
        graphics.drawImage(this.getPaneImage(), 0, 0, null);
    }

    public void paint(Graphics graphics) {
        this.clear(graphics);
        this.drawPanelImage(graphics);
        this.drawClockInfo(graphics);
    }
}

