/*
 * Decompiled with CFR 0.152.
 */
package audio.client;

import audio.client.GUIClient;
import audio.client.LabelCellRenderer;
import audio.client.PlayFrame;
import audio.common.AlreadyPlayingException;
import audio.common.AlreadyRecordingException;
import audio.common.NotRecordingException;
import audio.common.Sink;
import audio.common.Source;
import audio.common.VolumeControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jini.core.entry.Entry;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.UIDescriptor;
import net.jini.lookup.ui.attribute.UIFactoryTypes;
import net.jini.lookup.ui.factory.JDialogFactory;

public class PlayFrame
extends JFrame
implements ActionListener,
ChangeListener,
RemoteEventListener {
    private ServiceItem[] sources;
    private ServiceItem sinkItem;
    private Sink sink;
    private Source source;
    private boolean firstTime = true;
    private JList sourceList = new JList();
    private JButton stopBtn = new JButton("Stop");
    private JButton stopAllBtn = new JButton("Stop all");
    private JLabel sinkLabel = new JLabel();
    private JSlider sourceVolumeCtl = new JSlider();
    private JSlider sinkVolumeCtl = new JSlider();
    private DefaultListModel model;
    private Remote proxy;
    private GUIClient client;

    public PlayFrame(GUIClient client) {
        this.setTitle("Player");
        this.client = client;
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.sinkLabel, "North");
        contentPane.add((Component)this.sourceList, "Center");
        contentPane.add((Component)bottomPanel, "South");
        JPanel volumeControls = new JPanel();
        volumeControls.setLayout(new GridLayout(1, 2));
        volumeControls.add(this.sourceVolumeCtl);
        volumeControls.add(this.sinkVolumeCtl);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 3));
        buttons.add(this.stopBtn);
        buttons.add(this.stopAllBtn);
        bottomPanel.add((Component)volumeControls, "North");
        bottomPanel.add((Component)buttons, "South");
        this.stopBtn.addActionListener(this);
        this.stopAllBtn.addActionListener(this);
        LabelCellRenderer labelRend = new LabelCellRenderer();
        this.sourceList.setCellRenderer(labelRend);
        this.model = new DefaultListModel();
        this.sourceList.setModel(this.model);
        this.sourceVolumeCtl.setEnabled(false);
        this.sinkVolumeCtl.setEnabled(false);
        this.sourceVolumeCtl.addChangeListener(this);
        this.sinkVolumeCtl.addChangeListener(this);
        this.sourceVolumeCtl.setToolTipText("Set volume on the source");
        this.sinkVolumeCtl.setToolTipText("Set volume on the sink");
        this.setSize(400, 300);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.stopBtn) {
            try {
                this.sink.stop();
                this.sinkVolumeCtl.setEnabled(false);
                this.sourceVolumeCtl.setEnabled(false);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (NotRecordingException e) {
                e.printStackTrace();
            }
        } else if (evt.getSource() == this.stopAllBtn) {
            this.sources = null;
            try {
                this.sink.stop();
                this.sinkVolumeCtl.setEnabled(false);
                this.sourceVolumeCtl.setEnabled(false);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (NotRecordingException e) {
                e.printStackTrace();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        JSlider slider = (JSlider)e.getSource();
        int vol = slider.getValue();
        VolumeControl volCtl = null;
        if (slider == this.sinkVolumeCtl) {
            volCtl = (VolumeControl)((Object)this.sink);
        } else if (slider == this.sourceVolumeCtl) {
            volCtl = (VolumeControl)((Object)this.source);
        }
        try {
            volCtl.setVolume(vol);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void play(ServiceItem[] sources, ServiceItem sinkItem) {
        if (sources == null || sources.length == 0) {
            System.out.println("Play: null sources");
            1 doDispose = new /* Unavailable Anonymous Inner Class!! */;
            SwingUtilities.invokeLater((Runnable)doDispose);
            return;
        }
        this.sources = sources;
        this.sinkItem = sinkItem;
        this.sink = (Sink)sinkItem.service;
        this.source = (Source)sources[0].service;
        this.sinkLabel.setText("Playing to " + sinkItem.toString());
        this.model.clear();
        for (int n = 0; n < sources.length; ++n) {
            this.model.addElement(sources[n]);
        }
        MarshalledObject<Object> handback = null;
        try {
            handback = new MarshalledObject<Object>(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            if (this.firstTime) {
                if (this.proxy == null) {
                    this.proxy = this.client.export(this);
                }
                System.out.println("Added source " + this.source + " proxy " + this.proxy);
                this.sink.addSinkListener((RemoteEventListener)this.proxy, handback);
                System.out.println("Added sink " + this.sink + " proxy " + this.proxy + " handback " + "null");
                this.firstTime = false;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Setting sink to: " + this.sink);
            this.source.addSink(this.sink);
            System.out.println("Setting source to: " + this.source);
            this.sink.addSource(this.source);
            System.out.println("Playing" + sources[0].attributeSets[0]);
            this.checkUI(sinkItem);
            this.source.play();
            this.sink.record();
        }
        catch (AlreadyPlayingException e) {
            JOptionPane.showMessageDialog(null, "Source already playing", "Play error", 0);
            return;
        }
        catch (AlreadyRecordingException e) {
            JOptionPane.showMessageDialog(null, "Sink already recording", "Record error", 0);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Checking VC " + this.sink);
        if (this.source instanceof VolumeControl) {
            System.out.println("Source is VC");
            this.enableVolumeControl((VolumeControl)((Object)this.source), this.sourceVolumeCtl);
        }
        if (this.sink instanceof VolumeControl) {
            System.out.println("Sink is VC");
            this.enableVolumeControl((VolumeControl)((Object)this.sink), this.sinkVolumeCtl);
        }
    }

    public void notify(RemoteEvent evt) {
        Object src = evt.getSource();
        System.out.println("Event notified " + src);
        System.out.println("Event seq id " + evt.getSequenceNumber());
        if (src instanceof Sink && evt.getID() == 1L) {
            System.out.println("Sink stopped event");
            ServiceItem[] rest = null;
            if (this.sources != null) {
                rest = new ServiceItem[this.sources.length - 1];
                for (int n = 0; n < rest.length; ++n) {
                    rest[n] = this.sources[n + 1];
                }
            }
            this.play(rest, this.sinkItem);
        } else if (src instanceof Source && evt.getID() == 1L) {
            System.out.println("Source stopped event");
        }
    }

    private void enableVolumeControl(VolumeControl vol, JSlider slider) {
        int maxVol = 0;
        int currVol = 0;
        try {
            maxVol = vol.getMaxVolume();
            if (maxVol <= 0) {
                return;
            }
            currVol = vol.getVolume();
            System.out.println("Current vol: " + currVol);
            if (currVol < 0 || currVol > maxVol) {
                return;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return;
        }
        slider.setMinimum(0);
        slider.setMaximum(maxVol);
        slider.setValue(currVol);
        slider.setEnabled(true);
    }

    private void checkUI(ServiceItem item) {
        Entry[] attributes = item.attributeSets;
        System.out.println("Entries: " + attributes.length);
        for (int m = 0; m < attributes.length; ++m) {
            Entry attr = attributes[m];
            System.out.println("Checking Entry " + attr);
            if (!(attr instanceof UIDescriptor)) continue;
            System.out.println("Found a UI");
            this.checkForSwingDialog(item, (UIDescriptor)attr);
        }
    }

    private void checkForSwingDialog(ServiceItem item, UIDescriptor desc) {
        Set attributes = desc.attributes;
        for (Object obj : attributes) {
            UIFactoryTypes types;
            if (!(obj instanceof UIFactoryTypes) || !(types = (UIFactoryTypes)obj).isAssignableTo(JDialogFactory.class)) continue;
            JDialogFactory factory = null;
            try {
                factory = (JDialogFactory)desc.getUIFactory(this.getClass().getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            System.out.println("calling dialog with " + item);
            JDialog dialog = factory.getJDialog((Object)item, (Frame)this, true);
            dialog.setVisible(true);
        }
    }
}

