/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import org.netbeans.microedition.lcdui.laf.ColorSchema;
import org.netbeans.microedition.lcdui.laf.DefaultColorSchema;

public class LoginScreen
extends Canvas
implements CommandListener {
    public static Command LOGIN_COMMAND = new Command("Login", 4, 1);
    private static final int ACTIVE_USERNAME = 1;
    private static final int ACTIVE_PASSWORD = 2;
    private static final int ACTIVE_LOGIN_BUTTON = 3;
    private int activeField = 1;
    private String loginButtonText;
    private boolean useLoginButton = true;
    private int backgroundImageAnchorPoint;
    private InputTextBox inputTextBox;
    private boolean useTextBoxForInput = true;
    private boolean inputTextIsActive = false;
    private int borderStyle;
    private int hiBorderStyle;
    private Font titleFont;
    private Font inputFont;
    private Font loginButtonFont;
    private int visibleInputFieldLength = 12;
    private int maximumInputSize;
    private static final int borderPadding = 2;
    private static final int labelPadding = 4;
    private int loginTitleY;
    private int usernameY;
    private int passwordY;
    private int usernameX;
    private int passwordX;
    private int inputFieldsWidth;
    private int inputFieldsHeight;
    private int loginButtonWidth;
    private int loginButtonHeight;
    private int loginButtonY;
    private int loginButtonX;
    private int usernameLabelWidth;
    private int passwordLabelWidth;
    private String usernameLabel;
    private String passwordLabel;
    private String username = "";
    private String password = "";
    private String shownPassword = "";
    private static final char PASSWORD_CHAR = '*';
    private String loginScreenTitle;
    private Display display;
    private CommandListener l;
    private ColorSchema colorSchema;

    public LoginScreen(Display display) {
        this.display = display;
        this.colorSchema = new DefaultColorSchema();
        this.setDefaulBorderStyles();
        this.setDefaultFonts();
        this.titleFont = Font.getFont((int)64, (int)3, (int)0);
        this.loginButtonFont = Font.getFont((int)64, (int)1, (int)8);
        this.usernameLabel = "Username:";
        this.passwordLabel = "Password:";
        this.loginButtonText = "Login";
        this.maximumInputSize = 20;
        this.setUseLoginButton(this.useLoginButton);
        super.setCommandListener((CommandListener)this);
    }

    public void setUsername(String username) {
        if (username == null) {
            username = "";
        }
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = "";
        }
        this.password = password;
        char[] shownPwd = new char[password.length()];
        for (int i = 0; i < shownPwd.length; ++i) {
            shownPwd[i] = 42;
        }
        this.shownPassword = new String(shownPwd, 0, shownPwd.length);
    }

    public String getPassword() {
        return this.password;
    }

    public void setLoginTitle(String loginTitleText) {
        this.loginScreenTitle = loginTitleText;
    }

    public void setUseLoginButton(boolean useLoginButton) {
        this.useLoginButton = useLoginButton;
        if (!useLoginButton) {
            this.addCommand(LOGIN_COMMAND);
        } else {
            this.removeCommand(LOGIN_COMMAND);
        }
    }

    public void setLabelTexts(String usernameLabel, String passwordLabel) {
        this.usernameLabel = usernameLabel;
        this.passwordLabel = passwordLabel;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDefaulBorderStyles() {
        this.borderStyle = this.getDisplay().getBorderStyle(false);
        this.hiBorderStyle = this.getDisplay().getBorderStyle(true);
    }

    public void setDefaultFonts() {
        this.titleFont = Font.getFont((int)0);
        this.inputFont = Font.getFont((int)1);
        this.loginButtonFont = this.titleFont;
    }

    public void setFonts(Font titleFont, Font inputFont, Font loginButtonFont) {
        this.titleFont = titleFont;
        this.inputFont = inputFont;
        this.loginButtonFont = loginButtonFont;
    }

    public void setBackgroundImageAnchorPoint(int anchorPoint) {
        this.backgroundImageAnchorPoint = anchorPoint;
    }

    protected void showNotify() {
        this.computeMetrics();
    }

    protected void sizeChanged(int w, int h) {
        this.computeMetrics();
    }

    private int computeYMetrics(int baseY) {
        this.loginTitleY = baseY + 8;
        this.usernameY = this.loginTitleY + this.titleFont.getHeight() + 8;
        this.passwordY = this.usernameY + this.inputFieldsHeight + 4;
        this.loginButtonY = this.passwordY + this.inputFieldsHeight + 8;
        return this.loginButtonY + this.loginButtonHeight;
    }

    private void computeMetrics() {
        int labelWidth;
        int width = this.getWidth();
        int height = this.getHeight();
        int centerY = height / 2;
        int centerX = width / 2;
        this.inputFieldsWidth = this.inputFont.charWidth('X') * this.visibleInputFieldLength + 4;
        if (this.inputFieldsWidth > width) {
            this.inputFieldsWidth = width - 2;
        }
        this.inputFieldsHeight = this.inputFont.getHeight() + 4;
        int componentsHeight = this.computeYMetrics(0);
        int newbaseY = (height - componentsHeight) / 4;
        if (newbaseY > 0) {
            this.computeYMetrics(newbaseY);
        }
        this.usernameLabelWidth = this.inputFont.stringWidth(this.usernameLabel);
        this.passwordLabelWidth = this.inputFont.stringWidth(this.passwordLabel);
        this.usernameLabelWidth = labelWidth = Math.max(this.usernameLabelWidth, this.passwordLabelWidth);
        this.passwordLabelWidth = labelWidth;
        this.usernameX = centerX - (this.usernameLabelWidth + 4 + this.inputFieldsWidth) / 2;
        if (this.usernameX < 0) {
            this.usernameX = 0;
            this.inputFieldsWidth = width - labelWidth - 4 - 1;
        }
        this.passwordX = centerX - (this.passwordLabelWidth + 4 + this.inputFieldsWidth) / 2;
        if (this.passwordX < 0) {
            this.passwordY = 0;
            this.inputFieldsWidth = width - labelWidth - 4 - 1;
        }
        this.loginButtonHeight = this.loginButtonFont.getHeight() + 4;
        this.loginButtonWidth = this.loginButtonFont.stringWidth("X" + this.loginButtonText + "X") + 4;
        this.loginButtonX = centerX - this.loginButtonWidth / 2;
    }

    private static void setColorByState(Graphics g, int baseColor, int hiColor, boolean active) {
        if (active) {
            g.setColor(hiColor);
        } else {
            g.setColor(baseColor);
        }
    }

    private static void setStyleByState(Graphics g, int baseStyle, int hiStyle, boolean active) {
        if (active) {
            g.setStrokeStyle(baseStyle);
        } else {
            g.setStrokeStyle(hiStyle);
        }
    }

    public ColorSchema getColorSchema() {
        return this.colorSchema;
    }

    protected void paint(Graphics graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        int centerX = width / 2;
        this.getColorSchema().paintBackground(graphics, false);
        if (this.loginScreenTitle != null) {
            graphics.setColor(this.getColorSchema().getColor(1));
            graphics.setFont(this.titleFont);
            graphics.drawString(this.loginScreenTitle, centerX, this.loginTitleY, 17);
        }
        graphics.setFont(this.inputFont);
        int x = this.usernameX + this.usernameLabelWidth + 4;
        int y = this.usernameY;
        int w = this.inputFieldsWidth;
        int h = this.inputFieldsHeight;
        graphics.setColor(0xFFFFFF);
        graphics.fillRoundRect(x, y, w, h, 6, 6);
        boolean usernameActive = this.activeField == 1;
        LoginScreen.setColorByState(graphics, this.getColorSchema().getColor(4), this.getColorSchema().getColor(5), usernameActive);
        LoginScreen.setStyleByState(graphics, this.borderStyle, this.hiBorderStyle, usernameActive);
        graphics.drawRoundRect(x, y, w, h, 6, 6);
        LoginScreen.setColorByState(graphics, this.getColorSchema().getColor(1), this.getColorSchema().getColor(3), usernameActive);
        graphics.setClip(x + 2, y + 2, w - 4, h - 4);
        graphics.drawString(this.username, x + 2, this.usernameY + 2, 20);
        graphics.setClip(0, 0, width, height);
        graphics.setColor(this.getColorSchema().getColor(1));
        graphics.drawString(this.usernameLabel, this.usernameX, this.usernameY + 2, 20);
        boolean passwordActive = this.activeField == 2;
        LoginScreen.setColorByState(graphics, this.getColorSchema().getColor(0), this.getColorSchema().getColor(2), passwordActive);
        x = this.passwordX + this.passwordLabelWidth + 4;
        y = this.passwordY;
        w = this.inputFieldsWidth;
        h = this.inputFieldsHeight;
        graphics.setColor(0xFFFFFF);
        graphics.fillRoundRect(x, y, w, h, 6, 6);
        LoginScreen.setColorByState(graphics, this.getColorSchema().getColor(4), this.getColorSchema().getColor(5), passwordActive);
        LoginScreen.setStyleByState(graphics, this.borderStyle, this.hiBorderStyle, passwordActive);
        graphics.drawRoundRect(x, y, w, h, 6, 6);
        LoginScreen.setColorByState(graphics, this.getColorSchema().getColor(1), this.getColorSchema().getColor(3), passwordActive);
        graphics.setClip(x + 2, y + 2, w - 4, h - 4);
        graphics.drawString(this.shownPassword, x + 2, y + 2, 20);
        graphics.setClip(0, 0, width, height);
        graphics.setColor(this.getColorSchema().getColor(1));
        graphics.drawString(this.passwordLabel, this.passwordX, this.passwordY + 2, 20);
        if (this.useLoginButton) {
            boolean loginButtonActive = this.activeField == 3;
            LoginScreen.setColorByState(graphics, this.getColorSchema().getColor(0), this.getColorSchema().getColor(2), loginButtonActive);
            x = this.loginButtonX;
            y = this.loginButtonY;
            w = this.loginButtonWidth;
            h = this.loginButtonHeight;
            graphics.fillRoundRect(x, y, w, h, 6, 6);
            LoginScreen.setColorByState(graphics, this.getColorSchema().getColor(4), this.getColorSchema().getColor(5), loginButtonActive);
            LoginScreen.setStyleByState(graphics, this.borderStyle, this.hiBorderStyle, loginButtonActive);
            graphics.drawRoundRect(x, y, w, h, 6, 6);
            LoginScreen.setColorByState(graphics, this.getColorSchema().getColor(1), this.getColorSchema().getColor(3), loginButtonActive);
            graphics.setFont(this.loginButtonFont);
            graphics.drawString(this.loginButtonText, centerX, y + 2, 17);
            graphics.setClip(0, 0, width, height);
        }
    }

    private int getLastActiveItem() {
        return this.useLoginButton ? 3 : 2;
    }

    private void moveActiveField(boolean down) {
        int add = down ? 1 : -1;
        this.activeField += add;
        if (this.activeField > this.getLastActiveItem()) {
            this.activeField = 1;
        } else if (this.activeField < 1) {
            this.activeField = this.getLastActiveItem();
        }
        this.repaint();
    }

    private void fireLoginEvent() {
        CommandListener l = this.getCommandListener();
        if (l != null) {
            l.commandAction(LOGIN_COMMAND, (Displayable)this);
        }
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (!this.inputTextIsActive) {
            switch (gameAction) {
                case 8: {
                    if (this.activeField == 3) {
                        this.fireLoginEvent();
                    } else {
                        this.startEditingInputText();
                    }
                    return;
                }
            }
        }
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (!this.inputTextIsActive) {
            switch (gameAction) {
                case 2: 
                case 6: {
                    this.moveActiveField(true);
                    return;
                }
                case 1: 
                case 5: {
                    this.moveActiveField(false);
                    return;
                }
            }
        }
    }

    private InputTextBox getInputTextBox() {
        if (this.inputTextBox == null) {
            this.inputTextBox = new InputTextBox();
        }
        return this.inputTextBox;
    }

    private void startEditingInputText() {
        this.inputTextIsActive = true;
        if (this.useTextBoxForInput) {
            this.getInputTextBox().setTextBoxMode(this.activeField);
            if (this.activeField == 1) {
                this.getInputTextBox().setString(this.username);
            } else if (this.activeField == 2) {
                this.getInputTextBox().setString(this.password);
            }
            this.getDisplay().callSerially(new Runnable(){

                public void run() {
                    LoginScreen.this.getDisplay().setCurrent((Displayable)LoginScreen.this.getInputTextBox());
                }
            });
        }
    }

    private void stopEditingInputText(boolean confirmChanges) {
        this.inputTextIsActive = false;
        if (this.useTextBoxForInput) {
            if (confirmChanges) {
                if (this.activeField == 1) {
                    this.setUsername(this.getInputTextBox().getString());
                } else if (this.activeField == 2) {
                    this.setPassword(this.getInputTextBox().getString());
                }
            }
            this.getDisplay().setCurrent((Displayable)this);
        }
    }

    public void setCommandListener(CommandListener l) {
        this.l = l;
    }

    public CommandListener getCommandListener() {
        return this.l;
    }

    public void setBGColor(int color) {
        ((DefaultColorSchema)this.colorSchema).setBGColor(color);
    }

    public void setFGColor(int color) {
        ((DefaultColorSchema)this.colorSchema).setFGColor(color);
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this) {
            if (c.equals(LOGIN_COMMAND)) {
                this.fireLoginEvent();
            } else if (this.l != null) {
                this.l.commandAction(c, d);
            }
        }
    }

    private class InputTextBox
    extends TextBox
    implements CommandListener {
        private final Command CONFIRM_COMMAND = new Command("OK", 8, 1);
        private final Command CANCEL_COMMAND = new Command("Cancel", 3, 1);

        public InputTextBox() {
            super(null, null, LoginScreen.this.maximumInputSize, 0);
            this.setCommandListener(this);
            this.addCommand(this.CONFIRM_COMMAND);
            this.addCommand(this.CANCEL_COMMAND);
        }

        public void setTextBoxMode(int mode) {
            if (mode == 1) {
                this.setConstraints(524288);
                this.setTitle(LoginScreen.this.usernameLabel);
            } else if (mode == 2) {
                this.setConstraints(589824);
                this.setTitle(LoginScreen.this.passwordLabel);
            } else {
                throw new IllegalArgumentException("Wrong mode: " + mode);
            }
        }

        public void commandAction(Command c, Displayable d) {
            if (d == this) {
                if (c == this.CONFIRM_COMMAND) {
                    LoginScreen.this.stopEditingInputText(true);
                } else if (c == this.CANCEL_COMMAND) {
                    LoginScreen.this.stopEditingInputText(false);
                }
            }
        }
    }
}

