/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui.wma;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;
import org.netbeans.microedition.lcdui.laf.ColorSchema;
import org.netbeans.microedition.lcdui.laf.DefaultColorSchema;

public class SMSComposer
extends Canvas
implements CommandListener {
    private static String sendCommandName = "Send";
    public static Command SEND_COMMAND = new Command(sendCommandName, 4, 1);
    private String phoneNumber = "";
    private String message = "";
    private Display display;
    private int portNum = 50000;
    private boolean useTextBoxForInput = true;
    private boolean inputTextIsActive = false;
    private int borderStyle;
    private int hiBorderStyle;
    private Font inputFont;
    private static final int borderPadding = 2;
    private static final int labelPadding = 2;
    private int phoneNumberY;
    private int messageY;
    private int phoneNumberX;
    private int messageX;
    private int inputFieldsWidth;
    private int inputFieldsHeight;
    private int phoneNumberLabelWidth;
    private int messageLabelWidth;
    private static final int ACTIVE_PHONE_NUMBER = 1;
    private static final int ACTIVE_MESSAGE = 2;
    private int activeField = 1;
    private String phoneNumberLabel;
    private String messageLabel;
    private CommandListener l;
    private ColorSchema colorSchema = new DefaultColorSchema();
    private InputTextBox phoneBox;
    private InputTextBox msgBox;
    private InputTextBox current = null;
    private boolean sendAutomatically = true;

    public SMSComposer(Display display) {
        this.display = display;
        this.setDefaulBorderStyles();
        this.setDefaultFonts();
        this.addCommand(SEND_COMMAND);
        super.setCommandListener((CommandListener)this);
        this.phoneNumberLabel = "Phone Number:";
        this.messageLabel = "Message:";
        this.phoneBox = new InputTextBox(this.phoneNumberLabel, 20, 3);
        this.msgBox = new InputTextBox(this.messageLabel, 160, 0);
    }

    public void setPhoneNumber(String phoneNumber) {
        if (phoneNumber == null) {
            phoneNumber = "";
        }
        this.phoneNumber = phoneNumber;
    }

    public void setPhoneNumberLabel(String phoneNumberLabel) {
        if (phoneNumberLabel == null) {
            phoneNumberLabel = "";
        }
        this.phoneNumberLabel = phoneNumberLabel;
        this.phoneBox.setTitle(phoneNumberLabel);
    }

    public void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.message = message;
    }

    public void setMessageLabel(String messageLabel) {
        if (messageLabel == null) {
            messageLabel = "";
        }
        this.messageLabel = messageLabel;
        this.msgBox.setTitle(messageLabel);
    }

    public void setPort(int portNum) {
        this.portNum = portNum;
    }

    public void setSendAutomatically(boolean sendAutomatically) {
        this.sendAutomatically = sendAutomatically;
    }

    public void sendSMS() throws IOException {
        if (this.phoneNumber == null) {
            throw new IllegalArgumentException();
        }
        String address = "sms://" + this.phoneNumber + ":" + this.portNum;
        MessageConnection smsconn = null;
        smsconn = (MessageConnection)Connector.open((String)address);
        TextMessage txtmessage = (TextMessage)smsconn.newMessage("text");
        txtmessage.setAddress(address);
        txtmessage.setPayloadText(this.message);
        smsconn.send((Message)txtmessage);
        smsconn.close();
    }

    public void setDefaulBorderStyles() {
        this.borderStyle = this.getDisplay().getBorderStyle(false);
        this.hiBorderStyle = this.getDisplay().getBorderStyle(true);
    }

    public void setDefaultFonts() {
        this.inputFont = Font.getFont((int)1);
    }

    protected void showNotify() {
        this.computeMetrics();
    }

    protected void sizeChanged(int w, int h) {
        this.computeMetrics();
    }

    private int computeYMetrics(int baseY) {
        this.phoneNumberY = baseY + 2;
        this.messageY = this.phoneNumberY + this.inputFieldsHeight + 2;
        return this.messageY + this.inputFieldsHeight;
    }

    private void computeMetrics() {
        int labelWidth;
        int width = this.getWidth();
        int height = this.getHeight();
        int centerY = height / 2;
        int centerX = width / 2;
        int visibleInputFieldLength = 12;
        this.inputFieldsWidth = this.inputFont.charWidth('X') * visibleInputFieldLength + 4;
        if (this.inputFieldsWidth > width) {
            this.inputFieldsWidth = width - 2;
        }
        this.inputFieldsHeight = this.inputFont.getHeight() + 4;
        int componentsHeight = this.computeYMetrics(0);
        int newbaseY = (height - componentsHeight) / 4;
        if (newbaseY > 0) {
            this.computeYMetrics(newbaseY);
        }
        this.phoneNumberLabelWidth = this.inputFont.stringWidth(this.phoneNumberLabel);
        this.messageLabelWidth = this.inputFont.stringWidth(this.messageLabel);
        this.phoneNumberLabelWidth = labelWidth = Math.max(this.phoneNumberLabelWidth, this.messageLabelWidth);
        this.messageLabelWidth = labelWidth;
        this.phoneNumberX = centerX - (this.phoneNumberLabelWidth + 2 + this.inputFieldsWidth) / 2;
        if (this.phoneNumberX < 0) {
            this.phoneNumberX = 0;
            this.inputFieldsWidth = width - labelWidth - 2 - 1;
        }
        this.messageX = centerX - (this.messageLabelWidth + 2 + this.inputFieldsWidth) / 2;
        if (this.messageX < 0) {
            this.messageY = 0;
            this.inputFieldsWidth = width - labelWidth - 2 - 1;
        }
    }

    private static void setColorByState(Graphics g, int baseColor, int hiColor, boolean active) {
        if (active) {
            g.setColor(hiColor);
        } else {
            g.setColor(baseColor);
        }
    }

    private static void setStyleByState(Graphics g, int baseStyle, int hiStyle, boolean active) {
        if (active) {
            g.setStrokeStyle(baseStyle);
        } else {
            g.setStrokeStyle(hiStyle);
        }
    }

    public ColorSchema getColorSchema() {
        return this.colorSchema;
    }

    protected void paint(Graphics graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        int centerX = width / 2;
        this.getColorSchema().paintBackground(graphics, false);
        graphics.setFont(this.inputFont);
        int x = this.phoneNumberX + this.phoneNumberLabelWidth + 2;
        int y = this.phoneNumberY;
        int w = this.inputFieldsWidth;
        int h = this.inputFieldsHeight;
        graphics.setColor(0xFFFFFF);
        graphics.fillRoundRect(x, y, w, h, 6, 6);
        boolean phoneNumberActive = this.activeField == 1;
        SMSComposer.setColorByState(graphics, this.getColorSchema().getColor(4), this.getColorSchema().getColor(5), phoneNumberActive);
        SMSComposer.setStyleByState(graphics, this.borderStyle, this.hiBorderStyle, phoneNumberActive);
        graphics.drawRoundRect(x, y, w, h, 6, 6);
        SMSComposer.setColorByState(graphics, this.getColorSchema().getColor(1), this.getColorSchema().getColor(3), phoneNumberActive);
        graphics.setClip(x + 2, y + 2, w - 4, h - 4);
        graphics.drawString(this.phoneNumber, x + 2, this.phoneNumberY + 2, 20);
        graphics.setClip(0, 0, width, height);
        graphics.setColor(this.getColorSchema().getColor(1));
        graphics.drawString(this.phoneNumberLabel, this.phoneNumberX, this.phoneNumberY + 2, 20);
        boolean messageActive = this.activeField == 2;
        SMSComposer.setColorByState(graphics, this.getColorSchema().getColor(0), this.getColorSchema().getColor(2), messageActive);
        x = this.messageX + this.messageLabelWidth + 2;
        y = this.messageY;
        w = this.inputFieldsWidth;
        h = this.inputFieldsHeight;
        graphics.setColor(0xFFFFFF);
        graphics.fillRoundRect(2, y + this.inputFieldsHeight + 2, width - 4, height - (y + this.inputFieldsHeight + 2) - 4, 6, 6);
        SMSComposer.setColorByState(graphics, this.getColorSchema().getColor(4), this.getColorSchema().getColor(5), messageActive);
        SMSComposer.setStyleByState(graphics, this.borderStyle, this.hiBorderStyle, messageActive);
        graphics.drawRoundRect(2, y + this.inputFieldsHeight + 2, width - 4, height - (y + this.inputFieldsHeight + 2) - 4, 6, 6);
        SMSComposer.setColorByState(graphics, this.getColorSchema().getColor(1), this.getColorSchema().getColor(3), messageActive);
        graphics.setClip(2, y + this.inputFieldsHeight + 2, width - 4, height - (y + this.inputFieldsHeight + 2) - 4);
        int messageLength = this.message.length();
        int currentWidth = 0;
        int startPoint = 0;
        int line = 1;
        for (int i = 0; i < messageLength; ++i) {
            char c = this.message.charAt(i);
            int cWidth = this.inputFont.stringWidth("" + c);
            if ((currentWidth += cWidth) < width - 6) continue;
            String subMsg = this.message.substring(startPoint, --i);
            graphics.drawString(subMsg, 4, y + line * this.inputFieldsHeight + 2 + 2, 20);
            startPoint = i;
            currentWidth = 0;
            ++line;
        }
        String subMsg = this.message.substring(startPoint, messageLength);
        graphics.drawString(subMsg, 4, y + line * this.inputFieldsHeight + 2 + 2, 20);
        graphics.setClip(0, 0, width, height);
        graphics.setColor(this.getColorSchema().getColor(1));
        graphics.drawString(this.messageLabel, this.messageX, this.messageY + 2, 20);
    }

    private void moveActiveField(boolean down) {
        int add = down ? 1 : -1;
        this.activeField += add;
        if (this.activeField > 2) {
            this.activeField = 1;
        } else if (this.activeField < 1) {
            this.activeField = 2;
        }
        this.repaint();
    }

    private void fireSendEvent() {
        CommandListener l = this.getCommandListener();
        if (l != null) {
            l.commandAction(SEND_COMMAND, (Displayable)this);
        }
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (!this.inputTextIsActive) {
            switch (gameAction) {
                case 8: {
                    this.startEditingInputText();
                    return;
                }
            }
        }
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (!this.inputTextIsActive) {
            switch (gameAction) {
                case 2: 
                case 6: {
                    this.moveActiveField(true);
                    return;
                }
                case 1: 
                case 5: {
                    this.moveActiveField(false);
                    return;
                }
            }
        }
    }

    private void startEditingInputText() {
        this.inputTextIsActive = true;
        if (this.useTextBoxForInput) {
            if (this.activeField == 1) {
                this.phoneBox.setString(this.phoneNumber);
                this.current = this.phoneBox;
            } else if (this.activeField == 2) {
                this.msgBox.setString(this.message);
                this.current = this.msgBox;
            }
            this.getDisplay().callSerially(new Runnable(){

                public void run() {
                    SMSComposer.this.getDisplay().setCurrent((Displayable)SMSComposer.this.current);
                }
            });
        }
    }

    private void stopEditingInputText(boolean confirmChanges) {
        this.inputTextIsActive = false;
        if (this.useTextBoxForInput) {
            if (confirmChanges) {
                if (this.activeField == 1) {
                    this.setPhoneNumber(this.current.getString());
                } else if (this.activeField == 2) {
                    this.setMessage(this.current.getString());
                }
            }
            this.getDisplay().setCurrent((Displayable)this);
        }
    }

    public void setCommandListener(CommandListener listener) {
        this.l = listener;
    }

    public CommandListener getCommandListener() {
        return this.l;
    }

    public void setBGColor(int color) {
        ((DefaultColorSchema)this.colorSchema).setBGColor(color);
    }

    public void setFGColor(int color) {
        ((DefaultColorSchema)this.colorSchema).setFGColor(color);
    }

    private Display getDisplay() {
        return this.display;
    }

    public void commandAction(Command c, Displayable d) {
        if (c.equals(SEND_COMMAND) && this.sendAutomatically) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        SMSComposer.this.sendSMS();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
        }
        if (this.l != null) {
            this.l.commandAction(c, d);
        }
    }

    private class InputTextBox
    extends TextBox
    implements CommandListener {
        private final Command CONFIRM_COMMAND = new Command("OK", 4, 1);
        private final Command CANCEL_COMMAND = new Command("Cancel", 3, 1);

        public InputTextBox(String title, int maximumChars, int constraints) {
            super(title, null, maximumChars, constraints);
            this.setCommandListener(this);
            this.addCommand(this.CONFIRM_COMMAND);
            this.addCommand(this.CANCEL_COMMAND);
        }

        public void commandAction(Command c, Displayable d) {
            if (d == this) {
                if (c == this.CONFIRM_COMMAND) {
                    SMSComposer.this.stopEditingInputText(true);
                } else if (c == this.CANCEL_COMMAND) {
                    SMSComposer.this.stopEditingInputText(false);
                }
            }
        }
    }
}

