/*
 * Decompiled with CFR 0.152.
 */
package filebrowserexample;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import org.netbeans.microedition.lcdui.SplashScreen;
import org.netbeans.microedition.lcdui.pda.FileBrowser;

public class FileBrowserExample
extends MIDlet
implements CommandListener {
    private boolean midletPaused = false;
    private Command backCommand;
    private Command exitCommand;
    private TextBox textBox;
    private FileBrowser fileBrowser;
    private SplashScreen splashScreen;

    private void initialize() {
    }

    public void startMIDlet() {
        this.switchDisplayable(null, (Displayable)this.getSplashScreen());
    }

    public void resumeMIDlet() {
    }

    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {
        Display display = this.getDisplay();
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }
    }

    public Command getBackCommand() {
        if (this.backCommand == null) {
            this.backCommand = new Command("Back", 2, 0);
        }
        return this.backCommand;
    }

    public Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 7, 0);
        }
        return this.exitCommand;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.fileBrowser) {
            if (command == FileBrowser.SELECT_FILE_COMMAND) {
                this.readFile();
                this.switchDisplayable(null, (Displayable)this.getTextBox());
            } else if (command == this.exitCommand) {
                this.exitMIDlet();
            }
        } else if (displayable == this.splashScreen) {
            if (command == SplashScreen.DISMISS_COMMAND) {
                this.switchDisplayable(null, (Displayable)this.getFileBrowser());
            }
        } else if (displayable == this.textBox && command == this.backCommand) {
            this.switchDisplayable(null, (Displayable)this.getFileBrowser());
        }
    }

    public SplashScreen getSplashScreen() {
        if (this.splashScreen == null) {
            this.splashScreen = new SplashScreen(this.getDisplay());
            this.splashScreen.setTitle("splashScreen");
            this.splashScreen.setCommandListener(this);
            this.splashScreen.setText("File Browser Example");
        }
        return this.splashScreen;
    }

    public FileBrowser getFileBrowser() {
        if (this.fileBrowser == null) {
            this.fileBrowser = new FileBrowser(this.getDisplay());
            this.fileBrowser.setTitle("fileBrowser");
            this.fileBrowser.setCommandListener(this);
            this.fileBrowser.addCommand(FileBrowser.SELECT_FILE_COMMAND);
            this.fileBrowser.addCommand(this.getExitCommand());
        }
        return this.fileBrowser;
    }

    public TextBox getTextBox() {
        if (this.textBox == null) {
            this.textBox = new TextBox("textBox", null, 100, 0);
            this.textBox.addCommand(this.getBackCommand());
            this.textBox.setCommandListener((CommandListener)this);
        }
        return this.textBox;
    }

    private void readFile() {
        try {
            FileConnection textFile = this.fileBrowser.getSelectedFile();
            this.getTextBox().setString("");
            InputStream fis = textFile.openInputStream();
            byte[] b = new byte[1024];
            int length = fis.read(b, 0, 1024);
            fis.close();
            if (length > 0) {
                this.textBox.setString(new String(b, 0, length));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.switchDisplayable(null, null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        if (this.midletPaused) {
            this.resumeMIDlet();
        } else {
            this.initialize();
            this.startMIDlet();
        }
        this.midletPaused = false;
    }

    public void pauseApp() {
        this.midletPaused = true;
    }

    public void destroyApp(boolean unconditional) {
    }
}

